/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration.search;

import jakarta.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SearchConfiguration
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(SearchConfiguration.class);
    @Value(value="${lucene.local.file.storage.folder}")
    private String localFileStorageFolder;
    @Value(value="${lucene.index.recreate.onstart}")
    private boolean luceneIndexRecreate;
    @Value(value="${lucene.index.nrt.blocking}")
    private boolean blockingRefresh;
    @Value(value="${search.indexer.immediate.commit.enabled}")
    private boolean searchIndexerImmediateCommitEnabled;
    @Value(value="${search.stemming.enabled}")
    private boolean enabledStem;

    public void afterPropertiesSet() {
        log.info("SearchConfiguration loaded: {}", (Object)this);
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded SearchConfiguration: {}", (Object)this);
    }

    public String getLocalFileStorageFolder() {
        return this.localFileStorageFolder;
    }

    public boolean isLuceneIndexRecreate() {
        return this.luceneIndexRecreate;
    }

    public boolean isBlockingRefresh() {
        return this.blockingRefresh;
    }

    public boolean isSearchIndexerImmediateCommitEnabled() {
        return this.searchIndexerImmediateCommitEnabled;
    }

    public boolean isEnabledStem() {
        return this.enabledStem;
    }

    public void setLocalFileStorageFolder(String localFileStorageFolder) {
        this.localFileStorageFolder = localFileStorageFolder;
    }

    public void setLuceneIndexRecreate(boolean luceneIndexRecreate) {
        this.luceneIndexRecreate = luceneIndexRecreate;
    }

    public void setBlockingRefresh(boolean blockingRefresh) {
        this.blockingRefresh = blockingRefresh;
    }

    public void setSearchIndexerImmediateCommitEnabled(boolean searchIndexerImmediateCommitEnabled) {
        this.searchIndexerImmediateCommitEnabled = searchIndexerImmediateCommitEnabled;
    }

    public void setEnabledStem(boolean enabledStem) {
        this.enabledStem = enabledStem;
    }

    public String toString() {
        return "SearchConfiguration(localFileStorageFolder=" + this.getLocalFileStorageFolder() + ", luceneIndexRecreate=" + this.isLuceneIndexRecreate() + ", blockingRefresh=" + this.isBlockingRefresh() + ", searchIndexerImmediateCommitEnabled=" + this.isSearchIndexerImmediateCommitEnabled() + ", enabledStem=" + this.isEnabledStem() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchConfiguration)) {
            return false;
        }
        SearchConfiguration other = (SearchConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isLuceneIndexRecreate() != other.isLuceneIndexRecreate()) {
            return false;
        }
        if (this.isBlockingRefresh() != other.isBlockingRefresh()) {
            return false;
        }
        if (this.isSearchIndexerImmediateCommitEnabled() != other.isSearchIndexerImmediateCommitEnabled()) {
            return false;
        }
        if (this.isEnabledStem() != other.isEnabledStem()) {
            return false;
        }
        String this$localFileStorageFolder = this.getLocalFileStorageFolder();
        String other$localFileStorageFolder = other.getLocalFileStorageFolder();
        return !(this$localFileStorageFolder == null ? other$localFileStorageFolder != null : !this$localFileStorageFolder.equals(other$localFileStorageFolder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLuceneIndexRecreate() ? 79 : 97);
        result = result * 59 + (this.isBlockingRefresh() ? 79 : 97);
        result = result * 59 + (this.isSearchIndexerImmediateCommitEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnabledStem() ? 79 : 97);
        String $localFileStorageFolder = this.getLocalFileStorageFolder();
        result = result * 59 + ($localFileStorageFolder == null ? 43 : $localFileStorageFolder.hashCode());
        return result;
    }
}

