/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.qfm.erp.service.configuration.RequestLoggingFilterConfig;
import de.qfm.erp.service.configuration.SwaggerConfig;
import java.util.List;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages={"de.qfm.erp.service.resource", "de.qfm.erp.service.filter"}, excludeFilters={@ComponentScan.Filter(value={Configuration.class})})
@Import(value={SwaggerConfig.class, RequestLoggingFilterConfig.class})
public class WebConfig
implements WebMvcConfigurer {
    private final ObjectMapper objectMapper;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setObjectMapper(this.objectMapper);
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)mappingJackson2HttpMessageConverter);
    }

    public WebConfig(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

