/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

@Configuration
@Order(value=100)
public class SyncHttpBasicConfigurationAdapter {
    @Bean(name={"syncSecurityFilterChain"})
    public SecurityFilterChain syncSecurityFilterChain(@NonNull HttpSecurity http) throws Exception {
        if (http == null) {
            throw new NullPointerException("http is marked non-null but is null");
        }
        return (SecurityFilterChain)http.securityMatcher(new String[]{"/api/v1/erp-sync/**"}).authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(new String[]{"/api/v1/erp-sync/**"})).hasAuthority(UserHelper.grantedAuthorityName((EPrivilege)EPrivilege.UNRESTRICTED))).httpBasic(httpSecurityHttpBasicConfigurer -> httpSecurityHttpBasicConfigurer.authenticationEntryPoint(this.authenticationEntryPoint())).cors(AbstractHttpConfigurer::disable).csrf(AbstractHttpConfigurer::disable).build();
    }

    @Bean(name={"syncAuthenticationEntryPoint"})
    public AuthenticationEntryPoint authenticationEntryPoint() {
        BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
        entryPoint.setRealmName("sync realm");
        return entryPoint;
    }
}

