/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.service.mapper.UserMapper;
import de.qfm.erp.service.service.security.JwtTokenProvider;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.socket.StageWebSocketHandler;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
public class ServerWebSocketConfig
implements WebSocketConfigurer {
    private static final Logger log = LogManager.getLogger(ServerWebSocketConfig.class);
    private final ApplicationConfig applicationConfig;
    private final ObjectMapper objectMapper;
    private final UserMapper userMapper;
    private final UserService userService;
    private final JwtTokenProvider jwtTokenProvider;

    public void registerWebSocketHandlers(@NonNull WebSocketHandlerRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        WebSocketHandlerRegistration webSocketHandlerRegistration = registry.addHandler(this.stageServerWebSocketHandler(), new String[]{"/api/v1/erp-ws/stages/"});
        if (this.applicationConfig.isSecurityCorsEnabled()) {
            log.warn("*************************************");
            log.warn("********   WS CORS ENABLED  *********");
            log.warn("*************************************");
            webSocketHandlerRegistration.setAllowedOrigins(new String[]{"*"});
        }
    }

    @Bean
    public WebSocketHandler stageServerWebSocketHandler() {
        return new StageWebSocketHandler(this.applicationConfig, this.objectMapper, this.userMapper, this.userService, this.jwtTokenProvider);
    }

    public ServerWebSocketConfig(ApplicationConfig applicationConfig, ObjectMapper objectMapper, UserMapper userMapper, UserService userService, JwtTokenProvider jwtTokenProvider) {
        this.applicationConfig = applicationConfig;
        this.objectMapper = objectMapper;
        this.userMapper = userMapper;
        this.userService = userService;
        this.jwtTokenProvider = jwtTokenProvider;
    }
}

