/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import de.leancoders.common.jackson.ObjectMapperFactory;
import de.qfm.erp.service.configuration.SerializerConfig;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class SerializerConfig {
    private final ZoneId sourceZoneId;
    private final ZoneId destinationZoneId;
    private static final DateTimeFormatter DATE_TIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    @Autowired
    public SerializerConfig(@Qualifier(value="sourceZoneId") ZoneId sourceZoneId, @Qualifier(value="destinationZoneId") ZoneId destinationZoneId) {
        this.sourceZoneId = sourceZoneId;
        this.destinationZoneId = destinationZoneId;
    }

    @Bean
    public ObjectMapper objectMapper() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LDTSerializer(this.sourceZoneId, this.destinationZoneId));
        return ObjectMapperFactory.createDefaultObjectMapper().registerModule((Module)module);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customize() {
        return builder -> builder.dateFormat((DateFormat)SerializerConfig.dateFormat());
    }

    @Nonnull
    private static StdDateFormat dateFormat() {
        return new StdDateFormat().withColonInTimeZone(true);
    }
}

