/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import de.qfm.erp.service.service.job.DisableUserJob;
import de.qfm.erp.service.service.route.UserRoute;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"scheduler.enabled"}, havingValue="true")
@EnableScheduling
@ComponentScan(basePackages={"de.qfm.erp.service.service.job"}, excludeFilters={@ComponentScan.Filter(value={Configuration.class})})
public class EnableUserDisableConfig {
    private static final Logger log = LogManager.getLogger(EnableUserDisableConfig.class);

    @Bean
    public DisableUserJob disableUserJob(@NonNull UserRoute userRoute) {
        if (userRoute == null) {
            throw new NullPointerException("userRoute is marked non-null but is null");
        }
        return new DisableUserJob(userRoute);
    }
}

