/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.user;

import de.qfm.erp.common.request.user.UserUpdateRequest;
import de.qfm.erp.service.model.exception.request.DuplicationException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.validator.user.UserUpdateRequestValidator;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserUpdateRequestUniquenessValidator
extends UserUpdateRequestValidator {
    private final UserHandler userHandler;

    public boolean validate(@NonNull User user, @NonNull UserUpdateRequest userUpdateRequest) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (userUpdateRequest == null) {
            throw new NullPointerException("userUpdateRequest is marked non-null but is null");
        }
        Integer personalNumber = userUpdateRequest.getPersonalNumber();
        boolean duplicatePersonalNumber = this.userHandler.anotherUserWithSamePersonalNumber(user, personalNumber);
        if (duplicatePersonalNumber) {
            String personalNumberAsString = Integer.toString(personalNumber);
            String msg = String.format("User Personal Number: %s already used", personalNumberAsString);
            throw new DuplicationException(msg, List.of(RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__PERSONAL_NUMBER), (Object)personalNumber, (String)msg, (Message)Message.of((EMessageKey)EMessageKey.DUPLICATE_USER_PERSONAL_NUMBER, (String)personalNumberAsString), List.of())));
        }
        String safeUserName = StringUtils.trimToEmpty((String)userUpdateRequest.getUsername());
        boolean duplicateUsername = this.userHandler.anotherUserWithSameUsername(user, safeUserName);
        if (duplicateUsername) {
            String msg = String.format("User User Name: %s already used", safeUserName);
            throw new DuplicationException(msg, List.of(RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER_USER_NAME), (Object)safeUserName, (String)msg, (Message)Message.of((EMessageKey)EMessageKey.DUPLICATE_USER_USER_NAME, (String)safeUserName), List.of())));
        }
        return true;
    }

    public UserUpdateRequestUniquenessValidator(UserHandler userHandler) {
        this.userHandler = userHandler;
    }
}

