/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.user;

import de.qfm.erp.common.request.role.RoleUpdateRequest;
import de.qfm.erp.service.model.exception.request.DuplicationException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.service.handler.RoleHandler;
import de.qfm.erp.service.service.validator.user.RoleRequestValidator;
import java.util.List;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class RoleUpdateRequestValidator
extends RoleRequestValidator<RoleUpdateRequest> {
    private final RoleHandler roleHandler;

    public boolean validate(@NonNull Role role, @NonNull RoleUpdateRequest request) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String name = request.getName();
        boolean duplicateName = this.roleHandler.anotherRoleWithSameName(role, name);
        if (duplicateName) {
            String msg = String.format("Role Name: %s already used", duplicateName);
            throw new DuplicationException(msg, List.of(RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ROLE__NAME), (Object)name, (String)msg, (Message)Message.of((EMessageKey)EMessageKey.DUPLICATE_ROLE_NAME, (String)name), List.of())));
        }
        return true;
    }

    public RoleUpdateRequestValidator(RoleHandler roleHandler) {
        this.roleHandler = roleHandler;
    }
}

