/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.employee.payroll.PayrollItemModificationItem;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=4)
public class PayrollOverOrUnderchargeWageAccountValidator
extends PayrollBeforeMergeValidator {
    public boolean validate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        boolean isDeposit;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = updateBucket.getPayrollMonth();
        Iterable wageAccountItemsUpdateBuckets = updateBucket.getWageAccountItemsUpdateBuckets();
        List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
        ImmutableList existingWageAccountItems = (ImmutableList)payrollMonthItems.stream().filter(item -> item.getPayrollItemClazz() == EPayrollItemClazz.WAGE_ACCOUNT).collect(ImmutableList.toImmutableList());
        HashMap existing = Maps.newHashMap();
        for (PayrollMonthItem payrollMonthItem : existingWageAccountItems) {
            existing.put(payrollMonthItem.getId(), (BigDecimal)MoreObjects.firstNonNull((Object)payrollMonthItem.getValue(), (Object)BigDecimal.ZERO));
        }
        Set existingIDs = existing.keySet();
        Set updateIDs = (Set)Streams.stream((Iterable)wageAccountItemsUpdateBuckets).map(PayrollMonthItemUpdateBucket::getPayrollItemUpdateItem).map(PayrollItemModificationItem::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        ImmutableSet idsNotPresentAnymore = ImmutableSet.copyOf((Collection)Sets.difference(existingIDs, (Set)updateIDs));
        ArrayList valuesToBeReCharged = Lists.newArrayList();
        for (Long l : idsNotPresentAnymore) {
            valuesToBeReCharged.add((BigDecimal)existing.get(l));
            existing.remove(l);
        }
        BigDecimal removedValues = valuesToBeReCharged.stream().reduce(BigDecimal.ZERO, BigDecimal::add).negate();
        ImmutableList previousValues = (ImmutableList)Streams.stream((Iterable)wageAccountItemsUpdateBuckets).map(PayrollMonthItemUpdateBucket::getPayrollMonthItem).filter(Objects::nonNull).map(PayrollMonthItem::getValue).collect(ImmutableList.toImmutableList());
        BigDecimal previousValue = previousValues.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        ImmutableList postValues = (ImmutableList)Streams.stream((Iterable)wageAccountItemsUpdateBuckets).map(PayrollMonthItemUpdateBucket::getPayrollItemUpdateItem).map(PayrollItemModificationItem::getValue).collect(ImmutableList.toImmutableList());
        BigDecimal postValue = postValues.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        WageAccount wageAccount = updateBucket.getWageAccount();
        BigDecimal limit = ((BigDecimal)MoreObjects.firstNonNull((Object)wageAccount.getLimit(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal balance = (BigDecimal)MoreObjects.firstNonNull((Object)wageAccount.getBalance(), (Object)BigDecimal.ZERO);
        BigDecimal change = previousValue.subtract(postValue).subtract(removedValues).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newBalance = balance.add(change).setScale(2, RoundingMode.HALF_UP);
        boolean isChanged = change.compareTo(BigDecimal.ZERO) != 0;
        boolean bl = isDeposit = change.compareTo(BigDecimal.ZERO) > 0;
        if (isChanged) {
            if (newBalance.compareTo(BigDecimal.ZERO) < 0) {
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__WAGE_ACCOUNT__VALUE), (Object)"", String.format("Rule Validation Error: Payroll Month cannot be updated, the payout: %s exceeds available amount: %s", change, balance), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH__WAGE_ACCOUNT__BELOW_ZERO, (List)ImmutableList.of((Object)change, (Object)balance)));
            }
            if (newBalance.compareTo(limit) > 0 && isDeposit) {
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__WAGE_ACCOUNT__VALUE), (Object)"", String.format("Rule Validation Error: Payroll Month cannot be updated, the isDeposit: %s exceeds accepted limit: %s current balance: %s", change, limit, balance), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH__WAGE_ACCOUNT__ABOVE_LIMIT, (List)ImmutableList.of((Object)change, (Object)limit, (Object)balance)));
            }
        }
        return true;
    }
}

