/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.employee.payroll.PayrollItemUpdateItem;
import de.qfm.erp.service.helper.PayrollMonthHelper;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.PayrollMonthHandler;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=2)
public class PayrollOnReleaseDisallowChangeIncentiveValidator
extends PayrollBeforeMergeValidator {
    private static final Joiner USER_FULL_NAME_JOINER = Joiner.on((char)',').skipNulls();
    private final PayrollMonthHandler payrollMonthHandler;

    public boolean validate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = updateBucket.getPayrollMonth();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Iterable incentivePayrollItemsBucket = updateBucket.getIncentivePayrollItemsBuckets();
        ImmutableSet.Builder usersToValidateBuilder = ImmutableSet.builder();
        incentivePayrollItemsBucket.forEach(bucket -> {
            PayrollItemUpdateItem payrollItemUpdateItem = bucket.getPayrollItemUpdateItem();
            User recipientNew = bucket.getRecipient();
            BigDecimal valueNew = (BigDecimal)MoreObjects.firstNonNull((Object)payrollItemUpdateItem.getValue(), (Object)BigDecimal.ZERO);
            PayrollMonthItem payrollMonthItem = bucket.getPayrollMonthItem();
            if (null != payrollMonthItem) {
                BigDecimal valueExisting;
                boolean changeValue;
                boolean changePerson;
                User recipientExisting = payrollMonthItem.getRecipient();
                boolean bl = changePerson = !Objects.equals(recipientExisting, recipientNew);
                if (changePerson) {
                    usersToValidateBuilder.add((Object[])new User[]{recipientExisting, recipientNew});
                }
                boolean bl2 = changeValue = (valueExisting = (BigDecimal)MoreObjects.firstNonNull((Object)payrollMonthItem.getValue(), (Object)BigDecimal.ZERO)).compareTo(valueNew) != 0;
                if (changeValue) {
                    usersToValidateBuilder.add((Object)recipientExisting);
                }
            } else {
                usersToValidateBuilder.add((Object)recipientNew);
            }
        });
        ImmutableSet payrollMonthItemsExisting = ImmutableSet.copyOf((Collection)payrollMonth.getPayrollMonthItems());
        Set payrollMonthItemsInBuckets = IterableHelper.stream((Iterable)incentivePayrollItemsBucket).map(PayrollMonthItemUpdateBucket::getPayrollMonthItem).filter(Objects::nonNull).collect(Collectors.toSet());
        Sets.SetView payrollMonthItemsRemoved = Sets.difference((Set)payrollMonthItemsExisting, payrollMonthItemsInBuckets);
        payrollMonthItemsRemoved.stream().map(PayrollMonthItem::getRecipient).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)usersToValidateBuilder).add(arg_0));
        ImmutableSet usersToValidate = usersToValidateBuilder.build();
        Function userBooleanFunction = PayrollMonthHelper.usersInReleasedStateFn((YearMonth)accountingMonth, (Iterable)usersToValidate, (arg_0, arg_1) -> ((PayrollMonthHandler)this.payrollMonthHandler).releasedPayrollMonthsByUsersAndAccountingMonth(arg_0, arg_1));
        HashSet usersAlreadyReleased = Sets.newHashSet();
        for (User user : usersToValidate) {
            if (!((Boolean)userBooleanFunction.apply(user)).booleanValue()) continue;
            usersAlreadyReleased.add(user);
        }
        if (!Iterables.isEmpty((Iterable)usersAlreadyReleased)) {
            Set userFullNames = usersAlreadyReleased.stream().filter(Objects::nonNull).map(UserHelper::asString).collect(Collectors.toSet());
            String usersJoined = USER_FULL_NAME_JOINER.join(userFullNames);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__RECIPIENT), (Object)usersJoined, String.format("Payroll Month cannot be updated, you assign/change incentive wage on (an) Employee(s), which already have released: %s", usersJoined), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_UPDATE__INCENTIVE_WAGE__RECIPIENT_IN_RELEASED_STATE, (List)ImmutableList.of(userFullNames)));
        }
        return true;
    }

    public PayrollOnReleaseDisallowChangeIncentiveValidator(PayrollMonthHandler payrollMonthHandler) {
        this.payrollMonthHandler = payrollMonthHandler;
    }
}

