/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceResetBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.service.validator.payroll.AttendanceBeforeResetValidator;
import java.time.LocalDate;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=1)
public class AttendanceResetPostEditDisallowedValidator
extends AttendanceBeforeResetValidator {
    public boolean validate(@NonNull AttendanceResetBucket resetBucket) {
        boolean lastOriginIsPostEdit;
        if (resetBucket == null) {
            throw new NullPointerException("resetBucket is marked non-null but is null");
        }
        EAttendanceOrigin origin = resetBucket.getOrigin();
        Attendance attendance = resetBucket.getAttendance();
        EAttendanceOrigin lastOrigin = attendance.getLastOrigin();
        boolean requestOriginIsBadWeather = EAttendanceOrigin.BAD_WEATHER == origin;
        boolean bl = lastOriginIsPostEdit = EAttendanceOrigin.BAD_WEATHER != lastOrigin;
        if (requestOriginIsBadWeather && lastOriginIsPostEdit) {
            String dateAsString = DateTimeHelper.toIsoDate((LocalDate)attendance.getDate());
            String lastOriginName = lastOrigin.name();
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__ATTENDANCE__LAST_ORIGIN), (Object)lastOriginName, "Attendance cannot be updated, you try to assign/change Bad Weather to an Attendance, where the Payroll Month was already changed", Message.of((EMessageKey)EMessageKey.RULE_ATTENDANCE_UPDATE_BAD_WEATHER_POST_EDIT, (List)ImmutableList.of((Object)dateAsString)));
        }
        return true;
    }
}

