/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceResetBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.service.validator.payroll.AttendanceBeforeResetValidator;
import java.time.LocalDate;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=1)
public class AttendanceResetPayrollMonthReleasedDisallowedValidator
extends AttendanceBeforeResetValidator {
    public boolean validate(@NonNull AttendanceResetBucket resetBucket) {
        boolean payrollMonthIsReleased;
        if (resetBucket == null) {
            throw new NullPointerException("resetBucket is marked non-null but is null");
        }
        Attendance attendance = resetBucket.getAttendance();
        PayrollMonth payrollMonth = attendance.getPayrollMonth();
        EAttendanceOrigin lastOrigin = attendance.getLastOrigin();
        EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
        boolean bl = payrollMonthIsReleased = EPayrollMonthState.RELEASED == payrollMonthState;
        if (payrollMonthIsReleased) {
            String dateAsString = DateTimeHelper.toIsoDate((LocalDate)attendance.getDate());
            String lastOriginName = lastOrigin.name();
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__STATE), (Object)lastOriginName, "Attendance cannot be Resetted, you try to reset / delete an Attendance from a RELEASED Payroll Month", Message.of((EMessageKey)EMessageKey.RULE_ATTENDANCE_RESET_PAYROLL_MONTH_RELEASED, (List)ImmutableList.of((Object)dateAsString)));
        }
        return true;
    }
}

