/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.AvailableMeasurementStates;
import de.qfm.erp.service.model.internal.measurement.MeasurementChangeBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.service.service.MeasurementService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeStateChangeValidator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0)
public class MeasurementStateChangePrivilegedValidator
extends MeasurementBeforeStateChangeValidator {
    private final MeasurementService measurementService;
    private final MessageService messageService;

    public boolean validate(@NonNull MeasurementChangeBucket updateBucket) {
        MeasurementState stateOld;
        EMeasurementState eStateOld;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Measurement measurement = updateBucket.getMeasurement();
        EMeasurementState eStateNew = updateBucket.getMeasurementStateNew();
        if (!Objects.equals(eStateNew, eStateOld = (stateOld = measurement.getMeasurementState()).getMeasurementState())) {
            String stateOldTranslated = this.messageService.getDE((Translatable)eStateOld, new Object[0]);
            String stateNewTranslated = this.messageService.getDE((Translatable)eStateNew, new Object[0]);
            AvailableMeasurementStates availableStates = this.measurementService.availableStates(measurement);
            Iterable availableMeasurementStates = availableStates.getAllAvailableStates();
            if (!Iterables.contains((Iterable)availableMeasurementStates, (Object)eStateNew)) {
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_STATE), (Object)eStateNew, String.format("Measurement State cannot be changed from: %s to %s, you are not privileged", eStateOld, eStateNew), Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT_STATE_CHANGE_MISSING_PRIVILEGE, (List)ImmutableList.of((Object)stateOldTranslated, (Object)stateNewTranslated)));
            }
        }
        return true;
    }

    public MeasurementStateChangePrivilegedValidator(MeasurementService measurementService, MessageService messageService) {
        this.measurementService = measurementService;
        this.messageService = messageService;
    }
}

