/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.exception.request.ValueRangeException;
import de.qfm.erp.service.model.internal.fieldname.CascadedFieldName;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.MeasurementModificationBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeUpdateValidator;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class MeasurementBeforeUpdateAmountFactorProductValidator
extends MeasurementBeforeUpdateValidator {
    private static final Range<BigDecimal> AMOUNT_RANGE = Range.range((Comparable)BigDecimal.valueOf(-100000L), (BoundType)BoundType.OPEN, (Comparable)BigDecimal.valueOf(100000L), (BoundType)BoundType.OPEN);
    private static final Range<BigDecimal> FACTOR_RANGE_UPDATE = Range.range((Comparable)BigDecimal.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)BigDecimal.valueOf(100000L), (BoundType)BoundType.OPEN);
    private static final Range<BigDecimal> PRODUCT_RANGE = Range.range((Comparable)BigDecimal.valueOf(-100000L), (BoundType)BoundType.OPEN, (Comparable)BigDecimal.valueOf(100000L), (BoundType)BoundType.OPEN);

    public boolean validate(@NonNull MeasurementModificationBucket measurementModificationBucket) {
        if (measurementModificationBucket == null) {
            throw new NullPointerException("measurementModificationBucket is marked non-null but is null");
        }
        ImmutableList.Builder detailsBuilder = ImmutableList.builder();
        Measurement measurement = (Measurement)measurementModificationBucket.getEntity();
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        Range factorRange = FACTOR_RANGE_UPDATE;
        int position = 0;
        for (MeasurementPosition measurementPosition : measurementPositions) {
            BigDecimal amount = measurementPosition.getAmount();
            detailsBuilder.addAll((Iterable)this.checkWithinRange(position, EField.POSITION_AMOUNT, amount, AMOUNT_RANGE));
            BigDecimal factor1 = measurementPosition.getFactor1();
            detailsBuilder.addAll((Iterable)this.checkWithinRange(position, EField.POSITION_FACTOR_1, factor1, factorRange));
            BigDecimal factor2 = measurementPosition.getFactor2();
            detailsBuilder.addAll((Iterable)this.checkWithinRange(position, EField.POSITION_FACTOR_2, factor2, factorRange));
            BigDecimal factor3 = measurementPosition.getFactor3();
            detailsBuilder.addAll((Iterable)this.checkWithinRange(position, EField.POSITION_FACTOR_3, factor3, factorRange));
            BigDecimal product = measurementPosition.getProduct();
            detailsBuilder.addAll((Iterable)this.checkWithinRange(position, EField.POSITION_PRODUCT, product, PRODUCT_RANGE));
            ++position;
        }
        ImmutableList details = detailsBuilder.build();
        if (!details.isEmpty()) {
            throw new ValueRangeException("Positions contain Validation Errors", (List)details);
        }
        return true;
    }

    @Nonnull
    protected List<RequestValidationException.Detail> checkWithinRange(int position, @NonNull EField field, @Nullable BigDecimal value, @NonNull Range<BigDecimal> referenceRange) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (referenceRange == null) {
            throw new NullPointerException("referenceRange is marked non-null but is null");
        }
        ImmutableList.Builder detailBuilder = ImmutableList.builder();
        if (null != value && !referenceRange.contains((Comparable)value)) {
            CascadedFieldName fieldName = FieldNamesFactory.measurementPositionChild((int)position, (EField)field);
            String fieldPath = fieldName.path();
            String explain = String.format("Position Index: %s", position);
            String messageText = String.format("Field: %s has value: %s and is supposed to be in range: %s, Explain: %s", fieldPath, value, referenceRange, explain);
            Message message = Message.of((EMessageKey)EMessageKey.RANGE, (List)ImmutableList.of((Object)fieldPath, (Object)value, referenceRange, (Object)explain));
            detailBuilder.add((Object)RequestValidationException.Detail.of((FieldName)fieldName, (Object)value, (String)messageText, (Message)message, (List)ImmutableList.of((Object)((BigDecimal)referenceRange.lowerEndpoint()).toPlainString(), (Object)((BigDecimal)referenceRange.upperEndpoint()).toPlainString())));
        }
        return detailBuilder.build();
    }
}

