/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.invoice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.internal.invoice.InvoiceValidationBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeChangeValidator;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeStateChangeValidator;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceMultiFinalInvoiceValidator
extends InvoiceBeforeStateChangeValidator {
    private static final Iterable<EInvoiceType> INVOICE_TYPES_ALLOWED = ImmutableSet.of((Object)EInvoiceType.CREDIT_VOUCHER, (Object)EInvoiceType.CUSTOMER_VOUCHER, (Object)EInvoiceType.INTERNAL_VOUCHER, (Object)EInvoiceType.INTERNAL_INVOICE, (Object)EInvoiceType.INVOICE);

    @Autowired
    public InvoiceMultiFinalInvoiceValidator() {
        super((Iterable)ImmutableSet.of((Object)InvoiceBeforeChangeValidator.EInvoiceValidatorProperty.UPDATE));
    }

    public Iterable<ValidationResult> validate(@NonNull InvoiceValidationBucket validationBucket) {
        if (validationBucket == null) {
            throw new NullPointerException("validationBucket is marked non-null but is null");
        }
        ImmutableList.Builder validationResultBuilder = ImmutableList.builder();
        Iterable finalInvoices = validationBucket.getFinalInvoicesAccounted();
        EInvoiceState invoiceStateNew = validationBucket.getInvoiceStateNew();
        EInvoiceType invoiceTypeNew = validationBucket.getInvoiceTypeNew();
        boolean invoiceTypeAllowed = Iterables.contains((Iterable)INVOICE_TYPES_ALLOWED, (Object)invoiceTypeNew);
        if (!invoiceTypeAllowed && !Iterables.isEmpty((Iterable)finalInvoices) && EInvoiceState.ACCOUNTED == invoiceStateNew) {
            validationResultBuilder.add((Object)ValidationResult.error((Message)Message.of((EMessageKey)EMessageKey.RULE_INVOICE__EXISTING_FINAL_INVOICE_IN_COST_UNIT)));
        }
        return validationResultBuilder.build();
    }
}

