/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.base;

import de.qfm.erp.common.request.UpdateRequest;
import de.qfm.erp.service.model.exception.request.RowVersionDoNotMatchException;
import de.qfm.erp.service.model.internal.UpdateBucket;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.base.BaseValidator;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class RowVersionValidator
extends BaseValidator {
    private final MessageService messageService;

    public boolean validate(@NonNull UpdateBucket updateBucket) {
        int rowVersionRequest;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        UpdateRequest updateRequest = updateBucket.getRequest();
        EntityBase entity = updateBucket.getEntity();
        int rowVersionExisting = entity.getRowVersion();
        if (rowVersionExisting != (rowVersionRequest = updateRequest.getRowVersion())) {
            String className;
            Class<?> aClass = entity.getClass();
            if (aClass == Measurement.class) {
                className = this.messageService.get((Translatable)EEntityClass.MEASUREMENT, new Object[0]);
            } else if (aClass == Quotation.class) {
                Quotation quotation = (Quotation)entity;
                EQStageType stageType = quotation.getStageType();
                className = this.messageService.get((Translatable)stageType, new Object[0]);
            } else {
                className = this.messageService.get((Translatable)EEntityClass.NONE, new Object[0]);
            }
            throw new RowVersionDoNotMatchException(rowVersionRequest, rowVersionExisting, className, String.format("Row Versions do not match; Existing: %s, Request: %s", rowVersionExisting, rowVersionRequest));
        }
        return true;
    }

    public RowVersionValidator(MessageService messageService) {
        this.messageService = messageService;
    }
}

