/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator;

import de.qfm.erp.common.request.user.UserUpdateRequest;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceResetBucket;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthResetBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollStateChangeBucket;
import de.qfm.erp.service.model.internal.invoice.InvoiceValidationBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementChangeBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementModificationBucket;
import de.qfm.erp.service.model.internal.quotation.QStageStateUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.validator.Validators;
import de.qfm.erp.service.service.validator.base.BaseValidator;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeStateChangeValidator;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeUpdateValidator;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeCreateValidator;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeMergeValidator;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeStateChangeValidator;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeUpdateValidator;
import de.qfm.erp.service.service.validator.payroll.AttendanceBeforeMergeValidator;
import de.qfm.erp.service.service.validator.payroll.AttendanceBeforeResetValidator;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeResetValidator;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeStateChangeValidator;
import de.qfm.erp.service.service.validator.quotation.QStageBeforeUpdateValidator;
import de.qfm.erp.service.service.validator.user.UserUpdateRequestValidator;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public final class Validators {
    private List<BaseValidator> baseValidators;
    private List<InvoiceBeforeUpdateValidator> invoiceBeforeUpdateValidators;
    private List<InvoiceBeforeStateChangeValidator> invoiceBeforeStateChangeValidators;
    private List<MeasurementBeforeCreateValidator> measurementBeforeCreateValidators;
    private List<MeasurementBeforeMergeValidator> measurementBeforeMergeValidators;
    private List<MeasurementBeforeUpdateValidator> measurementBeforeUpdateValidators;
    private List<MeasurementBeforeStateChangeValidator> measurementBeforeStateChangeValidators;
    private List<PayrollBeforeMergeValidator> payrollBeforeMergeValidators;
    private List<PayrollBeforeResetValidator> payrollBeforeResetValidators;
    private List<PayrollBeforeStateChangeValidator> payrollBeforeStateChangeValidators;
    private List<AttendanceBeforeMergeValidator> attendanceBeforeMergeValidators;
    private List<AttendanceBeforeResetValidator> attendanceBeforeResetValidations;
    private List<UserUpdateRequestValidator> userUpdateRequestValidators;
    private List<QStageBeforeUpdateValidator> stageBeforeUpdateValidators;

    @Nonnull
    public MeasurementValidation measurementValidation(@NonNull MeasurementModificationBucket measurementModificationBucket) {
        if (measurementModificationBucket == null) {
            throw new NullPointerException("measurementModificationBucket is marked non-null but is null");
        }
        return new MeasurementValidation(measurementModificationBucket, this.baseValidators, this.measurementBeforeCreateValidators, this.measurementBeforeMergeValidators, this.measurementBeforeUpdateValidators);
    }

    @Nonnull
    public InvoiceValidation invoiceValidation(@NonNull InvoiceValidationBucket validationBucket) {
        if (validationBucket == null) {
            throw new NullPointerException("validationBucket is marked non-null but is null");
        }
        return new InvoiceValidation(validationBucket, this.invoiceBeforeUpdateValidators, this.invoiceBeforeStateChangeValidators);
    }

    @Nonnull
    public StageValidation stageValidation(@NonNull StageUpdateBucket stageUpdateBucket) {
        if (stageUpdateBucket == null) {
            throw new NullPointerException("stageUpdateBucket is marked non-null but is null");
        }
        return new StageValidation(stageUpdateBucket, this.baseValidators, this.stageBeforeUpdateValidators);
    }

    @Nonnull
    public StageStateValidation stageValidation(@NonNull QStageStateUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        return new StageStateValidation(updateBucket, this.baseValidators);
    }

    @Nonnull
    public MeasurementStateChangeValidation measurementStateChange(@NonNull MeasurementChangeBucket measurementChangeBucket) {
        if (measurementChangeBucket == null) {
            throw new NullPointerException("measurementChangeBucket is marked non-null but is null");
        }
        return new MeasurementStateChangeValidation(measurementChangeBucket, this.measurementBeforeStateChangeValidators);
    }

    @Nonnull
    public AttendanceUpdateValidation attendanceUpdate(@NonNull Iterable<AttendanceUpdateBucket> updateBuckets) {
        if (updateBuckets == null) {
            throw new NullPointerException("updateBuckets is marked non-null but is null");
        }
        return new AttendanceUpdateValidation(updateBuckets, this.attendanceBeforeMergeValidators);
    }

    @Nonnull
    public AttendanceResetValidation attendanceReset(@NonNull AttendanceResetBucket resetBucket) {
        if (resetBucket == null) {
            throw new NullPointerException("resetBucket is marked non-null but is null");
        }
        return new AttendanceResetValidation(resetBucket, this.attendanceBeforeResetValidations);
    }

    @Nonnull
    public PayrollMonthUpdateValidation payrollMonthUpdate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        return new PayrollMonthUpdateValidation(updateBucket, this.payrollBeforeMergeValidators);
    }

    @Nonnull
    public PayrollMonthResetValidation payrollMonthReset(@NonNull PayrollMonthResetBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        return new PayrollMonthResetValidation(bucket, this.payrollBeforeResetValidators);
    }

    @Nonnull
    public PayrollMonthStateChangeValidation payrollMonthStateChange(@NonNull PayrollStateChangeBucket stateChangeBucket) {
        if (stateChangeBucket == null) {
            throw new NullPointerException("stateChangeBucket is marked non-null but is null");
        }
        return new PayrollMonthStateChangeValidation(stateChangeBucket, this.payrollBeforeStateChangeValidators);
    }

    @Nonnull
    public UserUpdateRequestValidation beforeUserUpdate(@NonNull User user, @NonNull UserUpdateRequest userUpdateRequest) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (userUpdateRequest == null) {
            throw new NullPointerException("userUpdateRequest is marked non-null but is null");
        }
        return new UserUpdateRequestValidation(user, userUpdateRequest, this.userUpdateRequestValidators);
    }

    public Validators(List<BaseValidator> baseValidators, List<InvoiceBeforeUpdateValidator> invoiceBeforeUpdateValidators, List<InvoiceBeforeStateChangeValidator> invoiceBeforeStateChangeValidators, List<MeasurementBeforeCreateValidator> measurementBeforeCreateValidators, List<MeasurementBeforeMergeValidator> measurementBeforeMergeValidators, List<MeasurementBeforeUpdateValidator> measurementBeforeUpdateValidators, List<MeasurementBeforeStateChangeValidator> measurementBeforeStateChangeValidators, List<PayrollBeforeMergeValidator> payrollBeforeMergeValidators, List<PayrollBeforeResetValidator> payrollBeforeResetValidators, List<PayrollBeforeStateChangeValidator> payrollBeforeStateChangeValidators, List<AttendanceBeforeMergeValidator> attendanceBeforeMergeValidators, List<AttendanceBeforeResetValidator> attendanceBeforeResetValidations, List<UserUpdateRequestValidator> userUpdateRequestValidators, List<QStageBeforeUpdateValidator> stageBeforeUpdateValidators) {
        this.baseValidators = baseValidators;
        this.invoiceBeforeUpdateValidators = invoiceBeforeUpdateValidators;
        this.invoiceBeforeStateChangeValidators = invoiceBeforeStateChangeValidators;
        this.measurementBeforeCreateValidators = measurementBeforeCreateValidators;
        this.measurementBeforeMergeValidators = measurementBeforeMergeValidators;
        this.measurementBeforeUpdateValidators = measurementBeforeUpdateValidators;
        this.measurementBeforeStateChangeValidators = measurementBeforeStateChangeValidators;
        this.payrollBeforeMergeValidators = payrollBeforeMergeValidators;
        this.payrollBeforeResetValidators = payrollBeforeResetValidators;
        this.payrollBeforeStateChangeValidators = payrollBeforeStateChangeValidators;
        this.attendanceBeforeMergeValidators = attendanceBeforeMergeValidators;
        this.attendanceBeforeResetValidations = attendanceBeforeResetValidations;
        this.userUpdateRequestValidators = userUpdateRequestValidators;
        this.stageBeforeUpdateValidators = stageBeforeUpdateValidators;
    }
}

