/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.payroll.SalesRevenueGroup;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SalesRevenueXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(SalesRevenueXlsExportService.class);
    private static final BorderStyle DEFAULT_BORDER_STYLE = BorderStyle.THIN;
    private static final int DETAIL_RECIPIENT_ROW_IDX = 0;
    private static final int DETAIL_SENDER_ROW_IDX = 1;
    private static final int DETAIL_INCENTIVE_WAGE_ROW_IDX = 2;
    private static final int DETAIL_QUOTATION_NUMBER_ROW_IDX = 3;
    private static final int DETAIL_FACTOR_ROW_IDX = 4;
    private static final int DETAIL_REVENUE_ROW_IDX = 5;
    private static final int DETAIL_REMARKS_ROW_IDX = 6;
    private static final int GROUPED_SENDER_CC_ROW_IDX = 0;
    private static final int GROUPED_SENDER_ROW_IDX = 1;
    private static final int GROUPED_RECIPIENT_CC_ROW_IDX = 2;
    private static final int GROUPED_RECIPIENT_ROW_IDX = 3;
    private static final int GROUPED_QUOTATION_NUMBER_ROW_IDX = 4;
    private static final int GROUPED_INCENTIVE_WAGE_ROW_IDX = 5;
    private static final int GROUPED_FACTOR_ROW_IDX = 6;
    private static final int GROUPED_REVENUE_ROW_IDX = 7;
    private static final int GROUPED_REMARKS_ROW_IDX = 8;
    public static final BigDecimal DEFAULT_GROUPED_FACTOR = BigDecimal.valueOf(3L);
    public static final short HEADER_HEIGHT = 400;
    public static final short FOOTER_HEIGHT = 1250;

    @Nonnull
    public SXSSFWorkbook detailXLS(@NonNull YearMonth yearMonth, @NonNull Iterable<PayrollMonthItem> payrollMonthItems, @NonNull String senderCostCenter, @NonNull String recipientCostCenter, @NonNull String sheetName) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        if (senderCostCenter == null) {
            throw new NullPointerException("senderCostCenter is marked non-null but is null");
        }
        if (recipientCostCenter == null) {
            throw new NullPointerException("recipientCostCenter is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        String accountingMonthAsString = SalesRevenueXlsExportService.accountingMonthAsString((YearMonth)yearMonth);
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        topHeaderFont.setFontHeight((short)400);
        Font detailsHeaderFont = workbook.createFont();
        detailsHeaderFont.setBold(true);
        Font detailsFooterFont = workbook.createFont();
        detailsFooterFont.setBold(true);
        Font textFont = workbook.createFont();
        textFont.setBold(false);
        int f = 50;
        sheet.setColumnWidth(0, 6250);
        sheet.setColumnWidth(1, 6250);
        sheet.setColumnWidth(2, 3750);
        sheet.setColumnWidth(3, 5000);
        sheet.setColumnWidth(4, 2500);
        sheet.setColumnWidth(5, 5000);
        sheet.setColumnWidth(6, 6250);
        CellRangeAddress mergedHeader = new CellRangeAddress(0, 0, 0, 6);
        sheet.addMergedRegion(mergedHeader);
        CellStyle topHeaderStyle = workbook.createCellStyle();
        topHeaderStyle.setFont(topHeaderFont);
        CellStyle detailsHeaderStyle = workbook.createCellStyle();
        detailsHeaderStyle.setFont(detailsHeaderFont);
        detailsHeaderStyle.setBorderBottom(DEFAULT_BORDER_STYLE);
        detailsHeaderStyle.setBorderLeft(DEFAULT_BORDER_STYLE);
        detailsHeaderStyle.setBorderRight(DEFAULT_BORDER_STYLE);
        detailsHeaderStyle.setBorderTop(DEFAULT_BORDER_STYLE);
        CellStyle detailsFooterStyle = workbook.createCellStyle();
        detailsFooterStyle.setFont(detailsFooterFont);
        detailsFooterStyle.setBorderBottom(DEFAULT_BORDER_STYLE);
        detailsFooterStyle.setBorderLeft(DEFAULT_BORDER_STYLE);
        detailsFooterStyle.setBorderRight(DEFAULT_BORDER_STYLE);
        detailsFooterStyle.setBorderTop(DEFAULT_BORDER_STYLE);
        CellStyle textStyle = workbook.createCellStyle();
        textStyle.setFont(textFont);
        CellStyle detailsLeft = workbook.createCellStyle();
        detailsLeft.setFont(textFont);
        detailsLeft.setBorderLeft(DEFAULT_BORDER_STYLE);
        CellStyle detailsMiddle = workbook.createCellStyle();
        detailsMiddle.setFont(textFont);
        CellStyle detailsRight = workbook.createCellStyle();
        detailsRight.setFont(textFont);
        detailsRight.setBorderRight(DEFAULT_BORDER_STYLE);
        CellStyle footerStyle = workbook.createCellStyle();
        footerStyle.setFont(detailsHeaderFont);
        footerStyle.setAlignment(HorizontalAlignment.CENTER);
        footerStyle.setBorderBottom(DEFAULT_BORDER_STYLE);
        footerStyle.setBorderLeft(DEFAULT_BORDER_STYLE);
        footerStyle.setBorderRight(DEFAULT_BORDER_STYLE);
        footerStyle.setBorderTop(DEFAULT_BORDER_STYLE);
        CellStyles footerFormulaStyle = CellStyles.create((CellStyle)detailsHeaderStyle, (CellStyle)detailsFooterStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)detailsFooterStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)detailsFooterStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)detailsFooterStyle));
        AtomicInteger rowNum = new AtomicInteger(0);
        SXSSFRow header = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)topHeaderStyle, (String)String.format("Umsatzkorrektur f\u00fcr Monat: %s", accountingMonthAsString), (SXSSFRow)header, (int)0);
        SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SXSSFRow meta2 = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)textStyle, (String)"von Kostenstelle:", (SXSSFRow)meta2, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)textStyle, (String)StringUtils.trimToEmpty((String)senderCostCenter), (SXSSFRow)meta2, (int)1);
        SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SXSSFRow meta3 = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)textStyle, (String)"an Kostenstelle:", (SXSSFRow)meta3, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)textStyle, (String)StringUtils.trimToEmpty((String)recipientCostCenter), (SXSSFRow)meta3, (int)1);
        SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SXSSFRow detailsHeader = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Empf\u00e4nger", (SXSSFRow)detailsHeader, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Sender", (SXSSFRow)detailsHeader, (int)1);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Leistungslohn", (SXSSFRow)detailsHeader, (int)2);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Kostentr\u00e4ger", (SXSSFRow)detailsHeader, (int)3);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Faktor", (SXSSFRow)detailsHeader, (int)4);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Umsatz", (SXSSFRow)detailsHeader, (int)5);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Bemerkungen", (SXSSFRow)detailsHeader, (int)6);
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        for (PayrollMonthItem payrollMonthItem : payrollMonthItems) {
            User sender = payrollMonthItem.getSender();
            String senderName = StringUtils.trimToEmpty((String)sender.getFullName());
            User recipient = payrollMonthItem.getRecipient();
            String recipientName = StringUtils.trimToEmpty((String)recipient.getFullName());
            String quotationNumber = StringUtils.trimToEmpty((String)payrollMonthItem.getQuotationNumber());
            BigDecimal value = payrollMonthItem.getValue();
            String remarks = StringUtils.trimToEmpty((String)payrollMonthItem.getRemarks());
            SXSSFRow detailsRow = this.detailsRow(sheet, detailsLeft, detailsMiddle, detailsRight, rowNum, senderName, recipientName, value, quotationNumber, remarks);
            detailRowsBuilder.add((Object)detailsRow);
        }
        SXSSFRow blankDetailsRow = this.detailsRow(sheet, detailsLeft, detailsMiddle, detailsRight, rowNum, "", "", null, "", "");
        detailRowsBuilder.add((Object)blankDetailsRow);
        ImmutableList detailRows = detailRowsBuilder.build();
        SXSSFRow firstRow = (SXSSFRow)detailRows.get(0);
        SXSSFRow lastRow = (SXSSFRow)detailRows.get(detailRows.size() - 1);
        String firstI1 = new CellAddress((Cell)firstRow.getCell(2)).formatAsString();
        String lastI1 = new CellAddress((Cell)lastRow.getCell(2)).formatAsString();
        String sumFormulaI1 = String.format("SUM(%s:%s)", firstI1, lastI1);
        String firstI4 = new CellAddress((Cell)firstRow.getCell(5)).formatAsString();
        String lastI4 = new CellAddress((Cell)lastRow.getCell(5)).formatAsString();
        String sumFormulaI4 = String.format("SUM(%s:%s)", firstI4, lastI4);
        SXSSFRow detailsFooter = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"Summe:", (SXSSFRow)detailsFooter, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)1);
        SalesRevenueXlsExportService.numericFormula((CellStyles)footerFormulaStyle, (String)sumFormulaI1, (SXSSFRow)detailsFooter, (int)2);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)3);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)4);
        SalesRevenueXlsExportService.numericFormula((CellStyles)footerFormulaStyle, (String)sumFormulaI4, (SXSSFRow)detailsFooter, (int)5);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)6);
        workbook.setPrintArea(0, 0, 7, 0, 7 + detailRows.size() - 1 + 3);
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        sheet.setFitToPage(true);
        sheet.getPrintSetup().setFitWidth((short)1);
        sheet.getPrintSetup().setFitHeight((short)1);
        sheet.setDisplayGridlines(true);
        sheet.setPrintGridlines(false);
        return workbook;
    }

    @Nonnull
    public SXSSFWorkbook groupedXLS(@NonNull YearMonth yearMonth, @NonNull Map<SalesRevenueGroup, BigDecimal> groupedPayrollMonthItems, @NonNull String sheetName) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (groupedPayrollMonthItems == null) {
            throw new NullPointerException("groupedPayrollMonthItems is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        String accountingMonthAsString = SalesRevenueXlsExportService.accountingMonthAsString((YearMonth)yearMonth);
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        topHeaderFont.setFontHeight((short)400);
        Font detailsHeaderFont = workbook.createFont();
        detailsHeaderFont.setBold(true);
        Font detailsFooterFont = workbook.createFont();
        detailsFooterFont.setBold(true);
        Font textFont = workbook.createFont();
        textFont.setBold(false);
        int f = 50;
        sheet.setColumnWidth(0, 6250);
        sheet.setColumnWidth(1, 6250);
        sheet.setColumnWidth(2, 6250);
        sheet.setColumnWidth(3, 6250);
        sheet.setColumnWidth(4, 5000);
        sheet.setColumnWidth(5, 3750);
        sheet.setColumnWidth(6, 2500);
        sheet.setColumnWidth(7, 5000);
        sheet.setColumnWidth(8, 6250);
        CellRangeAddress mergedHeader = new CellRangeAddress(0, 0, 0, 6);
        sheet.addMergedRegion(mergedHeader);
        CellStyle topHeaderStyle = workbook.createCellStyle();
        topHeaderStyle.setFont(topHeaderFont);
        CellStyle detailsHeaderStyle = workbook.createCellStyle();
        detailsHeaderStyle.setFont(detailsHeaderFont);
        detailsHeaderStyle.setBorderBottom(DEFAULT_BORDER_STYLE);
        detailsHeaderStyle.setBorderLeft(DEFAULT_BORDER_STYLE);
        detailsHeaderStyle.setBorderRight(DEFAULT_BORDER_STYLE);
        detailsHeaderStyle.setBorderTop(DEFAULT_BORDER_STYLE);
        CellStyle detailsFooterStyle = workbook.createCellStyle();
        detailsFooterStyle.setFont(detailsFooterFont);
        detailsFooterStyle.setBorderBottom(DEFAULT_BORDER_STYLE);
        detailsFooterStyle.setBorderLeft(DEFAULT_BORDER_STYLE);
        detailsFooterStyle.setBorderRight(DEFAULT_BORDER_STYLE);
        detailsFooterStyle.setBorderTop(DEFAULT_BORDER_STYLE);
        CellStyle textStyle = workbook.createCellStyle();
        textStyle.setFont(textFont);
        CellStyle detailsLeft = workbook.createCellStyle();
        detailsLeft.setFont(textFont);
        detailsLeft.setBorderLeft(DEFAULT_BORDER_STYLE);
        CellStyle detailsMiddle = workbook.createCellStyle();
        detailsMiddle.setFont(textFont);
        CellStyle detailsRight = workbook.createCellStyle();
        detailsRight.setFont(textFont);
        detailsRight.setBorderRight(DEFAULT_BORDER_STYLE);
        CellStyle footerStyle = workbook.createCellStyle();
        footerStyle.setFont(detailsHeaderFont);
        footerStyle.setAlignment(HorizontalAlignment.CENTER);
        footerStyle.setBorderBottom(DEFAULT_BORDER_STYLE);
        footerStyle.setBorderLeft(DEFAULT_BORDER_STYLE);
        footerStyle.setBorderRight(DEFAULT_BORDER_STYLE);
        footerStyle.setBorderTop(DEFAULT_BORDER_STYLE);
        CellStyles footerFormulaStyle = CellStyles.create((CellStyle)detailsHeaderStyle, (CellStyle)detailsFooterStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)detailsFooterStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)detailsFooterStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)detailsFooterStyle));
        AtomicInteger rowNum = new AtomicInteger(0);
        SXSSFRow header = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)topHeaderStyle, (String)String.format("Umsatzkorrektur f\u00fcr Monat: %s", accountingMonthAsString), (SXSSFRow)header, (int)0);
        SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SXSSFRow detailsHeader = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Sender (KST)", (SXSSFRow)detailsHeader, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Sender (Name)", (SXSSFRow)detailsHeader, (int)1);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Empf\u00e4nger (KST)", (SXSSFRow)detailsHeader, (int)2);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Empf\u00e4nger (Name)", (SXSSFRow)detailsHeader, (int)3);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Kostentr\u00e4ger", (SXSSFRow)detailsHeader, (int)4);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Leistungslohn", (SXSSFRow)detailsHeader, (int)5);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Faktor", (SXSSFRow)detailsHeader, (int)6);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Umsatz", (SXSSFRow)detailsHeader, (int)7);
        SalesRevenueXlsExportService.createText((CellStyle)detailsHeaderStyle, (String)"Bemerkungen", (SXSSFRow)detailsHeader, (int)8);
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        for (Map.Entry<SalesRevenueGroup, BigDecimal> entry : groupedPayrollMonthItems.entrySet()) {
            SalesRevenueGroup salesRevenueGroup = entry.getKey();
            BigDecimal value = entry.getValue();
            String senderCC = StringUtils.trimToEmpty((String)salesRevenueGroup.getSenderCC());
            String senderName = StringUtils.trimToEmpty((String)salesRevenueGroup.getSenderName());
            String recipientCC = StringUtils.trimToEmpty((String)salesRevenueGroup.getRecipientCC());
            String recipientName = StringUtils.trimToEmpty((String)salesRevenueGroup.getRecipientName());
            String quotationNumber = StringUtils.trimToEmpty((String)salesRevenueGroup.getQuotationNumber());
            SXSSFRow detailsRow = this.groupedRow(sheet, detailsLeft, detailsMiddle, detailsRight, rowNum, senderCC, senderName, recipientCC, recipientName, value, quotationNumber);
            detailRowsBuilder.add((Object)detailsRow);
        }
        SXSSFRow blankDetailsRow = this.groupedRow(sheet, detailsLeft, detailsMiddle, detailsRight, rowNum, "", "", "", "", null, "");
        detailRowsBuilder.add((Object)blankDetailsRow);
        ImmutableList detailRows = detailRowsBuilder.build();
        SXSSFRow firstRow = (SXSSFRow)detailRows.get(0);
        SXSSFRow lastRow = (SXSSFRow)detailRows.get(detailRows.size() - 1);
        String firstI1 = new CellAddress((Cell)firstRow.getCell(5)).formatAsString();
        String lastI1 = new CellAddress((Cell)lastRow.getCell(5)).formatAsString();
        String sumFormulaI1 = String.format("SUM(%s:%s)", firstI1, lastI1);
        String firstI4 = new CellAddress((Cell)firstRow.getCell(7)).formatAsString();
        String lastI4 = new CellAddress((Cell)lastRow.getCell(7)).formatAsString();
        String sumFormulaI4 = String.format("SUM(%s:%s)", firstI4, lastI4);
        SXSSFRow detailsFooter = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)1);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)2);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)3);
        SalesRevenueXlsExportService.numericFormula((CellStyles)footerFormulaStyle, (String)sumFormulaI1, (SXSSFRow)detailsFooter, (int)5);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"Summe:", (SXSSFRow)detailsFooter, (int)4);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)6);
        SalesRevenueXlsExportService.numericFormula((CellStyles)footerFormulaStyle, (String)sumFormulaI4, (SXSSFRow)detailsFooter, (int)7);
        SalesRevenueXlsExportService.createText((CellStyle)detailsFooterStyle, (String)"", (SXSSFRow)detailsFooter, (int)8);
        workbook.setPrintArea(0, 0, 7, 0, 7 + detailRows.size() - 1 + 3 + 6);
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        sheet.setFitToPage(true);
        sheet.getPrintSetup().setFitWidth((short)1);
        sheet.getPrintSetup().setFitHeight((short)1);
        sheet.setDisplayGridlines(true);
        sheet.setPrintGridlines(false);
        return workbook;
    }

    @Nonnull
    private SXSSFRow detailsRow(SXSSFSheet sheet, CellStyle styleLeft, CellStyle styleMiddle, CellStyle styleRight, AtomicInteger rowNum, String sender, String recipient, BigDecimal o, String s2, String s3) {
        CellStyles middleStyle = CellStyles.create((CellStyle)styleMiddle, (CellStyle)styleMiddle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)styleMiddle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)styleMiddle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)styleMiddle));
        SXSSFRow blankDetailsRow = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)styleLeft, (String)recipient, (SXSSFRow)blankDetailsRow, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)styleMiddle, (String)sender, (SXSSFRow)blankDetailsRow, (int)1);
        SXSSFCell valueCell = SalesRevenueXlsExportService.createNumber((CellStyles)middleStyle, (BigDecimal)o, (SXSSFRow)blankDetailsRow, (int)2);
        SalesRevenueXlsExportService.createText((CellStyle)styleMiddle, (String)s2, (SXSSFRow)blankDetailsRow, (int)3);
        SXSSFCell factorCell = SalesRevenueXlsExportService.createNumber((CellStyles)middleStyle, (Integer)null, (SXSSFRow)blankDetailsRow, (int)4);
        String f1 = new CellAddress((Cell)valueCell).formatAsString();
        String f2 = new CellAddress((Cell)factorCell).formatAsString();
        SalesRevenueXlsExportService.numericFormula((CellStyles)middleStyle, (String)String.format("%s*%s", f1, f2), (SXSSFRow)blankDetailsRow, (int)5);
        SalesRevenueXlsExportService.createText((CellStyle)styleRight, (String)s3, (SXSSFRow)blankDetailsRow, (int)6);
        return blankDetailsRow;
    }

    @Nonnull
    private SXSSFRow groupedRow(SXSSFSheet sheet, CellStyle styleLeft, CellStyle styleMiddle, CellStyle styleRight, AtomicInteger rowNum, String senderCC, String sender, String recipientCC, String recipient, BigDecimal o, String s2) {
        CellStyles middleStyle = CellStyles.create((CellStyle)styleMiddle, (CellStyle)styleMiddle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)styleMiddle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)styleMiddle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)styleMiddle));
        SXSSFRow blankDetailsRow = SalesRevenueXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        SalesRevenueXlsExportService.createText((CellStyle)styleLeft, (String)senderCC, (SXSSFRow)blankDetailsRow, (int)0);
        SalesRevenueXlsExportService.createText((CellStyle)styleMiddle, (String)sender, (SXSSFRow)blankDetailsRow, (int)1);
        SalesRevenueXlsExportService.createText((CellStyle)styleMiddle, (String)recipientCC, (SXSSFRow)blankDetailsRow, (int)2);
        SalesRevenueXlsExportService.createText((CellStyle)styleMiddle, (String)recipient, (SXSSFRow)blankDetailsRow, (int)3);
        SXSSFCell valueCell = SalesRevenueXlsExportService.createNumber((CellStyles)middleStyle, (BigDecimal)o, (SXSSFRow)blankDetailsRow, (int)5);
        SalesRevenueXlsExportService.createText((CellStyle)styleMiddle, (String)s2, (SXSSFRow)blankDetailsRow, (int)4);
        SXSSFCell factorCell = SalesRevenueXlsExportService.createNumber((CellStyles)middleStyle, (BigDecimal)DEFAULT_GROUPED_FACTOR, (SXSSFRow)blankDetailsRow, (int)6);
        String f1 = new CellAddress((Cell)valueCell).formatAsString();
        String f2 = new CellAddress((Cell)factorCell).formatAsString();
        SalesRevenueXlsExportService.numericFormula((CellStyles)middleStyle, (String)String.format("%s*%s", f1, f2), (SXSSFRow)blankDetailsRow, (int)7);
        SalesRevenueXlsExportService.createText((CellStyle)styleRight, (String)"", (SXSSFRow)blankDetailsRow, (int)8);
        return blankDetailsRow;
    }
}

