/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import de.qfm.erp.service.model.internal.dashboard.NotAccountedMeasurementGrouped;
import de.qfm.erp.service.model.internal.dashboard.NotAccountedMeasurementUngrouped;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.NalXlsExportService;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NalXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(NalXlsExportService.class);

    @Nonnull
    public SXSSFWorkbook ungroupedXLS(@NonNull Iterable<NotAccountedMeasurementUngrouped> notAccountedMeasurements, @NonNull String sheetName) {
        if (notAccountedMeasurements == null) {
            throw new NullPointerException("notAccountedMeasurements is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        Font detailsFont = workbook.createFont();
        detailsFont.setBold(false);
        for (NALColumnUngrouped nalColumn : NALColumnUngrouped.values()) {
            sheet.setColumnWidth(nalColumn.index, 3750);
        }
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(topHeaderFont);
        CellStyle detailsStyle = workbook.createCellStyle();
        detailsStyle.setFont(detailsFont);
        CellStyles cellStyles = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle));
        AtomicInteger rowNum = new AtomicInteger();
        SXSSFRow header1 = NalXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        NalXlsExportService.createText((CellStyle)headerStyle, (String)"Auswertung unfertige Leistung (Kostenstellen)", (SXSSFRow)header1, (int)0);
        SXSSFRow header2 = NalXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        for (NALColumnUngrouped nalColumn : NALColumnUngrouped.values()) {
            NalXlsExportService.createText((CellStyle)headerStyle, (String)nalColumn.name, (SXSSFRow)header2, (int)nalColumn.index);
        }
        for (NotAccountedMeasurementUngrouped nalColumn : notAccountedMeasurements) {
            SXSSFRow detailRow = NalXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
            block7: for (NALColumnUngrouped nalMColumnUngrouped : NALColumnUngrouped.values()) {
                DSOType dsoType = nalMColumnUngrouped.getDsoType();
                Object value = nalMColumnUngrouped.getFn().apply(nalColumn);
                switch (dsoType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.ZERO;
                        NalXlsExportService.createNumber((CellStyles)cellStyles, (BigDecimal)bdValue, (SXSSFRow)detailRow, (int)nalMColumnUngrouped.index);
                        continue block7;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = value instanceof String ? (String)value : "";
                        NalXlsExportService.createText((CellStyle)detailsStyle, (String)stringValue, (SXSSFRow)detailRow, (int)nalMColumnUngrouped.index);
                    }
                }
            }
        }
        sheet.setDisplayGridlines(true);
        return workbook;
    }

    @Nonnull
    public SXSSFWorkbook groupedXLS(@NonNull Iterable<NotAccountedMeasurementGrouped> notAccountedMeasurements, @NonNull String sheetName) {
        if (notAccountedMeasurements == null) {
            throw new NullPointerException("notAccountedMeasurements is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        Font detailsFont = workbook.createFont();
        detailsFont.setBold(false);
        for (NALColumnUngrouped NALColumnUngrouped2 : NALColumnUngrouped.values()) {
            sheet.setColumnWidth(NALColumnUngrouped2.index, 3750);
        }
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(topHeaderFont);
        CellStyle detailsStyle = workbook.createCellStyle();
        detailsStyle.setFont(detailsFont);
        CellStyles cellStyles = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle));
        AtomicInteger rowNum = new AtomicInteger();
        SXSSFRow header1 = NalXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        NalXlsExportService.createText((CellStyle)headerStyle, (String)"Auswertung unfertige Leistung (Kostenstellen)", (SXSSFRow)header1, (int)0);
        SXSSFRow header2 = NalXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        for (NALColumnGrouped nalColumn : NALColumnGrouped.values()) {
            NalXlsExportService.createText((CellStyle)headerStyle, (String)nalColumn.name, (SXSSFRow)header2, (int)nalColumn.index);
        }
        for (NotAccountedMeasurementGrouped notAccountedMeasurement : notAccountedMeasurements) {
            SXSSFRow detailRow = NalXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
            block7: for (NALColumnGrouped nalColumn : NALColumnGrouped.values()) {
                DSOType dsoType = nalColumn.getDsoType();
                Object value = nalColumn.getFn().apply(notAccountedMeasurement);
                switch (dsoType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.ZERO;
                        NalXlsExportService.createNumber((CellStyles)cellStyles, (BigDecimal)bdValue, (SXSSFRow)detailRow, (int)nalColumn.index);
                        continue block7;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = value instanceof String ? (String)value : "";
                        NalXlsExportService.createText((CellStyle)detailsStyle, (String)stringValue, (SXSSFRow)detailRow, (int)nalColumn.index);
                    }
                }
            }
        }
        sheet.setDisplayGridlines(true);
        return workbook;
    }
}

