/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.base.Joiner;
import de.qfm.erp.service.model.internal.invoice.DailySaleOutInvoice;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.EndOfDayXlsExportService;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EndOfDayXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(EndOfDayXlsExportService.class);
    public static final Joiner MEASUREMENT_NUMBER_JOINER = Joiner.on((char)',').skipNulls();

    @Nonnull
    public SXSSFWorkbook detailXLS(@NonNull Iterable<DailySaleOutInvoice> dailySaleOutInvoices, @NonNull String sheetName) {
        if (dailySaleOutInvoices == null) {
            throw new NullPointerException("dailySaleOutInvoices is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        Font detailsFoont = workbook.createFont();
        detailsFoont.setBold(false);
        for (DSOColumn dsoColumn : DSOColumn.values()) {
            sheet.setColumnWidth(dsoColumn.index, 3750);
        }
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(topHeaderFont);
        CellStyle detailsStyle = workbook.createCellStyle();
        detailsStyle.setFont(detailsFoont);
        CellStyles cellStyles = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle));
        AtomicInteger rowNum = new AtomicInteger();
        SXSSFRow detailsHeader = EndOfDayXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        for (DSOColumn dsoColumn : DSOColumn.values()) {
            EndOfDayXlsExportService.createText((CellStyle)headerStyle, (String)dsoColumn.name, (SXSSFRow)detailsHeader, (int)dsoColumn.index);
        }
        for (DailySaleOutInvoice dsoItem : dailySaleOutInvoices) {
            SXSSFRow detailRow = EndOfDayXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
            block7: for (DSOColumn dsoColumn : DSOColumn.values()) {
                DSOType dsoType = dsoColumn.getDsoType();
                Object value = dsoColumn.getFn().apply(dsoItem);
                switch (dsoType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.ZERO;
                        EndOfDayXlsExportService.createNumber((CellStyles)cellStyles, (BigDecimal)bdValue, (SXSSFRow)detailRow, (int)dsoColumn.index);
                        continue block7;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = value instanceof String ? (String)value : "";
                        EndOfDayXlsExportService.createText((CellStyle)detailsStyle, (String)stringValue, (SXSSFRow)detailRow, (int)dsoColumn.index);
                    }
                }
            }
        }
        sheet.setDisplayGridlines(true);
        return workbook;
    }
}

