/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.service.service.xls.CustomerTemplateAEBExportService;
import de.qfm.erp.service.service.service.xls.CustomerTemplateExportService;
import de.qfm.erp.service.service.service.xls.ECustomerTemplateAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CustomerTemplateAEBExportService
extends CustomerTemplateExportService {
    private static final Logger log = LogManager.getLogger(CustomerTemplateAEBExportService.class);

    @Nonnull
    public ECustomerTemplateAlgorithm algorithm() {
        return ECustomerTemplateAlgorithm.AEB;
    }

    @Nonnull
    public String mediaType() {
        return "application/octet-stream";
    }

    public boolean detailXLS(@NonNull InputStream bis, @NonNull OutputStream bos, @NonNull Quotation stage, @NonNull String projectNumber, @NonNull String orderNumber, @NonNull String orderText, @NonNull Iterable<MeasurementPosition> measurementPositions) throws IOException {
        if (bis == null) {
            throw new NullPointerException("bis is marked non-null but is null");
        }
        if (bos == null) {
            throw new NullPointerException("bos is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (projectNumber == null) {
            throw new NullPointerException("projectNumber is marked non-null but is null");
        }
        if (orderNumber == null) {
            throw new NullPointerException("orderNumber is marked non-null but is null");
        }
        if (orderText == null) {
            throw new NullPointerException("orderText is marked non-null but is null");
        }
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        XSSFWorkbook workbook = new XSSFWorkbook(bis);
        ImmutableListMultimap byExternalPosNr = Multimaps.index(measurementPositions, MeasurementPosition::getPositionNumberExternal);
        ImmutableListMultimap byCleanedSPN = Multimaps.index(measurementPositions, item -> {
            boolean standardPositionType;
            boolean bl = standardPositionType = item.getAlternativePositionType() == EAlternativePositionType.NO;
            if (!standardPositionType) {
                return StringUtils.removeStart((String)StringUtils.remove((String)StringUtils.substringBeforeLast((String)item.getSurrogatePositionNumber(), (String)"."), (String)"."), (String)"0");
            }
            return StringUtils.removeStart((String)StringUtils.remove((String)item.getSurrogatePositionNumber(), (String)"."), (String)"0");
        });
        XSSFSheet sheet1 = workbook.getSheet("\u00dcbersicht");
        String stageNumber = stage.getQNumber();
        ContactPerson contactPerson = stage.getContactPerson();
        String contactPersonName = null != contactPerson ? StringUtils.trimToEmpty((String)contactPerson.getFirstName()) + " " + StringUtils.trimToEmpty((String)contactPerson.getLastName()) : "";
        String measurementNumbers = Streams.stream(measurementPositions).map(MeasurementPosition::getMeasurement).filter(Objects::nonNull).map(Measurement::getMeasurementNumber).filter(Objects::nonNull).sorted().distinct().collect(Collectors.joining(","));
        CustomerTemplateAEBExportService.updateText((String)stageNumber, (XSSFSheet)sheet1, (CellAddress)new CellAddress("B2"));
        CustomerTemplateAEBExportService.updateText((String)orderText, (XSSFSheet)sheet1, (CellAddress)new CellAddress("B3"));
        CustomerTemplateAEBExportService.updateText((String)measurementNumbers, (XSSFSheet)sheet1, (CellAddress)new CellAddress("B4"));
        CustomerTemplateAEBExportService.updateText((String)projectNumber, (XSSFSheet)sheet1, (CellAddress)new CellAddress("B5"));
        CustomerTemplateAEBExportService.updateText((String)contactPersonName, (XSSFSheet)sheet1, (CellAddress)new CellAddress("B6"));
        CustomerTemplateAEBExportService.updateText((String)orderNumber, (XSSFSheet)sheet1, (CellAddress)new CellAddress("B7"));
        CustomerTemplateAEBExportService.apply((XSSFSheet)sheet1, (Multimap)byExternalPosNr, (Multimap)byCleanedSPN, (String)"B", (String)"C", (String)"E");
        workbook.setForceFormulaRecalculation(true);
        workbook.write(bos);
        return true;
    }

    private static void apply(XSSFSheet sheet, Multimap<String, MeasurementPosition> byExternalPosNr, Multimap<String, MeasurementPosition> byCleanedSPN, String extPosCol, String shortTextCol, String amountCol) {
        for (int i = 2; i < 100; ++i) {
            boolean containsExternalPosNr;
            CellAddress cellAddressExternalPosNR = new CellAddress(extPosCol + i);
            CellAddress cellAddressShortText = new CellAddress(shortTextCol + i);
            CellAddress cellAddressAmount = new CellAddress(amountCol + i);
            if (null == sheet.getRow(i)) break;
            String supposedExternalPosNr = CustomerTemplateAEBExportService.textValue((Sheet)sheet, (CellAddress)cellAddressExternalPosNR).orElse("");
            boolean bl = containsExternalPosNr = StringUtils.isNotBlank((CharSequence)supposedExternalPosNr) && byExternalPosNr.containsKey((Object)supposedExternalPosNr);
            if (containsExternalPosNr) {
                Collection measurementPositionsByExtPosNr = byExternalPosNr.get((Object)supposedExternalPosNr);
                BigDecimal productByPosNr = measurementPositionsByExtPosNr.stream().map(MeasurementHelper.FN_JUMBO_PROD).reduce(BigDecimal.ZERO, BigDecimal::add);
                CustomerTemplateAEBExportService.updateNumber((BigDecimal)productByPosNr, (XSSFSheet)sheet, (CellAddress)cellAddressAmount);
                continue;
            }
            String supposedShortText = CustomerTemplateAEBExportService.textValue((Sheet)sheet, (CellAddress)cellAddressShortText).orElse("");
            String supposedCleanedSPN = StringUtils.remove((String)StringUtils.removeStart((String)StringUtils.substringBefore((String)supposedShortText, (String)" "), (String)"0"), (String)".");
            if (!byCleanedSPN.containsKey((Object)supposedCleanedSPN)) continue;
            Collection measurementPositionsByPosNr = byCleanedSPN.get((Object)supposedCleanedSPN);
            BigDecimal productByPosNr = measurementPositionsByPosNr.stream().map(MeasurementHelper.FN_JUMBO_PROD).reduce(BigDecimal.ZERO, BigDecimal::add);
            CustomerTemplateAEBExportService.updateNumber((BigDecimal)productByPosNr, (XSSFSheet)sheet, (CellAddress)cellAddressAmount);
        }
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Sheet sheet, @NonNull CellAddress cellAddress) {
        Cell cell;
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cellAddress == null) {
            throw new NullPointerException("cellAddress is marked non-null but is null");
        }
        Row row = sheet.getRow(cellAddress.getRow());
        if (null != row && null != (cell = row.getCell(cellAddress.getColumn()))) {
            return CustomerTemplateAEBExportService.textValue((Cell)cell);
        }
        return Optional.empty();
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Cell cell) {
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return Optional.of(cell.getStringCellValue());
            }
            case 2: {
                return Optional.of(((XSSFCell)cell).getRawValue());
            }
            case 3: {
                break;
            }
            case 4: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (cachedFormulaResultType == CellType.ERROR) {
                    byte by = cell.getErrorCellValue();
                    break;
                }
                if (cachedFormulaResultType == CellType.STRING) {
                    return Optional.of(cell.getStringCellValue());
                }
                if (cachedFormulaResultType == CellType.NUMERIC) break;
                log.warn("TODO: {}", (Object)cell.getCellType().name());
                break;
            }
            case 5: {
                log.warn("ERROR Cell: {}", (Object)cell.getErrorCellValue());
                break;
            }
            default: {
                return Optional.of(cell.getStringCellValue());
            }
        }
        return Optional.empty();
    }
}

