/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthSlipInfo;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthSlipItemPrintRow;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PayrollMonthSlipPrintService
extends AbstractPrintService<PayrollMonthSlipInfo, PayrollMonthPrintConfiguration> {
    private static final Logger log = LogManager.getLogger(PayrollMonthSlipPrintService.class);
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public PayrollMonthSlipPrintService(UserService userService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull PayrollMonthSlipInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        YearMonth yearMonth = printInfo.getYearMonth();
        String yearMonthsAsString = String.format("%02d/%d", yearMonth.getMonthValue(), yearMonth.getYear());
        String userFullName = printInfo.getEmployeeFullName();
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("Lohnkarte: %s", yearMonthsAsString));
        documentInformation.setSubject(String.format("Mitarbeiter: %s", userFullName));
        return documentInformation;
    }

    @Nonnull
    private List<Table> headers(@NonNull PayrollMonthSlipInfo payrollMonthSlipInfo, @NonNull PDDocument document, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) throws IOException {
        if (payrollMonthSlipInfo == null) {
            throw new NullPointerException("payrollMonthSlipInfo is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        byte[] imageBuffer = printSetup.getLogoBuffer();
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])imageBuffer, (String)"");
        String laborContractName = StringUtils.trimToEmpty((String)payrollMonthSlipInfo.getLaborContractName());
        Table.TableBuilder header1Builder = PayrollMonthSlipPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.2f)));
        String title = String.format("Lohnkarte gewerbliche Mitarbeiter (%s)", laborContractName);
        Row header1Row1 = Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.titleCell((PrintSetup)printSetup, (PDFont)fontBold, (String)title)).add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.CENTER)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.25f)).build()).build();
        header1Builder.addRow(header1Row1);
        Table header = header1Builder.build();
        return ImmutableList.of((Object)header);
    }

    @Nonnull
    private Table footer(@NonNull PayrollMonthSlipInfo payrollMonthSlipInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (payrollMonthSlipInfo == null) {
            throw new NullPointerException("payrollMonthSlipInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        Table.TableBuilder footerBuilder = PayrollMonthSlipPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.1f)));
        int printFontSize = printSetup.getDetailsFontSize();
        Map aggregation = payrollMonthSlipInfo.getAggregation();
        Duration workingHours = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_WORK, Duration.ZERO);
        String workingHoursAsString = PayrollMonthSlipPrintService.durationAsHourString((Duration)workingHours);
        Duration vacationHours = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_VACATION, Duration.ZERO);
        String vacationHoursAsString = PayrollMonthSlipPrintService.durationAsHourString((Duration)vacationHours);
        Duration sickHours = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_SICK, Duration.ZERO);
        String sickHoursAsString = PayrollMonthSlipPrintService.durationAsHourString((Duration)sickHours);
        Duration badWeatherHours = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER, Duration.ZERO);
        String badWeatherAsString = PayrollMonthSlipPrintService.durationAsHourString((Duration)badWeatherHours);
        Duration sickBadWeatherHours = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER_SICK, Duration.ZERO);
        String sickBadWeatherAsString = PayrollMonthSlipPrintService.durationAsHourString((Duration)sickBadWeatherHours);
        Duration absentHoursChild = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_CHILD_SICK_LEAVE, Duration.ZERO);
        Duration absentHoursChildEffective = absentHoursChild.isNegative() ? Duration.ZERO : absentHoursChild;
        Duration absentHours = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_ABSENT, Duration.ZERO);
        Duration absentHoursEffective = absentHours.isNegative() ? Duration.ZERO : absentHours;
        String absentHoursAsString = PayrollMonthSlipPrintService.durationAsHourString((Duration)absentHoursEffective.plus(absentHoursChildEffective));
        Duration bankingHolidayHours = aggregation.getOrDefault(EAggregatedAttendanceDayType.AGG_BANKING_HOLIDAYS, Duration.ZERO);
        Duration sum = PayrollMonthSlipPrintService.durationSum((Map)aggregation).plus(bankingHolidayHours);
        String sumAsString = PayrollMonthSlipPrintService.durationAsHourString((Duration)sum);
        String remarks = StringUtils.trimToEmpty((String)payrollMonthSlipInfo.getRemarks());
        boolean releaseState = payrollMonthSlipInfo.isReleaseState();
        String releaseEmployeeFullName = StringUtils.trimToEmpty((String)payrollMonthSlipInfo.getReleasedByUserFullName());
        LocalDateTime releaseDate = payrollMonthSlipInfo.getReleaseDate();
        String releaseDateTimeString = this.dateTimeAsString(releaseDate, arg_0 -> ((DateTimeHelperService)this.dateTimeHelperService).convertToDestination(arg_0));
        String remarksSignature = releaseState ? String.format("Freigegeben durch %s am/um %s", releaseEmployeeFullName, releaseDateTimeString) : "Nicht freigegeben";
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Bemerkungen", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Arbeit", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)String.format("%s Std", workingHoursAsString), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)B)).build());
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)remarks, (int)1, (int)5, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)LR)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Urlaub", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)String.format("%s Std", vacationHoursAsString), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)B)).build());
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Krank", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)String.format("%s Std", sickHoursAsString), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)B)).build());
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"SW", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)String.format("%s Std", badWeatherAsString), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)B)).build());
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Krank-SW", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)String.format("%s Std", sickBadWeatherAsString), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)B)).build());
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Fehlzeit", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)String.format("%s Std", absentHoursAsString), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)B)).build());
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)remarksSignature, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)LRB)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Gesamt", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)String.format("%s Std", sumAsString), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)B)).build());
        return footerBuilder.build();
    }

    public byte[] generatePDF(@NonNull PayrollMonthSlipInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block22: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight());
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getPayrollLogoPadding, PrintLayoutConfig::getPayrollLogoHeight, PrintLayoutConfig::getPayrollLogoBuffer);
                float maxDetailsWidth = PayrollMonthSlipPrintService.maxDetailsWidth((PDRectangle)mediaBox);
                float maxDetailsHeight = PayrollMonthSlipPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)0.0f, (float)0.0f, (float)0.0f);
                List headers = this.headers(printInfo, document, mediaBox, printSetup);
                Table footer = this.footer(printInfo, printSetup, mediaBox);
                List details = this.details(printInfo, printSetup, mediaBox);
                if (details.isEmpty()) {
                    PayrollMonthSlipPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    for (Table detailsTable : details) {
                        PDPage page = PayrollMonthSlipPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                            float yOffset = PayrollMonthSlipPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                            TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset -= 10.0f).table(detailsTable).build().draw();
                            float dataTableWidth = PayrollMonthSlipPrintService.width((Table)detailsTable);
                            float dataTableHeight = PayrollMonthSlipPrintService.height((Table)detailsTable);
                            ImmutableList.Builder filledUpColumnsBuilder = ImmutableList.builder();
                            boolean fillUpTable = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.FILL_UP_TABLE_ENABLED);
                            if (fillUpTable && !PayrollMonthSlipPrintService.almostSame((float)dataTableWidth, (float)maxDetailsWidth)) {
                                Table fillUpTableRight = PayrollMonthSlipPrintService.fillUpTableRight((PrintSetup)printSetup, (Table)detailsTable, (PDRectangle)mediaBox, (float)maxDetailsHeight);
                                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f + dataTableWidth).startY(yOffset).table(fillUpTableRight).build().draw();
                                filledUpColumnsBuilder.addAll((Iterable)fillUpTableRight.getColumns());
                            }
                            ImmutableList fillUpColumns = filledUpColumnsBuilder.build();
                            yOffset -= detailsTable.getHeight();
                            if (fillUpTable && !PayrollMonthSlipPrintService.almostSame((float)dataTableHeight, (float)maxDetailsHeight)) {
                                Table fillUpTableBelow = PayrollMonthSlipPrintService.fillUpTableBelow((PrintSetup)printSetup, (Table)detailsTable, (int)3, (float)maxDetailsHeight);
                                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(fillUpTableBelow).build().draw();
                                yOffset -= fillUpTableBelow.getHeight();
                                yOffset -= 10.0f;
                            }
                            yOffset -= this.printFooter(contentStream, page, footer);
                        }
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    private float printFooter(@NonNull PDPageContentStream contentStream, @NonNull PDPage page, @NonNull Table footer) {
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        PDRectangle mediaBox = page.getMediaBox();
        float footerHeight = footer.getHeight();
        float yOffset = 30.0f + footerHeight;
        TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(footer).build().draw();
        return yOffset -= footer.getHeight();
    }

    @Nonnull
    private List<Table> details(@NonNull PayrollMonthSlipInfo printInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int detailsFontSize = printSetup.getDetailsFontSize();
        Iterable payrollMonthItemPrintRows = printInfo.getPayrollMonthSlipItemPrintRows();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.3125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f));
        Table.TableBuilder tableBuilder = PayrollMonthSlipPrintService.table((PDRectangle)mediaBox, (Iterable)columnWidths);
        Row headline1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"Monat / Jahr", (int)2, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"Pers-Nr", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"Name", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"LA", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"Zeit", (int)2, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"Faktor", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"Betrag", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).build();
        YearMonth yearMonth = printInfo.getYearMonth();
        String yearMonthsAsString = String.format("%s/%s", yearMonth.getMonthValue(), yearMonth.getYear());
        String personalNumber = StringUtils.trimToEmpty((String)printInfo.getPersonalNumber());
        String fullName = StringUtils.trimToEmpty((String)printInfo.getEmployeeFullName());
        Row headline2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)yearMonthsAsString, (int)2, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)LRB)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)personalNumber, (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)LRB)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)fullName, (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)LRB)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)LRB)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)2, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)LRB)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)LRB)).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)LRB)).build();
        tableBuilder.addRow(headline1);
        tableBuilder.addRow(headline2);
        AtomicInteger rowNumber = new AtomicInteger();
        AtomicInteger detailRowNumber = new AtomicInteger();
        for (PayrollMonthSlipItemPrintRow item : payrollMonthItemPrintRows) {
            boolean isDetail = Boolean.TRUE.equals(item.getDetailFlag());
            if (!isDetail) {
                rowNumber.incrementAndGet();
                detailRowNumber.set(0);
            }
            String rowNumberAsString = Integer.toString(rowNumber.get());
            String detailRowNumberAsString = isDetail ? Integer.toString(detailRowNumber.incrementAndGet()) : "";
            String rowNumberWithChild = isDetail ? String.format("%s.%s", rowNumberAsString, detailRowNumberAsString) : rowNumberAsString;
            String name = item.getName();
            String unit = item.getUnit();
            String description = item.getDescription();
            BigDecimal descriptionValue = item.getDescriptionValue();
            String descriptionValueAsString = PayrollMonthSlipPrintService.asString((BigDecimal)descriptionValue, (String)"", (boolean)false);
            Integer wageTypeNumber = item.getWageTypeNumber();
            String wageTypeNumberAsString = this.asString(wageTypeNumber, "");
            BigDecimal time = item.getTimes();
            BigDecimal factor = item.getFactor();
            BigDecimal amount = item.getValue();
            boolean hideFactorOnEmptyTime = time == null || 0 == time.compareTo(BigDecimal.ZERO);
            String timeAsString = PayrollMonthSlipPrintService.asString((BigDecimal)time, (String)"", (boolean)false);
            String factorAsString = hideFactorOnEmptyTime ? "" : PayrollMonthSlipPrintService.asString((BigDecimal)factor, (String)"", (boolean)false);
            String amountAsString = PayrollMonthSlipPrintService.asString((BigDecimal)amount, (String)"", (boolean)false);
            String concatenatedDescription = String.format("%s %s", description, descriptionValueAsString);
            Row detail = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)rowNumberWithChild, (int)1, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)L)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)name, (int)2, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLB)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)concatenatedDescription, (int)1, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TRB)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)wageTypeNumberAsString, (int)1, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)ALL)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)unit, (int)1, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLB)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)timeAsString, (int)1, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)TRB)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)factorAsString, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)PayrollMonthSlipPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)amountAsString, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(detail);
        }
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthSlipPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)Iterables.size((Iterable)columnWidths), (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).build());
        Table table = tableBuilder.build();
        return ImmutableList.of((Object)table);
    }

    @Nonnull
    private String asString(@Nullable Integer value, @NonNull String fallback) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        return null != value ? Integer.toString(value) : fallback;
    }

    @Nonnull
    private static String asString(@Nullable BigDecimal value, @NonNull String fallback, boolean printZero) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        if (null != value && (0 != value.compareTo(BigDecimal.ZERO) || printZero)) {
            return BigDecimalHelper.asString((BigDecimal)value);
        }
        return fallback;
    }
}

