/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.pdfbox.EValueSource;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportAuxiliaryPrintRow;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportIncentivePrintRow;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportInfo;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportSquadLeaderPrintRow;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PayrollMonthReportPrintService
extends AbstractPrintService<PayrollMonthReportInfo, PayrollMonthPrintConfiguration> {
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public PayrollMonthReportPrintService(@NonNull UserService userService, @NonNull DateTimeHelperService dateTimeHelperService, @NonNull PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (dateTimeHelperService == null) {
            throw new NullPointerException("dateTimeHelperService is marked non-null but is null");
        }
        if (printHelper == null) {
            throw new NullPointerException("printHelper is marked non-null but is null");
        }
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull PayrollMonthReportInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        YearMonth yearMonth = printInfo.getYearMonth();
        String yearMonthsAsString = String.format("%02d/%d", yearMonth.getMonthValue(), yearMonth.getYear());
        Long userId = printInfo.getEmployeeUserId();
        String userFullName = printInfo.getEmployeeFullName();
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("Kostenstellen Report: %s", yearMonthsAsString));
        documentInformation.setSubject(String.format("Mitarbeiter: %s", userFullName));
        return documentInformation;
    }

    @Nonnull
    private List<Table> headers(@NonNull PayrollMonthReportInfo payrollMonthReportInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) throws IOException {
        if (payrollMonthReportInfo == null) {
            throw new NullPointerException("payrollMonthReportInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int printFontSize = printSetup.getDetailsFontSize();
        String employeePersonalNumber = StringUtils.trimToEmpty((String)payrollMonthReportInfo.getEmployeePersonalNumber());
        String employeeFullName = StringUtils.trimToEmpty((String)payrollMonthReportInfo.getEmployeeFullName());
        String dateAsString = DATE_FORMAT.format(DateTimeHelper.today());
        YearMonth yearMonth = payrollMonthReportInfo.getYearMonth();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("LLLL yyyy");
        String yearMonthAsText = df.format(yearMonth.atEndOfMonth());
        Table.TableBuilder header1Builder = PayrollMonthReportPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.1f)));
        header1Builder.addRow(Row.builder().add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Bauleiter:", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)employeeFullName, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Datum:", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)dateAsString, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ImmutableList.of())).build());
        Table header1 = header1Builder.build();
        Table.TableBuilder header2Builder = PayrollMonthReportPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.1f)));
        header2Builder.addRow(Row.builder().add((AbstractCell)PayrollMonthReportPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.headerCell((PrintSetup)printSetup, (String)String.format("Monatsbericht: %s", yearMonthAsText), (Iterable)ImmutableList.of(), (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER)).add((AbstractCell)PayrollMonthReportPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)ImmutableList.of())).build());
        header2Builder.addRow(Row.builder().add((AbstractCell)PayrollMonthReportPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.headerCell((PrintSetup)printSetup, (String)String.format("Bautrupp: %s (%s)", employeePersonalNumber, employeeFullName), (Iterable)ImmutableList.of(), (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER)).add((AbstractCell)PayrollMonthReportPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)ImmutableList.of())).build());
        Table header2 = header2Builder.build();
        return ImmutableList.of((Object)header1, (Object)header2);
    }

    @Nonnull
    private Table footer(@NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        Table.TableBuilder footerBuilder = PayrollMonthReportPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        int printFontSize = printSetup.getDetailsFontSize();
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)B)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ImmutableList.of())).build());
        footerBuilder.addRow(Row.builder().add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"Datum/Unterschrift", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)printFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ImmutableList.of())).build());
        return footerBuilder.build();
    }

    public byte[] generatePDF(@NonNull PayrollMonthReportInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        Object object;
        block21: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight());
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getPayrollLogoPadding, PrintLayoutConfig::getPayrollLogoHeight, PrintLayoutConfig::getPayrollLogoBuffer);
                List headers = this.headers(printInfo, printSetup, mediaBox);
                Table footer = this.footer(printSetup, mediaBox);
                float headerHeight = headers.stream().map(AbstractPrintService::height).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
                float footerHeight = PayrollMonthReportPrintService.height((Table)footer);
                float maxDetailsWidth = PayrollMonthReportPrintService.maxDetailsWidth((PDRectangle)mediaBox);
                float maxDetailsHeight = PayrollMonthReportPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)headerHeight, (float)footerHeight, (float)0.0f);
                List details = this.details(printInfo, printConfiguration, printSetup, mediaBox);
                if (details.isEmpty()) {
                    PayrollMonthReportPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    Iterable pagedTables = PayrollMonthReportPrintService.splitVertically((Iterable)details, (int)2, (float)maxDetailsHeight, (float)10.0f);
                    for (Iterable tablesOnPage : pagedTables) {
                        PDPage page = PayrollMonthReportPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                            float yOffset = PayrollMonthReportPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                            yOffset -= 10.0f;
                            for (Table table : tablesOnPage) {
                                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(table).build().draw();
                                yOffset -= table.getHeight();
                                yOffset -= 10.0f;
                            }
                        }
                    }
                    PayrollMonthReportPrintService.writeMeta((PrintSetup)printSetup, (PDDocument)document, (Table)footer);
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                object = outputStream.toByteArray();
                if (document == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return object;
    }

    private float printFooter(@NonNull PDPageContentStream contentStream, @NonNull PDPage page, @NonNull Table footer) {
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        PDRectangle mediaBox = page.getMediaBox();
        float footerHeight = footer.getHeight();
        float yOffset = 30.0f + footerHeight;
        TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(footer).build().draw();
        return yOffset -= footer.getHeight();
    }

    @Nonnull
    private List<Table> details(@NonNull PayrollMonthReportInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int detailsFontSize = printSetup.getDetailsFontSize();
        ImmutableList.Builder allTablesBuilder = ImmutableList.builder();
        ImmutableList incentiveWidths = ImmutableList.of((Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.25f));
        Table.TableBuilder incentiveTableBuilder = PayrollMonthReportPrintService.table((PDRectangle)mediaBox, (Iterable)incentiveWidths);
        incentiveTableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"#", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Name", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"PNR", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"KST", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Angebot", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Leistungslohn", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Bemerkung", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).build());
        Iterable payrollMonthReportIncentivePrintRows = printInfo.getPayrollMonthReportIncentivePrintRows();
        AtomicInteger incentiveRowNumber = new AtomicInteger();
        for (PayrollMonthReportIncentivePrintRow item : payrollMonthReportIncentivePrintRows) {
            String rowNumber = Integer.toString(incentiveRowNumber.getAndIncrement());
            String senderEmployeeFullName = StringUtils.trimToEmpty((String)item.getSenderEmployeeFullName());
            String senderEmployeePersonalNumber = Integer.toString(item.getSenderEmployeePersonalNumber());
            String senderEmployeeCostCenter = StringUtils.trimToEmpty((String)item.getSenderEmployeeCostCenter());
            String recipientEmployeeFullName = StringUtils.trimToEmpty((String)item.getRecipientEmployeeFullName());
            String recipientEmployeePersonalNumber = Integer.toString(item.getRecipientEmployeePersonalNumber());
            String recipientEmployeeCostCenter = StringUtils.trimToEmpty((String)item.getRecipientEmployeeCostCenter());
            String quotationNumber = StringUtils.trimToEmpty((String)item.getQuotationNumber());
            String remarks = StringUtils.trimToEmpty((String)item.getRemarks());
            BigDecimal value = (BigDecimal)MoreObjects.firstNonNull((Object)item.getValue(), (Object)BigDecimal.ZERO);
            incentiveTableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)rowNumber, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)recipientEmployeeFullName, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)recipientEmployeePersonalNumber, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)recipientEmployeeCostCenter, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)quotationNumber, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.valueCell((PDFont)printFonts.getRegular(), (int)detailsFontSize, (String)rowNumber, (String)"INCENTIVE_WAGE", (BigDecimal)value, (EValueSource)EValueSource.WAGE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)remarks, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).build());
        }
        BigDecimal incentiveWageSum = Streams.stream((Iterable)payrollMonthReportIncentivePrintRows).map(PayrollMonthReportIncentivePrintRow::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        incentiveTableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"Gesamt:", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.valueCell((PDFont)printFonts.getRegular(), (int)detailsFontSize, (String)"overall_value", (String)"INCENTIVE_WAGE", (BigDecimal)incentiveWageSum, (EValueSource)EValueSource.WAGE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).build());
        allTablesBuilder.add((Object)incentiveTableBuilder.build());
        ImmutableList auxiliaryWidths = ImmutableList.of((Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.25f));
        Table.TableBuilder auxiliaryTableBuilder = PayrollMonthReportPrintService.table((PDRectangle)mediaBox, (Iterable)auxiliaryWidths);
        auxiliaryTableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"#", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Name", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"PNR", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"KST", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Lohnart", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Einheit", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Anzahl", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Betrag", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Bemerkung", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).build());
        Iterable payrollMonthReportAuxiliaryPrintRows = printInfo.getPayrollMonthReportAuxiliaryPrintRows();
        AtomicInteger auxiliaryRowNumber = new AtomicInteger();
        for (PayrollMonthReportAuxiliaryPrintRow item : payrollMonthReportAuxiliaryPrintRows) {
            String rowNumber = Integer.toString(auxiliaryRowNumber.getAndIncrement());
            String fromEmployeeFullName = StringUtils.trimToEmpty((String)item.getFromEmployeeFullName());
            String fromEmployeePersonalNumber = Integer.toString(item.getFromEmployeePersonalNumber());
            String fromEmployeeCostCenter = StringUtils.trimToEmpty((String)item.getFromEmployeeCostCenter());
            String payrollItemTypeName = StringUtils.trimToEmpty((String)item.getPayrollItemTypeName());
            String payrollItemTypeUnit = StringUtils.trimToEmpty((String)item.getPayrollItemTypeUnit());
            String remarks = StringUtils.trimToEmpty((String)item.getRemarks());
            BigDecimal value = (BigDecimal)MoreObjects.firstNonNull((Object)item.getAmount(), (Object)BigDecimal.ZERO);
            BigDecimal valueX = (BigDecimal)MoreObjects.firstNonNull((Object)item.getValue(), (Object)BigDecimal.ZERO);
            auxiliaryTableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)rowNumber, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)fromEmployeeFullName, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)fromEmployeePersonalNumber, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)fromEmployeeCostCenter, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)payrollItemTypeName, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)payrollItemTypeUnit, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.valueCell((PDFont)printFonts.getRegular(), (int)detailsFontSize, (String)rowNumber, (String)"AUXILIARY_WAGE_ITEM", (BigDecimal)value, (EValueSource)EValueSource.WAGE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.valueCell((PDFont)printFonts.getRegular(), (int)detailsFontSize, (String)rowNumber, (String)"AUXILIARY_WAGE", (BigDecimal)valueX, (EValueSource)EValueSource.WAGE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)remarks, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).build());
        }
        BigDecimal auxiliaryWageValueSum = Streams.stream((Iterable)payrollMonthReportAuxiliaryPrintRows).map(PayrollMonthReportAuxiliaryPrintRow::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        auxiliaryTableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"Gesamt:", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.valueCell((PDFont)printFonts.getRegular(), (int)detailsFontSize, (String)"overall_value", (String)"AUXILIARY_WAGE", (BigDecimal)auxiliaryWageValueSum, (EValueSource)EValueSource.WAGE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of())).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).build());
        allTablesBuilder.add((Object)auxiliaryTableBuilder.build());
        ImmutableList squadLeaderBonusWidths = ImmutableList.of((Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.25f));
        Table.TableBuilder squadLeaderBonusBuilder = PayrollMonthReportPrintService.table((PDRectangle)mediaBox, (Iterable)squadLeaderBonusWidths);
        squadLeaderBonusBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"#", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Name", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"PNR", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Datum", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthReportPrintService.detailHeader((PrintSetup)printSetup, (String)"Anzahl", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).build());
        Iterable payrollMonthReportSquadLeaderPrintRows = printInfo.getPayrollMonthReportSquadLeaderPrintRows();
        AtomicInteger squadLeaderRowNumber = new AtomicInteger();
        for (PayrollMonthReportSquadLeaderPrintRow item : payrollMonthReportSquadLeaderPrintRows) {
            String rowNumber = Integer.toString(squadLeaderRowNumber.getAndIncrement());
            String fromEmployeeFullName = StringUtils.trimToEmpty((String)item.getFromEmployeeFullName());
            String fromEmployeePersonalNumber = Integer.toString(item.getFromEmployeePersonalNumber());
            String fromEmployeeCostCenter = StringUtils.trimToEmpty((String)item.getFromEmployeeCostCenter());
            LocalDate date = item.getDate();
            String dateRangeAsString = PayrollMonthReportPrintService.asString((LocalDate)date);
            BigDecimal amount = (BigDecimal)MoreObjects.firstNonNull((Object)item.getAmount(), (Object)BigDecimal.ZERO);
            squadLeaderBonusBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)rowNumber, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)fromEmployeeFullName, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)fromEmployeePersonalNumber, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)dateRangeAsString, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.valueCell((PDFont)printFonts.getRegular(), (int)detailsFontSize, (String)rowNumber, (String)"AMOUNT", (BigDecimal)amount, (EValueSource)EValueSource.AMOUNT, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of())).build());
        }
        BigDecimal squadLeaderBonusSum = Streams.stream((Iterable)payrollMonthReportSquadLeaderPrintRows).map(PayrollMonthReportSquadLeaderPrintRow::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        squadLeaderBonusBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T)).add((AbstractCell)PayrollMonthReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"Gesamt:", (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL)).add((AbstractCell)PayrollMonthReportPrintService.valueCell((PDFont)printFonts.getRegular(), (int)detailsFontSize, (String)"overall_value", (String)"SQUAD_LEADER_BONUS", (BigDecimal)squadLeaderBonusSum, (EValueSource)EValueSource.IGNORE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of())).build());
        allTablesBuilder.add((Object)squadLeaderBonusBuilder.build());
        return allTablesBuilder.build();
    }

    @Nonnull
    private String asString(@Nullable Integer value, @NonNull String fallback) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        return null != value ? Integer.toString(value) : fallback;
    }

    @Nonnull
    private static String asString(@Nullable LocalDate value) {
        return null != value ? DATE_FORMAT.format(value) : "";
    }

    @Nonnull
    private static String asString(@Nullable BigDecimal value, @NonNull String fallback, boolean printZero) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        if (null != value && (0 != value.compareTo(BigDecimal.ZERO) || printZero)) {
            return BigDecimalHelper.asString((BigDecimal)value);
        }
        return fallback;
    }
}

