/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.security.UserService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Locale;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.springframework.stereotype.Service;

@Service
public class PDFHelperService {
    private final UserService userService;

    @Nonnull
    public PDDocument document(@NonNull String title, @NonNull String subject) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        User user = this.userService.authenticatedUser();
        return this.document(title, subject, StringUtils.trimToEmpty((String)user.getFullName()));
    }

    @Nonnull
    public PDDocument document(@NonNull String title, @NonNull String subject, @NonNull String fullName) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        PDDocumentInformation info = new PDDocumentInformation();
        info.setAuthor(fullName);
        info.setCreationDate(Calendar.getInstance(Locale.GERMAN));
        info.setCreator("AppQ");
        info.setProducer("AppQ - eine QFM Anwendung");
        PDDocument document = new PDDocument();
        info.setKeywords("TODO");
        info.setTitle(title);
        info.setSubject(subject);
        document.setDocumentInformation(info);
        return document;
    }

    public byte[] merge(@NonNull String title, @NonNull String subject, @NonNull String fullName, @NonNull Iterable<byte[]> documents) throws IOException {
        byte[] byArray;
        block18: {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (subject == null) {
                throw new NullPointerException("subject is marked non-null but is null");
            }
            if (fullName == null) {
                throw new NullPointerException("fullName is marked non-null but is null");
            }
            if (documents == null) {
                throw new NullPointerException("documents is marked non-null but is null");
            }
            PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
            pdfMergerUtility.setIgnoreAcroFormErrors(true);
            PDDocument mergeDocuement = this.document(title, subject, fullName);
            try {
                for (byte[] document : documents) {
                    PDDocument pdDocument = Loader.loadPDF((byte[])document);
                    try {
                        pdfMergerUtility.appendDocument(mergeDocuement, pdDocument);
                    }
                    finally {
                        if (pdDocument == null) continue;
                        pdDocument.close();
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                mergeDocuement.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (mergeDocuement == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (mergeDocuement != null) {
                        try {
                            mergeDocuement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            mergeDocuement.close();
        }
        return byArray;
    }

    public PDFHelperService(UserService userService) {
        this.userService = userService;
    }
}

