/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.helper.DateRange;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintInfo;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintStandard;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintStandardRow;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import de.qfm.erp.service.service.service.print.BadWeatherReportPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BadWeatherReportPrintService
extends AbstractPrintService<BadWeatherReportPrintInfo, BadWeatherReportPrintConfiguration> {
    private static final Set<EAttendanceDayType> BOLD_ATTENDANCE_TYPES = ImmutableSet.of((Object)EAttendanceDayType.BAD_WEATHER, (Object)EAttendanceDayType.BAD_WEATHER_SICK);
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public BadWeatherReportPrintService(UserService userService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull BadWeatherReportPrintInfo printInfo, @NonNull BadWeatherReportPrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        YearMonth yearMonth = printInfo.getYearMonth();
        String yearMonthsAsString = String.format("%s/%s", yearMonth.getMonthValue(), yearMonth.getYear());
        Long userId = printInfo.getUserId();
        String userFullName = printInfo.getUserFullName();
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("Monatsbericht Schlechtwetter: %s", yearMonthsAsString));
        documentInformation.setSubject(String.format("Mitarbeiter: %s", userFullName));
        return documentInformation;
    }

    public byte[] generatePDF(@NonNull BadWeatherReportPrintInfo printInfo, @NonNull BadWeatherReportPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        Object object;
        block21: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getPayrollLogoPadding, PrintLayoutConfig::getPayrollLogoHeight, PrintLayoutConfig::getPayrollLogoBuffer);
                List headers = this.header(printInfo, printSetup, mediaBox);
                Table footer = this.footer(printSetup, mediaBox);
                float maxDetailsHeight = BadWeatherReportPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)BadWeatherReportPrintService.height((Iterable)headers), (float)BadWeatherReportPrintService.height((Table)footer), (float)10.0f);
                List details = this.details(printInfo, printSetup, mediaBox);
                if (details.isEmpty()) {
                    BadWeatherReportPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    Iterable pagedTables = BadWeatherReportPrintService.splitVertically((Iterable)details, (int)2, (float)maxDetailsHeight, (float)10.0f);
                    for (Iterable tablesOnPage : pagedTables) {
                        PDPage page = BadWeatherReportPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                            float yOffset = BadWeatherReportPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                            yOffset -= 10.0f;
                            for (Table table : tablesOnPage) {
                                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(table).build().draw();
                                yOffset -= table.getHeight();
                                yOffset -= 10.0f;
                            }
                        }
                    }
                    BadWeatherReportPrintService.writeMeta((PrintSetup)printSetup, (PDDocument)document, (Table)footer);
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                object = outputStream.toByteArray();
                if (document == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return object;
    }

    @Nonnull
    private List<Table> header(@NonNull BadWeatherReportPrintInfo printInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        YearMonth accountingMonth = printInfo.getYearMonth();
        String yearMonthsAsString = String.format("%s/%s", accountingMonth.getMonthValue(), accountingMonth.getYear());
        Table.TableBuilder tableBuilder = BadWeatherReportPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        Row.RowBuilder headlineBuilder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        headlineBuilder.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"Monats\u00fcbersicht Schlechtwetter", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)TLB, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        String yearMonthString = String.format("Monat/Jahr: %s", yearMonthsAsString);
        headlineBuilder.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)yearMonthString, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)TBR, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        Row headline = headlineBuilder.build();
        tableBuilder.addRow(headline);
        Table build = tableBuilder.build();
        return ImmutableList.of((Object)build);
    }

    @Nonnull
    private Table footer(@NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        Table.TableBuilder footerTableBuilder = BadWeatherReportPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        Row.RowBuilder r1Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        r1Builder.add((AbstractCell)BadWeatherReportPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)1, (Iterable)ImmutableList.of()));
        r1Builder.add((AbstractCell)BadWeatherReportPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)1, (Iterable)ImmutableList.of()));
        Row r1 = r1Builder.build();
        footerTableBuilder.addRow(r1);
        return footerTableBuilder.build();
    }

    @Nonnull
    private List<Table> details(@NonNull BadWeatherReportPrintInfo printInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int detailsFontSize = printSetup.getDetailsFontSize();
        YearMonth yearMonth = printInfo.getYearMonth();
        Iterable printStandardRow = printInfo.getBadWeatherReportPrintStandardRows();
        LocalDate startDate = yearMonth.atDay(1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        int lengthOfMonth = yearMonth.lengthOfMonth();
        Range dateRange = Range.closed((Comparable)startDate, (Comparable)endDate);
        Set neededDates = (Set)DateRange.of((Range)dateRange).stream().collect(ImmutableSet.toImmutableSet());
        float baseWidth = 210.0f;
        float nameColWidth = 0.1904762f;
        float calendarColWidth = 0.7619048f / (float)lengthOfMonth;
        float summarizeColWidth = 0.04761905f;
        float wageSumColWidth = 0.071428575f;
        ImmutableList.Builder columnWidthsBuilder = ImmutableList.builder();
        columnWidthsBuilder.add((Object)Float.valueOf(0.1904762f));
        IntStream.range(0, lengthOfMonth).forEach(item -> columnWidthsBuilder.add((Object)Float.valueOf(calendarColWidth)));
        IntStream.range(0, 4).forEach(item -> columnWidthsBuilder.add((Object)Float.valueOf(0.04761905f)));
        columnWidthsBuilder.add((Object)Float.valueOf(0.071428575f));
        ImmutableList columnWidths = columnWidthsBuilder.build();
        Table.TableBuilder attendancesTableBuilder = BadWeatherReportPrintService.table((PDRectangle)mediaBox, (Iterable)columnWidths);
        ImmutableMap daysBorderR1 = ImmutableMap.of((Object)AbstractPrintService.EBorder.TOP, (Object)Float.valueOf(0.75f), (Object)AbstractPrintService.EBorder.LEFT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.RIGHT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.BOTTOM, (Object)Float.valueOf(0.0f));
        ImmutableMap daysBorderR2 = ImmutableMap.of((Object)AbstractPrintService.EBorder.TOP, (Object)Float.valueOf(0.0f), (Object)AbstractPrintService.EBorder.LEFT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.RIGHT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.BOTTOM, (Object)Float.valueOf(0.75f));
        Row.RowBuilder headlineBuilder_1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        headlineBuilder_1.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"Mitarbeiter", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)TL, (float)0.75f, (float)0.0f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        IntStream.range(0, lengthOfMonth).forEach(arg_0 -> BadWeatherReportPrintService.lambda$details$2(headlineBuilder_1, printSetup, (Map)daysBorderR1, arg_0));
        headlineBuilder_1.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"A", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_1.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"U", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_1.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"F", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_1.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"RB", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_1.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"Gesamtstunden", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)TR, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        Row headline_1 = headlineBuilder_1.build();
        attendancesTableBuilder.addRow(headline_1);
        Row.RowBuilder headlineBuilder_2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        headlineBuilder_2.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)LB, (float)0.75f, (float)0.0f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        IntStream.range(0, lengthOfMonth).forEach(arg_0 -> BadWeatherReportPrintService.lambda$details$3(headlineBuilder_2, printSetup, (Map)daysBorderR2, arg_0));
        headlineBuilder_2.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"SW", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_2.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"K", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_2.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"H", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_2.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"KK", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder_2.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"", (Map)BadWeatherReportPrintService.defaultBorder((Iterable)RB, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        Row headline_2 = headlineBuilder_2.build();
        attendancesTableBuilder.addRow(headline_2);
        boolean even = false;
        for (BadWeatherReportPrintStandardRow BadWeatherReportPrintStandardRow2 : printStandardRow) {
            even = !even;
            Color bgColor = even ? DETAIL_BG_COLOR_EVEN : DETAIL_BG_COLOR_UNEVEN;
            Map attendances = BadWeatherReportPrintStandardRow2.getAttendances();
            Row.RowBuilder rowBuilder1 = Row.builder();
            String employeePersonalNumber = StringUtils.trimToEmpty((String)BadWeatherReportPrintStandardRow2.getEmployeePersonalNumber());
            String firstName = StringUtils.trimToEmpty((String)BadWeatherReportPrintStandardRow2.getEmployeeFirstName());
            String lastName = StringUtils.trimToEmpty((String)BadWeatherReportPrintStandardRow2.getEmployeeLastName());
            String employeeFullName = Joiner.on((char)',').join((Object)lastName, (Object)firstName, new Object[0]);
            String employeeName = String.format("%s [%s]", employeeFullName, employeePersonalNumber);
            rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)employeeName, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)TL, (float)0.75f, (float)0.0f)));
            for (LocalDate neededDate : neededDates) {
                if (attendances.containsKey(neededDate)) {
                    BadWeatherReportPrintStandard printStandard = (BadWeatherReportPrintStandard)attendances.get(neededDate);
                    EAttendanceDayType employeeDayType = (EAttendanceDayType)MoreObjects.firstNonNull((Object)printStandard.getEmployeeDayType(), (Object)EAttendanceDayType.UNKNOWN);
                    PDFont font = BOLD_ATTENDANCE_TYPES.contains(employeeDayType) ? printFonts.getBold() : printFonts.getRegular();
                    Color dayColor = BadWeatherReportPrintService.attendanceBGColor((BadWeatherReportPrintStandard)printStandard, (Color)bgColor);
                    String text = BadWeatherReportPrintService.firstRow((EAttendanceDayType)employeeDayType, (BadWeatherReportPrintStandard)printStandard);
                    rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PDFont)font, (int)detailsFontSize, (String)text, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
                    continue;
                }
                rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintSetup)printSetup, (String)"?"));
            }
            Map durationAggregatedByType = BadWeatherReportPrintStandardRow2.getDurationAggregatedByType();
            Duration standardDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_WORK, Duration.ZERO);
            String standardDurationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)standardDurationAggregated);
            rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)standardDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration vacationDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_VACATION, Duration.ZERO);
            String vacationDurationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)vacationDurationAggregated);
            rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)vacationDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration missingDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_ABSENT, Duration.ZERO);
            String missingDurationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)missingDurationAggregated);
            rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)missingDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration onDutyDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_ON_DUTY, Duration.ZERO);
            String onDutyDurationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)onDutyDurationAggregated);
            rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)onDutyDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration durationAggregated = BadWeatherReportPrintStandardRow2.getDurationAggregated();
            String durationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)durationAggregated);
            rowBuilder1.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)durationAggregatedString, (int)1, (int)1, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)TR, (float)0.75f, (float)0.25f)));
            Row row1 = rowBuilder1.build();
            Row.RowBuilder rowBuilder2 = Row.builder();
            String socialSecurityNumber = StringUtils.trimToEmpty((String)BadWeatherReportPrintStandardRow2.getEmployeeSocialSecurityNumber());
            rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)socialSecurityNumber, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)LB, (float)0.75f, (float)0.0f)));
            for (LocalDate neededDate : neededDates) {
                if (attendances.containsKey(neededDate)) {
                    BadWeatherReportPrintStandard printStandard = (BadWeatherReportPrintStandard)attendances.get(neededDate);
                    EAttendanceDayType employeeDayType = printStandard.getEmployeeDayType();
                    PDFont font = BOLD_ATTENDANCE_TYPES.contains(employeeDayType) ? printFonts.getBold() : printFonts.getRegular();
                    Color dayColor = BadWeatherReportPrintService.attendanceBGColor((BadWeatherReportPrintStandard)printStandard, (Color)bgColor);
                    String text = BadWeatherReportPrintService.secondRow((EAttendanceDayType)employeeDayType, (BadWeatherReportPrintStandard)printStandard);
                    rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PDFont)font, (int)detailsFontSize, (String)text, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
                    continue;
                }
                rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintSetup)printSetup, (String)"?"));
            }
            Duration badWeatherAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER, Duration.ZERO);
            String badWeatherAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)badWeatherAggregated);
            rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)badWeatherAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            Duration sickDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_SICK, Duration.ZERO);
            String sickDurationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)sickDurationAggregated);
            rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)sickDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            Duration helpDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_HELP_WAGE_HOURS, Duration.ZERO);
            String helpDurationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)helpDurationAggregated);
            rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)helpDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            Duration childSickDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_CHILD_SICK_LEAVE, Duration.ZERO);
            String childSickDurationAggregatedString = BadWeatherReportPrintService.formatDuration((Duration)childSickDurationAggregated);
            rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)childSickDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            rowBuilder2.add((AbstractCell)BadWeatherReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (int)1, (int)1, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)BadWeatherReportPrintService.defaultBorder((Iterable)RB, (float)0.75f, (float)0.25f)));
            Row row2 = rowBuilder2.build();
            attendancesTableBuilder.addRow(row1);
            attendancesTableBuilder.addRow(row2);
        }
        Table attendancesTable = attendancesTableBuilder.build();
        return ImmutableList.of((Object)attendancesTable);
    }

    @Nonnull
    private static String firstRow(@NonNull EAttendanceDayType attendanceDayType, @NonNull BadWeatherReportPrintStandard printStandard) {
        if (attendanceDayType == null) {
            throw new NullPointerException("attendanceDayType is marked non-null but is null");
        }
        if (printStandard == null) {
            throw new NullPointerException("printStandard is marked non-null but is null");
        }
        Duration badWeatherDuration = printStandard.getBadWeatherDuration();
        Duration workTimeDuration = printStandard.getWorkDuration();
        Duration workDuration = printStandard.getWorkDuration();
        switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$employee$attendance$EAttendanceDayType[attendanceDayType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return BadWeatherReportPrintService.formatDuration((Duration)workDuration);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return attendanceDayType.abbreviation();
            }
            case 10: {
                return "";
            }
        }
        return "N/A";
    }

    @Nonnull
    private static String secondRow(@NonNull EAttendanceDayType attendanceDayType, @NonNull BadWeatherReportPrintStandard printStandard) {
        if (attendanceDayType == null) {
            throw new NullPointerException("attendanceDayType is marked non-null but is null");
        }
        if (printStandard == null) {
            throw new NullPointerException("printStandard is marked non-null but is null");
        }
        Duration badWeatherDuration = printStandard.getBadWeatherDuration();
        Duration workTimeDuration = printStandard.getWorkDuration();
        Duration workDuration = printStandard.getWorkDuration();
        switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$employee$attendance$EAttendanceDayType[attendanceDayType.ordinal()]) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "";
            }
            case 2: {
                return BadWeatherReportPrintService.formatDuration((Duration)badWeatherDuration);
            }
            case 10: {
                return "";
            }
        }
        return "N/A";
    }

    private static /* synthetic */ void lambda$details$3(Row.RowBuilder headlineBuilder_2, PrintSetup printSetup, Map daysBorderR2, int item) {
        headlineBuilder_2.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)"", (Map)daysBorderR2, (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
    }

    private static /* synthetic */ void lambda$details$2(Row.RowBuilder headlineBuilder_1, PrintSetup printSetup, Map daysBorderR1, int item) {
        headlineBuilder_1.add((AbstractCell)BadWeatherReportPrintService.headerCell((PrintSetup)printSetup, (String)Integer.toString(1 + item), (Map)daysBorderR1, (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
    }
}

