/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.gaeb;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.service.service.gaeb.GaebD11Helper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GaebD11ExportService {
    private static final Logger log = LogManager.getLogger(GaebD11ExportService.class);
    public static final Joiner ROW_JOINER = Joiner.on((String)"\n");
    public static final boolean RENDER_POS_NUMBER_DEFAULT = true;

    @NonNull
    public String generateD11(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        rowsBuilder.addAll(this.headerRows(measurement));
        rowsBuilder.addAll(GaebD11Helper.itemRows((Measurement)measurement, (boolean)true));
        ImmutableList rows = rowsBuilder.build();
        return ROW_JOINER.join((Iterable)rows);
    }

    @Nonnull
    private Iterable<String> headerRows(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        ArrayList parts = Lists.newArrayList();
        parts.add("11");
        parts.add("        ");
        parts.add("23.003");
        parts.add("2009");
        String constructionSite40 = StringUtils.left((String)measurement.getConstructionSite(), (int)40);
        String measurementNumber = measurement.getMeasurementNumber();
        String header = StringUtils.rightPad((String)(constructionSite40 + " " + measurementNumber), (int)51, (char)' ');
        parts.add(header);
        parts.add("1122PPPPI");
        String row = StringUtils.join((Iterable)parts, (String)"");
        return ImmutableList.of((Object)row);
    }
}

