/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.er2.old;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.configuration.DiamantConfig;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceInputBucket;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.er2.ER2InvoiceService;
import de.qfm.erp.service.service.service.er2.old.ER2ServiceOther;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ER2ServiceOther
extends ER2InvoiceService {
    private final ConfigService configService;
    private final DiamantConfig diamantConfig;

    public ER2ServiceOther(ConfigService configService, DiamantConfig diamantConfig) {
        super(EER2OutputType.NORMAL, (Iterable)ImmutableSet.of((Object)EInvoiceType.CUSTOMER_VOUCHER, (Object)EInvoiceType.INTERNAL_VOUCHER, (Object)EInvoiceType.PARTIAL_INVOICE, (Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceType.FINAL_INVOICE, (Object)EInvoiceType.PARTIAL_CUMULATIVE_INVOICE, (Object[])new EInvoiceType[]{EInvoiceType.FINAL_CUMULATIVE_INVOICE, EInvoiceType.CUMULATIVE_INVOICE, EInvoiceType.INVOICE}));
        this.configService = configService;
        this.diamantConfig = diamantConfig;
    }

    @Nonnull
    public Iterable<Iterable<String>> generate(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        return this.er2Rows(invoice);
    }

    @Nonnull
    private static String fromCCToAddressSuffix(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        if (EInvoiceType.INTERNAL_INVOICE == invoiceType) {
            String costCenter = StringUtils.trimToEmpty((String)invoice.getCostCenter());
            String addressSuffix = ER2ServiceOther.addressSuffix((Invoice)invoice);
            return String.format("%s an %s", addressSuffix, costCenter);
        }
        return "";
    }

    @Nonnull
    private Iterable<Iterable<String>> er2Rows(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        ER2InvoiceInputBucket er2InvoiceInputBucket = ER2InvoiceInputBucket.of((String)stageOrEntityNumberPrefix, (Invoice)invoice);
        EInvoiceType invoiceType = invoice.getInvoiceType();
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        ImmutableList.Builder fPartsBuilder = ImmutableList.builder();
        for (ER2F er2F : ER2F.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2F.getFn().apply(er2InvoiceInputBucket)));
            fPartsBuilder.add((Object)value);
        }
        ImmutableList fParts = fPartsBuilder.build();
        ImmutableList.Builder iPartsBuilder = ImmutableList.builder();
        for (ER2I eR2I : ER2I.values()) {
            String value = StringUtils.trimToEmpty((String)((String)eR2I.getFn().apply(er2InvoiceInputBucket)));
            iPartsBuilder.add((Object)value);
        }
        ImmutableList iParts = iPartsBuilder.build();
        ImmutableList.Builder gPartRowsBuilder = ImmutableList.builder();
        ImmutableList.Builder gPartsBuilder = ImmutableList.builder();
        for (ER2G er2G : ER2G.values()) {
            ER2K_SENDER[] value = StringUtils.trimToEmpty((String)((String)er2G.getFn().apply(er2InvoiceInputBucket)));
            gPartsBuilder.add((Object)value);
        }
        ImmutableList immutableList = gPartsBuilder.build();
        gPartRowsBuilder.add((Object)immutableList);
        ImmutableList gPartRows = gPartRowsBuilder.build();
        ImmutableList.Builder kSenderPartsBuilder = ImmutableList.builder();
        ImmutableList.Builder kRecipientPartsBuilder = ImmutableList.builder();
        if (this.diamantConfig.isInvoiceCostAccountingEnabled()) {
            String value;
            for (ER2K_SENDER eR2K_SENDER : ER2K_SENDER.values()) {
                value = StringUtils.trimToEmpty((String)((String)eR2K_SENDER.getFn().apply(er2InvoiceInputBucket)));
                kSenderPartsBuilder.add((Object)value);
            }
            for (ER2K_SENDER eR2K_SENDER : ER2K_RECIPIENT.values()) {
                value = StringUtils.trimToEmpty((String)((String)eR2K_SENDER.getFn().apply(er2InvoiceInputBucket)));
                kRecipientPartsBuilder.add((Object)value);
            }
        }
        ImmutableList kSenderParts = kSenderPartsBuilder.build();
        ImmutableList kRecipientParts = kRecipientPartsBuilder.build();
        ImmutableList.Builder aPartsBuilder = ImmutableList.builder();
        for (ER2A er2A : ER2A.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2A.getFn().apply(er2InvoiceInputBucket)));
            aPartsBuilder.add((Object)value);
        }
        ImmutableList immutableList2 = aPartsBuilder.build();
        ImmutableList.Builder zbPartsBuilder = ImmutableList.builder();
        for (ER2ZB er2ZB : ER2ZB.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2ZB.getFn().apply(er2InvoiceInputBucket)));
            zbPartsBuilder.add((Object)value);
        }
        ImmutableList zbParts = zbPartsBuilder.build();
        ImmutableList.Builder tPartsBuilder = ImmutableList.builder();
        if (EInvoiceType.FINAL_INVOICE == invoiceType || EInvoiceType.PARTIAL_FINAL_INVOICE == invoiceType) {
            Iterable closingInvoices = (Iterable)MoreObjects.firstNonNull((Object)er2InvoiceInputBucket.getInvoice().getClosedInvoices(), (Object)ImmutableSet.of());
            for (Invoice closingInvoice : closingInvoices) {
                ImmutableList.Builder tChildPartsBuilder = ImmutableList.builder();
                for (ER2T er2t : ER2T.values()) {
                    String value = StringUtils.trimToEmpty((String)((String)er2t.getFn().apply(closingInvoice)));
                    tChildPartsBuilder.add((Object)value);
                }
                ImmutableList tChildParts = tChildPartsBuilder.build();
                tPartsBuilder.add((Object)tChildParts);
            }
        }
        ImmutableList tParts = tPartsBuilder.build();
        rowsBuilder.add((Object)fParts);
        if (EInvoiceType.INTERNAL_INVOICE != invoiceType) {
            rowsBuilder.add((Object)iParts);
        }
        rowsBuilder.add((Object)zbParts);
        if (!kSenderParts.isEmpty()) {
            rowsBuilder.add((Object)kSenderParts);
        }
        if (EInvoiceType.INTERNAL_INVOICE == invoiceType) {
            rowsBuilder.addAll((Iterable)gPartRows);
            rowsBuilder.add((Object)zbParts);
            if (!kRecipientParts.isEmpty()) {
                rowsBuilder.add((Object)kRecipientParts);
            }
        }
        if (EInvoiceType.INTERNAL_INVOICE != invoiceType) {
            rowsBuilder.add((Object)immutableList2);
        }
        if (EInvoiceType.FINAL_INVOICE == invoiceType || EInvoiceType.PARTIAL_FINAL_INVOICE == invoiceType) {
            rowsBuilder.addAll((Iterable)tParts);
        }
        return rowsBuilder.build();
    }

    static /* synthetic */ CharMatcher access$000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$200() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$600() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$700() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1200() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$1300() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$1400() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$1500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1600() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1700() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2300() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$2400() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$2500() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$2600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$2700() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$2800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$3000() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$3100() {
        return STR;
    }

    static /* synthetic */ DateTimeFormatter access$3200() {
        return DDMMYYYY;
    }

    static /* synthetic */ Set access$3300() {
        return NEGATE_INVOICE_STATES;
    }

    static /* synthetic */ DateTimeFormatter access$3400() {
        return DDMMYYYY;
    }

    static /* synthetic */ DateTimeFormatter access$3500() {
        return DDMMYYYY;
    }

    static /* synthetic */ DateTimeFormatter access$3600() {
        return MMYYYY;
    }

    static /* synthetic */ DateTimeFormatter access$3700() {
        return DDMMYYYY;
    }

    static /* synthetic */ CharMatcher access$3800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$3900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$4000() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$4100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$4200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$4300() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4400() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4500() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4700() {
        return STR;
    }

    static /* synthetic */ String access$4800(Invoice x0) {
        return ER2ServiceOther.addressSuffix((Invoice)x0);
    }

    static /* synthetic */ Set access$4900() {
        return NEGATE_INVOICE_STATES;
    }

    static /* synthetic */ CharMatcher access$5000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5200() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$5300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5500() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$5600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$5700() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$5800() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$5900() {
        return STR;
    }

    static /* synthetic */ Set access$6000() {
        return NEGATE_INVOICE_STATES;
    }

    static /* synthetic */ CharMatcher access$6100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6600() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6700() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6800() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$6900() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$7000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7400() {
        return STR;
    }

    static /* synthetic */ String access$7500(Invoice x0) {
        return ER2ServiceOther.addressSuffix((Invoice)x0);
    }

    static /* synthetic */ CharMatcher access$7600() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7700() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7900() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$8000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8600() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8700() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$8900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$9000() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$9100() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$9200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$9300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$9400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$9500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$9600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$9700() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$9800() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$9900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$10000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$10100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$10200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$10300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$10400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$10500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$10600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$10700() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$10800() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$10900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$11000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$11100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$11200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$11300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$11400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$11500() {
        return STR;
    }
}

