/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.er2;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.configuration.DiamantConfig;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceInputBucket;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.er2.ER2InvoiceService;
import de.qfm.erp.service.service.service.er2.ER2ServiceInvoiceCompanyGroupVIA;
import java.math.BigDecimal;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Order
public class ER2ServiceInvoiceCompanyGroupVIA
extends ER2InvoiceService {
    private final ConfigService configService;
    private final DiamantConfig diamantConfig;

    public ER2ServiceInvoiceCompanyGroupVIA(ConfigService configService, DiamantConfig diamantConfig) {
        super(EER2OutputType.COMPANY_GROUP, (Iterable)ImmutableSet.of((Object)EInvoiceType.CREDIT_VOUCHER));
        this.configService = configService;
        this.diamantConfig = diamantConfig;
    }

    @Nonnull
    public Iterable<Iterable<String>> generate(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation stage = invoice.getQuotation();
        Customer customer = stage.getCustomer();
        boolean companyGroup = (Boolean)MoreObjects.firstNonNull((Object)customer.getFlagCompanyGroup(), (Object)false);
        if (companyGroup) {
            return this.er2Rows(invoice);
        }
        return ImmutableList.of();
    }

    @Nonnull
    private static String fromCCToAddressSuffix(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        if (EInvoiceType.INTERNAL_INVOICE == invoiceType) {
            String costCenter = StringUtils.trimToEmpty((String)invoice.getCostCenter());
            String addressSuffix = ER2ServiceInvoiceCompanyGroupVIA.addressSuffix((Invoice)invoice);
            return String.format("%s an %s", addressSuffix, costCenter);
        }
        return "";
    }

    @Nonnull
    private Iterable<Iterable<String>> er2Rows(@NonNull Invoice invoice) {
        String value;
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        ER2InvoiceInputBucket er2InvoiceInputBucket = ER2InvoiceInputBucket.of((String)stageOrEntityNumberPrefix, (Invoice)invoice);
        EInvoiceType invoiceType = invoice.getInvoiceType();
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        ImmutableList.Builder fPartsBuilder = ImmutableList.builder();
        for (ER2F er2F : ER2F.values()) {
            String value2 = StringUtils.trimToEmpty((String)((String)er2F.getFn().apply(er2InvoiceInputBucket)));
            fPartsBuilder.add((Object)value2);
        }
        ImmutableList fParts = fPartsBuilder.build();
        ImmutableList.Builder iPartsBuilder = ImmutableList.builder();
        for (ER2I eR2I : ER2I.values()) {
            String value3 = StringUtils.trimToEmpty((String)((String)eR2I.getFn().apply(er2InvoiceInputBucket)));
            iPartsBuilder.add((Object)value3);
        }
        ImmutableList iParts = iPartsBuilder.build();
        ImmutableList.Builder er2GCounterAccountBuilder = ImmutableList.builder();
        ImmutableList.Builder er2gInvoiceRow1stBuilder = ImmutableList.builder();
        for (ER2G_COUNTER_ACCOUNT eR2G_COUNTER_ACCOUNT : ER2G_COUNTER_ACCOUNT.values()) {
            String value4 = StringUtils.trimToEmpty((String)((String)eR2G_COUNTER_ACCOUNT.getFn().apply(er2InvoiceInputBucket)));
            er2gInvoiceRow1stBuilder.add((Object)value4);
        }
        ImmutableList immutableList = er2gInvoiceRow1stBuilder.build();
        er2GCounterAccountBuilder.add((Object)immutableList);
        ImmutableList er2GCounterAccount = er2GCounterAccountBuilder.build();
        ImmutableList.Builder kSenderPartsBuilder = ImmutableList.builder();
        if (this.diamantConfig.isInvoiceCostAccountingEnabled()) {
            for (ER2K_SENDER er2KSENDER : ER2K_SENDER.values()) {
                ER2G_SEC_RET_WARRANTY[] value5 = StringUtils.trimToEmpty((String)((String)er2KSENDER.getFn().apply(er2InvoiceInputBucket)));
                kSenderPartsBuilder.add((Object)value5);
            }
        }
        ImmutableList immutableList2 = kSenderPartsBuilder.build();
        ImmutableList.Builder er2GSecurityRetentionRowsBuilder = ImmutableList.builder();
        boolean flagSecurityRetention = (Boolean)MoreObjects.firstNonNull((Object)invoice.getFlagSecurityRetention(), (Object)false);
        if (flagSecurityRetention) {
            BigDecimal fulfillmentSecurityRetentionCumulativeValue;
            if (invoice.getWarrantySecurityRetentionPercent().compareTo(BigDecimal.ZERO) != 0) {
                ImmutableList.Builder er2gSecRetWarrantyRowBuilder = ImmutableList.builder();
                for (ER2G_SEC_RET_WARRANTY er2GSecRetWarranty : ER2G_SEC_RET_WARRANTY.values()) {
                    String value6 = StringUtils.trimToEmpty((String)((String)er2GSecRetWarranty.getFn().apply(er2InvoiceInputBucket)));
                    er2gSecRetWarrantyRowBuilder.add((Object)value6);
                }
                ImmutableList er2gSecRetWarrantyRow = er2gSecRetWarrantyRowBuilder.build();
                er2GSecurityRetentionRowsBuilder.add((Object)er2gSecRetWarrantyRow);
            }
            if (invoice.getFulfillmentSecurityRetentionPercent().compareTo(BigDecimal.ZERO) != 0) {
                ImmutableList.Builder er2gSecRetFulfillmentRowBuilder = ImmutableList.builder();
                for (ImmutableList er2GSecRetFulfillment : ER2G_SEC_RET_FULFILLMENT.values()) {
                    String value2 = StringUtils.trimToEmpty((String)((String)er2GSecRetFulfillment.getFn().apply(er2InvoiceInputBucket)));
                    er2gSecRetFulfillmentRowBuilder.add((Object)value2);
                }
                ImmutableList er2gSecRetFulfillmentRow = er2gSecRetFulfillmentRowBuilder.build();
                er2GSecurityRetentionRowsBuilder.add((Object)er2gSecRetFulfillmentRow);
            }
            if ((fulfillmentSecurityRetentionCumulativeValue = invoice.getFulfillmentSecurityRetentionCumulativeValue()).compareTo(BigDecimal.ZERO) != 0) {
                ImmutableList.Builder er2gSecRetCumulativeRowBuilder = ImmutableList.builder();
                for (ER2G_SEC_RET_CUMULATIVE er2GSecRetCumulative : ER2G_SEC_RET_CUMULATIVE.values()) {
                    value = StringUtils.trimToEmpty((String)((String)er2GSecRetCumulative.getFn().apply(invoice)));
                    er2gSecRetCumulativeRowBuilder.add((Object)value);
                }
                ImmutableList er2gSecRetCumulativeRow = er2gSecRetCumulativeRowBuilder.build();
                er2GSecurityRetentionRowsBuilder.add((Object)er2gSecRetCumulativeRow);
            }
        }
        ImmutableList er2GSecurityRetentionRows = er2GSecurityRetentionRowsBuilder.build();
        ImmutableList.Builder aPartsBuilder = ImmutableList.builder();
        for (ER2A er2A : ER2A.values()) {
            value = StringUtils.trimToEmpty((String)((String)er2A.getFn().apply(er2InvoiceInputBucket)));
            aPartsBuilder.add((Object)value);
        }
        ImmutableList aParts = aPartsBuilder.build();
        rowsBuilder.add((Object)fParts);
        if (EInvoiceType.INTERNAL_INVOICE != invoiceType) {
            rowsBuilder.add((Object)iParts);
        }
        rowsBuilder.addAll((Iterable)er2GSecurityRetentionRows);
        rowsBuilder.addAll((Iterable)er2GCounterAccount);
        if (!immutableList2.isEmpty()) {
            rowsBuilder.add((Object)immutableList2);
        }
        if (EInvoiceType.CREDIT_VOUCHER != invoiceType && EInvoiceType.INTERNAL_INVOICE != invoiceType) {
            rowsBuilder.add((Object)aParts);
        }
        return rowsBuilder.build();
    }

    @Nonnull
    private static String netWithSecRetER2(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        BigDecimal totalValueNet = invoice.getTotalValueNet();
        BigDecimal vat = invoice.getVatValue();
        BigDecimal netWithSecRet = totalValueNet.add(vat);
        return ER2ServiceInvoiceCompanyGroupVIA.er2BigDecimalAsString((BigDecimal)netWithSecRet);
    }

    @Nonnull
    private static String valueByState(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket, @NonNull Function<Invoice, BigDecimal> valueFN, boolean negate) {
        BigDecimal finalValue;
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        if (valueFN == null) {
            throw new NullPointerException("valueFN is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        BigDecimal value = valueFN.apply(invoice);
        if (EInvoiceType.CREDIT_VOUCHER == invoiceType) {
            EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
            boolean negateByState = NEGATE_INVOICE_STATES.contains(invoiceState);
            boolean negateByType = NEGATE_INVOICE_TYPES.contains(invoiceType);
            BigDecimal valueRecalculated1 = negateByState ? value.negate() : value;
            BigDecimal valueRecalculated2 = negateByType ? valueRecalculated1.negate() : valueRecalculated1;
            finalValue = negate ? valueRecalculated2.negate() : valueRecalculated2;
        } else if (EInvoiceType.FINAL_INVOICE == invoiceType || EInvoiceType.PARTIAL_FINAL_INVOICE == invoiceType) {
            Set closedInvoices = (Set)MoreObjects.firstNonNull((Object)invoice.getClosedInvoices(), (Object)ImmutableSet.of());
            BigDecimal closedDueValue = closedInvoices.stream().map(Invoice::getTotalValueGross).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal calculatedTotalValueGross = value.add(closedDueValue);
            finalValue = negate ? calculatedTotalValueGross.negate() : calculatedTotalValueGross;
        } else {
            BigDecimal dueValueGrossRecalculated = ER2ServiceInvoiceCompanyGroupVIA.grossBasedOnState((ER2InvoiceInputBucket)er2InvoiceInputBucket);
            finalValue = negate ? dueValueGrossRecalculated.negate() : dueValueGrossRecalculated;
        }
        return ER2ServiceInvoiceCompanyGroupVIA.er2BigDecimalAsString((BigDecimal)finalValue);
    }

    @Nonnull
    private static BigDecimal grossBasedOnState(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        BigDecimal totalValueGross = invoice.getTotalValueGross();
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        boolean negateByState = NEGATE_INVOICE_STATES.contains(invoiceState);
        return negateByState ? totalValueGross.negate() : totalValueGross;
    }
}

