/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.qfm.erp.service.configuration.Q1Config;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.Q1Mapper;
import de.qfm.q1.common.request.Q1EmployeeSyncRequest;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class Q1Service {
    private static final Logger log = LogManager.getLogger(Q1Service.class);
    private final Q1Config config;
    private final ObjectMapper objectMapper;
    private final Q1Mapper q1Mapper;

    @Nonnull
    public HttpResponse<String> push(@NonNull User user) throws IOException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        HttpResponse<String> response;
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        HttpClient client = HttpClient.newBuilder().sslContext(this.sslContext()).sslParameters(this.sslParameters()).build();
        long requestTimeoutInSeconds = this.config.getRequestTimeout();
        Integer personalNumber = user.getPersonalNumber();
        String personalNumberAsString = Integer.toString(personalNumber);
        if (user.getEntityState() == EntityState.DELETED) {
            String requestUrl = MessageFormat.format(this.config.getEmployeeRequestUrl(), personalNumberAsString);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(requestUrl)).timeout(Duration.ofSeconds(requestTimeoutInSeconds)).header("Accept", "application/json").DELETE().build();
            log.info("Q1 Request: {}", (Object)request);
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        } else {
            Q1EmployeeSyncRequest syncRequest = this.q1Mapper.mapUser(user);
            String requestUrl = MessageFormat.format(this.config.getEmployeeRequestUrl(), personalNumberAsString);
            String body = this.objectMapper.writeValueAsString((Object)syncRequest);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(requestUrl)).timeout(Duration.ofSeconds(requestTimeoutInSeconds)).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
            log.info("Q1 Request: {}", (Object)request);
            log.info("Q1 Body: {}", (Object)body);
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        log.info("Q1 Response: {}", response);
        return response;
    }

    @Nonnull
    private SSLParameters sslParameters() {
        SSLParameters sslParams = new SSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("");
        return sslParams;
    }

    @Nonnull
    private SSLContext sslContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = (hostname, session) -> true;
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        Properties props = System.getProperties();
        props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
        return sc;
    }

    public Q1Service(Q1Config config, ObjectMapper objectMapper, Q1Mapper q1Mapper) {
        this.config = config;
        this.objectMapper = objectMapper;
        this.q1Mapper = q1Mapper;
    }
}

