/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import de.qfm.erp.service.helper.PayrollMonthHelper;
import de.qfm.erp.service.model.internal.EYearMonthDateRange;
import de.qfm.erp.service.model.internal.WageMoveBucket;
import de.qfm.erp.service.model.internal.employee.StageWage;
import de.qfm.erp.service.model.internal.measurement.AggMeasurementWage;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.PayrollMonthHandler;
import de.qfm.erp.service.service.handler.PayrollMonthItemHandler;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class PayrollMonthHelperService {
    private final MeasurementHandler measurementHandler;
    private final PayrollMonthHandler payrollMonthHandler;
    private final PayrollMonthItemHandler payrollMonthItemHandler;

    @Nonnull
    public Iterable<String> wageRelevantQuotationNumbers(@NonNull PayrollMonth payrollMonth, @NonNull EYearMonthDateRange yearMonthDateRange) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (yearMonthDateRange == null) {
            throw new NullPointerException("yearMonthDateRange is marked non-null but is null");
        }
        ImmutableSet relevantQuotationNumbersFromMeasurement = ImmutableSet.copyOf((Iterable)this.measurementHandler.quotationNumbersFromMeasurementsForAssignedUser(payrollMonth, yearMonthDateRange));
        ImmutableSet relevantQuotationNumbersFromPayouts = ImmutableSet.copyOf((Iterable)this.payrollMonthItemHandler.quotationNumbersFromPaymentsForSender(payrollMonth));
        return Sets.union((Set)relevantQuotationNumbersFromMeasurement, (Set)relevantQuotationNumbersFromPayouts);
    }

    @Nonnull
    public Iterable<StageWage> determineStageWages(@NonNull PayrollMonth payrollMonth, @NonNull EYearMonthDateRange yearMonthDateRange, boolean hideZero) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (yearMonthDateRange == null) {
            throw new NullPointerException("yearMonthDateRange is marked non-null but is null");
        }
        ImmutableSet relevantQuotationNumbers = ImmutableSet.copyOf((Iterable)this.wageRelevantQuotationNumbers(payrollMonth, yearMonthDateRange));
        LocalDate accountingMonth = payrollMonth.getAccountingMonth();
        User user = payrollMonth.getUser();
        Long payrollMonthId = payrollMonth.getId();
        return this.determineStageWages((Iterable)ImmutableSet.of((Object)user), accountingMonth, payrollMonthId, (Iterable)relevantQuotationNumbers, yearMonthDateRange, hideZero);
    }

    @Nonnull
    public Iterable<StageWage> determineStageWages(@NonNull Iterable<User> assignedUsers, @NonNull LocalDate accountingMonth, @NonNull Long filterSelfPayrollMonthId, @NonNull Iterable<String> relevantQuotationNumbers, @NonNull EYearMonthDateRange yearMonthDateRange, boolean hideZero) {
        if (assignedUsers == null) {
            throw new NullPointerException("assignedUsers is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (filterSelfPayrollMonthId == null) {
            throw new NullPointerException("filterSelfPayrollMonthId is marked non-null but is null");
        }
        if (relevantQuotationNumbers == null) {
            throw new NullPointerException("relevantQuotationNumbers is marked non-null but is null");
        }
        if (yearMonthDateRange == null) {
            throw new NullPointerException("yearMonthDateRange is marked non-null but is null");
        }
        if (Iterables.isEmpty(relevantQuotationNumbers)) {
            return ImmutableSet.of();
        }
        YearMonth yearMonth = YearMonth.from(accountingMonth);
        Iterable availableWages = this.availableWages(assignedUsers, accountingMonth, yearMonthDateRange, relevantQuotationNumbers);
        Range dateRange = yearMonthDateRange.from(yearMonth);
        Iterable paidWages = this.payrollMonthHandler.paidWagesByQuotation(dateRange, relevantQuotationNumbers, assignedUsers);
        return PayrollMonthHelper.stageWages((LocalDate)accountingMonth, (Iterable)availableWages, (Iterable)paidWages, (boolean)hideZero, (Long)filterSelfPayrollMonthId);
    }

    @Nonnull
    private Iterable<AggMeasurementWage> availableWages(@NonNull Iterable<User> assignedUsers, @NonNull LocalDate accountingMonth, @NonNull EYearMonthDateRange yearMonthDateRange, @NonNull Iterable<String> relevantQuotationNumbers) {
        if (assignedUsers == null) {
            throw new NullPointerException("assignedUsers is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (yearMonthDateRange == null) {
            throw new NullPointerException("yearMonthDateRange is marked non-null but is null");
        }
        if (relevantQuotationNumbers == null) {
            throw new NullPointerException("relevantQuotationNumbers is marked non-null but is null");
        }
        return this.measurementHandler.measurementWagesByStage(accountingMonth, yearMonthDateRange, relevantQuotationNumbers, assignedUsers);
    }

    public long moveWage(@NonNull Iterable<WageMoveBucket> wageMoveBuckets) {
        if (wageMoveBuckets == null) {
            throw new NullPointerException("wageMoveBuckets is marked non-null but is null");
        }
        long rowsAffected = 0L;
        for (WageMoveBucket wageMoveBucket : wageMoveBuckets) {
            Quotation sourceStage = wageMoveBucket.getSourceStage();
            Quotation targetStage = wageMoveBucket.getTargetStage();
            String targetQuotationNumber = targetStage.getQuotationNumber();
            Iterable payrollMonthItems = this.payrollMonthItemHandler.allByQuotation(sourceStage);
            for (PayrollMonthItem payrollMonthItem : payrollMonthItems) {
                payrollMonthItem.setQuotation(targetStage);
                payrollMonthItem.setQuotationNumber(targetQuotationNumber);
                ++rowsAffected;
            }
            this.payrollMonthItemHandler.update(payrollMonthItems);
        }
        return rowsAffected;
    }

    public PayrollMonthHelperService(MeasurementHandler measurementHandler, PayrollMonthHandler payrollMonthHandler, PayrollMonthItemHandler payrollMonthItemHandler) {
        this.measurementHandler = measurementHandler;
        this.payrollMonthHandler = payrollMonthHandler;
        this.payrollMonthItemHandler = payrollMonthItemHandler;
    }
}

