/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.exception.request.MeasurementNumberNotFetchedException;
import de.qfm.erp.service.model.internal.MeasurementMoveBucket;
import de.qfm.erp.service.model.internal.measurement.AvailableMeasurementStates;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementStateReason;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.repository.MeasurementRepository;
import de.qfm.erp.service.service.calculator.measurement.MeasurementCalculators;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.MeasurementPositionMapper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.SequenceNumberRepository;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementService {
    public static final Integer MAX_TRIES = 10;
    public final EntityFactory entityFactory;
    public final MeasurementPositionMapper measurementPositionMapper;
    public final MeasurementCalculators measurementCalculators;
    public final MeasurementRepository measurementRepository;
    public final SequenceNumberRepository sequenceNumberRepository;
    public final UserService userService;

    @Nonnull
    public String determineNextMeasurementNumber() {
        ImmutableList.Builder triesBuilder = ImmutableList.builder();
        for (int i = 0; i < MAX_TRIES; ++i) {
            Integer measurementNumber = this.sequenceNumberRepository.nextMeasurementNumber();
            if (null == measurementNumber) continue;
            triesBuilder.add((Object)measurementNumber);
            String measurementNumberAsString = Integer.toString(measurementNumber);
            Optional measurementCandidate = this.measurementRepository.findByMeasurementNumber(measurementNumberAsString);
            if (!measurementCandidate.isEmpty()) continue;
            return measurementNumberAsString;
        }
        ImmutableList tries = triesBuilder.build();
        Message message = MeasurementNumberNotFetchedException.message((Iterable)tries, (Integer)MAX_TRIES);
        throw MeasurementNumberNotFetchedException.of((String)"Could not acquire the next MeasurementNumber, check details", (Message)message);
    }

    @Nonnull
    public Measurement switchMeasurementState(@NonNull Measurement measurement, @NonNull EMeasurementState eMeasurementState, @NonNull EMeasurementStateReason reason) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (eMeasurementState == null) {
            throw new NullPointerException("eMeasurementState is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        MeasurementState measurementState = this.entityFactory.measurementState();
        measurementState.setMeasurementState(eMeasurementState);
        measurementState.setMeasurementStateSince(DateTimeHelper.now());
        measurementState.setMeasurementStateReason(reason);
        Set measurementStates = (Set)MoreObjects.firstNonNull((Object)measurement.getMeasurementStates(), (Object)Sets.newLinkedHashSet());
        measurementStates.add(measurementState);
        measurementState.setMeasurement(measurement);
        measurement.setMeasurementState(measurementState);
        return measurement;
    }

    private boolean currentStateIsEditable(boolean b2b, @NonNull EMeasurementState eMeasurementState) {
        if (eMeasurementState == null) {
            throw new NullPointerException("eMeasurementState is marked non-null but is null");
        }
        if (b2b && EMeasurementState.B2B_BLOCKING_STATES.contains(eMeasurementState)) {
            return false;
        }
        if (EMeasurementState.MEASUREMENT_STATE__PRIVILEGE.containsKey((Object)eMeasurementState)) {
            EPrivilege currentNeededPrivilege = (EPrivilege)EMeasurementState.MEASUREMENT_STATE__PRIVILEGE.get((Object)eMeasurementState);
            return this.userService.hasPrivilege(currentNeededPrivilege);
        }
        return false;
    }

    @Nonnull
    public AvailableMeasurementStates availableStates(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Quotation quotation = measurement.getQuotation();
        MeasurementState measurementState = measurement.getMeasurementState();
        EMeasurementState eMeasurementState = measurementState.getMeasurementState();
        boolean b2b = Objects.equals(Boolean.TRUE, quotation.getFlagB2B());
        boolean isB2BBlockingState = EMeasurementState.B2B_BLOCKING_STATES.contains(eMeasurementState);
        boolean isAccountingState = EMeasurementState.ACCOUNTING_STATES.contains(eMeasurementState);
        boolean isDeletedState = EMeasurementState.DELETED == eMeasurementState;
        boolean unrestricted = this.userService.hasPrivilege(EPrivilege.UNRESTRICTED);
        boolean isCurrentStateEditable = this.currentStateIsEditable(b2b, eMeasurementState);
        ImmutableSet allReachableStates = EMeasurementState.MEASUREMENT_STATE__PRIVILEGE.keySet();
        ImmutableSet allReachableAvailableStates = b2b && !unrestricted ? ImmutableSet.copyOf(allReachableStates.stream().filter(item -> !EMeasurementState.B2B_STATES.contains(item)).iterator()) : allReachableStates;
        HashSet availableMeasurementStatesCandidates = Sets.newHashSet();
        if (!isAccountingState && !isDeletedState) {
            if (unrestricted) {
                availableMeasurementStatesCandidates.addAll(allReachableStates);
            } else if (!(!isCurrentStateEditable || b2b && isB2BBlockingState)) {
                for (EMeasurementState availableState : allReachableAvailableStates) {
                    EPrivilege neededPrivilege = (EPrivilege)EMeasurementState.MEASUREMENT_STATE__PRIVILEGE.get((Object)availableState);
                    if (null == neededPrivilege || !this.userService.hasPrivilege(neededPrivilege)) continue;
                    availableMeasurementStatesCandidates.add(availableState);
                    ImmutableSet followUpStates = ImmutableSet.copyOf((Iterable)((Iterable)EMeasurementState.FOLLOWUP_STATE.getOrDefault(availableState, ImmutableSet.of())));
                    availableMeasurementStatesCandidates.addAll(followUpStates);
                }
            }
        }
        ImmutableSet allAvailableStates = ImmutableSet.copyOf((Collection)Sets.intersection((Set)allReachableAvailableStates, (Set)availableMeasurementStatesCandidates));
        ImmutableSet allAvailableStates2 = ImmutableSet.builder().add((Object)eMeasurementState).addAll((Iterable)allAvailableStates).build();
        Optional previousState = MeasurementService.nextState((Map)EMeasurementState.NEGATIVE_FOLLOW_UP_STATE, (EMeasurementState)eMeasurementState, (ImmutableSet)allAvailableStates2);
        Optional nextState = MeasurementService.nextState((Map)EMeasurementState.POSITIVE_FOLLOW_UP_STATE, (EMeasurementState)eMeasurementState, (ImmutableSet)allAvailableStates2);
        return AvailableMeasurementStates.of((Optional)previousState, (Optional)nextState, (Iterable)allAvailableStates2);
    }

    @Nonnull
    private static Optional<EMeasurementState> nextState(@NonNull Map<EMeasurementState, EMeasurementState> followUpStateMap, @NonNull EMeasurementState currentState, @NonNull ImmutableSet<EMeasurementState> allAvailableStates) {
        EMeasurementState followUpState;
        if (followUpStateMap == null) {
            throw new NullPointerException("followUpStateMap is marked non-null but is null");
        }
        if (currentState == null) {
            throw new NullPointerException("currentState is marked non-null but is null");
        }
        if (allAvailableStates == null) {
            throw new NullPointerException("allAvailableStates is marked non-null but is null");
        }
        if (followUpStateMap.containsKey(currentState) && allAvailableStates.contains((Object)(followUpState = followUpStateMap.get(currentState)))) {
            return Optional.of(followUpState);
        }
        return Optional.empty();
    }

    @Nonnull
    public Measurement move(@NonNull MeasurementMoveBucket measurementMoveBucket) {
        if (measurementMoveBucket == null) {
            throw new NullPointerException("measurementMoveBucket is marked non-null but is null");
        }
        Measurement measurement = measurementMoveBucket.getMeasurement();
        Quotation sourceStage = measurementMoveBucket.getSourceStage();
        Quotation targetStage = measurementMoveBucket.getTargetStage();
        Map positionMap = measurementMoveBucket.getPositionMap();
        String originalStageNumber = sourceStage.getQNumber();
        String targetStageNumber = targetStage.getQNumber();
        boolean sameStageNumber = StringUtils.equalsIgnoreCase((CharSequence)originalStageNumber, (CharSequence)targetStageNumber);
        measurement.setQuotation(targetStage);
        if (!sameStageNumber) {
            measurement.setSheetNumberValue(Long.valueOf(0L));
        }
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        for (MeasurementPosition measurementPosition : measurementPositions) {
            ReleaseOrder releaseOrder;
            measurementPosition.setQuotation(targetStage);
            QuotationPosition stagePositionOld = measurementPosition.getQuotationPosition();
            QuotationPosition stagePositionNew = (QuotationPosition)positionMap.get(stagePositionOld);
            if (null != stagePositionNew) {
                Optional jumboPositionCand = StageHelper.determineJumboPosition((QuotationPosition)stagePositionNew);
                this.measurementPositionMapper.mergeQuotationPositionIntoMeasurementPosition(measurementPosition, stagePositionNew, (QuotationPosition)jumboPositionCand.orElse(null));
            } else {
                measurementPosition.setQuotation(null);
                measurementPosition.setQuotationPosition(null);
                measurementPosition.setJumboQuotationPosition(null);
                measurementPosition.setJumboPositionUnit("");
                measurementPosition.setJumboPositionSurrogatePositionNumber("");
                measurementPosition.setJumboPositionPricePerUnit(BigDecimal.ZERO);
                measurementPosition.setJumboPositionShortText("");
            }
            if (null == (releaseOrder = measurement.getReleaseOrder())) continue;
            releaseOrder.setQuotation(targetStage);
            if (sameStageNumber) continue;
            releaseOrder.setPssReleaseOrder(null);
        }
        this.measurementCalculators.standard().calculateAndApply(measurement);
        return measurement;
    }

    public MeasurementService(EntityFactory entityFactory, MeasurementPositionMapper measurementPositionMapper, MeasurementCalculators measurementCalculators, MeasurementRepository measurementRepository, SequenceNumberRepository sequenceNumberRepository, UserService userService) {
        this.entityFactory = entityFactory;
        this.measurementPositionMapper = measurementPositionMapper;
        this.measurementCalculators = measurementCalculators;
        this.measurementRepository = measurementRepository;
        this.sequenceNumberRepository = sequenceNumberRepository;
        this.userService = userService;
    }
}

