/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import de.qfm.erp.service.configuration.DiamantConfig;
import de.qfm.erp.service.model.internal.quotation.StageER2Bucket;
import de.qfm.erp.service.model.internal.quotation.StageER2Result;
import de.qfm.erp.service.service.service.ER2Service;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DiamantER2Service
implements ER2Service {
    private static final Logger log = LogManager.getLogger(DiamantER2Service.class);
    private static final CharMatcher FILE_NAME = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_.")).precomputed();
    private final DiamantConfig diamantConfig;

    @Nonnull
    public StageER2Result pushSilent(@NonNull StageER2Bucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        try {
            return this.push(bucket);
        }
        catch (IOException e) {
            log.error("Error writing ER2 File: {}, Error: {}", (Object)bucket, (Object)e.getMessage(), (Object)e);
            return StageER2Result.of((boolean)false, null, (String)"", (String)"", (String)e.getMessage());
        }
    }

    @Nonnull
    public StageER2Result push(@NonNull StageER2Bucket bucket) throws IOException {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        log.info("Processing Stage Bucket: {}", (Object)bucket);
        if (this.diamantConfig.isEnabled()) {
            String fileName = DiamantER2Service.fileName((StageER2Bucket)bucket, (String)"er2");
            byte[] er2Content = bucket.getEr2Content();
            Path folderPath = this.diamantConfig.getFolderPathStandard();
            if (folderPath.toFile().exists()) {
                Path filePath = Path.of(folderPath.toString(), fileName);
                Files.write(filePath, er2Content, new OpenOption[0]);
                String fullPath = filePath.toString();
                return StageER2Result.of((boolean)true, (LocalDateTime)LocalDateTime.now(), (String)fullPath, (String)fileName, (String)"");
            }
            String msg = String.format("Cannot write File as Folder does not Exist: %s", folderPath);
            log.error(msg);
            return StageER2Result.of((boolean)false, (LocalDateTime)LocalDateTime.now(), (String)"", (String)fileName, (String)msg);
        }
        String msg = "DIAMANT Output NOT enabled";
        log.error("DIAMANT Output NOT enabled");
        return StageER2Result.of((boolean)false, (LocalDateTime)LocalDateTime.now(), (String)"", (String)"", (String)"DIAMANT Output NOT enabled");
    }

    @VisibleForTesting
    static String fileName(@NonNull StageER2Bucket bucket, @NonNull String suffix) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        long id = bucket.getId();
        String stageNumber = bucket.getStageNumber();
        String fileName = StringUtils.trimToEmpty((String)String.format("%s_%s.%s", stageNumber, id, suffix));
        return FILE_NAME.negate().replaceFrom((CharSequence)fileName, (CharSequence)"_");
    }

    public DiamantER2Service(DiamantConfig diamantConfig) {
        this.diamantConfig = diamantConfig;
    }
}

