/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import de.leancoders.common.helper.DateTimeFormats;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDocumentOutputService {
    protected static final DateTimeFormatter DATE_FORMAT = DateTimeFormats.GERMAN_FULL_DATE;
    protected static final DateTimeFormatter TIME_FORMAT = DateTimeFormats.GERMAN_FULL_TIME;

    @Nonnull
    protected String dateTimeAsString(@Nullable LocalDateTime referenceDateTime, Function<LocalDateTime, LocalDateTime> convertToDestinationFunction) {
        if (null != referenceDateTime) {
            LocalDateTime dateTimeAtDestination = convertToDestinationFunction.apply(referenceDateTime);
            return dateTimeAtDestination.format(DATE_FORMAT) + " " + dateTimeAtDestination.format(TIME_FORMAT);
        }
        return "";
    }

    @Nonnull
    protected String dateAsString(@Nullable LocalDate referenceDateTime) {
        if (null != referenceDateTime) {
            return referenceDateTime.format(DATE_FORMAT);
        }
        return "";
    }

    @NonNull
    protected static String accountingMonthAsString(@NonNull YearMonth accountingMonth) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        String month = StringUtils.leftPad((String)Integer.toString(accountingMonth.getMonthValue()), (int)2, (String)"0");
        int year = accountingMonth.getYear();
        return String.format("%s/%s", month, year);
    }
}

