/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.repository.UserRepository;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    private final UserRepository userRepository;

    @Transactional(readOnly=true)
    public UserDetails loadUserByUsername(@NonNull String usernameCandidate) throws UsernameNotFoundException {
        if (usernameCandidate == null) {
            throw new NullPointerException("usernameCandidate is marked non-null but is null");
        }
        Optional userCandidate = this.userRepository.findOneByUsernameIgnoreCase(usernameCandidate);
        if (userCandidate.isPresent()) {
            de.qfm.erp.service.model.jpa.user.User user = (de.qfm.erp.service.model.jpa.user.User)userCandidate.get();
            String username = user.getUsername();
            String password = user.getPassword();
            ImmutableList grantedAuthorities = ImmutableList.copyOf((Iterable)UserHelper.grantedAuthorities((de.qfm.erp.service.model.jpa.user.User)user));
            boolean disabled = (Boolean)MoreObjects.firstNonNull((Object)user.getAllowedToLogin(), (Object)false) == false;
            return User.withUsername((String)username).password(password).authorities((Collection)grantedAuthorities).accountExpired(false).accountLocked(false).credentialsExpired(false).disabled(disabled).build();
        }
        throw new UsernameNotFoundException("User '" + usernameCandidate + "' not found");
    }

    public UserDetailsServiceImpl(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

