/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.CacheNames;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.eventbus.UserChangeMessage;
import de.qfm.erp.service.model.internal.user.CachedUser;
import de.qfm.erp.service.model.internal.user.UserCacheUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.CacheMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.PrivilegeService;
import de.qfm.erp.service.service.security.UserService;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CachingUserServiceImpl
implements UserService,
ApplicationListener<UserChangeMessage>,
CacheNames {
    private static final Logger log = LogManager.getLogger(CachingUserServiceImpl.class);
    private final AuthenticationHelper authenticationHelper;
    private final UserHandler userHandler;
    private final Cache<String, Iterable<CachedUser>> usersAssignedToCache;
    private final Cache<LocalDate, Iterable<CachedUser>> usersValidAtReferenceDate;
    private final Cache<String, Iterable<EPrivilege>> userPrivilegeCache;
    private final CacheMapper cacheMapper;
    private final PrivilegeService privilegeService;
    private final AtomicReference<Iterable<CachedUser>> allCache = new AtomicReference<ImmutableList>(ImmutableList.of());

    @Autowired
    public CachingUserServiceImpl(AuthenticationHelper authenticationHelper, UserHandler userHandler, @Qualifier(value="user_hierarchy_cache") Cache<String, Iterable<CachedUser>> usersAssignedToCache, @Qualifier(value="user_valid_at_month_cache") Cache<LocalDate, Iterable<CachedUser>> usersValidAtReferenceDate, @Qualifier(value="user_privilege_cache") Cache<String, Iterable<EPrivilege>> userPrivilegeCache, CacheMapper cacheMapper, PrivilegeService privilegeService) {
        this.authenticationHelper = authenticationHelper;
        this.userHandler = userHandler;
        this.usersAssignedToCache = usersAssignedToCache;
        this.usersValidAtReferenceDate = usersValidAtReferenceDate;
        this.userPrivilegeCache = userPrivilegeCache;
        this.cacheMapper = cacheMapper;
        this.privilegeService = privilegeService;
    }

    public void onApplicationEvent(@NonNull UserChangeMessage changeMessage) {
        if (changeMessage == null) {
            throw new NullPointerException("changeMessage is marked non-null but is null");
        }
        User user = (User)changeMessage.getEntity();
        String cacheKey = CachingUserServiceImpl.cacheKey((User)user);
        this.usersAssignedToCache.invalidateAll((Iterable)ImmutableSet.of((Object)cacheKey));
        String username = StringUtils.trimToEmpty((String)user.getUsername());
        if (StringUtils.isNotBlank((CharSequence)username)) {
            this.userPrivilegeCache.invalidate((Object)username);
        }
        this.usersValidAtReferenceDate.invalidateAll();
        this.allCache.set(ImmutableList.of());
    }

    @NonNull
    public Iterable<CachedUser> usersAssignedToCurrentUserAt(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        User user = this.authenticatedUser();
        return this.usersAssignedToAt(user, referenceDate);
    }

    @NonNull
    public Iterable<User> refresh(@NonNull Iterable<CachedUser> cachedUsers) {
        if (cachedUsers == null) {
            throw new NullPointerException("cachedUsers is marked non-null but is null");
        }
        Iterable userIds = (Iterable)Streams.stream(cachedUsers).map(CachedUser::getId).collect(ImmutableSet.toImmutableSet());
        return this.userHandler.byIdsFailing(userIds);
    }

    public Iterable<CachedUser> all() {
        LocalDate today = DateTimeHelper.today();
        ImmutableList cachedUsers = ImmutableList.copyOf((Iterable)((Iterable)MoreObjects.firstNonNull((Object)((Iterable)this.allCache.get()), (Object)ImmutableList.of())));
        if (Iterables.isEmpty((Iterable)cachedUsers)) {
            Page fetchedValue = this.userHandler.page(Pageable.unpaged(), Range.all());
            Iterable validUserCacheUpdateBuckets = (Iterable)Streams.stream((Iterable)fetchedValue).filter(item -> Objects.equals(item.getEntityState(), EntityState.VALID)).map(item -> this.userCacheUpdateBucket(item, today)).collect(ImmutableList.toImmutableList());
            Iterable cachedUsersNew = this.cacheMapper.map(validUserCacheUpdateBuckets);
            this.allCache.set(cachedUsersNew);
            return cachedUsersNew;
        }
        return ImmutableList.copyOf((Iterable)cachedUsers);
    }

    @NonNull
    public Iterable<CachedUser> allActiveUsersAt(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Iterable currentUsers = (Iterable)MoreObjects.firstNonNull((Object)((Iterable)this.usersValidAtReferenceDate.getIfPresent((Object)referenceDate)), (Object)ImmutableList.of());
        if (Iterables.isEmpty((Iterable)currentUsers)) {
            Page fetchedValue = this.userHandler.page(Pageable.unpaged(), Range.singleton((Comparable)referenceDate));
            Iterable validUserCacheUpdateBuckets = (Iterable)Streams.stream((Iterable)fetchedValue).filter(item -> Objects.equals(item.getEntityState(), EntityState.VALID)).map(item -> this.userCacheUpdateBucket(item, referenceDate)).collect(ImmutableList.toImmutableList());
            Iterable cachedUsersNew = this.cacheMapper.map(validUserCacheUpdateBuckets);
            this.usersValidAtReferenceDate.put((Object)referenceDate, (Object)cachedUsersNew);
            return cachedUsersNew;
        }
        return ImmutableList.copyOf((Iterable)currentUsers);
    }

    @Nonnull
    public Iterable<CachedUser> usersAssignedToAt(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        String cacheKey = CachingUserServiceImpl.cacheKey((User)user);
        Iterable cachedUsers = (Iterable)this.usersAssignedToCache.getIfPresent((Object)cacheKey);
        if (null == cachedUsers) {
            Stopwatch sw = Stopwatch.createStarted();
            Iterable userCostCenters = (Iterable)MoreObjects.firstNonNull((Object)user.getUserCostCenters(), (Object)ImmutableSet.of());
            Iterable costCentersWithLead = (Iterable)Streams.stream((Iterable)userCostCenters).filter(EmployeeHelper.userCostCenterAt((LocalDate)referenceDate)).filter(item -> Objects.equals(item.getFlagLead(), Boolean.TRUE)).map(UserCostCenter::getCostCenter).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Stream usersInCostCenters = Streams.stream((Iterable)costCentersWithLead).map(CostCenterFilter::children).flatMap(item -> Streams.stream((Iterable)this.userHandler.usersInCostCenter(item, DateTimeHelper.today())));
            Iterable allCachedUsers = (Iterable)Stream.concat(Stream.of(user), usersInCostCenters).filter(Objects::nonNull).map(item -> this.userCacheUpdateBucket(item, referenceDate)).map(arg_0 -> ((CacheMapper)this.cacheMapper).map(arg_0)).collect(ImmutableSet.toImmutableSet());
            this.usersAssignedToCache.put((Object)cacheKey, (Object)allCachedUsers);
            long elapsed = sw.stop().elapsed(TimeUnit.MILLISECONDS);
            log.info("Refreshed Users Cache for Cost Center for: User: {}/{}, referenceDate: {} took: {} ms", (Object)user.getId(), (Object)user.getUsername(), (Object)referenceDate, (Object)elapsed);
            return allCachedUsers;
        }
        return cachedUsers;
    }

    @Nonnull
    private UserCacheUpdateBucket userCacheUpdateBucket(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Optional costCenterCandidate = EmployeeHelper.currentUserCostCenterNotFailing((User)user, (LocalDate)referenceDate);
        Optional laborUnionContractCandidate = EmployeeHelper.currentLaborUnionContract((User)user, (LocalDate)referenceDate);
        Optional laborUnionWageGroupCandidate = laborUnionContractCandidate.isPresent() ? EmployeeHelper.currentWageGroup((User)user, (LocalDate)referenceDate) : Optional.empty();
        String costCenter = costCenterCandidate.map(UserCostCenter::getCostCenter).orElse("");
        return UserCacheUpdateBucket.of((User)user, (String)costCenter, (LaborUnionContract)laborUnionContractCandidate.orElse(null), (LaborUnionWageGroup)laborUnionWageGroupCandidate.orElse(null));
    }

    @Nonnull
    public User authenticatedUser() {
        String currentUserName = this.authenticationHelper.currentUserName();
        return this.userHandler.byNameFailing(currentUserName);
    }

    public boolean hasPrivilege(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        String cacheKey = this.authenticationHelper.currentUserName();
        User user = this.authenticatedUser();
        return this.hasPrivilege(privilege, cacheKey, user);
    }

    public boolean hasPrivilege(@NonNull User user, @NonNull EPrivilege privilege) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        String cacheKey = user.getUsername();
        return this.hasPrivilege(privilege, cacheKey, user);
    }

    private boolean hasPrivilege(@NonNull EPrivilege privilege, @NonNull String cacheKey, @NonNull User user) {
        Iterable cachedPrivileges;
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Iterable existingCachePrivileges = (Iterable)this.userPrivilegeCache.getIfPresent((Object)cacheKey);
        if (null == existingCachePrivileges) {
            Iterable privileges = this.privilegeService.privileges(user);
            this.userPrivilegeCache.put((Object)cacheKey, (Object)privileges);
        }
        return Iterables.contains((Iterable)(cachedPrivileges = (Iterable)MoreObjects.firstNonNull((Object)((Iterable)this.userPrivilegeCache.getIfPresent((Object)cacheKey)), (Object)ImmutableSet.of())), (Object)EPrivilege.UNRESTRICTED) || Iterables.contains((Iterable)cachedPrivileges, (Object)privilege);
    }

    public void checkPrivilege(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        if (!this.hasPrivilege(privilege)) {
            throw new AuthorizationServiceException(String.format("Operation not allowed, User does not have Privilege: %s", privilege));
        }
    }

    @VisibleForTesting
    static String cacheKey(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Long userId = user.getId();
        return String.format("%s", userId);
    }
}

