/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security.impl;

import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.CacheNames;
import de.qfm.erp.service.model.internal.eventbus.UserChangeMessage;
import de.qfm.erp.service.model.internal.user.CachedAutoCompleteUser;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.CacheMapper;
import de.qfm.erp.service.service.security.UserAutoCompleteService;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CachingUserAutoCompleteServiceImpl
implements UserAutoCompleteService,
ApplicationListener<UserChangeMessage>,
CacheNames {
    private static final Logger log = LogManager.getLogger(CachingUserAutoCompleteServiceImpl.class);
    private final UserHandler userHandler;
    private final Cache<String, Iterable<CachedAutoCompleteUser>> usersValidInDateRange;
    private final CacheMapper cacheMapper;

    @Autowired
    public CachingUserAutoCompleteServiceImpl(UserHandler userHandler, @Qualifier(value="user_valid_in_range_cache") Cache<String, Iterable<CachedAutoCompleteUser>> usersValidInDateRange, CacheMapper cacheMapper) {
        this.userHandler = userHandler;
        this.usersValidInDateRange = usersValidInDateRange;
        this.cacheMapper = cacheMapper;
    }

    public void onApplicationEvent(@NonNull UserChangeMessage changeMessage) {
        if (changeMessage == null) {
            throw new NullPointerException("changeMessage is marked non-null but is null");
        }
        this.usersValidInDateRange.invalidateAll();
    }

    @NonNull
    public Iterable<User> refresh(@NonNull Iterable<CachedAutoCompleteUser> cachedUsers) {
        if (cachedUsers == null) {
            throw new NullPointerException("cachedUsers is marked non-null but is null");
        }
        Iterable userIds = (Iterable)Streams.stream(cachedUsers).map(CachedAutoCompleteUser::getId).collect(ImmutableSet.toImmutableSet());
        return this.userHandler.byIdsFailing(userIds);
    }

    @NonNull
    public Iterable<CachedAutoCompleteUser> allActiveUserInDateRange(@NonNull Range<LocalDate> dateRange, boolean truncateDateToMonth) {
        if (dateRange == null) {
            throw new NullPointerException("dateRange is marked non-null but is null");
        }
        String key = CachingUserAutoCompleteServiceImpl.key(dateRange, (boolean)truncateDateToMonth);
        Iterable currentUsers = (Iterable)MoreObjects.firstNonNull((Object)((Iterable)this.usersValidInDateRange.getIfPresent((Object)key)), (Object)ImmutableList.of());
        if (Iterables.isEmpty((Iterable)currentUsers)) {
            Page fetchedValue = this.userHandler.page(Pageable.unpaged(), dateRange, false, truncateDateToMonth);
            Iterable validUsers = (Iterable)Streams.stream((Iterable)fetchedValue).filter(item -> Objects.equals(item.getEntityState(), EntityState.VALID)).collect(ImmutableList.toImmutableList());
            Iterable cachedUsersNew = this.cacheMapper.mapAutoComplete(validUsers);
            this.usersValidInDateRange.put((Object)key, (Object)cachedUsersNew);
            return cachedUsersNew;
        }
        return ImmutableList.copyOf((Iterable)currentUsers);
    }

    @Nonnull
    public Iterable<CachedAutoCompleteUser> singleton(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.cacheMapper.mapAutoComplete((Iterable)ImmutableList.of((Object)user));
    }

    @Nonnull
    private static String key(@NonNull Range<LocalDate> range, boolean truncateDateToMonth) {
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        return String.format("Range: %s, TruncateToMonth: %s", range, truncateDateToMonth);
    }
}

