/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security.impl;

import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.role.CachedRole;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.repository.RoleRepository;
import de.qfm.erp.service.service.mapper.CacheMapper;
import de.qfm.erp.service.service.security.RoleService;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CachingRoleServiceImpl
implements RoleService {
    private static final Logger log = LogManager.getLogger(CachingRoleServiceImpl.class);
    private final RoleRepository repository;
    private final Cache<String, CachedRole> rolesAssignedToCache;
    private final CacheMapper cacheMapper;

    @Autowired
    public CachingRoleServiceImpl(RoleRepository roleRepository, @Qualifier(value="role_cache") Cache<String, CachedRole> rolesAssignedToCache, CacheMapper cacheMapper) {
        this.repository = roleRepository;
        this.rolesAssignedToCache = rolesAssignedToCache;
        this.cacheMapper = cacheMapper;
    }

    @Nonnull
    public Set<EPrivilege> privilegesFor(@NonNull Iterable<String> grantedAuthorityNames) {
        if (grantedAuthorityNames == null) {
            throw new NullPointerException("grantedAuthorityNames is marked non-null but is null");
        }
        ImmutableSet.Builder privilegeBuilder = ImmutableSet.builder();
        for (String grantedAuthorityName : grantedAuthorityNames) {
            CachedRole cachedRole = (CachedRole)this.rolesAssignedToCache.getIfPresent((Object)grantedAuthorityName);
            if (null != cachedRole) {
                Set rolePrivileges = (Set)MoreObjects.firstNonNull((Object)cachedRole.getPrivileges(), (Object)ImmutableSet.of());
                privilegeBuilder.addAll((Iterable)rolePrivileges);
                continue;
            }
            Optional roleCandidate = this.repository.findOneByNameIgnoreCase(grantedAuthorityName);
            roleCandidate.ifPresent(role -> {
                CachedRole cachedRoleNew = this.cacheMapper.map(role);
                this.rolesAssignedToCache.put((Object)role.getName(), (Object)cachedRoleNew);
                privilegeBuilder.addAll((Iterable)cachedRoleNew.getPrivileges());
            });
        }
        return privilegeBuilder.build();
    }
}

