/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security;

import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.internal.user.CachedUser;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import lombok.NonNull;

public interface UserService {
    @Nonnull
    default public Iterable<CachedUser> currentUsersAssignedToLogin() {
        return this.usersAssignedToCurrentUserAt(DateTimeHelper.today());
    }

    @Nonnull
    public Iterable<CachedUser> usersAssignedToCurrentUserAt(@NonNull LocalDate var1);

    @Nonnull
    public Iterable<User> refresh(@NonNull Iterable<CachedUser> var1);

    public Iterable<CachedUser> all();

    public Iterable<CachedUser> allActiveUsersAt(@NonNull LocalDate var1);

    @Nonnull
    public Iterable<CachedUser> usersAssignedToAt(@NonNull User var1, @NonNull LocalDate var2);

    @Nonnull
    public User authenticatedUser();

    public boolean hasPrivilege(@NonNull EPrivilege var1);

    public boolean hasPrivilege(@NonNull User var1, @NonNull EPrivilege var2);

    default public boolean hasAnyPrivilege(@NonNull Iterable<EPrivilege> privileges) {
        if (privileges == null) {
            throw new NullPointerException("privileges is marked non-null but is null");
        }
        for (EPrivilege privilege : privileges) {
            if (!this.hasPrivilege(privilege)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasAnyPrivilege(EPrivilege ... privileges) {
        if (privileges == null) {
            throw new NullPointerException("privileges is marked non-null but is null");
        }
        for (EPrivilege privilege : privileges) {
            if (!this.hasPrivilege(privilege)) continue;
            return true;
        }
        return false;
    }

    public void checkPrivilege(@NonNull EPrivilege var1);
}

