/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.response.profile.UserSettingCommon;
import de.qfm.erp.common.response.profile.UserSettingListCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.profile.UserSetting;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.UserSettingHandler;
import de.qfm.erp.service.service.mapper.UserSettingMapper;
import de.qfm.erp.service.service.route.UserSettingsRoute;
import de.qfm.erp.service.service.security.UserService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserSettingsRouteImpl
implements UserSettingsRoute {
    private static final Logger log = LogManager.getLogger(UserSettingsRouteImpl.class);
    private final EntityFactory entityFactory;
    private final UserService userService;
    private final UserSettingHandler handler;
    private final UserSettingMapper mapper;

    @Nonnull
    public UserSettingCommon byId(long id) {
        UserSetting userSetting = (UserSetting)this.handler.byIdFailing(Long.valueOf(id));
        return this.mapper.map(userSetting);
    }

    @Nonnull
    public UserSettingCommon byKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        User user = this.userService.authenticatedUser();
        UserSetting userSetting = this.handler.byKeyNotFailing(user, key).orElse(this.defaultWithKey(key));
        return this.mapper.map(userSetting);
    }

    @Nonnull
    public UserSettingListCommon mySettings() {
        User user = this.userService.authenticatedUser();
        Iterable userConfigurations = this.handler.allForUser(user);
        return this.mapper.map(userConfigurations);
    }

    @Nonnull
    public UserSettingCommon createOrUpdate(@NonNull String key, @Nullable String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        User user = this.userService.authenticatedUser();
        UserSetting userSetting = this.handler.byKeyNotFailing(user, key).orElse(this.entityFactory.profileEntry());
        UserSetting userSettingMerged = this.mapper.merge(userSetting, user, key, value);
        UserSetting userSettingUpdated = (UserSetting)this.handler.update((EntityBase)userSettingMerged);
        return this.mapper.map(userSettingUpdated);
    }

    @Nonnull
    private UserSetting defaultWithKey(String key) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public UserSettingsRouteImpl(EntityFactory entityFactory, UserService userService, UserSettingHandler handler, UserSettingMapper mapper) {
        this.entityFactory = entityFactory;
        this.userService = userService;
        this.handler = handler;
        this.mapper = mapper;
    }
}

