/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EUserIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.UserSearchMapper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.route.AbstractSyncable;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

@Service
public class UserSearchRoute
extends AbstractSyncable<User> {
    private static final Logger log = LogManager.getLogger(UserSearchRoute.class);
    private final UserHandler userHandler;
    private final UserSearchMapper userSearchMapper;
    private final IndexService indexService;

    public UserSearchRoute(@NonNull NodeConfig nodeConfig, @NonNull UserHandler userHandler, @NonNull UserSearchMapper userSearchMapper, @NonNull IndexService indexService) {
        super(nodeConfig);
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        if (userHandler == null) {
            throw new NullPointerException("userHandler is marked non-null but is null");
        }
        if (userSearchMapper == null) {
            throw new NullPointerException("userSearchMapper is marked non-null but is null");
        }
        if (indexService == null) {
            throw new NullPointerException("indexService is marked non-null but is null");
        }
        this.userHandler = userHandler;
        this.userSearchMapper = userSearchMapper;
        this.indexService = indexService;
    }

    @Nonnull
    public EIndexEntryType indexEntryType() {
        return EIndexEntryType.USER;
    }

    @Nonnull
    public Iterable<User> refresh(@NonNull Iterable<User> itemStream) {
        if (itemStream == null) {
            throw new NullPointerException("itemStream is marked non-null but is null");
        }
        ImmutableList.Builder entriesUpdatedBuilder = ImmutableList.builder();
        itemStream.forEach(item -> this.refresh(item).ifPresent(arg_0 -> ((ImmutableList.Builder)entriesUpdatedBuilder).add(arg_0)));
        return entriesUpdatedBuilder.build();
    }

    @Nonnull
    public Optional<User> refresh(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        String entryId = user.getReferenceId();
        try {
            IndexResult index = this.index(user);
            log.debug("Refreshed Entity: {} in Index", (Object)user);
            return Optional.of(user);
        }
        catch (Exception ioe) {
            log.error("Error Refreshing Index for EntryId: {}, Entry: {}", (Object)entryId, (Object)user, (Object)ioe);
            return Optional.empty();
        }
    }

    public boolean dirty() {
        return this.userHandler.dirty();
    }

    @Nonnull
    public Iterable<User> streamDirty(int max) {
        return this.userHandler.dirtyPage(max);
    }

    @Nonnull
    public Long id(@NonNull User item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getId();
    }

    @Nonnull
    public Iterable<Long> ids(@NonNull Iterable<User> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(User::getId).collect(ImmutableSet.toImmutableSet());
    }

    public void start() {
        log.info("Detected Dirty Entries - refreshing Entries in Index");
    }

    public void finish(@NonNull Iterable<User> itemsProcessed, @NonNull Stopwatch stopwatch) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        if (stopwatch == null) {
            throw new NullPointerException("stopwatch is marked non-null but is null");
        }
        int size = Iterables.size(itemsProcessed);
        long elapsedInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        int markedAsIndexed = this.userHandler.markIndexed(itemsProcessed);
        log.info("Finished Refreshing Dirty Entries, amount: {}, took: {} ms", (Object)size, (Object)elapsedInMs);
    }

    @Nonnull
    private Optional<String> delete(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        try {
            String documentId = UserSearchMapper.documentId((EIndexEntryType)this.indexEntryType(), (Long)stage.getId());
            long indexGeneration = this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EUserIndexField._ID, (String)documentId));
            log.debug("Deleted Entity: {}", (Object)stage);
            return Optional.of(stage.getReferenceId());
        }
        catch (IOException e) {
            log.error("Error Deleting Entry from Index, error: {}", (Object)e.getMessage());
            return Optional.of(e.getMessage());
        }
    }

    @Nonnull
    private IndexResult index(@NonNull User user) throws IOException {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        IndexDocument indexDocument = this.userSearchMapper.mapToDocument(user, this.indexEntryType());
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    private Iterable<IndexResult> index(@NonNull Iterable<User> users) throws IOException {
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        Iterable indexDocuments = this.userSearchMapper.mapToDocument(users, this.indexEntryType());
        return this.indexService.updateIndex(indexDocuments);
    }
}

