/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.taxkey.TaxKeyUpdateRequest;
import de.qfm.erp.common.response.taxkey.TaxKeyCommon;
import de.qfm.erp.common.response.taxkey.TaxKeyPageCommon;
import de.qfm.erp.service.model.exception.request.DeleteRejectException;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.InvoiceHandler;
import de.qfm.erp.service.service.handler.TaxKeyHandler;
import de.qfm.erp.service.service.mapper.TaxKeyMapper;
import de.qfm.erp.service.service.route.TaxKeyRoute;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxKeyRouteImpl
implements TaxKeyRoute {
    private final EntityFactory entityFactory;
    private final TaxKeyMapper mapper;
    private final TaxKeyHandler handler;
    private final InvoiceHandler invoiceHandler;
    private final MessageService messageService;
    private final UserService userService;

    @Nonnull
    @Transactional(readOnly=true)
    public TaxKeyCommon byId(long id) {
        return this.mapper.map((TaxKey)this.handler.byIdFailing(Long.valueOf(id)));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public TaxKeyPageCommon page(int page, int size, @NonNull String invoiceTypeCandidate, boolean flagSubContractorAsExternalServiceAccounting, boolean flagCompanyGroup) {
        if (invoiceTypeCandidate == null) {
            throw new NullPointerException("invoiceTypeCandidate is marked non-null but is null");
        }
        Optional invoiceTypeOpt = EInvoiceType.lookup((String)invoiceTypeCandidate);
        if (invoiceTypeOpt.isPresent()) {
            EInvoiceType invoiceType = (EInvoiceType)invoiceTypeOpt.get();
            return this.mapper.map(this.handler.page(page, size, invoiceType, flagSubContractorAsExternalServiceAccounting, flagCompanyGroup));
        }
        return this.mapper.map(this.handler.page(page, size));
    }

    @Nonnull
    public TaxKeyCommon update(@NonNull TaxKeyUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.TAX_KEY__WRITE);
        String invoiceType = updateRequest.getInvoiceType();
        BigDecimal vat = updateRequest.getVat();
        EInvoiceType eInvoiceType = EInvoiceType.lookupFailing((String)invoiceType);
        boolean flagSubContractorAsExternalServiceAccounting = (Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagSubContractorAsExternalServiceAccounting(), (Object)false);
        boolean flagCompanyGroup = (Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagCompanyGroup(), (Object)false);
        this.validateDuplicate(null, vat, eInvoiceType, flagSubContractorAsExternalServiceAccounting, flagCompanyGroup);
        TaxKey taxKey = this.entityFactory.taxKey();
        return this.mergeAndPersist(updateRequest, taxKey);
    }

    private void validateDuplicate(@Nullable Long idToUpdate, @NonNull BigDecimal vat, @NonNull EInvoiceType eInvoiceType, boolean flagSubContractorAsExternalServiceAccounting, boolean flagCompanyGroup) {
        if (vat == null) {
            throw new NullPointerException("vat is marked non-null but is null");
        }
        if (eInvoiceType == null) {
            throw new NullPointerException("eInvoiceType is marked non-null but is null");
        }
        Optional taxKeyCandidate = this.handler.byInvoiceTypeAndVAT(eInvoiceType, vat, flagSubContractorAsExternalServiceAccounting, flagCompanyGroup);
        if (taxKeyCandidate.isPresent()) {
            boolean same;
            TaxKey taxKey = (TaxKey)taxKeyCandidate.get();
            Long taxKeyExisting = taxKey.getId();
            boolean flagSubContractorAsExternalServiceAccountingExisting = (Boolean)MoreObjects.firstNonNull((Object)taxKey.getFlagSubContractorAsExternalServiceAccounting(), (Object)false);
            boolean bl = same = null != idToUpdate && Objects.equals(idToUpdate, taxKeyExisting) && flagSubContractorAsExternalServiceAccountingExisting == flagSubContractorAsExternalServiceAccounting;
            if (!same) {
                String invoiceTypeName = this.messageService.get((Translatable)eInvoiceType, new Object[0]);
                String value = String.format("%s/%s", invoiceTypeName, vat);
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.TAX_KEY__VAT_INVOICE_TYPE), (Object)value, String.format("The Tax Key with VAT: %s and InvoiceType: %s already exists", vat, invoiceTypeName), Message.of((EMessageKey)EMessageKey.DUPLICATE_TAX_KEY__VAT_INVOICE_TYPE, (List)ImmutableList.of((Object)vat, (Object)invoiceTypeName)));
            }
        }
    }

    @Nonnull
    public TaxKeyCommon update(long id, @NonNull TaxKeyUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.TAX_KEY__WRITE);
        TaxKey taxKey = (TaxKey)this.handler.byIdFailing(Long.valueOf(id));
        String invoiceType = updateRequest.getInvoiceType();
        BigDecimal vat = updateRequest.getVat();
        EInvoiceType eInvoiceType = EInvoiceType.lookupFailing((String)invoiceType);
        boolean flagSubContractorAsExternalServiceAccounting = (Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagSubContractorAsExternalServiceAccounting(), (Object)false);
        boolean flagCompanyGroup = (Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagCompanyGroup(), (Object)false);
        this.validateDuplicate(Long.valueOf(id), vat, eInvoiceType, flagSubContractorAsExternalServiceAccounting, flagCompanyGroup);
        return this.mergeAndPersist(updateRequest, taxKey);
    }

    @Nonnull
    public TaxKeyCommon deleteById(long id) {
        this.userService.checkPrivilege(EPrivilege.TAX_KEY__WRITE);
        TaxKey taxKey = (TaxKey)this.handler.byIdFailing(Long.valueOf(id));
        int amount = this.invoiceHandler.count(taxKey);
        if (amount > 0) {
            throw new DeleteRejectException((FieldName)FieldNamesFactory.cascadedFieldName((FieldName[])new FieldName[]{FieldNamesFactory.simpleFieldName((EField)EField.INVOICE), FieldNamesFactory.simpleFieldName((EField)EField.TAX_KEY)}), (Object)id, String.format("Tax Key cannot be Deleted, its used in: %s Invoices", amount), Message.of((EMessageKey)EMessageKey.TAX_KEY__DELETION_ERROR__USED_IN_INVOICES, (List)ImmutableList.of((Object)amount)));
        }
        this.handler.realDelete(taxKey);
        return this.mapper.map(taxKey);
    }

    @Nonnull
    private TaxKeyCommon mergeAndPersist(@NonNull TaxKeyUpdateRequest updateRequest, @NonNull TaxKey taxKey) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (taxKey == null) {
            throw new NullPointerException("taxKey is marked non-null but is null");
        }
        EInvoiceType invoiceType = EInvoiceType.lookupFailing((String)updateRequest.getInvoiceType());
        TaxKey taxKeyMerged = this.mapper.merge(updateRequest, invoiceType, taxKey);
        TaxKey taxKeyUpdated = (TaxKey)this.handler.update((EntityBase)taxKeyMerged);
        return this.mapper.map(taxKeyUpdated);
    }

    public TaxKeyRouteImpl(EntityFactory entityFactory, TaxKeyMapper mapper, TaxKeyHandler handler, InvoiceHandler invoiceHandler, MessageService messageService, UserService userService) {
        this.entityFactory = entityFactory;
        this.mapper = mapper;
        this.handler = handler;
        this.invoiceHandler = invoiceHandler;
        this.messageService = messageService;
        this.userService = userService;
    }
}

