/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.response.synclog.SyncLogPageCommon;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.service.handler.SyncLogService;
import de.qfm.erp.service.service.mapper.SyncLogMapper;
import de.qfm.erp.service.service.route.SyncLogRoute;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SyncLogRouteImpl
implements SyncLogRoute {
    private static final Logger log = LogManager.getLogger(SyncLogRouteImpl.class);
    private final SyncLogService service;
    private final SyncLogMapper mapper;

    @Nonnull
    public SyncLogPageCommon list(int page, int size) {
        return this.mapper.map(this.service.list(page, size));
    }

    @Nonnull
    public SyncLogPageCommon list(int page, int size, @NonNull String referenceTypeCandidate, @NonNull Long referenceId) {
        if (referenceTypeCandidate == null) {
            throw new NullPointerException("referenceTypeCandidate is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        EReferenceType referenceType = EReferenceType.lookup((String)referenceTypeCandidate, (EReferenceType)EReferenceType.UNKNOWN);
        return this.mapper.map(this.service.list(page, size, referenceType, referenceId));
    }

    public SyncLogRouteImpl(SyncLogService service, SyncLogMapper mapper) {
        this.service = service;
        this.mapper = mapper;
    }
}

