/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.mapper.StageSearchMapper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.route.AbstractSyncable;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

@Service
public class StageSearchRoute
extends AbstractSyncable<Quotation> {
    private static final Logger log = LogManager.getLogger(StageSearchRoute.class);
    private final StageHandler stageHandler;
    private final StageSearchMapper stageSearchMapper;
    private final IndexService indexService;

    public StageSearchRoute(@NonNull NodeConfig nodeConfig, @NonNull StageHandler stageHandler, @NonNull StageSearchMapper stageSearchMapper, @NonNull IndexService indexService) {
        super(nodeConfig);
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        if (stageHandler == null) {
            throw new NullPointerException("stageHandler is marked non-null but is null");
        }
        if (stageSearchMapper == null) {
            throw new NullPointerException("stageSearchMapper is marked non-null but is null");
        }
        if (indexService == null) {
            throw new NullPointerException("indexService is marked non-null but is null");
        }
        this.stageHandler = stageHandler;
        this.stageSearchMapper = stageSearchMapper;
        this.indexService = indexService;
    }

    @Nonnull
    public EIndexEntryType indexEntryType() {
        return EIndexEntryType.STAGE;
    }

    @Nonnull
    public Iterable<Quotation> refresh(@NonNull Iterable<Quotation> itemStream) {
        if (itemStream == null) {
            throw new NullPointerException("itemStream is marked non-null but is null");
        }
        ImmutableList.Builder entriesUpdatedBuilder = ImmutableList.builder();
        itemStream.forEach(item -> this.refresh(item).ifPresent(arg_0 -> ((ImmutableList.Builder)entriesUpdatedBuilder).add(arg_0)));
        return entriesUpdatedBuilder.build();
    }

    @Nonnull
    public Optional<Quotation> refresh(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        String entryId = stage.getReferenceId();
        try {
            IndexResult index = this.index(stage);
            log.debug("Refreshed Entity: {} in Index", (Object)stage);
            return Optional.of(stage);
        }
        catch (Exception ioe) {
            log.error("Error Refreshing Index for EntryId: {}, Entry: {}", (Object)entryId, (Object)stage, (Object)ioe);
            return Optional.empty();
        }
    }

    public boolean dirty() {
        return this.stageHandler.dirty();
    }

    @Nonnull
    public Iterable<Quotation> streamDirty(int max) {
        return this.stageHandler.dirtyPage(max);
    }

    @Nonnull
    public Long id(@NonNull Quotation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getId();
    }

    @Nonnull
    public Iterable<Long> ids(@NonNull Iterable<Quotation> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(Quotation::getId).collect(ImmutableSet.toImmutableSet());
    }

    public void start() {
        log.info("Detected Dirty Entries - refreshing Entries in Index");
    }

    public void finish(@NonNull Iterable<Quotation> itemsProcessed, @NonNull Stopwatch stopwatch) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        if (stopwatch == null) {
            throw new NullPointerException("stopwatch is marked non-null but is null");
        }
        int size = Iterables.size(itemsProcessed);
        long elapsedInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        int markedAsIndexed = this.stageHandler.markIndexed(itemsProcessed);
        log.info("Finished Refreshing Dirty Entries, amount: {}, took: {} ms", (Object)size, (Object)elapsedInMs);
    }

    @Nonnull
    private Optional<String> delete(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        try {
            String documentId = StageSearchMapper.documentId((EIndexEntryType)this.indexEntryType(), (Long)stage.getId());
            long indexGeneration = this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EStageIndexField._ID, (String)documentId));
            log.debug("Deleted Entity: {}", (Object)stage);
            return Optional.of(stage.getReferenceId());
        }
        catch (IOException e) {
            log.error("Error Deleting Entry from Index, error: {}", (Object)e.getMessage());
            return Optional.of(e.getMessage());
        }
    }

    @Nonnull
    private IndexResult index(@NonNull Quotation stage) throws IOException {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        IndexDocument indexDocument = this.stageSearchMapper.mapToDocument(stage, this.indexEntryType());
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    private Iterable<IndexResult> index(@NonNull Iterable<Quotation> stages) throws IOException {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        Iterable indexDocuments = this.stageSearchMapper.mapToDocument(stages, this.indexEntryType());
        return this.indexService.updateIndex(indexDocuments);
    }
}

