/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.response.search.SearchV2Response;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.helper.InvoiceDefinition;
import de.qfm.erp.service.model.internal.search.CustomerSearchItemBucket;
import de.qfm.erp.service.model.internal.search.ESearchTask;
import de.qfm.erp.service.model.internal.search.EntitySearchItemBucket;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.internal.search.InvoiceSearchItemBucket;
import de.qfm.erp.service.model.internal.search.MeasurementSearchItemBucket;
import de.qfm.erp.service.model.internal.search.StageSearchItemBucket;
import de.qfm.erp.service.model.internal.search.SubProjectSearchItemBucket;
import de.qfm.erp.service.model.internal.search.UserSearchItemBucket;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.search.CustomerIndexEntry;
import de.qfm.erp.service.model.search.CustomerIndexSearchResult;
import de.qfm.erp.service.model.search.CustomerSearchResultItem;
import de.qfm.erp.service.model.search.ECustomerIndexField;
import de.qfm.erp.service.model.search.EEntityIndexField;
import de.qfm.erp.service.model.search.EInvoiceIndexField;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.ESubProjectIndexField;
import de.qfm.erp.service.model.search.EUserIndexField;
import de.qfm.erp.service.model.search.EntityIndexEntry;
import de.qfm.erp.service.model.search.EntityIndexSearchResult;
import de.qfm.erp.service.model.search.EntitySearchResultItem;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.InvoiceIndexEntry;
import de.qfm.erp.service.model.search.InvoiceIndexSearchResult;
import de.qfm.erp.service.model.search.InvoiceSearchResultItem;
import de.qfm.erp.service.model.search.MeasurementIndexEntry;
import de.qfm.erp.service.model.search.MeasurementIndexSearchResult;
import de.qfm.erp.service.model.search.MeasurementSearchResultItem;
import de.qfm.erp.service.model.search.StageIndexEntry;
import de.qfm.erp.service.model.search.StageIndexSearchResult;
import de.qfm.erp.service.model.search.StageSearchResultItem;
import de.qfm.erp.service.model.search.SubProjectIndexEntry;
import de.qfm.erp.service.model.search.SubProjectIndexSearchResult;
import de.qfm.erp.service.model.search.SubProjectSearchResultItem;
import de.qfm.erp.service.model.search.UserIndexEntry;
import de.qfm.erp.service.model.search.UserIndexSearchResult;
import de.qfm.erp.service.model.search.UserSearchResultItem;
import de.qfm.erp.service.service.handler.InvoiceHandler;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.mapper.CustomerMapper;
import de.qfm.erp.service.service.mapper.InvoiceMapper;
import de.qfm.erp.service.service.mapper.MeasurementMapper;
import de.qfm.erp.service.service.mapper.QEntityMapper;
import de.qfm.erp.service.service.mapper.QuotationMapper;
import de.qfm.erp.service.service.mapper.SubProjectMapper;
import de.qfm.erp.service.service.mapper.UserMapper;
import de.qfm.erp.service.service.route.SearchV2Route;
import de.qfm.erp.service.service.route.impl.SearchV2RouteImpl;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.StageHelperService;
import de.qfm.erp.service.service.service.search.CustomerIndexSearchService;
import de.qfm.erp.service.service.service.search.EntityIndexSearchService;
import de.qfm.erp.service.service.service.search.InvoiceIndexSearchService;
import de.qfm.erp.service.service.service.search.MeasurementIndexSearchService;
import de.qfm.erp.service.service.service.search.StageIndexSearchService;
import de.qfm.erp.service.service.service.search.SubProjectIndexSearchService;
import de.qfm.erp.service.service.service.search.UserIndexSearchService;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SearchV2RouteImpl
implements SearchV2Route {
    private static final Logger log = LogManager.getLogger(SearchV2RouteImpl.class);
    public static final int MINIMUM_SEARCH_HIGHLIGHT_LENGTH = 2;
    public static final int MINIMUM_SEARCH_QUERY_LENGTH = 2;
    private final ApplicationConfig applicationConfig;
    private final ConfigService configService;
    private final UserService userService;
    private final MeasurementHandler measurementHandler;
    private final CustomerIndexSearchService customerIndexSearchService;
    private final MeasurementIndexSearchService measurementIndexSearchService;
    private final EntityIndexSearchService entityIndexSearchService;
    private final InvoiceIndexSearchService invoiceIndexSearchService;
    private final StageIndexSearchService stageIndexSearchService;
    private final SubProjectIndexSearchService subProjectIndexSearchService;
    private final UserIndexSearchService userIndexSearchService;
    private final InvoiceHandler invoiceHandler;
    private final StageHandler stageHandler;
    private final CustomerMapper customerMapper;
    private final QEntityMapper entityMapper;
    private final MeasurementMapper measurementMapper;
    private final InvoiceMapper invoiceMapper;
    private final QuotationMapper quotationMapper;
    private final SubProjectMapper subProjectMapper;
    private final UserMapper userMapper;
    private final StageHelperService stageHelperService;
    private static final Pattern MEASUREMENT_NUMBER_PATTERN = Pattern.compile("[0-9]{6,7}");
    private static final Pattern INVOICE_NUMBER_MATCHER = Pattern.compile("(?i)(r|ir|ib|gu)[0-9]{2}/[0-9]{5}");

    @Transactional(readOnly=true)
    @Nonnull
    public SearchV2Response search(@NonNull String query, int size, boolean includeArchived, @NonNull Iterable<String> entityTypesCandidates) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (entityTypesCandidates == null) {
            throw new NullPointerException("entityTypesCandidates is marked non-null but is null");
        }
        SearchV2Response.SearchV2ResponseBuilder searchV2ResponseBuilder = SearchV2Response.builder();
        ImmutableSet searchTasksAsked = (ImmutableSet)Streams.stream(entityTypesCandidates).filter(Objects::nonNull).map(EEntityClass::lookup).filter(Optional::isPresent).map(Optional::get).map(ESearchTask.MAPPING::get).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        AtomicReference invoices = new AtomicReference();
        AtomicReference measurements = new AtomicReference();
        AtomicReference entities = new AtomicReference();
        AtomicReference stages = new AtomicReference();
        AtomicReference subProjects = new AtomicReference();
        AtomicReference employees = new AtomicReference();
        AtomicReference customers = new AtomicReference();
        if (StringUtils.length((CharSequence)query) >= 2) {
            Locale locale = LocaleContextHolder.getLocale();
            Iterable searchTasksEffective = this.determineSearchTasks((Iterable)searchTasksAsked);
            log.info("Global Search query: {}, SearchTasks: {}", (Object)query, (Object)searchTasksEffective);
            int expectedLatches = Iterables.size((Iterable)searchTasksEffective) + 1;
            log.info("Executing {} SearchTasks: {}", (Object)size, (Object)searchTasksEffective);
            CountDownLatch countDownLatch = new CountDownLatch(expectedLatches);
            ExecutorService executorService = Executors.newFixedThreadPool(4);
            try (Closeable closeable = executorService::shutdown;){
                executorService.submit(() -> {
                    if (Iterables.contains((Iterable)searchTasksEffective, (Object)ESearchTask.STAGE)) {
                        LocaleContextHolder.setLocale((Locale)locale);
                        Stopwatch sw = Stopwatch.createStarted();
                        try {
                            EntityIndexSearchResult indexSearchResult = this.entityIndexSearchService.search(query, 0, size, includeArchived);
                            Page stageBuckets = this.entityBuckets(indexSearchResult, query, 0, size);
                            PageCommon pageCommon = this.entityMapper.mapToSearchItem(stageBuckets);
                            entities.set(pageCommon);
                        }
                        catch (Exception e) {
                            log.error("Error Running Stage Search: {}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            log.info("Finished Stage: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                        }
                    } else {
                        searchV2ResponseBuilder.stages(new PageCommon(0, size, 0, 0L, (List)ImmutableList.of()));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                executorService.submit(() -> {
                    if (Iterables.contains((Iterable)searchTasksEffective, (Object)ESearchTask.INVOICE)) {
                        LocaleContextHolder.setLocale((Locale)locale);
                        Stopwatch sw = Stopwatch.createStarted();
                        try {
                            InvoiceIndexSearchResult invoiceIndexSearchResult = this.invoiceIndexSearchService.search(query, 0, size);
                            Page buckets = this.invoiceBuckets(invoiceIndexSearchResult, query, 0, size);
                            PageCommon pageCommon = this.invoiceMapper.mapToSearchItem(buckets);
                            invoices.set(pageCommon);
                        }
                        catch (Exception e) {
                            log.error("Error Running Invoice Search: {}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            log.info("Finished Invoice: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                        }
                    } else {
                        searchV2ResponseBuilder.invoices(new PageCommon(0, size, 0, 0L, (List)ImmutableList.of()));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                executorService.submit(() -> {
                    if (Iterables.contains((Iterable)searchTasksEffective, (Object)ESearchTask.MEASUREMENT)) {
                        LocaleContextHolder.setLocale((Locale)locale);
                        Stopwatch sw = Stopwatch.createStarted();
                        try {
                            MeasurementIndexSearchResult measurementPage = this.measurementIndexSearchService.search(query, 0, size);
                            Page buckets = this.measurementBuckets(measurementPage, query, 0, size);
                            PageCommon pageCommon = this.measurementMapper.mapToSearchItem(buckets);
                            measurements.set(pageCommon);
                        }
                        catch (Exception e) {
                            log.error("Error Running Measurement Search: {}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            log.info("Finished Measurement: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                        }
                    } else {
                        searchV2ResponseBuilder.measurements(new PageCommon(0, size, 0, 0L, (List)ImmutableList.of()));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                executorService.submit(() -> {
                    LocaleContextHolder.setLocale((Locale)locale);
                    Stopwatch sw = Stopwatch.createStarted();
                    try {
                        Optional directMatchCand = this.directMatch(searchTasksEffective, query);
                        if (directMatchCand.isPresent()) {
                            DirectMatch directMatch = (DirectMatch)directMatchCand.get();
                            searchV2ResponseBuilder.directAccess(true).directAccessEntityId(directMatch.getId()).directAccessEntityClass(directMatch.getEntityClass().name());
                        } else {
                            searchV2ResponseBuilder.directAccess(false);
                        }
                    }
                    catch (Exception e) {
                        log.error("Error Running DirectMatch Search: {}", (Object)e.getMessage(), (Object)e);
                    }
                    finally {
                        log.info("Finished DirectMatch: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                executorService.submit(() -> {
                    if (Iterables.contains((Iterable)searchTasksEffective, (Object)ESearchTask.STAGE)) {
                        LocaleContextHolder.setLocale((Locale)locale);
                        Stopwatch sw = Stopwatch.createStarted();
                        try {
                            StageIndexSearchResult stageIndexSearchResult = this.stageIndexSearchService.search(query, 0, size, includeArchived);
                            Page stageBuckets = this.stageBuckets(stageIndexSearchResult, query, 0, size);
                            PageCommon pageCommon = this.quotationMapper.mapToSearchItem(stageBuckets);
                            stages.set(pageCommon);
                        }
                        catch (Exception e) {
                            log.error("Error Running Stage Search: {}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            log.info("Finished Stage: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                        }
                    } else {
                        searchV2ResponseBuilder.stages(new PageCommon(0, size, 0, 0L, (List)ImmutableList.of()));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                executorService.submit(() -> {
                    if (Iterables.contains((Iterable)searchTasksEffective, (Object)ESearchTask.SUB_PROJECT)) {
                        LocaleContextHolder.setLocale((Locale)locale);
                        Stopwatch sw = Stopwatch.createStarted();
                        try {
                            SubProjectIndexSearchResult indexSearchResult = this.subProjectIndexSearchService.search(query, 0, size);
                            Page buckets = this.subProjectBuckets(indexSearchResult, query, 0, size);
                            PageCommon pageCommon = this.subProjectMapper.mapToSearchItem(buckets);
                            subProjects.set(pageCommon);
                        }
                        catch (Exception e) {
                            log.error("Error Running SubProject Search: {}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            log.info("Finished SubProject: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                        }
                    } else {
                        searchV2ResponseBuilder.subProjects(new PageCommon(0, size, 0, 0L, (List)ImmutableList.of()));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                executorService.submit(() -> {
                    if (Iterables.contains((Iterable)searchTasksEffective, (Object)ESearchTask.USER)) {
                        LocaleContextHolder.setLocale((Locale)locale);
                        Stopwatch sw = Stopwatch.createStarted();
                        try {
                            UserIndexSearchResult userIndexSearchResult = this.userIndexSearchService.search(query, 0, size);
                            Page buckets = this.userBuckets(userIndexSearchResult, query, 0, size);
                            PageCommon pageCommon = this.userMapper.mapToSearchItem(buckets);
                            employees.set(pageCommon);
                        }
                        catch (Exception e) {
                            log.error("Error Running Employee Search: {}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            log.info("Finished Employee: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                        }
                    } else {
                        searchV2ResponseBuilder.employees(new PageCommon(0, size, 0, 0L, (List)ImmutableList.of()));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                executorService.submit(() -> {
                    if (Iterables.contains((Iterable)searchTasksEffective, (Object)ESearchTask.CUSTOMER)) {
                        LocaleContextHolder.setLocale((Locale)locale);
                        Stopwatch sw = Stopwatch.createStarted();
                        try {
                            CustomerIndexSearchResult customerPage = this.customerIndexSearchService.search(query, 0, size);
                            Page buckets = this.customerBuckets(customerPage, query, 0, size);
                            PageCommon pageCommon = this.customerMapper.mapToSearchItem(buckets);
                            customers.set(pageCommon);
                        }
                        catch (Exception e) {
                            log.error("Error Running Customer Search: {}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            log.info("Finished Customer: {} milliseconds", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                        }
                    } else {
                        searchV2ResponseBuilder.customers(new PageCommon(0, size, 0, 0L, (List)ImmutableList.of()));
                    }
                    countDownLatch.countDown();
                    return true;
                });
                int globalSearchAutoCompleteMaxTimeoutMS = this.applicationConfig.getGlobalSearchAutoCompleteMaxTimeoutMS();
                boolean awaitResult = countDownLatch.await(globalSearchAutoCompleteMaxTimeoutMS, TimeUnit.MILLISECONDS);
                executorService.shutdown();
                boolean bl = executorService.awaitTermination(globalSearchAutoCompleteMaxTimeoutMS, TimeUnit.MILLISECONDS);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            log.info("Done Querying");
        }
        PageCommon invoiceSearchItemPageCommon = (PageCommon)MoreObjects.firstNonNull((Object)((PageCommon)invoices.get()), (Object)new PageCommon(0, 0, 0, 0L, (List)ImmutableList.of()));
        searchV2ResponseBuilder.invoices(invoiceSearchItemPageCommon);
        PageCommon measurementSearchItemPageCommon = (PageCommon)MoreObjects.firstNonNull((Object)((PageCommon)measurements.get()), (Object)new PageCommon(0, 0, 0, 0L, (List)ImmutableList.of()));
        searchV2ResponseBuilder.measurements(measurementSearchItemPageCommon);
        PageCommon entitySearchItemPageCommon = (PageCommon)MoreObjects.firstNonNull((Object)((PageCommon)entities.get()), (Object)new PageCommon(0, 0, 0, 0L, (List)ImmutableList.of()));
        searchV2ResponseBuilder.entities(entitySearchItemPageCommon);
        PageCommon stageSearchItemPageCommon = (PageCommon)MoreObjects.firstNonNull((Object)((PageCommon)stages.get()), (Object)new PageCommon(0, 0, 0, 0L, (List)ImmutableList.of()));
        searchV2ResponseBuilder.stages(stageSearchItemPageCommon);
        PageCommon subProjectSearchItemPageCommon = (PageCommon)MoreObjects.firstNonNull((Object)((PageCommon)subProjects.get()), (Object)new PageCommon(0, 0, 0, 0L, (List)ImmutableList.of()));
        searchV2ResponseBuilder.subProjects(subProjectSearchItemPageCommon);
        PageCommon employeeSearchItemPageCommon = (PageCommon)MoreObjects.firstNonNull((Object)((PageCommon)employees.get()), (Object)new PageCommon(0, 0, 0, 0L, (List)ImmutableList.of()));
        searchV2ResponseBuilder.employees(employeeSearchItemPageCommon);
        PageCommon customerSearchItemPageCommon = (PageCommon)MoreObjects.firstNonNull((Object)((PageCommon)customers.get()), (Object)new PageCommon(0, 0, 0, 0L, (List)ImmutableList.of()));
        searchV2ResponseBuilder.customers(customerSearchItemPageCommon);
        return searchV2ResponseBuilder.build();
    }

    @Nonnull
    private Page<CustomerSearchItemBucket> customerBuckets(@NonNull CustomerIndexSearchResult customerIndexSearchResult, @NonNull String query, int page, int size) {
        if (customerIndexSearchResult == null) {
            throw new NullPointerException("customerIndexSearchResult is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List parts = Splitter.on((char)' ').splitToList((CharSequence)query);
        Pair rootFN = Pair.of((Object)ECustomerIndexField.CUSTOMER__NAME, CustomerIndexEntry::getName);
        ImmutableList detailFNs = ImmutableList.of((Object)Pair.of((Object)ECustomerIndexField.CUSTOMER__NAME, CustomerIndexEntry::getName), (Object)Pair.of((Object)ECustomerIndexField.CUSTOMER__DEBTOR_ACCOUNT_NUMBER, CustomerIndexEntry::getDebtorAccountNumber));
        ImmutableList detailFNs2 = ImmutableList.of((Object)Pair.of((Object)ECustomerIndexField.CUSTOMER__ADDRESS, CustomerIndexEntry::getAddresses));
        ArrayList globalBuckets = Lists.newArrayList();
        List customerSearchResultItems = customerIndexSearchResult.getItems();
        for (CustomerSearchResultItem searchResultItem : customerSearchResultItems) {
            Highlight detailHighlight;
            Optional detailHighlightCandidate;
            CustomerIndexEntry customerIndexEntry = (CustomerIndexEntry)searchResultItem.getIndexEntry();
            Highlight fallback = Highlight.of((IndexField)ECustomerIndexField.UNKNOWN, (String)customerIndexEntry.getName(), (Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
            Highlight rootHighlight = SearchV2RouteImpl.firstHighlight((Object)customerIndexEntry, (Pair)rootFN, (Iterable)parts).orElse(fallback);
            ArrayList buckets = Lists.newArrayList();
            for (Pair detailFN : detailFNs) {
                detailHighlightCandidate = SearchV2RouteImpl.firstHighlight((Object)customerIndexEntry, (Pair)detailFN, (Iterable)parts);
                if (!detailHighlightCandidate.isPresent()) continue;
                detailHighlight = (Highlight)detailHighlightCandidate.get();
                buckets.add(CustomerSearchItemBucket.of((CustomerIndexEntry)customerIndexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                break;
            }
            if (buckets.isEmpty()) {
                for (Pair detailFN : detailFNs2) {
                    detailHighlightCandidate = SearchV2RouteImpl.firstHighlight2((Object)customerIndexEntry, (Pair)detailFN, (Iterable)parts);
                    if (!detailHighlightCandidate.isPresent()) continue;
                    detailHighlight = (Highlight)detailHighlightCandidate.get();
                    buckets.add(CustomerSearchItemBucket.of((CustomerIndexEntry)customerIndexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                    break;
                }
            }
            if (buckets.isEmpty()) {
                buckets.add(CustomerSearchItemBucket.of((CustomerIndexEntry)customerIndexEntry, (String)customerIndexEntry.getName(), (Highlight)rootHighlight, (Highlight)fallback));
            }
            globalBuckets.addAll(buckets);
        }
        return new PageImpl((List)globalBuckets, (Pageable)PageRequest.of((int)page, (int)size), customerIndexSearchResult.getTotalHits());
    }

    @Nonnull
    private Page<UserSearchItemBucket> userBuckets(@NonNull UserIndexSearchResult userIndexSearchResult, @NonNull String query, int page, int size) {
        if (userIndexSearchResult == null) {
            throw new NullPointerException("userIndexSearchResult is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List parts = Splitter.on((char)' ').splitToList((CharSequence)query);
        Pair rootFN = Pair.of((Object)EUserIndexField.USER__FULL_NAME, UserIndexEntry::getFullName);
        ImmutableList detailFNs = ImmutableList.of((Object)Pair.of((Object)EUserIndexField.USER__FULL_NAME, UserIndexEntry::getFullName), (Object)Pair.of((Object)EUserIndexField.USER__PERSONAL_NUMBER_TXT, UserIndexEntry::getPersonalNumberTxt), (Object)Pair.of((Object)EUserIndexField.USER__EMAIL, UserIndexEntry::getEmail));
        ArrayList globalBuckets = Lists.newArrayList();
        List searchResultItems = userIndexSearchResult.getItems();
        for (UserSearchResultItem userSearchResultItem : searchResultItems) {
            UserIndexEntry userIndexEntry = (UserIndexEntry)userSearchResultItem.getIndexEntry();
            Highlight fallback = Highlight.of((IndexField)EUserIndexField.UNKNOWN, (String)"", (Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
            Highlight rootHighlight = SearchV2RouteImpl.firstHighlight((Object)userIndexEntry, (Pair)rootFN, (Iterable)parts).orElse(fallback);
            ArrayList buckets = Lists.newArrayList();
            for (Pair detailFN : detailFNs) {
                Optional detailHighlightCandidate = SearchV2RouteImpl.firstHighlight((Object)userIndexEntry, (Pair)detailFN, (Iterable)parts);
                if (!detailHighlightCandidate.isPresent()) continue;
                Highlight detailHighlight = (Highlight)detailHighlightCandidate.get();
                buckets.add(UserSearchItemBucket.of((UserIndexEntry)userIndexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                break;
            }
            if (buckets.isEmpty()) {
                buckets.add(UserSearchItemBucket.of((UserIndexEntry)userIndexEntry, (String)"", (Highlight)rootHighlight, (Highlight)fallback));
            }
            globalBuckets.addAll(buckets);
        }
        return new PageImpl((List)globalBuckets, (Pageable)PageRequest.of((int)page, (int)size), userIndexSearchResult.getTotalHits());
    }

    @Nonnull
    private Page<MeasurementSearchItemBucket> measurementBuckets(@NonNull MeasurementIndexSearchResult measurementIndexSearchResult, @NonNull String query, int page, int size) {
        if (measurementIndexSearchResult == null) {
            throw new NullPointerException("measurementIndexSearchResult is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List originalParts = Splitter.on((char)' ').splitToList((CharSequence)query);
        Iterable highlightParts = SearchV2RouteImpl.highlightParts((Iterable)originalParts);
        Pair rootFN = Pair.of((Object)EMeasurementIndexField.MEASUREMENT__MEASUREMENT_NUMBER, MeasurementIndexEntry::getMeasurementNumber);
        ImmutableList detailFNs = ImmutableList.of((Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__MEASUREMENT_NUMBER, MeasurementIndexEntry::getMeasurementNumber), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__ASSIGNED_USER_FULL_NAME, MeasurementIndexEntry::getAssignedUserFullName), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__RELEASE_ORDER__NAME, MeasurementIndexEntry::getReleaseOrderName), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__PSS_RELEASE_ORDER__NAME, MeasurementIndexEntry::getPssReleaseOrderName), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__CONSTRUCTION_SITE, MeasurementIndexEntry::getConstructionSite), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__INVOICE_NUMBER, MeasurementIndexEntry::getInvoiceNumber), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__STAGE_NUMBER, MeasurementIndexEntry::getStageNumber), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__STAGE_ALIAS, MeasurementIndexEntry::getStageAlias), (Object)Pair.of((Object)EMeasurementIndexField.MEASUREMENT__QUOTATION_NUMBER, MeasurementIndexEntry::getQuotationNumber));
        ArrayList globalBuckets = Lists.newArrayList();
        List measurementSearchResultItems = measurementIndexSearchResult.getItems();
        for (MeasurementSearchResultItem measurementSearchResultItem : measurementSearchResultItems) {
            MeasurementIndexEntry measurementIndexEntry = (MeasurementIndexEntry)measurementSearchResultItem.getIndexEntry();
            Highlight fallback = Highlight.of((IndexField)EMeasurementIndexField.UNKNOWN, (String)measurementIndexEntry.getMeasurementNumber(), (Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
            Highlight rootHighlight = SearchV2RouteImpl.firstHighlight((Object)measurementIndexEntry, (Pair)rootFN, (Iterable)highlightParts).orElse(fallback);
            ArrayList localBuckets = Lists.newArrayList();
            for (Pair detailFN : detailFNs) {
                Optional detailHighlightCandidate = SearchV2RouteImpl.firstHighlight((Object)measurementIndexEntry, (Pair)detailFN, (Iterable)highlightParts);
                if (!detailHighlightCandidate.isPresent()) continue;
                Highlight detailHighlight = (Highlight)detailHighlightCandidate.get();
                localBuckets.add(MeasurementSearchItemBucket.of((MeasurementIndexEntry)measurementIndexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                break;
            }
            if (localBuckets.isEmpty()) {
                localBuckets.add(MeasurementSearchItemBucket.of((MeasurementIndexEntry)measurementIndexEntry, (String)"", (Highlight)rootHighlight, (Highlight)fallback));
            }
            globalBuckets.addAll(localBuckets);
        }
        return new PageImpl((List)globalBuckets, (Pageable)PageRequest.of((int)page, (int)size), measurementIndexSearchResult.getTotalHits());
    }

    @Nonnull
    @VisibleForTesting
    static Iterable<String> highlightParts(@NonNull Iterable<String> originalParts) {
        if (originalParts == null) {
            throw new NullPointerException("originalParts is marked non-null but is null");
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String originalPart : originalParts) {
            if (StringUtils.length((CharSequence)originalPart) == 8 && StageHelperService.COST_UNIT_NUMBER_WOD_MATCHER.matcher(originalPart).matches()) {
                String left = StringUtils.substring((String)originalPart, (int)0, (int)2);
                String middle = StringUtils.substring((String)originalPart, (int)2, (int)5);
                String right = StringUtils.substring((String)originalPart, (int)5, (int)8);
                builder.add((Object)(left + "/" + middle + "/" + right));
            }
            builder.add((Object)originalPart);
        }
        return builder.build();
    }

    private Iterable<String> quotationNumbers(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        String quotationNumber = stage.getQuotationNumber();
        if (quotationNumber.contains("/")) {
            // empty if block
        }
        return null;
    }

    @Nonnull
    private Page<InvoiceSearchItemBucket> invoiceBuckets(@NonNull InvoiceIndexSearchResult invoiceIndexSearchResult, @NonNull String query, int page, int size) {
        if (invoiceIndexSearchResult == null) {
            throw new NullPointerException("invoiceIndexSearchResult is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List originalParts = Splitter.on((char)' ').splitToList((CharSequence)query);
        Iterable highlightParts = SearchV2RouteImpl.highlightParts((Iterable)originalParts);
        Pair rootFN = Pair.of((Object)EInvoiceIndexField.INVOICE__INVOICE_NUMBER, InvoiceIndexEntry::getInvoiceNumber);
        ImmutableList detailFNs = ImmutableList.of((Object)Pair.of((Object)EInvoiceIndexField.INVOICE__INVOICE_NUMBER, InvoiceIndexEntry::getInvoiceNumber), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__COST_CENTER, InvoiceIndexEntry::getCostCenter), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__ORDER_NUMBER, InvoiceIndexEntry::getOrderNumber), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__ORDER_DESCRIPTION, InvoiceIndexEntry::getOrderDescription), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__VOUCHER_NUMBER, InvoiceIndexEntry::getVoucherNumber), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__CREDIT_VOUCHER_NUMBER, InvoiceIndexEntry::getCreditVoucherNumber), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__CONSTRUCTION_SITE, InvoiceIndexEntry::getConstructionSite), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__INVOICE_NAME, InvoiceIndexEntry::getInvoiceName), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__INVOICE_ADDRESS_SUFFIX, InvoiceIndexEntry::getInvoiceAddressSuffix), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__INVOICE_REF_ADDRESS_SUFFIX, InvoiceIndexEntry::getInvoiceRefAddressSuffix), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__IMPORT_FILE_NAME, InvoiceIndexEntry::getImportFileName), (Object)Pair.of((Object)EInvoiceIndexField.INVOICE__CONTACT_PERSON, InvoiceIndexEntry::getContactPerson), (Object[])new Pair[]{Pair.of((Object)EInvoiceIndexField.INVOICE__STAGE_NUMBER, InvoiceIndexEntry::getStageNumber), Pair.of((Object)EInvoiceIndexField.INVOICE__QUOTATION_NUMBER, InvoiceIndexEntry::getQuotationNumber), Pair.of((Object)EInvoiceIndexField.INVOICE__FINANCE_DEBTOR_ACCOUNT_NUMBER, InvoiceIndexEntry::getFinanceDebtorAccountNumber)});
        ImmutableList detailFNs2 = ImmutableList.of((Object)Pair.of((Object)EInvoiceIndexField.INVOICE__MEASUREMENT_NUMBER, InvoiceIndexEntry::getMeasurementNumbers));
        ArrayList globalBuckets = Lists.newArrayList();
        List invoiceSearchResultItems = invoiceIndexSearchResult.getItems();
        for (InvoiceSearchResultItem invoiceSearchResultItem : invoiceSearchResultItems) {
            Highlight detailHighlight;
            Optional detailHighlightCandidate;
            InvoiceIndexEntry invoiceIndexEntry = (InvoiceIndexEntry)invoiceSearchResultItem.getIndexEntry();
            Highlight fallback = Highlight.of((IndexField)EInvoiceIndexField.UNKNOWN, (String)invoiceIndexEntry.getInvoiceNumber(), (Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
            Highlight rootHighlight = SearchV2RouteImpl.firstHighlight((Object)invoiceIndexEntry, (Pair)rootFN, (Iterable)highlightParts).orElse(fallback);
            ArrayList buckets = Lists.newArrayList();
            for (Pair detailFN : detailFNs) {
                detailHighlightCandidate = SearchV2RouteImpl.firstHighlight((Object)invoiceIndexEntry, (Pair)detailFN, (Iterable)highlightParts);
                if (!detailHighlightCandidate.isPresent()) continue;
                detailHighlight = (Highlight)detailHighlightCandidate.get();
                buckets.add(InvoiceSearchItemBucket.of((InvoiceIndexEntry)invoiceIndexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                break;
            }
            if (buckets.isEmpty()) {
                for (Pair detailFN : detailFNs2) {
                    detailHighlightCandidate = SearchV2RouteImpl.firstHighlight2((Object)invoiceIndexEntry, (Pair)detailFN, (Iterable)highlightParts);
                    if (!detailHighlightCandidate.isPresent()) continue;
                    detailHighlight = (Highlight)detailHighlightCandidate.get();
                    buckets.add(InvoiceSearchItemBucket.of((InvoiceIndexEntry)invoiceIndexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                    break;
                }
            }
            if (buckets.isEmpty()) {
                buckets.add(InvoiceSearchItemBucket.of((InvoiceIndexEntry)invoiceIndexEntry, (String)"", (Highlight)rootHighlight, (Highlight)fallback));
            }
            globalBuckets.addAll(buckets);
        }
        return new PageImpl((List)globalBuckets, (Pageable)PageRequest.of((int)page, (int)size), invoiceIndexSearchResult.getTotalHits());
    }

    @Nonnull
    private Page<EntitySearchItemBucket> entityBuckets(@NonNull EntityIndexSearchResult indexSearchResult, @NonNull String query, int page, int size) {
        if (indexSearchResult == null) {
            throw new NullPointerException("indexSearchResult is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List originalParts = Splitter.on((char)' ').splitToList((CharSequence)query);
        Iterable highlightParts = SearchV2RouteImpl.highlightParts((Iterable)originalParts);
        Pair rootFN = Pair.of((Object)EEntityIndexField.ENTITY__ENTITY_NUMBER, EntityIndexEntry::getEntityNumber);
        ImmutableList detailFNs = ImmutableList.of((Object)Pair.of((Object)EEntityIndexField.ENTITY__ENTITY_NUMBER, EntityIndexEntry::getEntityNumber), (Object)Pair.of((Object)EEntityIndexField.ENTITY__ENTITY_ALIAS, EntityIndexEntry::getEntityAlias), (Object)Pair.of((Object)EEntityIndexField.ENTITY__PRIMARY_STAGE_NUMBER, EntityIndexEntry::getPrimaryStageNumber), (Object)Pair.of((Object)EEntityIndexField.ENTITY__PRIMARY_STAGE_QUOTATION_NUMBER, EntityIndexEntry::getPrimaryStageQuotationNumber), (Object)Pair.of((Object)EEntityIndexField.ENTITY__PRIMARY_STAGE_ALIAS, EntityIndexEntry::getPrimaryStageAlias), (Object)Pair.of((Object)EEntityIndexField.ENTITY__CUSTOMER__NAME, EntityIndexEntry::getCustomerName));
        ArrayList globalBuckets = Lists.newArrayList();
        List indexSearchResultItems = indexSearchResult.getItems();
        for (EntitySearchResultItem searchResultItem : indexSearchResultItems) {
            EntityIndexEntry indexEntry = (EntityIndexEntry)searchResultItem.getIndexEntry();
            Highlight fallback = Highlight.of((IndexField)EStageIndexField.UNKNOWN, (String)indexEntry.getEntityNumber(), (Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
            Highlight rootHighlight = SearchV2RouteImpl.firstHighlight((Object)indexEntry, (Pair)rootFN, (Iterable)highlightParts).orElse(fallback);
            ArrayList buckets = Lists.newArrayList();
            for (Pair detailFN : detailFNs) {
                Optional detailHighlightCandidate = SearchV2RouteImpl.firstHighlight((Object)indexEntry, (Pair)detailFN, (Iterable)highlightParts);
                if (!detailHighlightCandidate.isPresent()) continue;
                Highlight detailHighlight = (Highlight)detailHighlightCandidate.get();
                buckets.add(EntitySearchItemBucket.of((EntityIndexEntry)indexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                break;
            }
            if (buckets.isEmpty()) {
                buckets.add(EntitySearchItemBucket.of((EntityIndexEntry)indexEntry, (String)"", (Highlight)rootHighlight, (Highlight)fallback));
            }
            globalBuckets.addAll(buckets);
        }
        return new PageImpl((List)globalBuckets, (Pageable)PageRequest.of((int)page, (int)size), indexSearchResult.getTotalHits());
    }

    @Nonnull
    private Page<StageSearchItemBucket> stageBuckets(@NonNull StageIndexSearchResult stageIndexSearchResult, @NonNull String query, int page, int size) {
        if (stageIndexSearchResult == null) {
            throw new NullPointerException("stageIndexSearchResult is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List originalParts = Splitter.on((char)' ').splitToList((CharSequence)query);
        Iterable highlightParts = SearchV2RouteImpl.highlightParts((Iterable)originalParts);
        Pair rootFN = Pair.of((Object)EStageIndexField.STAGE__STAGE_NUMBER, StageIndexEntry::getStageNumber);
        ImmutableList detailFNs = ImmutableList.of((Object)Pair.of((Object)EStageIndexField.STAGE__STAGE_NUMBER, StageIndexEntry::getStageNumber), (Object)Pair.of((Object)EStageIndexField.STAGE__STAGE_ALIAS, StageIndexEntry::getStageAlias), (Object)Pair.of((Object)EStageIndexField.STAGE__ENTITY_NUMBER, StageIndexEntry::getEntityNumber), (Object)Pair.of((Object)EStageIndexField.STAGE__ENTITY_ALIAS, StageIndexEntry::getEntityAlias), (Object)Pair.of((Object)EStageIndexField.STAGE__PROJECT__NAME, StageIndexEntry::getProjectName), (Object)Pair.of((Object)EStageIndexField.STAGE__SUBPROJECT__NAME, StageIndexEntry::getSubProjectName), (Object)Pair.of((Object)EStageIndexField.STAGE__CUSTOMER__NAME, StageIndexEntry::getCustomerName), (Object)Pair.of((Object)EStageIndexField.STAGE__ORDER_NUMBER, StageIndexEntry::getOrderNumber), (Object)Pair.of((Object)EStageIndexField.STAGE__ORDER_DESCRIPTION_CUSTOMER, StageIndexEntry::getOrderDescriptionCustomer), (Object)Pair.of((Object)EStageIndexField.STAGE__ORDER_DESCRIPTION_INTERNAL, StageIndexEntry::getOrderDescriptionInternal), (Object)Pair.of((Object)EStageIndexField.STAGE__PROCUREMENT_NUMBER, StageIndexEntry::getProcurementNumber), (Object)Pair.of((Object)EStageIndexField.STAGE__QUOTATION_NUMBER, StageIndexEntry::getQuotationNumber), (Object[])new Pair[0]);
        ArrayList globalBuckets = Lists.newArrayList();
        List stageIndexSearchResultItems = stageIndexSearchResult.getItems();
        for (StageSearchResultItem stageSearchResultItem : stageIndexSearchResultItems) {
            StageIndexEntry stageIndexEntry = (StageIndexEntry)stageSearchResultItem.getIndexEntry();
            Highlight fallback = Highlight.of((IndexField)EStageIndexField.UNKNOWN, (String)stageIndexEntry.getStageNumber(), (Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
            Highlight rootHighlight = SearchV2RouteImpl.firstHighlight((Object)stageIndexEntry, (Pair)rootFN, (Iterable)highlightParts).orElse(fallback);
            ArrayList buckets = Lists.newArrayList();
            for (Pair detailFN : detailFNs) {
                Optional detailHighlightCandidate = SearchV2RouteImpl.firstHighlight((Object)stageIndexEntry, (Pair)detailFN, (Iterable)highlightParts);
                if (!detailHighlightCandidate.isPresent()) continue;
                Highlight detailHighlight = (Highlight)detailHighlightCandidate.get();
                buckets.add(StageSearchItemBucket.of((StageIndexEntry)stageIndexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                break;
            }
            if (buckets.isEmpty()) {
                buckets.add(StageSearchItemBucket.of((StageIndexEntry)stageIndexEntry, (String)"", (Highlight)rootHighlight, (Highlight)fallback));
            }
            globalBuckets.addAll(buckets);
        }
        return new PageImpl((List)globalBuckets, (Pageable)PageRequest.of((int)page, (int)size), stageIndexSearchResult.getTotalHits());
    }

    @Nonnull
    private Page<SubProjectSearchItemBucket> subProjectBuckets(@NonNull SubProjectIndexSearchResult indexSearchResult, @NonNull String query, int page, int size) {
        if (indexSearchResult == null) {
            throw new NullPointerException("indexSearchResult is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List originalParts = Splitter.on((char)' ').splitToList((CharSequence)query);
        Iterable highlightParts = SearchV2RouteImpl.highlightParts((Iterable)originalParts);
        Pair rootFN = Pair.of((Object)ESubProjectIndexField.SUB_PROJECT__NAME, SubProjectIndexEntry::getName);
        ImmutableList detailFNs = ImmutableList.of((Object)Pair.of((Object)ESubProjectIndexField.SUB_PROJECT__NAME, SubProjectIndexEntry::getName), (Object)Pair.of((Object)ESubProjectIndexField.SUB_PROJECT__ENTITY_NUMBER, SubProjectIndexEntry::getEntityNumber), (Object)Pair.of((Object)ESubProjectIndexField.SUB_PROJECT__STAGE_NUMBER, SubProjectIndexEntry::getPrimaryStageNumber));
        ArrayList globalBuckets = Lists.newArrayList();
        List indexSearchResultItems = indexSearchResult.getItems();
        for (SubProjectSearchResultItem searchResultItem : indexSearchResultItems) {
            SubProjectIndexEntry indexEntry = (SubProjectIndexEntry)searchResultItem.getIndexEntry();
            Highlight fallback = Highlight.of((IndexField)EStageIndexField.UNKNOWN, (String)indexEntry.getName(), (Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
            Highlight rootHighlight = SearchV2RouteImpl.firstHighlight((Object)indexEntry, (Pair)rootFN, (Iterable)highlightParts).orElse(fallback);
            ArrayList buckets = Lists.newArrayList();
            for (Pair detailFN : detailFNs) {
                Optional detailHighlightCandidate = SearchV2RouteImpl.firstHighlight((Object)indexEntry, (Pair)detailFN, (Iterable)highlightParts);
                if (!detailHighlightCandidate.isPresent()) continue;
                Highlight detailHighlight = (Highlight)detailHighlightCandidate.get();
                buckets.add(SubProjectSearchItemBucket.of((SubProjectIndexEntry)indexEntry, (String)detailHighlight.getOriginal(), (Highlight)rootHighlight, (Highlight)detailHighlight));
                break;
            }
            if (buckets.isEmpty()) {
                buckets.add(SubProjectSearchItemBucket.of((SubProjectIndexEntry)indexEntry, (String)"", (Highlight)rootHighlight, (Highlight)fallback));
            }
            globalBuckets.addAll(buckets);
        }
        return new PageImpl((List)globalBuckets, (Pageable)PageRequest.of((int)page, (int)size), indexSearchResult.getTotalHits());
    }

    @Nonnull
    static <T> Optional<Highlight> firstHighlight(@NonNull T entity, @NonNull Pair<IndexField, Function<T, String>> fnPair, @NonNull Iterable<String> queryTokens) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (fnPair == null) {
            throw new NullPointerException("fnPair is marked non-null but is null");
        }
        if (queryTokens == null) {
            throw new NullPointerException("queryTokens is marked non-null but is null");
        }
        Iterable highlights = SearchV2RouteImpl.highlight(entity, fnPair, queryTokens);
        if (!Iterables.isEmpty((Iterable)highlights)) {
            Iterable highlightsMerged = SearchV2RouteImpl.merge((Iterable)highlights);
            Highlight highlight = (Highlight)highlightsMerged.iterator().next();
            return Optional.of(highlight);
        }
        return Optional.empty();
    }

    @Nonnull
    static <T> Optional<Highlight> firstHighlight2(@NonNull T entity, @NonNull Pair<IndexField, Function<T, Iterable<String>>> fnPair, @NonNull Iterable<String> queryTokens) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (fnPair == null) {
            throw new NullPointerException("fnPair is marked non-null but is null");
        }
        if (queryTokens == null) {
            throw new NullPointerException("queryTokens is marked non-null but is null");
        }
        Iterable highlights = SearchV2RouteImpl.highlight2(entity, fnPair, queryTokens);
        if (!Iterables.isEmpty((Iterable)highlights)) {
            Iterable highlightsMerged = SearchV2RouteImpl.merge((Iterable)highlights);
            Highlight highlight = (Highlight)highlightsMerged.iterator().next();
            return Optional.of(highlight);
        }
        return Optional.empty();
    }

    @Nonnull
    @VisibleForTesting
    static <T> Iterable<Highlight> highlight(@NonNull T entity, @NonNull Pair<IndexField, Function<T, String>> fnPair, @NonNull Iterable<String> queryTokens) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (fnPair == null) {
            throw new NullPointerException("fnPair is marked non-null but is null");
        }
        if (queryTokens == null) {
            throw new NullPointerException("queryTokens is marked non-null but is null");
        }
        ImmutableList.Builder highlightBuilder = ImmutableList.builder();
        IndexField field = (IndexField)fnPair.getLeft();
        Function fn = (Function)fnPair.getRight();
        String text = (String)fn.apply(entity);
        for (String queryToken : queryTokens) {
            if (StringUtils.length((CharSequence)queryToken) < 2) continue;
            int begin = StringUtils.indexOfIgnoreCase((CharSequence)text, (CharSequence)queryToken);
            int end = begin + queryToken.length();
            if (begin < 0) continue;
            highlightBuilder.add((Object)Highlight.of((IndexField)field, (String)text, (Range)Range.closed((Comparable)Integer.valueOf(begin), (Comparable)Integer.valueOf(end))));
        }
        return highlightBuilder.build();
    }

    @Nonnull
    @VisibleForTesting
    static <T> Iterable<Highlight> highlight2(@NonNull T entity, @NonNull Pair<IndexField, Function<T, Iterable<String>>> fnPair, @NonNull Iterable<String> queryTokens) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (fnPair == null) {
            throw new NullPointerException("fnPair is marked non-null but is null");
        }
        if (queryTokens == null) {
            throw new NullPointerException("queryTokens is marked non-null but is null");
        }
        ImmutableList.Builder highlightBuilder = ImmutableList.builder();
        IndexField field = (IndexField)fnPair.getLeft();
        Function fn = (Function)fnPair.getRight();
        Iterable texts = (Iterable)fn.apply(entity);
        for (String text : texts) {
            for (String queryToken : queryTokens) {
                int begin = StringUtils.indexOfIgnoreCase((CharSequence)text, (CharSequence)queryToken);
                int end = begin + queryToken.length();
                if (begin < 0) continue;
                highlightBuilder.add((Object)Highlight.of((IndexField)field, (String)text, (Range)Range.closed((Comparable)Integer.valueOf(begin), (Comparable)Integer.valueOf(end))));
            }
        }
        return highlightBuilder.build();
    }

    @Nonnull
    private Iterable<ESearchTask> determineSearchTasks(@NonNull Iterable<ESearchTask> searchTasksAsked) {
        if (searchTasksAsked == null) {
            throw new NullPointerException("searchTasksAsked is marked non-null but is null");
        }
        HashSet searchTasksAllowed = Sets.newHashSet();
        if (this.userService.hasPrivilege(EPrivilege.INVOICE__READ)) {
            searchTasksAllowed.add(ESearchTask.INVOICE);
        }
        if (this.userService.hasPrivilege(EPrivilege.VIS_MENU__ADMIN_USER)) {
            searchTasksAllowed.add(ESearchTask.USER);
        }
        if (this.userService.hasPrivilege(EPrivilege.OP_MEASUREMENT_CREATE)) {
            searchTasksAllowed.add(ESearchTask.MEASUREMENT);
        }
        if (this.userService.hasAnyPrivilege(new EPrivilege[]{EPrivilege.VIS_MENU__ADMIN_CUSTOMER, EPrivilege.CRM__READ})) {
            searchTasksAllowed.add(ESearchTask.CUSTOMER);
        }
        if (this.userService.hasPrivilege(EPrivilege.VIS_MENU__Q_OVERVIEW)) {
            searchTasksAllowed.addAll(ImmutableSet.of((Object)ESearchTask.ENTITY, (Object)ESearchTask.STAGE, (Object)ESearchTask.SUB_PROJECT));
        }
        return Sets.intersection((Set)searchTasksAllowed, (Set)ImmutableSet.copyOf(searchTasksAsked));
    }

    @Nonnull
    private Optional<DirectMatch> directMatch(@NonNull Iterable<ESearchTask> searchTasks, @NonNull String query) {
        if (searchTasks == null) {
            throw new NullPointerException("searchTasks is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        boolean isInvoicePattern = Iterables.contains(searchTasks, (Object)ESearchTask.INVOICE) && this.invoicePattern(query);
        boolean isMeasurementPattern = Iterables.contains(searchTasks, (Object)ESearchTask.MEASUREMENT) && this.measurementPattern(query);
        boolean isStageNumberPattern = Iterables.contains(searchTasks, (Object)ESearchTask.STAGE) && this.stageHelperService.stageNumberPattern(query);
        boolean isEntityNumberPattern = Iterables.contains(searchTasks, (Object)ESearchTask.STAGE) && this.stageHelperService.entityNumberPattern(query);
        boolean isCostUnitNumberPattern = Iterables.contains(searchTasks, (Object)ESearchTask.STAGE) && this.stageHelperService.costUnitNumberPattern(query);
        log.info("DirectMatch Q: {}; isInvoicePattern: {}, isMeasurementPattern: {}, isStageNumberPattern: {}, isEntityNumberPattern: {}, isCostUnitNumberPattern: {}", (Object)query, (Object)isInvoicePattern, (Object)isMeasurementPattern, (Object)isStageNumberPattern, (Object)isEntityNumberPattern, (Object)isCostUnitNumberPattern);
        if (isInvoicePattern) {
            String invoiceNumber = query;
            Iterable invoiceNumberPrefixes = InvoiceDefinition.INVOICE_NUMBER_PREFIXES;
            for (String invoiceNumberPrefix : invoiceNumberPrefixes) {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)query, (CharSequence)invoiceNumberPrefix)) continue;
                invoiceNumber = StringUtils.replaceIgnoreCase((String)query, (String)invoiceNumberPrefix, (String)invoiceNumberPrefix);
            }
            Optional invoice = this.invoiceHandler.byInvoiceNumberNotFailing(invoiceNumber);
            return invoice.map(item -> DirectMatch.of((Long)item.getId(), (EEntityClass)EEntityClass.INVOICE, (String)item.getInvoiceNumber()));
        }
        if (isMeasurementPattern) {
            Optional measurement = this.measurementHandler.byMeasurementNumberNotFailing(query);
            return measurement.map(item -> DirectMatch.of((Long)item.getId(), (EEntityClass)EEntityClass.MEASUREMENT, (String)item.getMeasurementNumber()));
        }
        if (isEntityNumberPattern || isStageNumberPattern) {
            String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
            Object stageNumber = isEntityNumberPattern ? StringUtils.prependIfMissing((String)StringUtils.upperCase((String)query), (CharSequence)stageOrEntityNumberPrefix, (CharSequence[])new CharSequence[0]) + "0000" : StringUtils.prependIfMissing((String)StringUtils.upperCase((String)query), (CharSequence)stageOrEntityNumberPrefix, (CharSequence[])new CharSequence[0]);
            Optional stage = this.stageHandler.byStageNumberNotFailing((String)stageNumber);
            return stage.map(item -> DirectMatch.of((Long)item.getId(), (EEntityClass)EEntityClass.STAGE, (String)item.getQNumber()));
        }
        if (isCostUnitNumberPattern) {
            String costUnitNumberPattern = this.ensurePattern(query);
            Optional stage = this.stageHandler.byQuotationNumberNotFailing(costUnitNumberPattern, Long.valueOf(0L));
            return stage.map(item -> DirectMatch.of((Long)item.getId(), (EEntityClass)EEntityClass.STAGE, (String)item.getQNumber()));
        }
        return Optional.empty();
    }

    @Nonnull
    private String ensurePattern(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        int length = StringUtils.length((CharSequence)query);
        if (length == 8 && !StringUtils.contains((CharSequence)query, (CharSequence)"/")) {
            return Strings.left((String)query, (int)2) + "/" + StringUtils.substring((String)query, (int)2, (int)5) + "/" + StringUtils.right((String)query, (int)3);
        }
        return query;
    }

    private boolean measurementPattern(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return MEASUREMENT_NUMBER_PATTERN.matcher(query).matches();
    }

    private boolean invoicePattern(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        int length = StringUtils.length((CharSequence)query);
        return (length == 9 || length == 10) && INVOICE_NUMBER_MATCHER.matcher(StringUtils.lowerCase((String)query)).matches();
    }

    @Nonnull
    @VisibleForTesting
    static Iterable<Highlight> merge(@NonNull Iterable<Highlight> allHighLights) {
        if (allHighLights == null) {
            throw new NullPointerException("allHighLights is marked non-null but is null");
        }
        if (Iterables.size(allHighLights) < 2) {
            return allHighLights;
        }
        Iterable sortedUniqueRanges = (Iterable)StreamSupport.stream(allHighLights.spliterator(), false).sorted((l, r) -> Comparator.naturalOrder().compare((Integer)l.getRange().lowerEndpoint(), (Integer)r.getRange().lowerEndpoint())).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder rangeBuilder = ImmutableList.builder();
        Highlight referenceHighLight = null;
        Range referenceRange = null;
        for (Highlight highlight : sortedUniqueRanges) {
            boolean noGap;
            Range range = highlight.getRange();
            if (null == referenceRange) {
                referenceRange = range;
                referenceHighLight = highlight;
                continue;
            }
            boolean isConnected = range.isConnected(referenceRange);
            if (isConnected) {
                referenceRange = referenceRange.span(range);
                continue;
            }
            Range gap = range.gap(referenceRange);
            boolean bl = noGap = gap.isEmpty() || 1 + (Integer)gap.lowerEndpoint() == (Integer)gap.upperEndpoint();
            if (noGap) {
                referenceRange = referenceRange.span(range);
                continue;
            }
            Highlight mergedHighLight = Highlight.of((IndexField)highlight.getField(), (String)highlight.getOriginal(), (Range)referenceRange);
            rangeBuilder.add((Object)mergedHighLight);
            referenceRange = range;
            referenceHighLight = highlight;
        }
        if (null != referenceHighLight) {
            rangeBuilder.add(referenceHighLight);
        }
        return rangeBuilder.build();
    }

    public SearchV2RouteImpl(ApplicationConfig applicationConfig, ConfigService configService, UserService userService, MeasurementHandler measurementHandler, CustomerIndexSearchService customerIndexSearchService, MeasurementIndexSearchService measurementIndexSearchService, EntityIndexSearchService entityIndexSearchService, InvoiceIndexSearchService invoiceIndexSearchService, StageIndexSearchService stageIndexSearchService, SubProjectIndexSearchService subProjectIndexSearchService, UserIndexSearchService userIndexSearchService, InvoiceHandler invoiceHandler, StageHandler stageHandler, CustomerMapper customerMapper, QEntityMapper entityMapper, MeasurementMapper measurementMapper, InvoiceMapper invoiceMapper, QuotationMapper quotationMapper, SubProjectMapper subProjectMapper, UserMapper userMapper, StageHelperService stageHelperService) {
        this.applicationConfig = applicationConfig;
        this.configService = configService;
        this.userService = userService;
        this.measurementHandler = measurementHandler;
        this.customerIndexSearchService = customerIndexSearchService;
        this.measurementIndexSearchService = measurementIndexSearchService;
        this.entityIndexSearchService = entityIndexSearchService;
        this.invoiceIndexSearchService = invoiceIndexSearchService;
        this.stageIndexSearchService = stageIndexSearchService;
        this.subProjectIndexSearchService = subProjectIndexSearchService;
        this.userIndexSearchService = userIndexSearchService;
        this.invoiceHandler = invoiceHandler;
        this.stageHandler = stageHandler;
        this.customerMapper = customerMapper;
        this.entityMapper = entityMapper;
        this.measurementMapper = measurementMapper;
        this.invoiceMapper = invoiceMapper;
        this.quotationMapper = quotationMapper;
        this.subProjectMapper = subProjectMapper;
        this.userMapper = userMapper;
        this.stageHelperService = stageHelperService;
    }
}

