/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.request.releaseorder.ReleaseOrderSyncRequest;
import de.qfm.erp.common.response.measurement.ReleaseOrderCommon;
import de.qfm.erp.common.response.measurement.ReleaseOrdersCommon;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.ReleaseOrderSyncBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.PssHandler;
import de.qfm.erp.service.service.handler.ReleaseOrderHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.ReleaseOrderMapper;
import de.qfm.erp.service.service.route.ReleaseOrderRoute;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReleaseOrderRouteImpl
implements ReleaseOrderRoute {
    private final EntityFactory entityFactory;
    private final MeasurementHandler measurementHandler;
    private final StageHandler quotationService;
    private final UserHandler userService;
    private final PssHandler pssService;
    private final ReleaseOrderHandler releaseOrderHandler;
    private final ReleaseOrderMapper releaseOrderMapper;

    @Transactional(readOnly=true)
    @Nonnull
    public ReleaseOrdersCommon listByQuotationAndSquad(@Nullable Long quotationId, @Nullable Long userId, int page, int size) {
        Page releaseOrders;
        if (null == quotationId && null == userId) {
            releaseOrders = this.releaseOrderHandler.list(page, size);
        } else if (null != quotationId && null == userId) {
            Quotation quotation = (Quotation)this.quotationService.byIdFailing(quotationId);
            releaseOrders = this.releaseOrderHandler.listByQuotation(quotation, page, size);
        } else if (null == quotationId && null != userId) {
            User user = (User)this.userService.byIdFailing(userId);
            releaseOrders = this.releaseOrderHandler.listBySquad(user, page, size);
        } else {
            Quotation quotation = (Quotation)this.quotationService.byIdFailing(quotationId);
            User user = (User)this.userService.byIdFailing(userId);
            releaseOrders = this.releaseOrderHandler.listByQuotationAndSquad(quotation, user, page, size);
        }
        return this.releaseOrderMapper.map(releaseOrders);
    }

    @Nonnull
    @Transactional
    public ReleaseOrderCommon create(@NonNull ReleaseOrderSyncRequest releaseOrderSyncRequest) {
        if (releaseOrderSyncRequest == null) {
            throw new NullPointerException("releaseOrderSyncRequest is marked non-null but is null");
        }
        String referenceId = releaseOrderSyncRequest.getReferenceId();
        Optional releaseOrderPresent = this.releaseOrderHandler.byReferenceIdNotFailing(referenceId);
        if (releaseOrderPresent.isPresent()) {
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REFERENCE_ID), (Object)referenceId, String.format("The Release Order Reference Id: %s already exists", referenceId), Message.of((EMessageKey)EMessageKey.DUPLICATE_RELEASE_ORDER_REFERENCE_ID, (String)referenceId));
        }
        ReleaseOrderSyncBucket bucket = this.bucket(referenceId, releaseOrderSyncRequest, this.entityFactory.releaseOrder());
        ReleaseOrder releaseOrderMerged = this.releaseOrderMapper.merge(bucket);
        return this.releaseOrderMapper.map((ReleaseOrder)this.releaseOrderHandler.update((EntityBase)releaseOrderMerged));
    }

    @Nonnull
    @Transactional
    public ReleaseOrderCommon update(@NonNull String referenceId, @NonNull ReleaseOrderSyncRequest releaseOrderSyncRequest) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        if (releaseOrderSyncRequest == null) {
            throw new NullPointerException("releaseOrderSyncRequest is marked non-null but is null");
        }
        ReleaseOrder releaseOrder = this.releaseOrderHandler.byReferenceIdFailing(referenceId);
        ReleaseOrderSyncBucket bucket = this.bucket(referenceId, releaseOrderSyncRequest, releaseOrder);
        ReleaseOrder releaseOrderMerged = this.releaseOrderMapper.merge(bucket);
        return this.releaseOrderMapper.map((ReleaseOrder)this.releaseOrderHandler.update((EntityBase)releaseOrderMerged));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public ReleaseOrderCommon byReferenceId(@NonNull String refId) {
        if (refId == null) {
            throw new NullPointerException("refId is marked non-null but is null");
        }
        return this.releaseOrderMapper.map(this.releaseOrderHandler.byReferenceIdFailing(refId));
    }

    @Nonnull
    private ReleaseOrderSyncBucket bucket(@NonNull String referenceId, @NonNull ReleaseOrderSyncRequest releaseOrderSyncRequest, @NonNull ReleaseOrder releaseOrder) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        if (releaseOrderSyncRequest == null) {
            throw new NullPointerException("releaseOrderSyncRequest is marked non-null but is null");
        }
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        String measurementReferenceId = releaseOrderSyncRequest.getMeasurementReferenceId();
        String quotationReferenceId = releaseOrderSyncRequest.getQuotationReferenceId();
        String pssReleaseOrderReferenceId = releaseOrderSyncRequest.getPssReleaseOrderReferenceId();
        Measurement measurement = this.measurementHandler.byReferenceIdFailing(measurementReferenceId);
        Quotation quotation = this.quotationService.byReferenceIdFailing(quotationReferenceId);
        Optional<Object> pssReleaseOrder = StringUtils.isNotBlank((CharSequence)pssReleaseOrderReferenceId) ? Optional.of(this.pssService.byReferenceIdFailing(pssReleaseOrderReferenceId)) : Optional.empty();
        String name = releaseOrderSyncRequest.getName();
        String orderNumber = releaseOrderSyncRequest.getOrderNumber();
        return ReleaseOrderSyncBucket.of((String)referenceId, (ReleaseOrder)releaseOrder, (Measurement)measurement, (Quotation)quotation, (String)orderNumber, (String)name, (PssReleaseOrder)pssReleaseOrder.orElse(null));
    }

    public ReleaseOrderRouteImpl(EntityFactory entityFactory, MeasurementHandler measurementHandler, StageHandler quotationService, UserHandler userService, PssHandler pssService, ReleaseOrderHandler releaseOrderHandler, ReleaseOrderMapper releaseOrderMapper) {
        this.entityFactory = entityFactory;
        this.measurementHandler = measurementHandler;
        this.quotationService = quotationService;
        this.userService = userService;
        this.pssService = pssService;
        this.releaseOrderHandler = releaseOrderHandler;
        this.releaseOrderMapper = releaseOrderMapper;
    }
}

