/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemGroupListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemListCommon;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.EExportFileName;
import de.qfm.erp.service.model.internal.payroll.EPayrollItemClazzFilterOption;
import de.qfm.erp.service.model.internal.payroll.EPayrollItemFilterOption;
import de.qfm.erp.service.model.internal.payroll.EPayrollItemXlsTemplate;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthItemGroupCC;
import de.qfm.erp.service.model.internal.payroll.SalesRevenueGroup;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.PayrollMonthItemHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.PayrollMonthItemMapper;
import de.qfm.erp.service.service.route.PayrollMonthItemRoute;
import de.qfm.erp.service.service.route.impl.PayrollMonthItemRouteImpl;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.SalesRevenueXlsExportService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PayrollMonthItemRouteImpl
implements PayrollMonthItemRoute {
    private static final Logger log = LogManager.getLogger(PayrollMonthItemRouteImpl.class);
    private static final DateTimeFormatter YEAR_MONTH_YYYY_MM_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final int MAX_PAYROLL_ITEMS_COUNT = 10000;
    private final PayrollMonthItemHandler handler;
    private final UserHandler userHandler;
    private final PayrollMonthItemMapper mapper;
    private final SalesRevenueXlsExportService salesRevenueXlsService;
    private final MessageService messageService;
    private final DateTimeHelperService dateTimeHelperService;

    @Transactional(readOnly=true)
    @Nonnull
    public PayrollMonthItemListCommon list(@NonNull LocalDate referenceDate, @NonNull String costCenterCandidate, @NonNull String payrollItemFilterOptionCandidate, @NonNull String payrollItemClazzOptionCandidate, int page, int size) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (costCenterCandidate == null) {
            throw new NullPointerException("costCenterCandidate is marked non-null but is null");
        }
        if (payrollItemFilterOptionCandidate == null) {
            throw new NullPointerException("payrollItemFilterOptionCandidate is marked non-null but is null");
        }
        if (payrollItemClazzOptionCandidate == null) {
            throw new NullPointerException("payrollItemClazzOptionCandidate is marked non-null but is null");
        }
        YearMonth accountingMonth = YearMonth.from(referenceDate);
        EPayrollItemFilterOption payrollItemFilterOption = EPayrollItemFilterOption.lookupFailing((String)payrollItemFilterOptionCandidate);
        EPayrollItemClazzFilterOption payrollItemClazzFilterOption = EPayrollItemClazzFilterOption.lookupFailing((String)payrollItemClazzOptionCandidate);
        CostCenterFilter costCenter = CostCenterFilter.from((String)costCenterCandidate);
        Iterable payrollMonthItemsWithPM = this.allRelevantPayrollMonthItems(accountingMonth, costCenter, payrollItemFilterOption, payrollItemClazzFilterOption, page, size);
        if (EPayrollItemFilterOption.SENDER_IN_CHILD_BUSINESS_UNIT_AND_RECIPIENT_IN_UNEQUAL_CHILD_BUSINESS_UNIT == payrollItemFilterOption) {
            Set senders = (Set)Streams.stream((Iterable)payrollMonthItemsWithPM).map(PayrollMonthItem::getSender).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Set recipients = (Set)Streams.stream((Iterable)payrollMonthItemsWithPM).map(PayrollMonthItem::getRecipient).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Sets.SetView allUsers = Sets.union((Set)recipients, (Set)senders);
            Map allUsersById = MapsHelper.mapFirst((Iterable)allUsers, User::getId);
            Map costCentersByUserId = this.determineCostCenters(accountingMonth, allUsersById);
            Predicate filter = this.filterUnequalChildBusinessUnits(costCenter, costCentersByUserId);
            ImmutableList payrollMonthItemsWithFilterApplied = (ImmutableList)Streams.stream((Iterable)payrollMonthItemsWithPM).filter(filter).collect(ImmutableList.toImmutableList());
            return this.mapper.mapPayrollMonthItems((Iterable)payrollMonthItemsWithFilterApplied, x -> true);
        }
        return this.mapper.mapPayrollMonthItems(payrollMonthItemsWithPM, x -> true);
    }

    @Nonnull
    public PayrollMonthItemGroupListCommon aggregatedList(@NonNull LocalDate referenceDate, @NonNull String costCenterCandidate, @NonNull String payrollItemFilterOptionCandidate, @NonNull String payrollItemClazzOptionCandidate, int page, int size) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (costCenterCandidate == null) {
            throw new NullPointerException("costCenterCandidate is marked non-null but is null");
        }
        if (payrollItemFilterOptionCandidate == null) {
            throw new NullPointerException("payrollItemFilterOptionCandidate is marked non-null but is null");
        }
        if (payrollItemClazzOptionCandidate == null) {
            throw new NullPointerException("payrollItemClazzOptionCandidate is marked non-null but is null");
        }
        YearMonth accountingMonth = YearMonth.from(referenceDate);
        EPayrollItemFilterOption payrollItemFilterOption = EPayrollItemFilterOption.lookupFailing((String)payrollItemFilterOptionCandidate);
        EPayrollItemClazzFilterOption payrollItemClazzFilterOption = EPayrollItemClazzFilterOption.lookupFailing((String)payrollItemClazzOptionCandidate);
        CostCenterFilter costCenter = CostCenterFilter.from((String)costCenterCandidate);
        Iterable payrollMonthItemGroups = this.aggregatedList(page, size, accountingMonth, payrollItemFilterOption, payrollItemClazzFilterOption, costCenter);
        return this.mapper.mapPayrollMonthItemGroupsCC(payrollMonthItemGroups);
    }

    @Nonnull
    private Map<Long, String> determineCostCenters(@NonNull YearMonth accountingMonth, @NonNull Map<Long, User> allUsersById) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (allUsersById == null) {
            throw new NullPointerException("allUsersById is marked non-null but is null");
        }
        LocalDate referenceDate = accountingMonth.atDay(1);
        ImmutableMap.Builder costCenterBuilder = ImmutableMap.builder();
        for (Map.Entry<Long, User> entry : allUsersById.entrySet()) {
            Long userId = entry.getKey();
            User user = entry.getValue();
            EmployeeHelper.currentCostCenterNotFailing((User)user, (LocalDate)referenceDate).ifPresent(item -> costCenterBuilder.put((Object)userId, item));
        }
        return costCenterBuilder.build();
    }

    @Nonnull
    private Iterable<PayrollMonthItemGroupCC> groupByRecipient(@NonNull Map<Long, String> costCenterByUserId, @NonNull Iterable<PayrollMonthItem> allPayrollMonthItems) {
        if (costCenterByUserId == null) {
            throw new NullPointerException("costCenterByUserId is marked non-null but is null");
        }
        if (allPayrollMonthItems == null) {
            throw new NullPointerException("allPayrollMonthItems is marked non-null but is null");
        }
        ImmutableList allRecipients = (ImmutableList)Streams.stream(allPayrollMonthItems).map(PayrollMonthItem::getRecipient).collect(ImmutableList.toImmutableList());
        Map recipientById = MapsHelper.mapFirst((Iterable)allRecipients, User::getId);
        Multimap payrollMonthItemsByUserId = MapsHelper.map(allPayrollMonthItems, item -> item.getRecipient().getId(), item -> item);
        Set recipientsUserIds = payrollMonthItemsByUserId.keySet();
        ImmutableList.Builder payrollMonthItemGroupBuilder = ImmutableList.builder();
        for (Long recipientUserId : recipientsUserIds) {
            User recipient = (User)recipientById.get(recipientUserId);
            String recipientCostCenter = costCenterByUserId.getOrDefault(recipientUserId, null);
            Collection payrollMonthItemsForUser = payrollMonthItemsByUserId.get((Object)recipientUserId);
            BigDecimal sum = Streams.stream((Iterable)payrollMonthItemsForUser).map(PayrollMonthItem::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            Iterable children = this.ungrouped(costCenterByUserId, (Iterable)payrollMonthItemsForUser);
            PayrollMonthItemGroupCC payrollMonthItemGroupCC = PayrollMonthItemGroupCC.of(null, null, (User)recipient, (String)recipientCostCenter, (EPayrollItemClazz)EPayrollItemClazz.INCENTIVE_PAYMENT, (BigDecimal)sum, (String)"", (String)"", (Iterable)children);
            payrollMonthItemGroupBuilder.add((Object)payrollMonthItemGroupCC);
        }
        return payrollMonthItemGroupBuilder.build();
    }

    @Nonnull
    private Iterable<PayrollMonthItemGroupCC> ungrouped(@NonNull Map<Long, String> costCenterByUserId, @NonNull Iterable<PayrollMonthItem> payrollMonthItemsWithPM) {
        if (costCenterByUserId == null) {
            throw new NullPointerException("costCenterByUserId is marked non-null but is null");
        }
        if (payrollMonthItemsWithPM == null) {
            throw new NullPointerException("payrollMonthItemsWithPM is marked non-null but is null");
        }
        ImmutableList.Builder payrollMonthItemGroupBuilder = ImmutableList.builder();
        for (PayrollMonthItem payrollMonthItem : payrollMonthItemsWithPM) {
            User recipient = payrollMonthItem.getRecipient();
            User sender = payrollMonthItem.getSender();
            BigDecimal value = payrollMonthItem.getValue();
            String quotationNumber = StringUtils.trimToEmpty((String)payrollMonthItem.getQuotationNumber());
            String remarks = StringUtils.trimToEmpty((String)payrollMonthItem.getRemarks());
            String recipientCostCenter = costCenterByUserId.getOrDefault(recipient.getId(), null);
            String senderCostCenter = costCenterByUserId.getOrDefault(sender.getId(), null);
            PayrollMonthItemGroupCC child = PayrollMonthItemGroupCC.of((User)sender, (String)senderCostCenter, (User)recipient, (String)recipientCostCenter, (EPayrollItemClazz)EPayrollItemClazz.INCENTIVE_PAYMENT, (BigDecimal)value, (String)quotationNumber, (String)remarks, (Iterable)ImmutableList.of());
            PayrollMonthItemGroupCC parent = PayrollMonthItemGroupCC.of((User)sender, (String)senderCostCenter, (User)recipient, (String)recipientCostCenter, (EPayrollItemClazz)EPayrollItemClazz.INCENTIVE_PAYMENT, (BigDecimal)value, (String)quotationNumber, (String)remarks, (Iterable)ImmutableList.of((Object)child));
            payrollMonthItemGroupBuilder.add((Object)parent);
        }
        return payrollMonthItemGroupBuilder.build();
    }

    @Nonnull
    public Pair<String, byte[]> detailXLS(@NonNull LocalDate referenceDate, @NonNull String senderCostCenterCandidate, @NonNull String recipientCostCenterCandidate, @NonNull String payrollItemClazzOptionCandidate, @NonNull String templateCandidate) throws IOException {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (senderCostCenterCandidate == null) {
            throw new NullPointerException("senderCostCenterCandidate is marked non-null but is null");
        }
        if (recipientCostCenterCandidate == null) {
            throw new NullPointerException("recipientCostCenterCandidate is marked non-null but is null");
        }
        if (payrollItemClazzOptionCandidate == null) {
            throw new NullPointerException("payrollItemClazzOptionCandidate is marked non-null but is null");
        }
        if (templateCandidate == null) {
            throw new NullPointerException("templateCandidate is marked non-null but is null");
        }
        YearMonth accountingMonth = YearMonth.from(referenceDate);
        EPayrollItemXlsTemplate template = EPayrollItemXlsTemplate.lookupFailing((String)templateCandidate);
        EPayrollItemClazzFilterOption payrollItemClazzFilterOption = EPayrollItemClazzFilterOption.lookupFailing((String)payrollItemClazzOptionCandidate);
        String sheetName = this.messageService.getDE((Translatable)template, new Object[0]);
        String senderCC = StringUtils.trimToEmpty((String)senderCostCenterCandidate);
        String recipientCC = StringUtils.trimToEmpty((String)recipientCostCenterCandidate);
        CostCenterFilter senderCostCenter = CostCenterFilter.from((String)senderCC);
        CostCenterFilter recipientCostCenter = CostCenterFilter.from((String)recipientCC);
        Iterable senderBuUsers = this.userHandler.usersInCostCenter(senderCostCenter, referenceDate);
        Iterable recipientBuUsers = this.userHandler.usersInCostCenter(recipientCostCenter, referenceDate);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Page payrollMonthItems = this.handler.payrollMonthItemPage(0, 10000, accountingMonth, senderBuUsers, recipientBuUsers, EPayrollItemFilterOption.SENDER_IN_AND_RECIPIENT_IN_BUSINESS_UNIT, payrollItemClazzFilterOption);
        switch (1.$SwitchMap$de$qfm$erp$service$model$internal$payroll$EPayrollItemXlsTemplate[template.ordinal()]) {
            case 1: 
            case 2: {
                this.salesRevenueXlsService.detailXLS(accountingMonth, (Iterable)payrollMonthItems, senderCC, recipientCC, sheetName).write((OutputStream)byteArrayOutputStream);
                break;
            }
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        String fileName = this.messageService.getDE((Translatable)EExportFileName.SALES_REVENUE_CORRECTION_DETAIL, new Object[]{this.dateTimeHelperService.timeStampForFile()});
        return Pair.of((Object)fileName, (Object)bytes);
    }

    @Nonnull
    public Pair<String, byte[]> aggregatedXLS(@NonNull LocalDate referenceDate, @NonNull String costCenterCandidate, @NonNull String payrollItemFilterOptionCandidate, @NonNull String payrollItemClazzOptionCandidate, @NonNull String templateCandidate) throws IOException {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (costCenterCandidate == null) {
            throw new NullPointerException("costCenterCandidate is marked non-null but is null");
        }
        if (payrollItemFilterOptionCandidate == null) {
            throw new NullPointerException("payrollItemFilterOptionCandidate is marked non-null but is null");
        }
        if (payrollItemClazzOptionCandidate == null) {
            throw new NullPointerException("payrollItemClazzOptionCandidate is marked non-null but is null");
        }
        if (templateCandidate == null) {
            throw new NullPointerException("templateCandidate is marked non-null but is null");
        }
        YearMonth accountingMonth = YearMonth.from(referenceDate);
        EPayrollItemFilterOption payrollItemFilterOption = EPayrollItemFilterOption.lookupFailing((String)payrollItemFilterOptionCandidate);
        EPayrollItemClazzFilterOption payrollItemClazzFilterOption = EPayrollItemClazzFilterOption.lookupFailing((String)payrollItemClazzOptionCandidate);
        CostCenterFilter costCenter = CostCenterFilter.from((String)costCenterCandidate);
        Iterable payrollMonthItemGroups = this.aggregatedList(0, 10000, accountingMonth, payrollItemFilterOption, payrollItemClazzFilterOption, costCenter);
        EPayrollItemXlsTemplate template = EPayrollItemXlsTemplate.lookupFailing((String)templateCandidate);
        String sheetName = this.messageService.getDE((Translatable)template, new Object[0]);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (1.$SwitchMap$de$qfm$erp$service$model$internal$payroll$EPayrollItemXlsTemplate[template.ordinal()]) {
            case 3: {
                Map groupedPayrollMonthItems = PayrollMonthItemRouteImpl.group((Iterable)payrollMonthItemGroups, (LocalDate)referenceDate);
                this.salesRevenueXlsService.groupedXLS(accountingMonth, groupedPayrollMonthItems, sheetName).write((OutputStream)byteArrayOutputStream);
                break;
            }
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        String fileName = this.messageService.getDE((Translatable)EExportFileName.SALES_REVENUE_CORRECTION_GROUPED, new Object[]{this.dateTimeHelperService.timeStampForFile()});
        return Pair.of((Object)fileName, (Object)bytes);
    }

    @Nonnull
    static Map<SalesRevenueGroup, BigDecimal> group(@NonNull Iterable<PayrollMonthItemGroupCC> payrollMonthItemGroupCCs, @NonNull LocalDate referenceDate) {
        if (payrollMonthItemGroupCCs == null) {
            throw new NullPointerException("payrollMonthItemGroupCCs is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        HashMap grouped = Maps.newHashMap();
        for (PayrollMonthItemGroupCC payrollMonthItem : payrollMonthItemGroupCCs) {
            String quotationNumber = payrollMonthItem.getQuotationNumber();
            User sender = payrollMonthItem.getSender();
            User recipient = payrollMonthItem.getRecipient();
            BigDecimal value = payrollMonthItem.getValue();
            String senderName = StringUtils.trimToEmpty((String)sender.getFullName());
            String recipientName = StringUtils.trimToEmpty((String)recipient.getFullName());
            String senderCC = EmployeeHelper.currentCostCenterFailing((User)sender, (LocalDate)referenceDate);
            String recipientCC = EmployeeHelper.currentCostCenterFailing((User)recipient, (LocalDate)referenceDate);
            SalesRevenueGroup salesRevenueGroup = SalesRevenueGroup.of((String)senderCC, (String)senderName, (String)recipientCC, (String)recipientName, (String)quotationNumber);
            BigDecimal groupedValue = grouped.getOrDefault(salesRevenueGroup, BigDecimal.ZERO);
            grouped.put(salesRevenueGroup, groupedValue.add(value));
        }
        return ImmutableMap.copyOf((Map)grouped);
    }

    @Nonnull
    public Pair<String, byte[]> xlsAsZip(@NonNull LocalDate referenceDate, @NonNull String senderCostCenterCandidate, @NonNull String recipientCostCenterCandidate, @NonNull String payrollItemClazzOptionCandidate, @NonNull String payrollItemFilterOptionCandidate, @NonNull String templateCandidate) throws IOException {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (senderCostCenterCandidate == null) {
            throw new NullPointerException("senderCostCenterCandidate is marked non-null but is null");
        }
        if (recipientCostCenterCandidate == null) {
            throw new NullPointerException("recipientCostCenterCandidate is marked non-null but is null");
        }
        if (payrollItemClazzOptionCandidate == null) {
            throw new NullPointerException("payrollItemClazzOptionCandidate is marked non-null but is null");
        }
        if (payrollItemFilterOptionCandidate == null) {
            throw new NullPointerException("payrollItemFilterOptionCandidate is marked non-null but is null");
        }
        if (templateCandidate == null) {
            throw new NullPointerException("templateCandidate is marked non-null but is null");
        }
        YearMonth accountingMonth = YearMonth.from(referenceDate);
        LocalDate accountingMonth1st = accountingMonth.atDay(1);
        EPayrollItemXlsTemplate template = EPayrollItemXlsTemplate.lookupFailing((String)templateCandidate);
        EPayrollItemClazzFilterOption payrollItemClazzFilterOption = EPayrollItemClazzFilterOption.lookupFailing((String)payrollItemClazzOptionCandidate);
        EPayrollItemFilterOption payrollItemFilterOption = EPayrollItemFilterOption.lookupFailing((String)payrollItemFilterOptionCandidate);
        String sheetName = this.messageService.getDE((Translatable)template, new Object[0]);
        CostCenterFilter senderCostCenter = CostCenterFilter.from((String)senderCostCenterCandidate);
        CostCenterFilter recipientCostCenter = CostCenterFilter.from((String)recipientCostCenterCandidate);
        Iterable senderBuUsers = this.userHandler.usersInCostCenter(senderCostCenter, referenceDate);
        Iterable recipientBuUsers = this.userHandler.usersInCostCenter(recipientCostCenter, referenceDate);
        Page payrollMonthItems = this.handler.payrollMonthItemPage(0, 1000, accountingMonth, senderBuUsers, recipientBuUsers, payrollItemFilterOption, payrollItemClazzFilterOption);
        ArrayListMultimap payrollMonthItemsByFromTo = ArrayListMultimap.create();
        for (PayrollMonthItem payrollMonthItem : payrollMonthItems) {
            String recipientCC;
            String senderCC;
            User sender = payrollMonthItem.getSender();
            User recipient = payrollMonthItem.getRecipient();
            Optional optional = EmployeeHelper.currentCostCenterNotFailing((User)sender, (LocalDate)accountingMonth1st);
            Optional recipientCCCandidate = EmployeeHelper.currentCostCenterNotFailing((User)recipient, (LocalDate)accountingMonth1st);
            if (!optional.isPresent() || !recipientCCCandidate.isPresent() || Objects.equals(senderCC = (String)optional.get(), recipientCC = (String)recipientCCCandidate.get())) continue;
            payrollMonthItemsByFromTo.put((Object)Pair.of((Object)senderCC, (Object)recipientCC), (Object)payrollMonthItem);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bos);
        String fileTimeStamp = YEAR_MONTH_YYYY_MM_FORMAT.format(accountingMonth);
        for (Map.Entry entry : payrollMonthItemsByFromTo.asMap().entrySet()) {
            Pair ccPair = (Pair)entry.getKey();
            Collection value = (Collection)entry.getValue();
            String senderCC = (String)ccPair.getLeft();
            String recipientCC = (String)ccPair.getRight();
            SXSSFWorkbook xls = this.salesRevenueXlsService.detailXLS(accountingMonth, (Iterable)value, senderCC, recipientCC, sheetName);
            String fileName = this.messageService.get((Translatable)EExportFileName.SALES_REVENUE_CORRECTION_XLS, new Object[]{fileTimeStamp, sheetName, senderCC, recipientCC});
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xls.write((OutputStream)byteArrayOutputStream);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            zipOut.write(bytes);
        }
        zipOut.close();
        byte[] zipBuffer = bos.toByteArray();
        String string = this.messageService.get((Translatable)EExportFileName.SALES_REVENUE_CORRECTION_ZIP, new Object[]{fileTimeStamp, sheetName});
        return Pair.of((Object)string, (Object)zipBuffer);
    }

    @Nonnull
    private Iterable<PayrollMonthItem> allRelevantPayrollMonthItems(@NonNull YearMonth accountingMonth, @NonNull CostCenterFilter costCenterFilter, @NonNull EPayrollItemFilterOption payrollItemFilterOption, @NonNull EPayrollItemClazzFilterOption payrollItemClazzFilterOption, int page, int size) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        if (payrollItemFilterOption == null) {
            throw new NullPointerException("payrollItemFilterOption is marked non-null but is null");
        }
        if (payrollItemClazzFilterOption == null) {
            throw new NullPointerException("payrollItemClazzFilterOption is marked non-null but is null");
        }
        LocalDate referenceDate = accountingMonth.atDay(1);
        Iterable employeesInBusinessUnit = this.userHandler.usersInCostCenter(costCenterFilter, referenceDate);
        if (!Iterables.isEmpty((Iterable)employeesInBusinessUnit)) {
            Page payrollMonthItemPage = this.handler.payrollMonthItemPage(page, size, accountingMonth, employeesInBusinessUnit, employeesInBusinessUnit, payrollItemFilterOption, payrollItemClazzFilterOption);
            return (Iterable)payrollMonthItemPage.stream().filter(item -> null != item.getPayrollMonth()).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }

    @Nonnull
    private Predicate<PayrollMonthItem> filterUnequalChildBusinessUnits(@NonNull CostCenterFilter costCenterFilter, @NonNull Map<Long, String> costCenterByUserId) {
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        if (costCenterByUserId == null) {
            throw new NullPointerException("costCenterByUserId is marked non-null but is null");
        }
        String costCenter = costCenterFilter.getCostCenter();
        return payrollMonthItem -> {
            User sender = payrollMonthItem.getSender();
            Long senderUserId = sender.getId();
            String senderCostCenter = (String)costCenterByUserId.get(senderUserId);
            User recipient = payrollMonthItem.getRecipient();
            Long recipientUserId = recipient.getId();
            String recipientCostCenter = (String)costCenterByUserId.get(recipientUserId);
            String paddedCostCenter = StringUtils.rightPad((String)costCenter, (int)StringUtils.length((CharSequence)senderCostCenter), (char)'0');
            boolean isDifferentFromRoot = !StringUtils.equalsIgnoreCase((CharSequence)paddedCostCenter, (CharSequence)senderCostCenter);
            boolean isDifferentSenderAndRecipientBusinessUnit = !StringUtils.equalsIgnoreCase((CharSequence)senderCostCenter, (CharSequence)recipientCostCenter);
            return isDifferentFromRoot && isDifferentSenderAndRecipientBusinessUnit;
        };
    }

    @Nonnull
    private Iterable<PayrollMonthItemGroupCC> aggregatedList(int page, int size, YearMonth accountingMonth, EPayrollItemFilterOption payrollItemFilterOption, EPayrollItemClazzFilterOption payrollItemClazzFilterOption, CostCenterFilter costCenter) {
        Iterable payrollMonthItemsWithPM = this.allRelevantPayrollMonthItems(accountingMonth, costCenter, payrollItemFilterOption, payrollItemClazzFilterOption, page, size);
        Set senders = (Set)Streams.stream((Iterable)payrollMonthItemsWithPM).map(PayrollMonthItem::getSender).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Set recipients = (Set)Streams.stream((Iterable)payrollMonthItemsWithPM).map(PayrollMonthItem::getRecipient).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Sets.SetView allUsers = Sets.union((Set)recipients, (Set)senders);
        Map allUsersById = MapsHelper.mapFirst((Iterable)allUsers, User::getId);
        Map costCentersByUserId = this.determineCostCenters(accountingMonth, allUsersById);
        return switch (1.$SwitchMap$de$qfm$erp$service$model$internal$payroll$EPayrollItemFilterOption[payrollItemFilterOption.ordinal()]) {
            case 1, 2, 3, 4 -> this.groupByRecipient(costCentersByUserId, payrollMonthItemsWithPM);
            case 5 -> this.ungrouped(costCentersByUserId, payrollMonthItemsWithPM);
            case 6 -> {
                Predicate filter = this.filterUnequalChildBusinessUnits(costCenter, costCentersByUserId);
                ImmutableList payrollMonthItemsWithFilterApplied = (ImmutableList)Streams.stream((Iterable)payrollMonthItemsWithPM).filter(filter).collect(ImmutableList.toImmutableList());
                yield this.ungrouped(costCentersByUserId, (Iterable)payrollMonthItemsWithFilterApplied);
            }
            default -> ImmutableList.of();
        };
    }

    public PayrollMonthItemRouteImpl(PayrollMonthItemHandler handler, UserHandler userHandler, PayrollMonthItemMapper mapper, SalesRevenueXlsExportService salesRevenueXlsService, MessageService messageService, DateTimeHelperService dateTimeHelperService) {
        this.handler = handler;
        this.userHandler = userHandler;
        this.mapper = mapper;
        this.salesRevenueXlsService = salesRevenueXlsService;
        this.messageService = messageService;
        this.dateTimeHelperService = dateTimeHelperService;
    }
}

