/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.mapper.MeasurementSearchMapper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.route.AbstractSyncable;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

@Service
public class MeasurementSearchRoute
extends AbstractSyncable<Measurement> {
    private static final Logger log = LogManager.getLogger(MeasurementSearchRoute.class);
    private final MeasurementHandler measurementHandler;
    private final MeasurementSearchMapper measurementSearchMapper;
    private final IndexService indexService;

    public MeasurementSearchRoute(@NonNull NodeConfig nodeConfig, @NonNull MeasurementHandler measurementHandler, @NonNull MeasurementSearchMapper measurementSearchMapper, @NonNull IndexService indexService) {
        super(nodeConfig);
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        if (measurementHandler == null) {
            throw new NullPointerException("measurementHandler is marked non-null but is null");
        }
        if (measurementSearchMapper == null) {
            throw new NullPointerException("measurementSearchMapper is marked non-null but is null");
        }
        if (indexService == null) {
            throw new NullPointerException("indexService is marked non-null but is null");
        }
        this.measurementHandler = measurementHandler;
        this.measurementSearchMapper = measurementSearchMapper;
        this.indexService = indexService;
    }

    @Nonnull
    public EIndexEntryType indexEntryType() {
        return EIndexEntryType.MEASUREMENT;
    }

    @Nonnull
    public Iterable<Measurement> refresh(@NonNull Iterable<Measurement> itemStream) {
        if (itemStream == null) {
            throw new NullPointerException("itemStream is marked non-null but is null");
        }
        ImmutableList.Builder entriesUpdatedBuilder = ImmutableList.builder();
        itemStream.forEach(item -> this.refresh(item).ifPresent(arg_0 -> ((ImmutableList.Builder)entriesUpdatedBuilder).add(arg_0)));
        return entriesUpdatedBuilder.build();
    }

    @Nonnull
    public Optional<Measurement> refresh(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        String entryId = measurement.getReferenceId();
        try {
            IndexResult index = this.index(measurement);
            log.debug("Refreshed Entity: {} in Index", (Object)measurement);
            return Optional.of(measurement);
        }
        catch (Exception ioe) {
            log.error("Error Refreshing Index for EntryId: {}, Entry: {}", (Object)entryId, (Object)measurement, (Object)ioe);
            return Optional.empty();
        }
    }

    public boolean dirty() {
        return this.measurementHandler.dirty();
    }

    @Nonnull
    public Iterable<Measurement> streamDirty(int max) {
        return this.measurementHandler.dirtyPage(max);
    }

    @Nonnull
    public Long id(@NonNull Measurement item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getId();
    }

    @Nonnull
    public Iterable<Long> ids(@NonNull Iterable<Measurement> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(Measurement::getId).collect(ImmutableSet.toImmutableSet());
    }

    public void start() {
        log.info("Detected Dirty Entries - refreshing Entries in Index");
    }

    public void finish(@NonNull Iterable<Measurement> itemsProcessed, @NonNull Stopwatch stopwatch) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        if (stopwatch == null) {
            throw new NullPointerException("stopwatch is marked non-null but is null");
        }
        int size = Iterables.size(itemsProcessed);
        long elapsedInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        int markedAsIndexed = this.measurementHandler.markIndexed(itemsProcessed);
        log.info("Finished Refreshing Dirty Entries, amount: {}, took: {} ms", (Object)size, (Object)elapsedInMs);
    }

    @Nonnull
    private Optional<String> delete(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        try {
            String documentId = MeasurementSearchMapper.documentId((EIndexEntryType)this.indexEntryType(), (Long)measurement.getId());
            long indexGeneration = this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EMeasurementIndexField._ID, (String)documentId));
            log.debug("Deleted Entity: {}", (Object)measurement);
            return Optional.of(measurement.getReferenceId());
        }
        catch (IOException e) {
            log.error("Error Deleting Entry from Index, error: {}", (Object)e.getMessage());
            return Optional.of(e.getMessage());
        }
    }

    @Nonnull
    private IndexResult index(@NonNull Measurement measurement) throws IOException {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        IndexDocument indexDocument = this.measurementSearchMapper.mapToDocument(measurement, this.indexEntryType());
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    private Iterable<IndexResult> index(@NonNull Iterable<Measurement> measurements) throws IOException {
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        Iterable indexDocuments = this.measurementSearchMapper.mapToDocument(measurements, this.indexEntryType());
        return this.indexService.updateIndex(indexDocuments);
    }
}

