/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.request.invoice.MeasurementValidationRequest;
import de.qfm.erp.common.request.measurement.MeasurementModificationRequest;
import de.qfm.erp.common.request.measurement.MeasurementPatchRequest;
import de.qfm.erp.common.request.measurement.MeasurementPositionUpdateItem;
import de.qfm.erp.common.request.measurement.MeasurementTransposedRemarkUpdateItem;
import de.qfm.erp.common.request.measurement.MeasurementUpdateRequest;
import de.qfm.erp.common.request.measurement.ReleaseOrderUpdateItem;
import de.qfm.erp.common.response.invoice.MeasurementValidationResponse;
import de.qfm.erp.common.response.measurement.MeasurementAvailableStatesCommon;
import de.qfm.erp.common.response.measurement.MeasurementCommon;
import de.qfm.erp.common.response.measurement.MeasurementDuplicateCheckResponse;
import de.qfm.erp.common.response.measurement.MeasurementImportResultListCommon;
import de.qfm.erp.common.response.measurement.MeasurementNumberExistsResponse;
import de.qfm.erp.common.response.measurement.MeasurementPageCommon;
import de.qfm.erp.common.response.measurement.MeasurementPatchResponse;
import de.qfm.erp.common.response.measurement.MeasurementSearchResultCommon;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.DateRangeHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.FileHelper;
import de.qfm.erp.service.helper.FileStoreHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.helper.PrintOptionHelper;
import de.qfm.erp.service.helper.ProductCalculatorHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionGroupingLevelComparator;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.exception.request.DuplicationException;
import de.qfm.erp.service.model.exception.request.EntityAccessRestrictionException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.exception.response.PDFGenerationException;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.MeasurementMoveBucket;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.ReleaseOrderUpdateBucket;
import de.qfm.erp.service.model.internal.StringSearchFilter;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.csv.ECsvExportType;
import de.qfm.erp.service.model.internal.eventbus.MeasurementChangeMessage;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.gaeb.GaebX31ExportResult;
import de.qfm.erp.service.model.internal.history.MeasurementHistorySnapShot;
import de.qfm.erp.service.model.internal.measurement.AvailableMeasurementStates;
import de.qfm.erp.service.model.internal.measurement.EMeasurementPrintTemplate;
import de.qfm.erp.service.model.internal.measurement.MeasurementChangeBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementFilter;
import de.qfm.erp.service.model.internal.measurement.MeasurementModificationBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionsUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementTransposedRemarkUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementTransposedRemarksUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementXLSImportRow;
import de.qfm.erp.service.model.internal.measurement.MeasurementXlsExtractResult;
import de.qfm.erp.service.model.internal.measurement.MeasurementXlsImportResult;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.EExportFileName;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementGroupedPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPreliminaryStandardPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintBucket;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintGrouped;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintPreliminaryStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintTransposed;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementStandardPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementTransposedPrintConfiguration;
import de.qfm.erp.service.model.internal.quotation.BillOfQuantitiesMeasurementExport;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.CustomerTemplate;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementSheetNumber;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.MeasurementTransposedRemark;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementOrigin;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementStateReason;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementValidationFlag;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementViewType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.measurement.MeasurementCalculators;
import de.qfm.erp.service.service.handler.ConfigurationCompanyHandler;
import de.qfm.erp.service.service.handler.CustomerTemplateHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.MeasurementSheetNumberHandler;
import de.qfm.erp.service.service.handler.PssHandler;
import de.qfm.erp.service.service.handler.QueueService;
import de.qfm.erp.service.service.handler.ReleaseOrderHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.MeasurementMapper;
import de.qfm.erp.service.service.mapper.MeasurementPositionMapper;
import de.qfm.erp.service.service.mapper.MeasurementPrintMapper;
import de.qfm.erp.service.service.mapper.ReleaseOrderMapper;
import de.qfm.erp.service.service.route.HistoryItemRoute;
import de.qfm.erp.service.service.route.MeasurementRoute;
import de.qfm.erp.service.service.route.PdfRoute;
import de.qfm.erp.service.service.route.impl.MeasurementRouteImpl;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.EntityUsageService;
import de.qfm.erp.service.service.service.MeasurementService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.csv.CsvExportService;
import de.qfm.erp.service.service.service.gaeb.GaebD11ExportService;
import de.qfm.erp.service.service.service.gaeb.GaebX31ExportService;
import de.qfm.erp.service.service.service.xls.BillOfQuantitiesMeasurementXlsCluster35ExportService;
import de.qfm.erp.service.service.service.xls.BillOfQuantitiesMeasurementXlsSubContractorExportService;
import de.qfm.erp.service.service.service.xls.CustomerTemplateExportService;
import de.qfm.erp.service.service.service.xls.ECustomerTemplateAlgorithm;
import de.qfm.erp.service.service.service.xls.MeasurementXlsExportService;
import de.qfm.erp.service.service.service.xls.MeasurementXlsImportService;
import de.qfm.erp.service.service.validator.Validator;
import de.qfm.erp.service.service.validator.Validators;
import de.qfm.erp.service.service.validator.measurement.MeasurementUpdateRequestValidator;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MeasurementRouteImpl
implements MeasurementRoute {
    private static final Logger log = LogManager.getLogger(MeasurementRouteImpl.class);
    public static final String BOQ_CLUSTER_35_TEMPLATE_PATH = "/xls/BillOfQuantities_Measurement_XLS_Template_Cluster_3.5.xlsx";
    public static final String BOQ_CLUSTER_35_MEASUREMENT_SHEET_NAME = "Aufma\u00df";
    private static final Joiner IMPORT_ERROR_JOINER = Joiner.on((char)',').skipNulls();
    private static final Joiner POSITION_ID_ERROR_MSG_JOINER = Joiner.on((char)',').skipNulls();
    private static final String MEASUREMENT_NUMBER_DELETED_FORMAT = "%s_DELETED_%s";
    public static final Pair<String, byte[]> EMPTY = Pair.of((Object)"", (Object)new byte[0]);
    public static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    public static final int MAX_SAME_PSS_RO = 10;
    @NonNull
    public static final Consumer<Long> NO_OP = value -> {};
    private final EntityFactory entityFactory;
    private final CompanyConfig companyConfig;
    private final ConfigurationCompanyHandler configurationCompanyHandler;
    private ApplicationEventPublisher applicationEventPublisher;
    private final ApplicationConfig applicationConfig;
    private final BillOfQuantitiesMeasurementXlsCluster35ExportService billOfQuantitiesMeasurementXlsCluster35ExportService;
    private final BillOfQuantitiesMeasurementXlsSubContractorExportService billOfQuantitiesMeasurementXlsSubContractorExportService;
    private final CsvExportService csvExportService;
    private final DateTimeHelperService dateTimeHelperService;
    private final EntityUsageService entityUsageService;
    private final GaebD11ExportService gaebD11ExportService;
    private final GaebX31ExportService gaebX31ExportService;
    private final MeasurementMapper mapper;
    private final MeasurementPositionMapper measurementPositionMapper;
    private final ReleaseOrderMapper releaseOrderMapper;
    private final MeasurementHandler measurementHandler;
    private final MeasurementSheetNumberHandler measurementSheetNumberHandler;
    private final MeasurementService measurementService;
    private final MeasurementXlsExportService measurementXlsExportService;
    private final MeasurementXlsImportService measurementXLSImportService;
    private final StageHandler stageHandler;
    private final MeasurementUpdateRequestValidator measurementUpdateRequestValidator;
    private final Validators validators;
    private final HistoryItemRoute historyItemRoute;
    private final MeasurementPrintMapper measurementPrintMapper;
    private final ReleaseOrderHandler releaseOrderHandler;
    private final PssHandler pssHandler;
    private final QueueService queueService;
    private final UserHandler userHandler;
    private final UserService userService;
    private final CustomerTemplateHandler customerTemplateHandler;
    private final PdfRoute pdfRoute;
    private final MeasurementCalculators measurementCalculators;
    private final MessageService messageService;
    private final List<CustomerTemplateExportService> customerTemplateExportServices;

    @Nonnull
    @Transactional
    public MeasurementCommon byId(long measurementId) {
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(measurementId));
        this.checkCurrentUserIsAllowedToOpen(measurement);
        this.entityUsageService.open(measurement);
        return this.mapper.map(measurement);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public MeasurementCommon byReferenceId(@NonNull String refId) {
        if (refId == null) {
            throw new NullPointerException("refId is marked non-null but is null");
        }
        Measurement measurement = this.measurementHandler.byReferenceIdFailing(refId);
        return this.mapper.map(measurement);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon byMeasurementNumber(@NonNull String measurementNumber) {
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        Measurement measurement = this.measurementHandler.byMeasurementNumberFailing(measurementNumber);
        this.checkCurrentUserIsAllowedToOpen(measurement);
        this.entityUsageService.open(measurement);
        return this.mapper.map(measurement);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public MeasurementPageCommon page(int page, int size, @NonNull String filterText, @Nullable Long filterStageId, @NonNull String filterCostCenter, @NonNull String filterPositionNumber, @Nullable Long filterUserId, @Nullable LocalDate filterProjectExecutionFrom, @Nullable LocalDate filterProjectExecutionTo, @Nullable LocalDate filterAccountingMonth, @NonNull Boolean optionShowOnlyTemporary, @NonNull Boolean optionMyMeasurements, @NonNull Boolean optionRecent, @NonNull Boolean optionIncludeDeleted) {
        ImmutableList filterStages;
        ImmutableList filterUsers;
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (filterCostCenter == null) {
            throw new NullPointerException("filterCostCenter is marked non-null but is null");
        }
        if (filterPositionNumber == null) {
            throw new NullPointerException("filterPositionNumber is marked non-null but is null");
        }
        if (optionShowOnlyTemporary == null) {
            throw new NullPointerException("optionShowOnlyTemporary is marked non-null but is null");
        }
        if (optionMyMeasurements == null) {
            throw new NullPointerException("optionMyMeasurements is marked non-null but is null");
        }
        if (optionRecent == null) {
            throw new NullPointerException("optionRecent is marked non-null but is null");
        }
        if (optionIncludeDeleted == null) {
            throw new NullPointerException("optionIncludeDeleted is marked non-null but is null");
        }
        boolean userEntered = null != filterUserId;
        Object object = filterUsers = userEntered ? this.userHandler.allByIds((Iterable)ImmutableSet.of((Object)filterUserId)) : ImmutableList.of();
        if (userEntered && Iterables.isEmpty((Iterable)filterUsers)) {
            return MeasurementPageCommon.empty();
        }
        boolean quotationNumberEntered = null != filterStageId;
        ImmutableList immutableList = filterStages = quotationNumberEntered ? ImmutableList.of((Object)((Quotation)this.stageHandler.byIdFailing(filterStageId))) : ImmutableList.of();
        if (quotationNumberEntered && Iterables.isEmpty((Iterable)filterStages)) {
            return MeasurementPageCommon.empty();
        }
        Range projectExecutionRange = DateRangeHelper.dateRange((LocalDate)filterProjectExecutionFrom, (LocalDate)filterProjectExecutionTo);
        Page measurementsPage = this.measurementHandler.all(page, size, filterText, filterCostCenter, filterPositionNumber, (Iterable)filterStages, (Iterable)filterUsers, projectExecutionRange, filterAccountingMonth, optionShowOnlyTemporary, optionMyMeasurements, optionIncludeDeleted, optionRecent);
        return this.mapper.map(measurementsPage);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public Pair<String, byte[]> exportToXLS(int page, int size, @NonNull String filterText, @NonNull String filterQuotationNumber, @NonNull String filterCostCenter, @NonNull String filterPositionNumber, @Nullable Long filterEntityId, @Nullable Long filterStageId, @Nullable Long filterProjectId, @Nullable Long filterUserId, @Nullable LocalDate filterProjectExecutionFrom, @Nullable LocalDate filterProjectExecutionTo, @Nullable LocalDate filterAccountingMonth, @NonNull Boolean optionShowOnlyTemporary, @NonNull Boolean optionMyMeasurements, @NonNull Boolean optionRecent, @NonNull Boolean optionIncludeDeleted, @NonNull Boolean optionLastViewed) throws IOException {
        Range recentDateRange;
        ImmutableSet relevantMeasurementStates;
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (filterQuotationNumber == null) {
            throw new NullPointerException("filterQuotationNumber is marked non-null but is null");
        }
        if (filterCostCenter == null) {
            throw new NullPointerException("filterCostCenter is marked non-null but is null");
        }
        if (filterPositionNumber == null) {
            throw new NullPointerException("filterPositionNumber is marked non-null but is null");
        }
        if (optionShowOnlyTemporary == null) {
            throw new NullPointerException("optionShowOnlyTemporary is marked non-null but is null");
        }
        if (optionMyMeasurements == null) {
            throw new NullPointerException("optionMyMeasurements is marked non-null but is null");
        }
        if (optionRecent == null) {
            throw new NullPointerException("optionRecent is marked non-null but is null");
        }
        if (optionIncludeDeleted == null) {
            throw new NullPointerException("optionIncludeDeleted is marked non-null but is null");
        }
        if (optionLastViewed == null) {
            throw new NullPointerException("optionLastViewed is marked non-null but is null");
        }
        ImmutableList userIds = null != filterUserId ? ImmutableSet.of((Object)filterUserId) : ImmutableList.of();
        ImmutableList quotationNumbers = StringUtils.isNotBlank((CharSequence)filterQuotationNumber) ? ImmutableSet.of((Object)filterQuotationNumber) : ImmutableList.of();
        ImmutableSet entityIds = null != filterEntityId ? ImmutableSet.of((Object)filterEntityId) : ImmutableSet.of();
        ImmutableSet stageIds = null != filterStageId ? ImmutableSet.of((Object)filterStageId) : ImmutableSet.of();
        ImmutableSet projectIds = null != filterProjectId ? ImmutableSet.of((Object)filterProjectId) : ImmutableSet.of();
        Iterable relevantEntityStates = Boolean.TRUE == optionIncludeDeleted ? EntityState.ENTITY_STATES__ALL : EntityState.ENTITY_STATES__NOT_DELETED;
        ImmutableSet immutableSet = relevantMeasurementStates = Boolean.TRUE == optionShowOnlyTemporary ? ImmutableSet.of((Object)EMeasurementState.TEMPORARY) : ImmutableSet.copyOf((Object[])EMeasurementState.values());
        if (Boolean.TRUE == optionRecent) {
            LocalDate referenceDate = DateTimeHelper.today().minusDays(this.applicationConfig.getMeasurementListingRecentDays());
            recentDateRange = Range.atLeast((Comparable)referenceDate);
        } else {
            recentDateRange = Range.all();
        }
        CostCenterFilter costCenterFilter = CostCenterFilter.from((String)filterCostCenter);
        List<Object> costCenters = costCenterFilter == CostCenterFilter.EMPTY ? List.of() : List.of(costCenterFilter);
        StringSearchFilter positionNumberFilter = StringSearchFilter.from((String)filterPositionNumber);
        List<Object> positionNumbers = positionNumberFilter == StringSearchFilter.EMPTY ? List.of() : List.of(positionNumberFilter);
        Range projectExecutionDateRange = DateRangeHelper.dateRange((LocalDate)filterProjectExecutionFrom, (LocalDate)filterProjectExecutionTo);
        Range accountingMonthDateRange = DateRangeHelper.dateRange((LocalDate)filterAccountingMonth, (LocalDate)filterAccountingMonth);
        MeasurementFilter measurementFilter = MeasurementFilter.of((boolean)false, (boolean)false, (boolean)false, (String)StringUtils.trimToEmpty((String)filterText), (String)StringUtils.trimToEmpty((String)filterPositionNumber), (Iterable)ImmutableList.of(), (Iterable)quotationNumbers, costCenters, positionNumbers, (Iterable)entityIds, (Iterable)stageIds, (Iterable)projectIds, (Pageable)Pageable.unpaged(), (Iterable)userIds, (Range)accountingMonthDateRange, (Range)projectExecutionDateRange, (Range)recentDateRange, (Iterable)relevantEntityStates, (Iterable)relevantMeasurementStates);
        Stream xls = this.measurementHandler.xls(measurementFilter);
        try (SXSSFWorkbook sxssfWorkbook = this.measurementXlsExportService.detailXLS(xls, "Aufmasse");){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sxssfWorkbook.write((OutputStream)byteArrayOutputStream);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String dateForFile = this.dateTimeHelperService.dateForFile();
            String fileName = this.messageService.get((Translatable)EExportFileName.MEASUREMENT_AS_XLSX, new Object[]{dateForFile});
            Pair pair = Pair.of((Object)fileName, (Object)bytes);
            return pair;
        }
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> exportToD11(long id) {
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(id));
        Quotation stage = measurement.getQuotation();
        this.ensureSheetNumber(measurement, stage, value -> this.measurementHandler.patchSheetNumberValue(Long.valueOf(id), value));
        String d11Content = this.gaebD11ExportService.generateD11(measurement);
        byte[] d11BytesISO88591 = d11Content.getBytes(StandardCharsets.ISO_8859_1);
        String measurementNumber = measurement.getMeasurementNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.MEASUREMENT_AS_D11, new Object[]{measurementNumber, dateForFile});
        return Pair.of((Object)fileName, (Object)d11BytesISO88591);
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> exportToX31(long id) {
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(id));
        Quotation stage = measurement.getQuotation();
        this.ensureSheetNumber(measurement, stage, value -> this.measurementHandler.patchSheetNumberValue(Long.valueOf(id), value));
        GaebX31ExportResult gaebX31ExportResult = this.gaebX31ExportService.generateD11(measurement);
        byte[] x31ContentBytesUTF8 = gaebX31ExportResult.getBuffer();
        String measurementNumber = measurement.getMeasurementNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.MEASUREMENT_AS_X31, new Object[]{measurementNumber, dateForFile});
        return Pair.of((Object)fileName, (Object)x31ContentBytesUTF8);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public MeasurementSearchResultCommon search(int page, int size, @NonNull String query, boolean includeDeleted) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        String queryToBeUsed = StringUtils.isNotBlank((CharSequence)query) ? StringUtils.trimToEmpty((String)query) : "%";
        Page measurements = this.measurementHandler.search(page, size, queryToBeUsed, includeDeleted);
        return this.mapper.mapSearchItem(measurements);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon create(@NonNull MeasurementUpdateRequest measurementUpdateRequest) {
        if (measurementUpdateRequest == null) {
            throw new NullPointerException("measurementUpdateRequest is marked non-null but is null");
        }
        this.measurementUpdateRequestValidator.validate(measurementUpdateRequest);
        MeasurementModificationBucket measurementModificationBucket = this.measurementBucket(measurementUpdateRequest);
        MeasurementPositionsUpdateBucket measurementPositionsUpdateBucket = this.measurementPositionsBucket(measurementModificationBucket, measurementUpdateRequest);
        MeasurementTransposedRemarksUpdateBucket measurementTransposedRemarksUpdateBucket = this.measurementTransposedRemarksUpdateBucket(measurementModificationBucket, measurementUpdateRequest);
        this.validators.measurementValidation(measurementModificationBucket).validBeforeCreate().validBeforeMerge().validate();
        return this.mergeAndPersist(measurementModificationBucket, measurementPositionsUpdateBucket, measurementTransposedRemarksUpdateBucket);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon update(long id, @NonNull MeasurementUpdateRequest measurementUpdateRequest) {
        if (measurementUpdateRequest == null) {
            throw new NullPointerException("measurementUpdateRequest is marked non-null but is null");
        }
        this.measurementUpdateRequestValidator.validate(measurementUpdateRequest);
        MeasurementModificationBucket measurementModificationBucket = this.measurementBucket(Long.valueOf(id), measurementUpdateRequest);
        MeasurementPositionsUpdateBucket measurementPositionsUpdateBucket = this.measurementPositionsBucket(measurementModificationBucket, measurementUpdateRequest);
        MeasurementTransposedRemarksUpdateBucket measurementTransposedRemarksUpdateBucket = this.measurementTransposedRemarksUpdateBucket(measurementModificationBucket, measurementUpdateRequest);
        this.validators.measurementValidation(measurementModificationBucket).validBase().validBeforeMerge().validate();
        return this.mergeAndPersist(measurementModificationBucket, measurementPositionsUpdateBucket, measurementTransposedRemarksUpdateBucket);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon updateStateForMeasurementNumber(@NonNull String measurementNumber, @NonNull String newStateCandidate) {
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        if (newStateCandidate == null) {
            throw new NullPointerException("newStateCandidate is marked non-null but is null");
        }
        Measurement measurement = this.measurementHandler.byMeasurementNumberFailing(measurementNumber);
        return this.updateStateForMeasurement(measurement, newStateCandidate);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon updateStateForId(long id, @NonNull String newStateCandidate) {
        if (newStateCandidate == null) {
            throw new NullPointerException("newStateCandidate is marked non-null but is null");
        }
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(id));
        return this.updateStateForMeasurement(measurement, newStateCandidate);
    }

    @Nonnull
    private MeasurementCommon updateStateForMeasurement(@NonNull Measurement measurement, @NonNull String newStateCandidate) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (newStateCandidate == null) {
            throw new NullPointerException("newStateCandidate is marked non-null but is null");
        }
        EMeasurementState measurementStateNew = EMeasurementState.lookupFailing((String)newStateCandidate);
        Iterable measurementsWithSamePSSRO = this.measurementHandler.otherWithPssReleaseOrderInState(measurement, EMeasurementType.PARTIAL, (Iterable)ImmutableSet.of((Object)EMeasurementState.TEMPORARY), 10);
        MeasurementState measurementStateOld = measurement.getMeasurementState();
        EMeasurementState eMeasurementStateOld = measurementStateOld.getMeasurementState();
        EMeasurementType measurementType = measurement.getMeasurementType();
        MeasurementChangeBucket measurementChangeBucket = MeasurementChangeBucket.of((Measurement)measurement, (EMeasurementState)eMeasurementStateOld, (EMeasurementState)measurementStateNew, (EMeasurementType)measurementType, (EMeasurementType)measurementType, (Iterable)measurementsWithSamePSSRO);
        this.validators.measurementStateChange(measurementChangeBucket).validate();
        MeasurementHistorySnapShot measurementHistorySnapShot = this.historyItemRoute.snapShot(measurementChangeBucket.getMeasurement());
        this.measurementService.switchMeasurementState(measurement, measurementStateNew, EMeasurementStateReason.USER);
        Measurement updatedMeasurement = this.saveAndEmitMessage(measurementChangeBucket);
        Iterable historyItems = this.historyItemRoute.persistChanges(measurementHistorySnapShot, updatedMeasurement);
        return this.mapper.map(updatedMeasurement);
    }

    @Nonnull
    private Measurement saveAndEmitMessage(@NonNull MeasurementChangeBucket measurementChangeBucket) {
        if (measurementChangeBucket == null) {
            throw new NullPointerException("measurementChangeBucket is marked non-null but is null");
        }
        return this.saveAndEmitMessage(measurementChangeBucket, true, true);
    }

    @Nonnull
    private Measurement saveAndEmitMessage(@NonNull MeasurementChangeBucket measurementChangeBucket, boolean externalChange, boolean refreshUpdated) {
        if (measurementChangeBucket == null) {
            throw new NullPointerException("measurementChangeBucket is marked non-null but is null");
        }
        Measurement entity = measurementChangeBucket.getMeasurement();
        Measurement measurementSaved = (Measurement)this.measurementHandler.update((EntityBase)entity, refreshUpdated);
        Long measurementId = entity.getId();
        this.queueService.updated(EReferenceType.MEASUREMENT, measurementId);
        if (externalChange) {
            EMeasurementState measurementStateOld = measurementChangeBucket.getMeasurementStateOld();
            EMeasurementState measurementStateNew = measurementChangeBucket.getMeasurementStateNew();
            EMeasurementType measurementTypeOld = measurementChangeBucket.getMeasurementTypeOld();
            EMeasurementType measurementTypeNew = measurementChangeBucket.getMeasurementTypeNew();
            Iterable measurementsWithSamePSSRO = measurementChangeBucket.getMeasurementsWithSamePSSRO();
            MeasurementChangeMessage measurementChangeMessage = MeasurementChangeMessage.of((Object)this, (Measurement)measurementSaved, (EMeasurementState)measurementStateOld, (EMeasurementState)measurementStateNew, (EMeasurementType)measurementTypeOld, (EMeasurementType)measurementTypeNew, (Iterable)measurementsWithSamePSSRO);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)measurementChangeMessage);
        }
        return measurementSaved;
    }

    @Nonnull
    @Transactional(readOnly=true)
    public MeasurementNumberExistsResponse existsCheck(@NonNull String measurementNumber) {
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        Measurement measurement = this.measurementHandler.byMeasurementNumberFailing(measurementNumber);
        return this.mapper.mapExists(measurement);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public MeasurementDuplicateCheckResponse duplicateCheck(long measurementId, @Nullable Long targetStageId) {
        PssReleaseOrder pssReleaseOrder;
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(measurementId));
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        Quotation originalQuotation = measurement.getQuotation();
        Long originalStageId = originalQuotation.getId();
        boolean differentStage = null != targetStageId && !Objects.equals(originalStageId, targetStageId);
        Long stageIdToBeUsed = differentStage ? targetStageId : originalStageId;
        Quotation targetStage = (Quotation)this.stageHandler.byIdFailing(stageIdToBeUsed);
        Map stagesMap = this.stageHandler.allPositionStages(targetStage);
        ImmutableList allPos = (ImmutableList)stagesMap.values().stream().flatMap(Streams::stream).collect(ImmutableList.toImmutableList());
        Map positionsBySPN = MapsHelper.mapFirst((Iterable)allPos, QuotationPosition::getSurrogatePositionNumber);
        Set missingSurrogatePositionNumbers = MeasurementHelper.missingSurrogatePositionNumbers((Measurement)measurement, (Map)positionsBySPN);
        boolean hasPositions = !measurementPositions.isEmpty();
        boolean hasPositionsWithMissingQP = !missingSurrogatePositionNumbers.isEmpty();
        boolean standardCopyIsPossible = !hasPositions || !hasPositionsWithMissingQP;
        boolean partialCopyIsPossible = !hasPositions || hasPositionsWithMissingQP;
        boolean anotherMainMeasurementWithSamePssRO = false;
        boolean anotherMainMeasurementWithInvalidStateStateWithSamePssRO = false;
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        if (null != releaseOrder && null != (pssReleaseOrder = releaseOrder.getPssReleaseOrder())) {
            EMeasurementType measurementType = measurement.getMeasurementType();
            if (EMeasurementType.MAIN == measurementType) {
                anotherMainMeasurementWithSamePssRO = true;
            } else if (EMeasurementType.PARTIAL == measurementType) {
                Long othersWithSamePssCount = this.measurementHandler.countOtherWithPssReleaseOrderInState(measurement, pssReleaseOrder, EMeasurementType.MAIN, (Iterable)EMeasurementState.PSSRO_DISALLOW_NEW_MEASUREMENT_STATES);
                anotherMainMeasurementWithInvalidStateStateWithSamePssRO = othersWithSamePssCount > 0L;
            }
        }
        ImmutableList.Builder errorMessagesBuilder = ImmutableList.builder();
        for (String missingSurrogatePositionNumber : missingSurrogatePositionNumbers) {
            String translatedError = this.messageService.getDE((Translatable)EMessageKey.MEASUREMENT_COPY__MISSING_SPN, new Object[]{missingSurrogatePositionNumber, targetStage.getQNumber()});
            errorMessagesBuilder.add((Object)translatedError);
        }
        ImmutableList errorMessages = errorMessagesBuilder.build();
        return MeasurementDuplicateCheckResponse.of((Long)measurement.getId(), (String)measurement.getMeasurementNumber(), (Boolean)standardCopyIsPossible, (Boolean)partialCopyIsPossible, (Boolean)anotherMainMeasurementWithSamePssRO, (Boolean)anotherMainMeasurementWithInvalidStateStateWithSamePssRO, (Iterable)errorMessages);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon duplicate(long measurementId, @Nullable Long targetStageId, boolean allowPartialCopy, boolean includeReleaseOrder, boolean includePositions, boolean optionCopyAmounts) {
        Set missing;
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(measurementId));
        Quotation originalQuotation = measurement.getQuotation();
        Long originalStageId = originalQuotation.getId();
        boolean differentStage = null != targetStageId && !Objects.equals(originalStageId, targetStageId);
        Long stageIdToBeUsed = differentStage ? targetStageId : originalStageId;
        Quotation targetStage = (Quotation)this.stageHandler.byIdFailing(stageIdToBeUsed);
        Map stagesMap = this.stageHandler.allPositionStages(targetStage);
        ImmutableList allPos = (ImmutableList)stagesMap.values().stream().flatMap(Streams::stream).collect(ImmutableList.toImmutableList());
        Map positionsBySPN = MapsHelper.mapFirst((Iterable)allPos, QuotationPosition::getSurrogatePositionNumber);
        if (!(allowPartialCopy || differentStage || (missing = MeasurementHelper.missingSurrogatePositionNumbers((Measurement)measurement, (Map)positionsBySPN)).isEmpty())) {
            String missingSurrogatePositionNumbers = COMMA_JOINER.join((Iterable)missing);
            String msg = String.format("Positions: %s not present in Quotation", missingSurrogatePositionNumbers);
            throw new DuplicationException(msg, List.of(RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.STAGE_POSITION_SURROGATE_NUMBER), (Object)missingSurrogatePositionNumbers, (String)msg, (Message)Message.of((EMessageKey)EMessageKey.DUPLICATE_REQUEST_QUOTATION_POSITIONS_POSITION_NUMBER_MISSING, (String)missingSurrogatePositionNumbers), List.of())));
        }
        boolean flagMeasurementTransposed = measurement.getMeasurementViewType() == EMeasurementViewType.TRANSPOSED;
        Measurement measurementCopy = this.entityFactory.measurement(EMeasurementOrigin.QUANTE_V2);
        measurementCopy.setCreatedByUser(this.userService.authenticatedUser());
        this.measurementService.switchMeasurementState(measurementCopy, EMeasurementState.TEMPORARY, EMeasurementStateReason.COPY);
        MeasurementHistorySnapShot measurementHistorySnapShot = this.historyItemRoute.snapShot(measurementCopy);
        LocalDate headerAccountingMonth = measurement.getAccountingMonth();
        Function<MeasurementPosition, Optional> measurementPositionMeasurementPositionFunction = source -> {
            QuotationPosition originalQuotationPosition = source.getQuotationPosition();
            String surrogatePositionNumber = source.getSurrogatePositionNumber();
            QuotationPosition quotationPosition = differentStage ? (QuotationPosition)positionsBySPN.get(surrogatePositionNumber) : (null != originalQuotationPosition && allPos.contains((Object)originalQuotationPosition) ? originalQuotationPosition : (QuotationPosition)positionsBySPN.get(surrogatePositionNumber));
            if (null != quotationPosition) {
                String measurementPositionShortText;
                Optional jumboPositionCandidates = StageHelper.determineJumboPosition((QuotationPosition)quotationPosition);
                String quotationPositionShortText = StringUtils.trimToEmpty((String)StringUtils.lowerCase((String)quotationPosition.getShortText()));
                boolean similar = StringUtils.equalsIgnoreCase((CharSequence)quotationPositionShortText, (CharSequence)(measurementPositionShortText = StringUtils.trimToEmpty((String)StringUtils.lowerCase((String)source.getShortText()))));
                if (similar) {
                    MeasurementPosition destination = this.entityFactory.measurementPosition();
                    MeasurementPosition measurementPositionMerged = this.measurementPositionMapper.mergeMeasurementPosition(source, destination, quotationPosition, (QuotationPosition)jumboPositionCandidates.orElse(null), headerAccountingMonth, optionCopyAmounts, flagMeasurementTransposed);
                    return Optional.of(measurementPositionMerged);
                }
            }
            return Optional.empty();
        };
        Function<ReleaseOrder, ReleaseOrder> releaseOrderReleaseOrderFunction = releaseOrder -> {
            Long othersWithSamePssCount;
            EMeasurementType measurementType;
            ReleaseOrder to = this.entityFactory.releaseOrder();
            String name = StringUtils.trimToEmpty((String)releaseOrder.getName());
            String orderNumber = StringUtils.trimToEmpty((String)releaseOrder.getOrderNumber());
            PssReleaseOrder pssReleaseOrder = releaseOrder.getPssReleaseOrder();
            PssReleaseOrder safePssReleaseOrder = differentStage ? null : (EMeasurementType.MAIN == (measurementType = measurement.getMeasurementType()) ? null : (EMeasurementType.PARTIAL == measurementType ? ((othersWithSamePssCount = this.measurementHandler.countOtherWithPssReleaseOrderInState(measurement, pssReleaseOrder, EMeasurementType.MAIN, (Iterable)EMeasurementState.PSSRO_DISALLOW_NEW_MEASUREMENT_STATES)) > 0L ? null : pssReleaseOrder) : pssReleaseOrder));
            ReleaseOrderUpdateBucket releaseOrderUpdateBucket = ReleaseOrderUpdateBucket.of((String)name, (String)orderNumber, (String)to.getReferenceId(), (Measurement)measurementCopy, (Quotation)targetStage, (ReleaseOrder)to, (PssReleaseOrder)safePssReleaseOrder);
            return this.releaseOrderMapper.merge(releaseOrderUpdateBucket);
        };
        String measurementNumber = this.measurementService.determineNextMeasurementNumber();
        Measurement duplicatedMeasurement = this.mapper.mergeMeasurement(measurement, measurementCopy, targetStage, measurementNumber, measurementPositionMeasurementPositionFunction, releaseOrderReleaseOrderFunction, includeReleaseOrder, includePositions);
        this.measurementCalculators.standard().calculateAndApply(duplicatedMeasurement);
        Iterable measurementsWithSamePSSRO = this.measurementHandler.otherWithPssReleaseOrderInState(duplicatedMeasurement, EMeasurementType.MAIN, (Iterable)ImmutableSet.of((Object)EMeasurementState.TEMPORARY), 10);
        MeasurementChangeBucket measurementChangeBucket = MeasurementChangeBucket.of((Measurement)duplicatedMeasurement, (EMeasurementState)EMeasurementState.UNKNOWN, (EMeasurementState)duplicatedMeasurement.getMeasurementState().getMeasurementState(), (EMeasurementType)EMeasurementType.NONE, (EMeasurementType)duplicatedMeasurement.getMeasurementType(), (Iterable)measurementsWithSamePSSRO);
        Measurement measurementSaved_1 = this.saveAndEmitMessage(measurementChangeBucket);
        Iterable historyItems = this.historyItemRoute.persistChanges(measurementHistorySnapShot, measurementSaved_1);
        return this.mapper.map(measurementSaved_1);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon move(long measurementId, @Nullable Long targetStageId, boolean allowPartialCopy, boolean includeReleaseOrder, boolean includePositions, boolean optionCopyAmounts) {
        Set missing;
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(measurementId));
        Quotation originalStage = measurement.getQuotation();
        Long originalStageId = originalStage.getId();
        MeasurementHistorySnapShot measurementHistorySnapShot = this.historyItemRoute.snapShot(measurement);
        MeasurementState measurementStateOld = measurement.getMeasurementState();
        EMeasurementState eMeasurementStateOld = measurementStateOld.getMeasurementState();
        this.validateEditabilityFailing(measurement, eMeasurementStateOld, EMessageKey.RULE_MEASUREMENT_NOT_MOVED_DUE_TO_STATE);
        boolean differentStage = null != targetStageId && !Objects.equals(originalStageId, targetStageId);
        Long stageIdToBeUsed = differentStage ? targetStageId : originalStageId;
        Quotation targetStage = (Quotation)this.stageHandler.byIdFailing(stageIdToBeUsed);
        Map targetStagesMap = this.stageHandler.allPositionStages(targetStage);
        ImmutableList allTargetPos = (ImmutableList)targetStagesMap.values().stream().flatMap(Streams::stream).collect(ImmutableList.toImmutableList());
        Map targetPositionsBySPN = MapsHelper.mapFirst((Iterable)allTargetPos, QuotationPosition::getSurrogatePositionNumber);
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        ImmutableList sourceQuotationPositions = (ImmutableList)measurementPositions.stream().map(MeasurementPosition::getQuotationPosition).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        Map sourcePosBySPN = MapsHelper.mapFirst((Iterable)sourceQuotationPositions, QuotationPosition::getSurrogatePositionNumber);
        if (!(allowPartialCopy || differentStage || (missing = MeasurementHelper.missingSurrogatePositionNumbers((Measurement)measurement, (Map)targetPositionsBySPN)).isEmpty())) {
            String missingSurrogatePositionNumbers = COMMA_JOINER.join((Iterable)missing);
            String msg = String.format("Positions: %s not present in Quotation", missingSurrogatePositionNumbers);
            throw new DuplicationException(msg, List.of(RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.STAGE_POSITION_SURROGATE_NUMBER), (Object)missingSurrogatePositionNumbers, (String)msg, (Message)Message.of((EMessageKey)EMessageKey.DUPLICATE_REQUEST_QUOTATION_POSITIONS_POSITION_NUMBER_MISSING, (String)missingSurrogatePositionNumbers), List.of())));
        }
        LinkedHashMap positionMap = Maps.newLinkedHashMap();
        sourceQuotationPositions.forEach(sourcePos -> {
            String spn = sourcePos.getSurrogatePositionNumber();
            if (targetPositionsBySPN.containsKey(spn)) {
                QuotationPosition targetPos = (QuotationPosition)targetPositionsBySPN.get(spn);
                positionMap.put(sourcePos, targetPos);
            }
        });
        MeasurementMoveBucket measurementMoveBucket = MeasurementMoveBucket.of((Measurement)measurement, (Quotation)originalStage, (Quotation)targetStage, (Map)positionMap);
        Measurement measurementMoved = this.measurementService.move(measurementMoveBucket);
        MeasurementChangeBucket measurementChangeBucket = MeasurementChangeBucket.of((Measurement)measurementMoved, (EMeasurementState)EMeasurementState.UNKNOWN, (EMeasurementState)measurementMoved.getMeasurementState().getMeasurementState(), (EMeasurementType)EMeasurementType.NONE, (EMeasurementType)measurementMoved.getMeasurementType(), (Iterable)ImmutableList.of());
        Measurement updatedMeasurement = this.saveAndEmitMessage(measurementChangeBucket);
        Iterable historyItems = this.historyItemRoute.persistChanges(measurementHistorySnapShot, updatedMeasurement);
        return this.mapper.map(updatedMeasurement);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon delete(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.OP_MEASUREMENT_DELETE);
        Measurement measurement = this.measurementHandler.byReferenceIdFailing(referenceId);
        measurement.setLastOrigin(EMeasurementOrigin.QUANTE_V1);
        Measurement measurementDeleted = this.deleteAndEmitMessage(measurement, false);
        return this.mapper.map(measurementDeleted);
    }

    @Nonnull
    @Transactional
    public MeasurementCommon delete(long id) {
        this.userService.checkPrivilege(EPrivilege.OP_MEASUREMENT_DELETE);
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(id));
        measurement.setLastOrigin(EMeasurementOrigin.QUANTE_V2);
        Measurement measurementDeleted = this.deleteAndEmitMessage(measurement, true);
        return this.mapper.map(measurementDeleted);
    }

    @Nonnull
    private Measurement deleteAndEmitMessage(@NonNull Measurement measurement, boolean emitMessage) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (measurement.getEntityState() != EntityState.DELETED) {
            MeasurementState measurementStateOld = measurement.getMeasurementState();
            EMeasurementState eMeasurementStateOld = measurementStateOld.getMeasurementState();
            EMeasurementType measurementTypeOld = measurement.getMeasurementType();
            this.validateEditabilityFailing(measurement, eMeasurementStateOld, EMessageKey.RULE_MEASUREMENT_NOT_DELETED_DUE_TO_STATE);
            String measurementNumber = measurement.getMeasurementNumber();
            measurement.setOriginalMeasurementNumber(measurementNumber);
            LocalDateTime referenceDateTime = this.dateTimeHelperService.convertToDestination(DateTimeHelper.now());
            String timeStampAsString = DateTimeHelper.toIsoDateTime((LocalDateTime)referenceDateTime);
            String measurementNumberNew = String.format(MEASUREMENT_NUMBER_DELETED_FORMAT, measurementNumber, timeStampAsString);
            measurement.setMeasurementNumber(measurementNumberNew);
            measurement.setReferenceId(UUID.randomUUID().toString());
            measurement.setEntityState(EntityState.DELETED);
            this.measurementService.switchMeasurementState(measurement, EMeasurementState.DELETED, EMeasurementStateReason.USER);
            Measurement measurementDeleted = (Measurement)this.measurementHandler.delete((EntityBase)measurement);
            Iterable measurementsWithSamePSSRO = this.measurementHandler.otherWithPssReleaseOrderInState(measurementDeleted, EMeasurementType.MAIN, (Iterable)ImmutableSet.of((Object)EMeasurementState.TEMPORARY), 10);
            MeasurementState measurementStateNew = measurementDeleted.getMeasurementState();
            EMeasurementState eMeasurementStateNew = measurementStateNew.getMeasurementState();
            EMeasurementType measurementTypeNew = measurementDeleted.getMeasurementType();
            MeasurementChangeMessage measurementChangeMessage = MeasurementChangeMessage.of((Object)this, (Measurement)measurementDeleted, (EMeasurementState)eMeasurementStateOld, (EMeasurementState)eMeasurementStateNew, (EMeasurementType)measurementTypeOld, (EMeasurementType)measurementTypeNew, (Iterable)measurementsWithSamePSSRO);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)measurementChangeMessage);
            if (emitMessage) {
                Long measurementId = measurement.getId();
                this.queueService.deleted(EReferenceType.MEASUREMENT, measurementId);
            }
            return measurementDeleted;
        }
        return measurement;
    }

    private void validateEditabilityFailing(Measurement measurement, EMeasurementState eMeasurementStateOld, EMessageKey ruleMeasurementNotDeletedDueToState) {
        boolean usedInB2B = measurement.getQuotation().getFlagB2B() == Boolean.TRUE && EMeasurementState.B2B_BLOCKING_STATES.contains(eMeasurementStateOld);
        boolean usedInInvoice = EMeasurementState.ACCOUNTING_STATES.contains(eMeasurementStateOld);
        if (usedInInvoice || usedInB2B) {
            String measurementNumber = measurement.getMeasurementNumber();
            String stateTxt = this.messageService.get((Translatable)eMeasurementStateOld, new Object[0]);
            String message = this.messageService.get((Translatable)ruleMeasurementNotDeletedDueToState, new Object[]{measurementNumber, stateTxt});
            throw new BusinessRuleValidationException(message, (List)ImmutableList.of());
        }
    }

    @Nonnull
    private MeasurementPositionsUpdateBucket measurementPositionsBucket(@NonNull MeasurementModificationBucket measurementModificationBucket, @NonNull MeasurementUpdateRequest measurementUpdateRequest) {
        Set positionNumbersExisting;
        if (measurementModificationBucket == null) {
            throw new NullPointerException("measurementModificationBucket is marked non-null but is null");
        }
        if (measurementUpdateRequest == null) {
            throw new NullPointerException("measurementUpdateRequest is marked non-null but is null");
        }
        List measurementPositionUpdateItems = (List)MoreObjects.firstNonNull((Object)measurementUpdateRequest.getMeasurementPositions(), List.of());
        Measurement measurement = (Measurement)measurementModificationBucket.getEntity();
        User assignedUser = measurementModificationBucket.getAssignedUser();
        Iterable measurementPositions = (Iterable)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        ImmutableSet quotationPositions = ImmutableSet.copyOf((Iterable)measurementModificationBucket.getQuotationPositions());
        ImmutableMap measurementPositionsById = Maps.uniqueIndex((Iterable)measurementPositions, MeasurementPosition::getId);
        ImmutableMap quotationPositionsById = Maps.uniqueIndex((Iterable)quotationPositions, QuotationPosition::getId);
        ImmutableSet positionNumbersRequired = ImmutableSet.copyOf(measurementPositionUpdateItems.stream().map(MeasurementPositionUpdateItem::getPositionId).filter(Objects::nonNull).iterator());
        Sets.SetView positionIdsNotPresent = Sets.difference((Set)positionNumbersRequired, positionNumbersExisting = quotationPositionsById.keySet());
        if (!positionIdsNotPresent.isEmpty()) {
            String positionIds = POSITION_ID_ERROR_MSG_JOINER.join((Iterable)positionIdsNotPresent);
            throw ResourceNotFoundException.of((String)QuotationPosition.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.STAGE_POSITION_ID), (String)positionIds);
        }
        ImmutableList.Builder measurementPositionUpdateBucketsBuilder = ImmutableList.builder();
        for (MeasurementPositionUpdateItem measurementPositionUpdateItem : measurementPositionUpdateItems) {
            Long measurementPositionId = measurementPositionUpdateItem.getId();
            MeasurementPosition measurementPosition = measurementPositionsById.getOrDefault(measurementPositionId, this.entityFactory.measurementPosition());
            MeasurementPositionUpdateBucket measurementPositionUpdateBucket = MeasurementPositionUpdateBucket.of((Long)measurementPositionId, (MeasurementPosition)measurementPosition, (User)assignedUser, (Long)measurementPositionUpdateItem.getPositionId(), (String)measurementPositionUpdateItem.getSurrogatePositionNumber(), (BigDecimal)measurementPositionUpdateItem.getAmount(), (BigDecimal)measurementPositionUpdateItem.getFactor1(), (BigDecimal)measurementPositionUpdateItem.getFactor2(), (BigDecimal)measurementPositionUpdateItem.getFactor3(), (String)StringUtils.trimToEmpty((String)measurementPositionUpdateItem.getRemarks()), (LocalDate)measurementPositionUpdateItem.getAccountingMonth(), (Integer)measurementPositionUpdateItem.getSequenceNumberMeasurementStandard(), (Integer)((Integer)MoreObjects.firstNonNull((Object)measurementPositionUpdateItem.getSequenceNumberMeasurementTransposed(), (Object)0)), (Integer)((Integer)MoreObjects.firstNonNull((Object)measurementPositionUpdateItem.getTransposedSortIndex(), (Object)0)));
            measurementPositionUpdateBucketsBuilder.add((Object)measurementPositionUpdateBucket);
        }
        ImmutableList measurementPositionUpdateBuckets = measurementPositionUpdateBucketsBuilder.build();
        return MeasurementPositionsUpdateBucket.of((Measurement)measurement, (Iterable)quotationPositions, (User)assignedUser, (Iterable)measurementPositionUpdateBuckets);
    }

    @Nonnull
    private MeasurementTransposedRemarksUpdateBucket measurementTransposedRemarksUpdateBucket(@NonNull MeasurementModificationBucket measurementModificationBucket, @NonNull MeasurementUpdateRequest measurementUpdateRequest) {
        if (measurementModificationBucket == null) {
            throw new NullPointerException("measurementModificationBucket is marked non-null but is null");
        }
        if (measurementUpdateRequest == null) {
            throw new NullPointerException("measurementUpdateRequest is marked non-null but is null");
        }
        Measurement measurement = (Measurement)measurementModificationBucket.getEntity();
        List transposedRemarksUI = (List)MoreObjects.firstNonNull((Object)measurementUpdateRequest.getTransposedRemarks(), List.of());
        Iterable measurementTransposedRemarks = (Iterable)MoreObjects.firstNonNull((Object)measurement.getMeasurementTransposedRemarks(), (Object)ImmutableList.of());
        Map stringMeasurementTransposedRemarkMap = MapsHelper.mapFirst((Iterable)measurementTransposedRemarks, MeasurementTransposedRemark::getRemark);
        ImmutableList.Builder updateBucketBuilder = ImmutableList.builder();
        for (MeasurementTransposedRemarkUpdateItem transposedRemarkUpdateItem : transposedRemarksUI) {
            String remark = transposedRemarkUpdateItem.getRemark();
            Integer rowIndex = transposedRemarkUpdateItem.getRowIndex();
            MeasurementTransposedRemark orDefault = stringMeasurementTransposedRemarkMap.getOrDefault(remark, this.entityFactory.measurementTransposedRemark());
            MeasurementTransposedRemarkUpdateBucket updateBucket = MeasurementTransposedRemarkUpdateBucket.of((Long)orDefault.getId(), (String)remark, (Integer)rowIndex);
            updateBucketBuilder.add((Object)updateBucket);
        }
        ImmutableList updateBuckets = updateBucketBuilder.build();
        return MeasurementTransposedRemarksUpdateBucket.of((Measurement)measurement, (Iterable)updateBuckets);
    }

    @Nonnull
    MeasurementModificationBucket measurementBucket(@NonNull MeasurementUpdateRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String measurementNumber = this.measurementService.determineNextMeasurementNumber();
        Measurement measurement = this.entityFactory.measurement(EMeasurementOrigin.QUANTE_V2);
        this.measurementService.switchMeasurementState(measurement, EMeasurementState.TEMPORARY, EMeasurementStateReason.USER);
        return this.measurementBucket(true, request, measurement, measurementNumber);
    }

    @Nonnull
    MeasurementModificationBucket measurementBucket(@NonNull Long id, @NonNull MeasurementUpdateRequest request) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Measurement existing = (Measurement)this.measurementHandler.byIdFailing(id);
        String measurementNumber = existing.getMeasurementNumber();
        return this.measurementBucket(false, request, existing, measurementNumber);
    }

    @Nonnull
    MeasurementModificationBucket measurementBucket(boolean create, @NonNull MeasurementUpdateRequest request, @NonNull Measurement measurement, @NonNull String measurementNumber) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        String refMeasurementId = StringUtils.trimToEmpty((String)measurementNumber);
        Long assignedUserId = request.getAssignedUserId();
        User authenticatedUser = this.userService.authenticatedUser();
        User createdByUser = create ? authenticatedUser : (User)MoreObjects.firstNonNull((Object)measurement.getCreatedByUser(), (Object)authenticatedUser);
        User assignedUser = (User)this.userHandler.byIdFailing(assignedUserId);
        Long stageId = request.getQuotationId();
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(stageId);
        EQStageType stageType = stage.getStageType();
        ImmutableSet additionalStages = create ? ImmutableSet.of() : this.stageHandler.stagesUsedInPositions(measurement);
        Iterable eCostUnitCEViewModes = ECostUnitCEViewMode.modesForMeasurement((EQStageType)stageType);
        Map stagesMap = this.stageHandler.allPositionStages(stage, (Iterable)additionalStages, eCostUnitCEViewModes, true);
        Set allStages = stagesMap.keySet();
        Iterable allPositions = (Iterable)stagesMap.values().stream().flatMap(Streams::stream).collect(ImmutableList.toImmutableList());
        ReleaseOrderUpdateItem releaseOrderUpdateItem = request.getReleaseOrder();
        ReleaseOrder releaseOrder = null != measurement.getReleaseOrder() ? measurement.getReleaseOrder() : this.entityFactory.releaseOrder();
        ReleaseOrderUpdateBucket bucket = this.bucket(measurement, stage, releaseOrderUpdateItem, releaseOrder);
        PssReleaseOrder pssReleaseOrder = bucket.getPssReleaseOrder();
        Iterable measurements = this.measurementHandler.otherWithPssReleaseOrderInState(measurement, pssReleaseOrder, EMeasurementType.MAIN, (Iterable)EMeasurementState.PSSRO_DISALLOW_NEW_MAIN_MEASUREMENTS, 1);
        return MeasurementModificationBucket.of((MeasurementModificationRequest)request, (String)measurementNumber, (Measurement)measurement, (EMeasurementOrigin)EMeasurementOrigin.QUANTE_V2, (Quotation)stage, allStages, (Iterable)allPositions, (Map)stagesMap, (User)createdByUser, (User)assignedUser, (String)refMeasurementId, (ReleaseOrderUpdateBucket)bucket, (boolean)false, (Iterable)measurements);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Pair<String, byte[]> csv(long id, @NonNull String csvExportTypeCandidate) {
        if (csvExportTypeCandidate == null) {
            throw new NullPointerException("csvExportTypeCandidate is marked non-null but is null");
        }
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(id));
        ECsvExportType csvExportType = ECsvExportType.lookupFailing((String)csvExportTypeCandidate);
        String measurementNumber = measurement.getMeasurementNumber();
        String csvExportName = csvExportType.name();
        String csvContent = this.csvExportService.generate(csvExportType, measurement);
        String fileName = this.messageService.get((Translatable)EExportFileName.MEASUREMENT_AS_CSV, new Object[]{measurementNumber, csvExportName});
        return Pair.of((Object)fileName, (Object)csvContent.getBytes(StandardCharsets.UTF_8));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Pair<String, byte[]> print(long measurementId, @NonNull String templateCandidate, @NonNull String fontSizeCandidate, @NonNull Map<String, String> allRequestParams, @Nullable LocalDate printDateCandidate, int transposedColumnAmount, int transposedHeaderLength) {
        if (templateCandidate == null) {
            throw new NullPointerException("templateCandidate is marked non-null but is null");
        }
        if (fontSizeCandidate == null) {
            throw new NullPointerException("fontSizeCandidate is marked non-null but is null");
        }
        if (allRequestParams == null) {
            throw new NullPointerException("allRequestParams is marked non-null but is null");
        }
        Optional printTemplateCandidate = EMeasurementPrintTemplate.lookup((String)templateCandidate);
        EPrintFontSize printFontSize = EPrintFontSize.lookup((String)fontSizeCandidate, (EPrintFontSize)EPrintFontSize.DEFAULT);
        Iterable booleanPrintOptions = PrintOptionHelper.measurementPrintOptions(allRequestParams);
        LocalDate printDate = (LocalDate)MoreObjects.firstNonNull((Object)printDateCandidate, (Object)DateTimeHelper.today());
        if (printTemplateCandidate.isPresent()) {
            EMeasurementPrintTemplate eMeasurementPrintTemplate = (EMeasurementPrintTemplate)printTemplateCandidate.get();
            MeasurementPrintBucket measurementPrintBucket = this.measurementPrintBucket(measurementId);
            try {
                ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
                String name = this.fileName(measurementPrintBucket, eMeasurementPrintTemplate, printFontSize);
                LocalDate projectExecutionEndDate = measurementPrintBucket.getMeasurement().getProjectExecutionEndDate();
                LocalDate transferOfPerilsDate = projectExecutionEndDate.withMonth(12).withDayOfMonth(31);
                switch (1.$SwitchMap$de$qfm$erp$service$model$internal$measurement$EMeasurementPrintTemplate[eMeasurementPrintTemplate.ordinal()]) {
                    case 1: {
                        MeasurementStandardPrintConfiguration standardPrintConfiguration = MeasurementStandardPrintConfiguration.of((Color)MeasurementStandardPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)booleanPrintOptions, (LocalDate)printDate, (LocalDate)transferOfPerilsDate);
                        MeasurementPrintStandard measurementPrintStandard = this.measurementPrintMapper.mapStandard(measurementPrintBucket, booleanPrintOptions);
                        byte[] buffer = this.pdfRoute.generatePDF(measurementPrintStandard, standardPrintConfiguration, printFontSize, configurationCompany);
                        return Pair.of((Object)name, (Object)buffer);
                    }
                    case 2: {
                        MeasurementGroupedPrintConfiguration groupedPrintConfiguration = MeasurementGroupedPrintConfiguration.of((Color)MeasurementGroupedPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)booleanPrintOptions, (LocalDate)printDate, (LocalDate)transferOfPerilsDate);
                        MeasurementPrintGrouped measurementPrintGrouped = this.measurementPrintMapper.mapGrouped(measurementPrintBucket, booleanPrintOptions);
                        byte[] buffer = this.pdfRoute.generatePDF(measurementPrintGrouped, groupedPrintConfiguration, printFontSize, configurationCompany);
                        return Pair.of((Object)name, (Object)buffer);
                    }
                    case 3: {
                        MeasurementTransposedPrintConfiguration printConfiguration = MeasurementTransposedPrintConfiguration.of((Color)MeasurementTransposedPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (int)transposedColumnAmount, (int)30, (int)transposedHeaderLength, (Iterable)booleanPrintOptions, (LocalDate)printDate, (LocalDate)transferOfPerilsDate);
                        MeasurementPrintTransposed measurementPrintTransposed = this.measurementPrintMapper.mapRotated(measurementPrintBucket, booleanPrintOptions);
                        byte[] buffer = this.pdfRoute.generatePDF(measurementPrintTransposed, printConfiguration, printFontSize, configurationCompany);
                        return Pair.of((Object)name, (Object)buffer);
                    }
                    case 4: {
                        throw new IllegalArgumentException(String.format("Print Template Candidate: %s not known", templateCandidate));
                    }
                }
            }
            catch (Exception e) {
                String msg = String.format("Error generating PDF: %s for Measurement: %s and Template: %s", e.getMessage(), measurementId, templateCandidate);
                log.error(msg, (Throwable)e);
                throw new PDFGenerationException(msg);
            }
        } else {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PRINT_TEMPLATE), (String)templateCandidate, EMeasurementPrintTemplate.class, EMeasurementPrintTemplate::allowedKeys);
        }
        return EMPTY;
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Pair<String, byte[]> print(@NonNull Iterable<Long> measurementIds, @NonNull String templateCandidate) {
        if (measurementIds == null) {
            throw new NullPointerException("measurementIds is marked non-null but is null");
        }
        if (templateCandidate == null) {
            throw new NullPointerException("templateCandidate is marked non-null but is null");
        }
        Optional printTemplateCandidate = EMeasurementPrintTemplate.lookup((String)templateCandidate);
        EPrintFontSize printFontSize = EPrintFontSize.DEFAULT;
        ImmutableSet booleanPrintOptions = ImmutableSet.of();
        LocalDate printDate = DateTimeHelper.today();
        if (printTemplateCandidate.isPresent()) {
            EMeasurementPrintTemplate eMeasurementPrintTemplate = (EMeasurementPrintTemplate)printTemplateCandidate.get();
            Iterable measurements = this.measurementHandler.allByIds(measurementIds);
            ImmutableSet quotationNumbers = (ImmutableSet)Streams.stream((Iterable)measurements).map(Measurement::getQuotation).map(Quotation::getQuotationNumber).collect(ImmutableSet.toImmutableSet());
            if (Iterables.size((Iterable)quotationNumbers) > 1) {
                throw new DuplicationException("Mehr als eine Angebotsnummer in den gew\u00e4hlten Aufma\u00dfen", (List)ImmutableList.of());
            }
            if (Iterables.isEmpty((Iterable)quotationNumbers)) {
                throw new DuplicationException("Keine Angebotsnummer in den gew\u00e4hlten Aufma\u00dfen", (List)ImmutableList.of());
            }
            String quotationNumber = (String)quotationNumbers.stream().iterator().next();
            Quotation quotation = this.stageHandler.firstByQuotationNumberFailing(quotationNumber);
            Map addendumDiscounts = this.stageHandler.stageDiscountsAsMap(quotation);
            ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
            try {
                switch (1.$SwitchMap$de$qfm$erp$service$model$internal$measurement$EMeasurementPrintTemplate[eMeasurementPrintTemplate.ordinal()]) {
                    case 5: {
                        MeasurementPreliminaryStandardPrintConfiguration printConfiguration = MeasurementPreliminaryStandardPrintConfiguration.of((Color)MeasurementStandardPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)booleanPrintOptions, (LocalDate)printDate, null);
                        MeasurementPrintPreliminaryStandard measurementPrintStandard = this.measurementPrintMapper.mapPreliminaryStandard(measurements, quotation, addendumDiscounts);
                        byte[] buffer = this.pdfRoute.generatePDF(measurementPrintStandard, printConfiguration, printFontSize, configurationCompany);
                        String dateForFile = this.dateTimeHelperService.timeStampForFile();
                        String name = this.messageService.get((Translatable)EExportFileName.MEASUREMENT_PRELIMINARY_AS_PDF, new Object[]{dateForFile});
                        return Pair.of((Object)name, (Object)buffer);
                    }
                    case 4: {
                        throw new IllegalArgumentException(String.format("Print Template Candidate: %s not known", templateCandidate));
                    }
                }
            }
            catch (Exception e) {
                String msg = String.format("Error generating PDF: %s for Measurement: %s and Template: %s", e.getMessage(), measurementIds, templateCandidate);
                log.error(msg, (Throwable)e);
                throw new PDFGenerationException(msg);
            }
        } else {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PRINT_TEMPLATE), (String)templateCandidate, EMeasurementPrintTemplate.class, EMeasurementPrintTemplate::allowedKeys);
        }
        return EMPTY;
    }

    @Nonnull
    public Triple<String, String, byte[]> exportCustomerTemplate(@NonNull Iterable<Long> measurementIds) throws IOException {
        String orderText;
        if (measurementIds == null) {
            throw new NullPointerException("measurementIds is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.MEASUREMENT__EXPORT_CUSTOMER_TEMPLATE);
        Iterable measurements = this.measurementHandler.allByIds(measurementIds);
        Iterable measurementPositions = (Iterable)Streams.stream((Iterable)measurements).flatMap(item -> item.getMeasurementPositions().stream()).collect(ImmutableList.toImmutableList());
        Iterable stages = (Iterable)Streams.stream((Iterable)measurements).map(Measurement::getQuotation).collect(ImmutableSet.toImmutableSet());
        Iterable customers = (Iterable)Streams.stream((Iterable)stages).map(Quotation::getCustomer).collect(ImmutableSet.toImmutableSet());
        if (Iterables.size((Iterable)customers) > 1) {
            String error = this.messageService.get(Message.of((EMessageKey)EMessageKey.MULTIPLE_CUSTOMERS_ASSOCIATED_ERROR));
            throw new BusinessRuleValidationException(error, List.of());
        }
        if (Iterables.size((Iterable)stages) > 1) {
            String error = this.messageService.get(Message.of((EMessageKey)EMessageKey.MULTIPLE_STAGES_ASSOCIATED_ERROR));
            throw new BusinessRuleValidationException(error, List.of());
        }
        Measurement measurement = (Measurement)measurements.iterator().next();
        Quotation stage = (Quotation)stages.iterator().next();
        Customer customer = (Customer)customers.iterator().next();
        Optional templateCandidate = this.customerTemplateHandler.findFirstByCustomer(customer);
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        PssReleaseOrder pssReleaseOrder = releaseOrder.getPssReleaseOrder();
        String orderNumber = null != pssReleaseOrder ? pssReleaseOrder.getReleaseOrderNumber() : "";
        String projectNumber = null != pssReleaseOrder ? pssReleaseOrder.getProjectNumber() : "";
        String string = orderText = null != pssReleaseOrder ? pssReleaseOrder.getPlace() : "";
        if (templateCandidate.isEmpty()) {
            String error = this.messageService.get(Message.of((EMessageKey)EMessageKey.NO_CUSTOMER_TEMPLATE_ERROR, List.of(customer.getName())));
            throw new BusinessRuleValidationException(error, List.of());
        }
        ArrayList errorDetails = Lists.newArrayList();
        CustomerTemplate customerTemplate = (CustomerTemplate)templateCandidate.get();
        ECustomerTemplateAlgorithm algorithm = (ECustomerTemplateAlgorithm)MoreObjects.firstNonNull((Object)customerTemplate.getAlgorithm(), (Object)ECustomerTemplateAlgorithm.UNKNOWN);
        Optional<CustomerTemplateExportService> customerTemplateExportServiceOptional = this.customerTemplateExportServices.stream().filter(item -> algorithm == item.algorithm()).findFirst();
        if (customerTemplateExportServiceOptional.isPresent()) {
            CustomerTemplateExportService customerTemplateExportService = customerTemplateExportServiceOptional.get();
            FileStore fileStore = customerTemplate.getFileStore();
            if (null != fileStore) {
                Optional bytesOptional = FileStoreHelper.fetchBytes((FileStore)fileStore);
                if (bytesOptional.isPresent()) {
                    byte[] buffer = (byte[])bytesOptional.get();
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(buffer);){
                        Triple triple;
                        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                            customerTemplateExportService.detailXLS((InputStream)bis, (OutputStream)bos, stage, projectNumber, orderNumber, orderText, measurementPositions);
                            String mediaType = customerTemplateExportService.mediaType();
                            byte[] byteArray = bos.toByteArray();
                            String fileName = this.fileName(fileStore, stage, measurement, customerTemplate);
                            triple = Triple.of((Object)mediaType, (Object)fileName, (Object)byteArray);
                        }
                        return triple;
                    }
                }
                errorDetails.add("no file data associated with customer template");
            } else {
                errorDetails.add("no file associated with customer template");
            }
        } else {
            errorDetails.add("no service for algorithm: " + String.valueOf(algorithm));
        }
        errorDetails.add(0, customer.getName());
        String error = this.messageService.get(Message.of((EMessageKey)EMessageKey.NO_CUSTOMER_TEMPLATE_ERROR, (List)ImmutableList.copyOf((Collection)errorDetails)));
        throw new BusinessRuleValidationException(error, List.of());
    }

    @Nonnull
    private String fileName(@NonNull FileStore fileStore, @NonNull Quotation stage, @NonNull Measurement measurement, @NonNull CustomerTemplate customerTemplate) {
        if (fileStore == null) {
            throw new NullPointerException("fileStore is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (customerTemplate == null) {
            throw new NullPointerException("customerTemplate is marked non-null but is null");
        }
        String fileSuffix = StringUtils.substringAfterLast((String)fileStore.getUploadOriginalFilename(), (String)".");
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String orderNumber = stage.getOrderNumber();
        String costCenter = EmployeeHelper.currentUserCostCenterNotFailing((User)measurement.getAssignedUser(), (LocalDate)measurement.getProjectExecutionStartDate()).map(UserCostCenter::getCostCenter).orElse("");
        String alias = stage.getAlias();
        String fileNamePattern = customerTemplate.getFileNamePattern();
        return MessageFormat.format(fileNamePattern, dateForFile, orderNumber, alias, costCenter, fileSuffix);
    }

    @Nonnull
    private MeasurementPrintBucket measurementPrintBucket(long measurementId) {
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(measurementId));
        Quotation stage = measurement.getQuotation();
        return MeasurementPrintBucket.of((Measurement)measurement, (Quotation)stage, (Quotation)stage);
    }

    @Nonnull
    private ReleaseOrderUpdateBucket bucket(@NonNull Measurement measurement, @NonNull Quotation quotation, @NonNull ReleaseOrderUpdateItem releaseOrderUpdateItem, @NonNull ReleaseOrder releaseOrder) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (releaseOrderUpdateItem == null) {
            throw new NullPointerException("releaseOrderUpdateItem is marked non-null but is null");
        }
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        String randomReferenceId = UUID.randomUUID().toString();
        Long pssReleaseOrderIdRequested = releaseOrderUpdateItem.getPssReleaseOrderId();
        PssReleaseOrder pssReleaseOrder = null != pssReleaseOrderIdRequested ? this.pssHandler.byExternalPssReleaseOrderIdFailing(pssReleaseOrderIdRequested) : null;
        String name = StringUtils.trimToEmpty((String)releaseOrderUpdateItem.getName());
        String orderNumber = StringUtils.trimToEmpty((String)releaseOrderUpdateItem.getOrderNumber());
        return ReleaseOrderUpdateBucket.of((String)name, (String)orderNumber, (String)randomReferenceId, (Measurement)measurement, (Quotation)quotation, (ReleaseOrder)releaseOrder, (PssReleaseOrder)pssReleaseOrder);
    }

    @Nonnull
    private MeasurementCommon mergeAndPersist(@NonNull MeasurementModificationBucket measurementModificationBucket, @NonNull MeasurementPositionsUpdateBucket measurementPositionsUpdateBucket, @NonNull MeasurementTransposedRemarksUpdateBucket measurementTransposedRemarksUpdateBucket) {
        if (measurementModificationBucket == null) {
            throw new NullPointerException("measurementModificationBucket is marked non-null but is null");
        }
        if (measurementPositionsUpdateBucket == null) {
            throw new NullPointerException("measurementPositionsUpdateBucket is marked non-null but is null");
        }
        if (measurementTransposedRemarksUpdateBucket == null) {
            throw new NullPointerException("measurementTransposedRemarksUpdateBucket is marked non-null but is null");
        }
        MeasurementHistorySnapShot measurementHistorySnapShot = this.historyItemRoute.snapShot((Measurement)measurementModificationBucket.getEntity());
        Measurement measurement = (Measurement)measurementModificationBucket.getEntity();
        MeasurementState measurementStateOld = measurement.getMeasurementState();
        EMeasurementState eMeasurementStateOld = measurementStateOld.getMeasurementState();
        EMeasurementType measurementTypeOld = measurement.getMeasurementType();
        Quotation stage = measurementModificationBucket.getQuotation();
        this.ensureSheetNumber(measurement, stage, NO_OP);
        Measurement measurementMerged = this.mapper.mergeMeasurement(measurementModificationBucket);
        List measurementPositions = this.mapper.mergeMeasurementPositions(measurementPositionsUpdateBucket);
        MergedBucket measurementTransposedRemarkMergedBucket = this.mapper.mergeMeasurementTransposedRemarks(measurementTransposedRemarksUpdateBucket);
        this.measurementCalculators.standard().calculateAndApply(measurementMerged);
        this.validators.measurementValidation(measurementModificationBucket).validBeforeUpdate().validate();
        MeasurementState measurementStateNew = measurement.getMeasurementState();
        EMeasurementState eMeasurementStateNew = measurementStateNew.getMeasurementState();
        EMeasurementType measurementTypeNew = measurement.getMeasurementType();
        Iterable measurementsWithSamePSSRO = this.measurementHandler.otherWithPssReleaseOrderInState(measurement, EMeasurementType.PARTIAL, (Iterable)ImmutableSet.of((Object)EMeasurementState.TEMPORARY), 10);
        MeasurementChangeBucket measurementChangeBucket = MeasurementChangeBucket.of((Measurement)measurementMerged, (EMeasurementState)eMeasurementStateOld, (EMeasurementState)eMeasurementStateNew, (EMeasurementType)measurementTypeOld, (EMeasurementType)measurementTypeNew, (Iterable)measurementsWithSamePSSRO);
        this.validators.measurementStateChange(measurementChangeBucket).validate();
        Measurement updatedMeasurement = this.saveAndEmitMessage(measurementChangeBucket);
        Iterable historyItems = this.historyItemRoute.persistChanges(measurementHistorySnapShot, updatedMeasurement);
        this.entityUsageService.update(updatedMeasurement);
        this.entityUsageService.reference(stage);
        return this.mapper.map(updatedMeasurement);
    }

    @Transactional
    public boolean handlePssReleaseOrderUpdate(@NonNull Long referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional pssReleaseOrderCandidate = this.pssHandler.byIdNotFailing(referenceId);
        if (pssReleaseOrderCandidate.isPresent()) {
            String releaseOrderNameCurrent;
            PssReleaseOrder pssReleaseOrder = (PssReleaseOrder)pssReleaseOrderCandidate.get();
            String releaseOrderNamePrevious = pssReleaseOrder.getReleaseOrderNameSelectPrevious();
            if (!StringUtils.equalsIgnoreCase((CharSequence)releaseOrderNamePrevious, (CharSequence)(releaseOrderNameCurrent = pssReleaseOrder.getReleaseOrderNameSelectCurrent()))) {
                Iterable releaseOrders = this.releaseOrderHandler.allByPssReleaseOrderAndName(pssReleaseOrder);
                ImmutableList.Builder measurementsUpdate = ImmutableList.builder();
                for (ReleaseOrder releaseOrder : releaseOrders) {
                    String constructionSite;
                    Measurement measurement = releaseOrder.getMeasurement();
                    String releaseOrderName = StringUtils.trimToEmpty((String)releaseOrder.getName());
                    if (StringUtils.equalsIgnoreCase((CharSequence)releaseOrderName, (CharSequence)(constructionSite = StringUtils.trimToEmpty((String)measurement.getConstructionSite())))) {
                        measurement.setConstructionSite(releaseOrderNameCurrent);
                    }
                    releaseOrder.setName(releaseOrderNameCurrent);
                    measurementsUpdate.add((Object)measurement);
                }
                ImmutableList measurementsUpdated = measurementsUpdate.build();
                for (Measurement measurement : measurementsUpdated) {
                    MeasurementState measurementState = measurement.getMeasurementState();
                    EMeasurementState eMeasurementState = measurementState.getMeasurementState();
                    MeasurementChangeBucket measurementChangeBucket = MeasurementChangeBucket.of((Measurement)measurement, (EMeasurementState)eMeasurementState, (EMeasurementState)eMeasurementState, (EMeasurementType)measurement.getMeasurementType(), (EMeasurementType)measurement.getMeasurementType(), (Iterable)ImmutableList.of());
                    Measurement measurement2 = this.saveAndEmitMessage(measurementChangeBucket, false, false);
                }
            }
            return true;
        }
        return false;
    }

    @Transactional
    @Nonnull
    public MeasurementImportResultListCommon fromFile(@NonNull MultipartFile[] multiPartFiles) {
        if (multiPartFiles == null) {
            throw new NullPointerException("multiPartFiles is marked non-null but is null");
        }
        ImmutableList.Builder measurementXLSImportResultBuilder = ImmutableList.builder();
        for (MultipartFile multipartFile : multiPartFiles) {
            this.handleMultiPart(multipartFile).ifPresent(arg_0 -> ((ImmutableList.Builder)measurementXLSImportResultBuilder).add(arg_0));
        }
        ImmutableList measurementXlsExtractResults = measurementXLSImportResultBuilder.build();
        return this.mapper.map((Iterable)measurementXlsExtractResults);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public MeasurementAvailableStatesCommon availableStates(long measurementId) {
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(measurementId));
        AvailableMeasurementStates availableMeasurementStates = this.measurementService.availableStates(measurement);
        return this.mapper.mapAvailableStates(measurement, availableMeasurementStates);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public MeasurementValidationResponse validate(@NonNull MeasurementValidationRequest validationRequest) {
        if (validationRequest == null) {
            throw new NullPointerException("validationRequest is marked non-null but is null");
        }
        List measurementIds = (List)MoreObjects.firstNonNull((Object)validationRequest.getMeasurementIds(), (Object)ImmutableList.of());
        Iterable measurements = this.measurementHandler.allByIds((Iterable)measurementIds);
        ArrayList validationWarnings = Lists.newArrayList();
        for (Measurement measurement : measurements) {
            List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
            List measurementPositionsToBeValidated = (List)measurementPositions.stream().filter(item -> IterableUtils.contains((Iterable)EPositionType.WAGE_AND_VALUE_TYPES, (Object)item.getPositionType())).collect(ImmutableList.toImmutableList());
            for (MeasurementPosition measurementPosition : measurementPositionsToBeValidated) {
                QuotationPosition quotationPosition = measurementPosition.getQuotationPosition();
                if (null != quotationPosition) {
                    Quotation stage = quotationPosition.getQuotation();
                    if (null != stage) {
                        EQStageType stageType = stage.getStageType();
                        EQStageState stageState = stage.getStageState();
                        boolean accountableType = IterableUtils.contains((Iterable)EQStageType.MEASUREMENT_ACCOUNTABLE_STAGE_TYPES, (Object)stageType);
                        boolean accountableState = IterableUtils.contains((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (Object)stageState);
                        if (accountableType && accountableState) continue;
                        String message = this.messageService.get((Translatable)EMessageKey.RULE_MEASUREMENT_NOT_COMMISSIONED_POSITION_WARNING, new Object[]{measurement.getMeasurementNumber(), measurementPosition.getSurrogatePositionNumber()});
                        validationWarnings.add(Triple.of((Object)measurementPosition, (Object)message, (Object)ImmutableSet.of((Object)EMeasurementValidationFlag.NOT_COMMISSIONED)));
                        continue;
                    }
                    String message = this.messageService.get((Translatable)EMessageKey.RULE_MEASUREMENT_NOT_EXISTING_POSITION_WARNING, new Object[]{measurement.getMeasurementNumber(), measurementPosition.getSurrogatePositionNumber()});
                    validationWarnings.add(Triple.of((Object)measurementPosition, (Object)message, (Object)ImmutableSet.of((Object)EMeasurementValidationFlag.NOT_EXISTING_IN_QUOTATION)));
                    continue;
                }
                String message = this.messageService.get((Translatable)EMessageKey.RULE_MEASUREMENT_NOT_EXISTING_POSITION_WARNING, new Object[]{measurement.getMeasurementNumber(), measurementPosition.getSurrogatePositionNumber()});
                validationWarnings.add(Triple.of((Object)measurementPosition, (Object)message, (Object)ImmutableSet.of((Object)EMeasurementValidationFlag.NOT_EXISTING_IN_QUOTATION)));
            }
        }
        return this.mapper.mapToInvoiceMeasurementValidation((List)validationWarnings);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Pair<String, byte[]> boqXLSCluster35(long id) throws IOException {
        this.userService.checkPrivilege(EPrivilege.MEASUREMENT__BOQ_CLUSTER35_MEASUREMENT_DOWNLOAD_ALLOW);
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(id));
        Quotation quotation = measurement.getQuotation();
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        Iterable boqStream = (Iterable)measurementPositions.stream().map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        try (InputStream fis = FileHelper.fisFromResource(this.getClass(), (String)BOQ_CLUSTER_35_TEMPLATE_PATH);){
            Pair pair;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                XSSFWorkbook template = new XSSFWorkbook(fis);
                XSSFWorkbook sxssfWorkbook = this.billOfQuantitiesMeasurementXlsCluster35ExportService.detailXLS(template, BOQ_CLUSTER_35_MEASUREMENT_SHEET_NAME, measurement.getMeasurementNumber(), boqStream);
                sxssfWorkbook.setActiveSheet(0);
                sxssfWorkbook.write((OutputStream)bos);
                byte[] bytes = bos.toByteArray();
                String dateForFile = this.dateTimeHelperService.dateForFile();
                String quotationNumber = quotation.getQuotationNumber();
                String fileName = this.messageService.get((Translatable)EExportFileName.QUOTATION__BOQ_MEASUREMENT_TEMPLATE_AS_XLSX, new Object[]{dateForFile, quotationNumber});
                pair = Pair.of((Object)fileName, (Object)bytes);
            }
            return pair;
        }
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Pair<String, byte[]> boqXLSSubContractor(long id) throws IOException {
        this.userService.checkPrivilege(EPrivilege.QUOTATION__BOQ_MEASUREMENT_DOWNLOAD_ALLOW);
        Measurement measurement = (Measurement)this.measurementHandler.byIdFailing(Long.valueOf(id));
        Quotation stage = measurement.getQuotation();
        Map allPositions = this.stageHandler.allPositionStages(stage, ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE, true);
        Stream<BillOfQuantitiesMeasurementExport> boqStream = allPositions.values().stream().flatMap(Streams::stream).sorted(QuotationPositionGroupingLevelComparator.of((boolean)true)).map(arg_0 -> this.map(arg_0));
        try (InputStream fis = FileHelper.fisFromResource(this.getClass(), (String)"/xls/BillOfQuantities_Measurement_XLS_Template.xlsx");){
            Pair pair;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                String companyName = this.companyConfig.getCompanyName();
                XSSFWorkbook template = new XSSFWorkbook(fis);
                XSSFWorkbook sxssfWorkbook = this.billOfQuantitiesMeasurementXlsSubContractorExportService.detailXLS(template, companyName, "Aufmass", "Positionen", measurement, boqStream);
                sxssfWorkbook.setActiveSheet(0);
                sxssfWorkbook.write((OutputStream)bos);
                byte[] bytes = bos.toByteArray();
                String dateForFile = this.dateTimeHelperService.dateForFile();
                String qNUmber = stage.getQNumber();
                String fileName = this.messageService.get((Translatable)EExportFileName.QUOTATION__BOQ_MEASUREMENT_TEMPLATE_AS_XLSX, new Object[]{dateForFile, qNUmber});
                pair = Pair.of((Object)fileName, (Object)bytes);
            }
            return pair;
        }
    }

    @Transactional
    @Nonnull
    public MeasurementPatchResponse patchAccountingMonthPlanned(@NonNull MeasurementPatchRequest patchRequest) {
        if (patchRequest == null) {
            throw new NullPointerException("patchRequest is marked non-null but is null");
        }
        Set measurementIds = patchRequest.getMeasurementIds();
        Object value = patchRequest.getValue();
        if (value instanceof LocalDate || value instanceof String) {
            LocalDate referenceDate;
            if (value instanceof String) {
                String valueAsString = (String)value;
                referenceDate = LocalDate.parse(valueAsString, DateTimeFormatter.ISO_LOCAL_DATE);
            } else {
                referenceDate = (LocalDate)value;
            }
            ImmutableList.Builder successIDsBuilder = ImmutableList.builder();
            Iterable allMeasurements = this.measurementHandler.byIdsFailing((Iterable)measurementIds);
            for (Measurement measurement : allMeasurements) {
                measurement.setAccountingMonthPlanned(referenceDate);
                MeasurementChangeBucket measurementChangeBucket = MeasurementChangeBucket.of((Measurement)measurement, (EMeasurementState)measurement.getMeasurementState().getMeasurementState(), (EMeasurementState)measurement.getMeasurementState().getMeasurementState(), (EMeasurementType)measurement.getMeasurementType(), (EMeasurementType)measurement.getMeasurementType(), (Iterable)ImmutableList.of());
                Measurement measurementUpdated = this.saveAndEmitMessage(measurementChangeBucket, false, true);
                successIDsBuilder.add((Object)measurementUpdated.getId());
            }
            ImmutableList successIds = successIDsBuilder.build();
            return MeasurementPatchResponse.of((boolean)true, (List)successIds);
        }
        return MeasurementPatchResponse.of((boolean)true, (List)ImmutableList.of());
    }

    @Transactional
    @Nonnull
    public MeasurementPatchResponse patchRemarksInternal(@NonNull MeasurementPatchRequest patchRequest) {
        if (patchRequest == null) {
            throw new NullPointerException("patchRequest is marked non-null but is null");
        }
        Set measurementIds = patchRequest.getMeasurementIds();
        Object value = patchRequest.getValue();
        if (value instanceof String) {
            String valueAsString = (String)value;
            ImmutableList.Builder successIDsBuilder = ImmutableList.builder();
            Iterable allMeasurements = this.measurementHandler.byIdsFailing((Iterable)measurementIds);
            for (Measurement measurement : allMeasurements) {
                measurement.setRemarksInternal(valueAsString);
                MeasurementChangeBucket measurementChangeBucket = MeasurementChangeBucket.of((Measurement)measurement, (EMeasurementState)measurement.getMeasurementState().getMeasurementState(), (EMeasurementState)measurement.getMeasurementState().getMeasurementState(), (EMeasurementType)measurement.getMeasurementType(), (EMeasurementType)measurement.getMeasurementType(), (Iterable)ImmutableList.of());
                Measurement measurementUpdated = this.saveAndEmitMessage(measurementChangeBucket, false, true);
                successIDsBuilder.add((Object)measurementUpdated.getId());
            }
            ImmutableList successIds = successIDsBuilder.build();
            return MeasurementPatchResponse.of((boolean)true, (List)successIds);
        }
        return MeasurementPatchResponse.of((boolean)true, (List)ImmutableList.of());
    }

    @Nonnull
    private BillOfQuantitiesMeasurementExport map(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BillOfQuantitiesMeasurementExport boq = new BillOfQuantitiesMeasurementExport();
        boq.setUnit(measurementPosition.getUnit());
        boq.setShortText(measurementPosition.getShortText());
        boq.setSurrogatePositionNumber(measurementPosition.getSurrogatePositionNumber());
        boq.setPricePerUnit(measurementPosition.getPricePerUnit());
        boq.setRemarks(measurementPosition.getRemarks());
        boq.setPriceAggregated(measurementPosition.getPriceAggregated());
        boq.setProduct(measurementPosition.getProduct());
        boq.setDiscount(BigDecimal.ZERO);
        return boq;
    }

    @Nonnull
    private BillOfQuantitiesMeasurementExport map(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        BillOfQuantitiesMeasurementExport boq = new BillOfQuantitiesMeasurementExport();
        boq.setUnit(quotationPosition.getUnit());
        boq.setShortText(quotationPosition.getShortText());
        boq.setSurrogatePositionNumber(quotationPosition.getSurrogatePositionNumber());
        boq.setPricePerUnit(quotationPosition.getPricePerUnit());
        boq.setRemarks(quotationPosition.getRemarks());
        boq.setPriceAggregated(quotationPosition.getPriceAggregated());
        boq.setProduct(quotationPosition.getOrderedAmount());
        boq.setDiscount(BigDecimal.ZERO);
        return boq;
    }

    @Nonnull
    private Optional<MeasurementXlsImportResult> handleMultiPart(@NonNull MultipartFile multiPartFile) {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        try {
            String originalFilename = StringUtils.trimToEmpty((String)multiPartFile.getOriginalFilename());
            byte[] fileContent = multiPartFile.getBytes();
            Optional measurementXLSImportResultCandidate = this.measurementXLSImportService.handleMultiPart(fileContent);
            LinkedHashSet importErrors = Sets.newLinkedHashSet();
            if (measurementXLSImportResultCandidate.isPresent()) {
                User user;
                MeasurementXlsExtractResult measurementXlsExtractResult = (MeasurementXlsExtractResult)measurementXLSImportResultCandidate.get();
                String quotationNumber = measurementXlsExtractResult.getQuotationNumber();
                Integer stageVersion = measurementXlsExtractResult.getStageVersion();
                Integer personalNumber = measurementXlsExtractResult.getPersonalNumber();
                if (null != personalNumber) {
                    Optional userCandidate = this.userHandler.byPersonalNumberNotFailing(personalNumber);
                    if (userCandidate.isPresent()) {
                        if (personalNumber == 0) {
                            importErrors.add(String.format("Mitarbeiter mit Personalnummer: '%s' wird verwendet, ist das korrekt?", personalNumber));
                        }
                        user = (User)userCandidate.get();
                    } else {
                        importErrors.add(String.format("Mitarbeiter mit Personalnummer: '%s' nicht gefunden, verwende angemeldeten Mitarbeiter", personalNumber));
                        user = this.userService.authenticatedUser();
                    }
                } else {
                    importErrors.add("Keine Personalnummer angegeben:, verwende angemeldeten Mitarbeiter");
                    user = this.userService.authenticatedUser();
                }
                Quotation primaryStage = this.stageHandler.firstByQuotationNumberFailing(quotationNumber, stageVersion);
                List quotations = this.stageHandler.allQuotationsByQuotationNumberFailing(primaryStage);
                ImmutableList allPositions = (ImmutableList)quotations.stream().flatMap(item -> ((Collection)MoreObjects.firstNonNull((Object)item.getQuotationPositions(), (Object)ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList());
                Map positionsByPosNr = MapsHelper.mapFirst((Iterable)allPositions, QuotationPosition::getPositionNumber);
                Map positionsBySPN = MapsHelper.mapFirst((Iterable)allPositions, QuotationPosition::getSurrogatePositionNumber);
                AtomicInteger sequenceNumberStandard = new AtomicInteger(1);
                Iterable positions = measurementXlsExtractResult.getPositions();
                ImmutableList.Builder measurementPositionBuilder = ImmutableList.builder();
                for (MeasurementXLSImportRow position : positions) {
                    QuotationPosition quotationPosition;
                    String positionNumber = position.getPositionNumber();
                    BigDecimal amount = position.getAmount();
                    BigDecimal factor1 = position.getFactor1();
                    BigDecimal factor2 = position.getFactor2();
                    BigDecimal factor3 = position.getFactor3();
                    String remarks = StringUtils.trimToEmpty((String)position.getRemarks());
                    String asIsShortText = StringUtils.trimToEmpty((String)position.getShortText());
                    BigDecimal asIsProduct = (BigDecimal)MoreObjects.firstNonNull((Object)position.getProduct(), (Object)BigDecimal.ZERO);
                    BigDecimal asIsPricePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)position.getPricePerUnit(), (Object)BigDecimal.ZERO);
                    BigDecimal asIsPriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)position.getPricePerAggregated(), (Object)BigDecimal.ZERO);
                    if (StringUtils.isBlank((CharSequence)positionNumber)) continue;
                    QuotationPosition quotationPositionBySPN = (QuotationPosition)positionsBySPN.get(positionNumber);
                    QuotationPosition quotationPosition2 = quotationPosition = null == quotationPositionBySPN ? (QuotationPosition)positionsByPosNr.get(positionNumber) : quotationPositionBySPN;
                    if (null != quotationPosition) {
                        BigDecimal expectedPriceAggregated;
                        BigDecimal expectedPricePerUnit;
                        BigDecimal expectedProduct;
                        Optional jumboPositionCandidate = StageHelper.determineJumboPosition((QuotationPosition)quotationPosition);
                        MeasurementPosition measurementPosition2 = this.entityFactory.measurementPosition();
                        measurementPosition2.setAmount(amount);
                        measurementPosition2.setFactor1(factor1);
                        measurementPosition2.setFactor2(factor2);
                        measurementPosition2.setFactor3(factor3);
                        measurementPosition2.setRemarks(remarks);
                        measurementPosition2.setAccountingMonth(DateTimeHelper.thisMonth());
                        measurementPosition2.setSequenceNumberMeasurementStandard(Integer.valueOf(sequenceNumberStandard.getAndIncrement()));
                        measurementPosition2.setSequenceNumberMeasurementTransposed(Integer.valueOf(0));
                        measurementPosition2.setSequenceNumberInvoice(Integer.valueOf(0));
                        String expectedShortText = quotationPosition.getShortText();
                        if (!StringUtils.equalsIgnoreCase((CharSequence)asIsShortText, (CharSequence)expectedShortText)) {
                            importErrors.add(String.format("Kurztext der Position: '%s' stimmt nicht \u00fcberein: %s <-> %s", positionNumber, asIsShortText, expectedShortText));
                        }
                        if ((expectedProduct = ProductCalculatorHelper.product((BigDecimal)amount, (BigDecimal)factor1, (BigDecimal)factor2, (BigDecimal)factor3)).compareTo(asIsProduct) != 0) {
                            importErrors.add(String.format("Produkt der Position '%s' stimmt nicht \u00fcberein: %s <-> %s", positionNumber, expectedProduct, asIsProduct));
                        }
                        if ((expectedPricePerUnit = quotationPosition.getPricePerUnit().setScale(2, RoundingMode.HALF_UP)).compareTo(asIsPricePerUnit) != 0) {
                            importErrors.add(String.format("EP der Position: '%s' stimmt nicht \u00fcberein: %s <-> %s", positionNumber, asIsPricePerUnit, expectedPricePerUnit));
                        }
                        if ((expectedPriceAggregated = expectedProduct.multiply(expectedPricePerUnit).setScale(2, RoundingMode.HALF_UP)).compareTo(asIsPriceAggregated) != 0) {
                            importErrors.add(String.format("GP der Position: '%s' stimmt nicht \u00fcberein: %s <-> %s", positionNumber, asIsPriceAggregated, expectedPriceAggregated));
                        }
                        MeasurementPosition measurementPositionMerged = this.measurementPositionMapper.mergeQuotationPositionIntoMeasurementPosition(measurementPosition2, quotationPosition, (QuotationPosition)jumboPositionCandidate.orElse(null));
                        measurementPositionBuilder.add((Object)measurementPositionMerged);
                        continue;
                    }
                    importErrors.add(String.format("Aufma\u00dfposition mit Positionsnummer: '%s' nicht gefunden", positionNumber));
                }
                ImmutableList measurementPositions = measurementPositionBuilder.build();
                Measurement measurement = this.entityFactory.measurement(EMeasurementOrigin.QUANTE_V2);
                String measurementNumber = this.measurementService.determineNextMeasurementNumber();
                MeasurementHistorySnapShot measurementHistorySnapShot1 = this.historyItemRoute.snapShot(measurement);
                measurement.setMeasurementNumber(measurementNumber);
                measurement.setQuotation(primaryStage);
                measurement.setAssignedUser(user);
                ReleaseOrder releaseOrder = this.entityFactory.releaseOrder();
                releaseOrder.setMeasurement(measurement);
                releaseOrder.setName(measurementXlsExtractResult.getReleaseOrder());
                measurement.setMeasurementType(EMeasurementType.PARTIAL);
                measurement.setMeasurementViewType(EMeasurementViewType.STANDARD);
                measurement.setCostUnitCEViewMode(ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE);
                this.measurementService.switchMeasurementState(measurement, EMeasurementState.TEMPORARY, EMeasurementStateReason.XLS_UPLOAD);
                measurement.setReleaseOrder(releaseOrder);
                measurement.setConstructionSite(measurementXlsExtractResult.getConstructionSite());
                measurement.setProjectExecutionStartDate(measurementXlsExtractResult.getProjectExecutionStart());
                measurement.setProjectExecutionEndDate(measurementXlsExtractResult.getProjectExecutionEnd());
                measurement.setRemarks(measurementXlsExtractResult.getRemarks());
                LocalDate safeProjectExecutionStart = (LocalDate)MoreObjects.firstNonNull((Object)measurementXlsExtractResult.getProjectExecutionStart(), (Object)DateTimeHelper.today());
                measurement.setAccountingMonth(YearMonth.from(safeProjectExecutionStart).atDay(1));
                measurement.setAccountingMonthPlanned(YearMonth.from(safeProjectExecutionStart).atDay(1));
                measurement.setMeasurementPositions((List)ImmutableList.copyOf((Iterable)measurementPositions));
                measurementPositions.forEach(measurementPosition -> measurementPosition.setMeasurement(measurement));
                this.measurementCalculators.standard().calculateAndApply(measurement);
                String importErrorText = StringUtils.left((String)IMPORT_ERROR_JOINER.join((Iterable)importErrors), (int)2000);
                measurement.setImportErrors(importErrorText);
                measurement.setImportFileName(originalFilename);
                Measurement measurementUpdated = (Measurement)this.measurementHandler.update((EntityBase)measurement);
                Iterable historyItems = this.historyItemRoute.persistChanges(measurementHistorySnapShot1, measurementUpdated);
                return Optional.of(MeasurementXlsImportResult.of((String)originalFilename, (MeasurementXlsExtractResult)measurementXlsExtractResult, (Measurement)measurementUpdated, (Quotation)primaryStage, (User)user, (Iterable)ImmutableList.copyOf((Collection)importErrors)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    @Nonnull
    String fileName(@NonNull MeasurementPrintBucket measurementPrintBucket, @NonNull EMeasurementPrintTemplate eMeasurementPrintTemplate, @NonNull EPrintFontSize printFontSize) {
        if (measurementPrintBucket == null) {
            throw new NullPointerException("measurementPrintBucket is marked non-null but is null");
        }
        if (eMeasurementPrintTemplate == null) {
            throw new NullPointerException("eMeasurementPrintTemplate is marked non-null but is null");
        }
        if (printFontSize == null) {
            throw new NullPointerException("printFontSize is marked non-null but is null");
        }
        Measurement measurement = measurementPrintBucket.getMeasurement();
        Quotation quotation = measurementPrintBucket.getQuotation();
        String measurementNumber = measurement.getMeasurementNumber();
        String quotationNumber = quotation.getQuotationNumber();
        Long addendumNumber = quotation.getAddendumNumber();
        String quotationPart = String.format("%s_%s", quotationNumber, addendumNumber);
        String templatePart = eMeasurementPrintTemplate.name();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        return this.messageService.getDE((Translatable)EExportFileName.MEASUREMENT_AS_PDF, new Object[]{dateForFile, measurementNumber, quotationPart, templatePart});
    }

    void checkCurrentUserIsAllowedToOpen(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (this.applicationConfig.isRestrictMeasurementAccessEnabled()) {
            boolean allowed;
            User authenticatedUser = this.userService.authenticatedUser();
            boolean bl = allowed = this.userService.hasPrivilege(EPrivilege.ACCESS_MEASUREMENT_ALL) || this.userService.hasPrivilege(EPrivilege.OP_MEASUREMENT_CREATE) && measurement.getCreatedByUser() == authenticatedUser || measurement.getAssignedUser() == authenticatedUser;
            if (!allowed) {
                Long id = measurement.getId();
                String measurementNumber = measurement.getMeasurementNumber();
                String message = String.format("User is not allowed to open Measurement (Number: %s, Id: %s)", measurementNumber, id);
                throw new EntityAccessRestrictionException(message, EEntityClass.MEASUREMENT, id, measurementNumber);
            }
        }
    }

    @Nonnull
    public synchronized Long determineNextMeasurementSheetNumber(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        MeasurementSheetNumber measurementSheetNumber = this.measurementSheetNumberHandler.byStage(stage).orElseGet(() -> this.entityFactory.measurementSheetNumber(stage));
        Long currentNumber = (Long)MoreObjects.firstNonNull((Object)measurementSheetNumber.getSheetNumberValue(), (Object)0L);
        Long nextNumber = 1L + currentNumber;
        measurementSheetNumber.setSheetNumberValue(nextNumber);
        MeasurementSheetNumber measurementSheetNumberUpdated = (MeasurementSheetNumber)this.measurementSheetNumberHandler.update((EntityBase)measurementSheetNumber);
        return measurementSheetNumberUpdated.getSheetNumberValue();
    }

    private Long ensureSheetNumber(@NonNull Measurement measurement, @NonNull Quotation stage, @NonNull Consumer<Long> sheetNumberConsumer) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (sheetNumberConsumer == null) {
            throw new NullPointerException("sheetNumberConsumer is marked non-null but is null");
        }
        Long sheetNumberValue = (Long)MoreObjects.firstNonNull((Object)measurement.getSheetNumberValue(), (Object)0L);
        if (sheetNumberValue < 1L) {
            Long sheetNumberValueNew = this.determineNextMeasurementSheetNumber(stage);
            measurement.setSheetNumberValue(sheetNumberValueNew);
            sheetNumberConsumer.accept(sheetNumberValueNew);
        }
        return measurement.getSheetNumberValue();
    }

    public MeasurementRouteImpl(EntityFactory entityFactory, CompanyConfig companyConfig, ConfigurationCompanyHandler configurationCompanyHandler, ApplicationEventPublisher applicationEventPublisher, ApplicationConfig applicationConfig, BillOfQuantitiesMeasurementXlsCluster35ExportService billOfQuantitiesMeasurementXlsCluster35ExportService, BillOfQuantitiesMeasurementXlsSubContractorExportService billOfQuantitiesMeasurementXlsSubContractorExportService, CsvExportService csvExportService, DateTimeHelperService dateTimeHelperService, EntityUsageService entityUsageService, GaebD11ExportService gaebD11ExportService, GaebX31ExportService gaebX31ExportService, MeasurementMapper mapper, MeasurementPositionMapper measurementPositionMapper, ReleaseOrderMapper releaseOrderMapper, MeasurementHandler measurementHandler, MeasurementSheetNumberHandler measurementSheetNumberHandler, MeasurementService measurementService, MeasurementXlsExportService measurementXlsExportService, MeasurementXlsImportService measurementXLSImportService, StageHandler stageHandler, MeasurementUpdateRequestValidator measurementUpdateRequestValidator, Validators validators, HistoryItemRoute historyItemRoute, MeasurementPrintMapper measurementPrintMapper, ReleaseOrderHandler releaseOrderHandler, PssHandler pssHandler, QueueService queueService, UserHandler userHandler, UserService userService, CustomerTemplateHandler customerTemplateHandler, PdfRoute pdfRoute, MeasurementCalculators measurementCalculators, MessageService messageService, List<CustomerTemplateExportService> customerTemplateExportServices) {
        this.entityFactory = entityFactory;
        this.companyConfig = companyConfig;
        this.configurationCompanyHandler = configurationCompanyHandler;
        this.applicationEventPublisher = applicationEventPublisher;
        this.applicationConfig = applicationConfig;
        this.billOfQuantitiesMeasurementXlsCluster35ExportService = billOfQuantitiesMeasurementXlsCluster35ExportService;
        this.billOfQuantitiesMeasurementXlsSubContractorExportService = billOfQuantitiesMeasurementXlsSubContractorExportService;
        this.csvExportService = csvExportService;
        this.dateTimeHelperService = dateTimeHelperService;
        this.entityUsageService = entityUsageService;
        this.gaebD11ExportService = gaebD11ExportService;
        this.gaebX31ExportService = gaebX31ExportService;
        this.mapper = mapper;
        this.measurementPositionMapper = measurementPositionMapper;
        this.releaseOrderMapper = releaseOrderMapper;
        this.measurementHandler = measurementHandler;
        this.measurementSheetNumberHandler = measurementSheetNumberHandler;
        this.measurementService = measurementService;
        this.measurementXlsExportService = measurementXlsExportService;
        this.measurementXLSImportService = measurementXLSImportService;
        this.stageHandler = stageHandler;
        this.measurementUpdateRequestValidator = measurementUpdateRequestValidator;
        this.validators = validators;
        this.historyItemRoute = historyItemRoute;
        this.measurementPrintMapper = measurementPrintMapper;
        this.releaseOrderHandler = releaseOrderHandler;
        this.pssHandler = pssHandler;
        this.queueService = queueService;
        this.userHandler = userHandler;
        this.userService = userService;
        this.customerTemplateHandler = customerTemplateHandler;
        this.pdfRoute = pdfRoute;
        this.measurementCalculators = measurementCalculators;
        this.messageService = messageService;
        this.customerTemplateExportServices = customerTemplateExportServices;
    }
}

