/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.primitives.Longs;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.request.invoice.InvoiceAccountRequest;
import de.qfm.erp.common.request.invoice.InvoiceCancelRequest;
import de.qfm.erp.common.request.invoice.InvoiceModificationRequest;
import de.qfm.erp.common.request.invoice.InvoicePositionCustomUpdateItem;
import de.qfm.erp.common.request.invoice.InvoicePositionMeasurementUpdateItem;
import de.qfm.erp.common.request.invoice.InvoicePositionUpdateItem;
import de.qfm.erp.common.request.invoice.InvoiceSupplementUpdateItem;
import de.qfm.erp.common.request.invoice.InvoiceUpdateRequest;
import de.qfm.erp.common.response.invoice.ClosingInvoiceListCommon;
import de.qfm.erp.common.response.invoice.CreditVoucherImportResultListCommon;
import de.qfm.erp.common.response.invoice.InvoiceAttachmentListCommon;
import de.qfm.erp.common.response.invoice.InvoiceCommon;
import de.qfm.erp.common.response.invoice.InvoiceMeasurementAutoCompleteResponse;
import de.qfm.erp.common.response.invoice.InvoicePageCommon;
import de.qfm.erp.common.response.invoice.NewInvoiceAutoCompleteResponse;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.configuration.EnaioConfig;
import de.qfm.erp.service.configuration.FileStoreConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.FileStoreHelper;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.exception.request.MissingPrivilegeException;
import de.qfm.erp.service.model.exception.response.PDFGenerationException;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.dms.InvoiceDMSBucket;
import de.qfm.erp.service.model.internal.dms.InvoiceDMSResult;
import de.qfm.erp.service.model.internal.dms.InvoiceFileStoreBucket;
import de.qfm.erp.service.model.internal.dms.InvoiceFileStoreResult;
import de.qfm.erp.service.model.internal.eventbus.InvoiceChangeMessage;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.history.MeasurementHistorySnapShot;
import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.invoice.CreditVoucherImportResult;
import de.qfm.erp.service.model.internal.invoice.CumulativePrintBucket;
import de.qfm.erp.service.model.internal.invoice.EEndOfDayType;
import de.qfm.erp.service.model.internal.invoice.EImportResultType;
import de.qfm.erp.service.model.internal.invoice.EInvoiceSortOption;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.invoice.InvoicePdfExtraction;
import de.qfm.erp.service.model.internal.invoice.InvoicePositionUpdateBucket;
import de.qfm.erp.service.model.internal.invoice.InvoicePositionsUpdateBucket;
import de.qfm.erp.service.model.internal.invoice.InvoiceSupplementUpdateBucket;
import de.qfm.erp.service.model.internal.invoice.InvoiceUpdateBucket;
import de.qfm.erp.service.model.internal.invoice.InvoiceValidationBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionsUpdateBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.EExportFileName;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePrintConfiguration;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementCumulativePrintInfo;
import de.qfm.erp.service.model.internal.print.payroll.MeasurementCumulativePrintConfiguration;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceOutputBucket;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceAttachmentType;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceExportState;
import de.qfm.erp.service.model.jpa.invoice.EInvoicePositionType;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAttachment;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.measurement.InvoiceMeasurement;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementStateReason;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.invoice.InvoiceCalculators;
import de.qfm.erp.service.service.calculator.measurement.MeasurementCalculators;
import de.qfm.erp.service.service.handler.AddressHandler;
import de.qfm.erp.service.service.handler.ConfigurationCompanyHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.FileStoreHandler;
import de.qfm.erp.service.service.handler.InvoiceAttachmentHandler;
import de.qfm.erp.service.service.handler.InvoiceHandler;
import de.qfm.erp.service.service.handler.InvoiceSupplementHandler;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.TaxKeyHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.FileStoreMapper;
import de.qfm.erp.service.service.mapper.InvoiceMapper;
import de.qfm.erp.service.service.mapper.InvoicePrintMapper;
import de.qfm.erp.service.service.mapper.MeasurementCumulativePrintMapper;
import de.qfm.erp.service.service.mapper.MeasurementMapper;
import de.qfm.erp.service.service.route.ER2Route;
import de.qfm.erp.service.service.route.HistoryItemRoute;
import de.qfm.erp.service.service.route.InvoiceRoute;
import de.qfm.erp.service.service.route.impl.InvoiceRouteImpl;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.DMSService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.FileStoreService;
import de.qfm.erp.service.service.service.InvoiceService;
import de.qfm.erp.service.service.service.MeasurementService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.StageHelperService;
import de.qfm.erp.service.service.service.pdf.ImageToPdfConverter;
import de.qfm.erp.service.service.service.pdf.PdfExtractor;
import de.qfm.erp.service.service.service.pdf.ZugferdService;
import de.qfm.erp.service.service.service.print.InvoicePrintService;
import de.qfm.erp.service.service.service.print.MeasurementCumulativePrintService;
import de.qfm.erp.service.service.service.print.PDFHelperService;
import de.qfm.erp.service.service.service.xls.EndOfDayXlsExportService;
import de.qfm.erp.service.service.validator.Validators;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InvoiceRouteImpl
implements InvoiceRoute {
    private static final Logger log = LogManager.getLogger(InvoiceRouteImpl.class);
    static final BigDecimal DEFAULT_FIX_POSITION_VALUE = BigDecimal.valueOf(0.01);
    static final BigDecimal DEFAULT_MAX_VALUE_DIFF = BigDecimal.valueOf(2.0);
    static final int INVOICE_DMS_STORE__PUSH_SIZE = 3;
    static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange((char)'0', (char)'9').precomputed();
    static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    static final Joiner ID_JOINER = Joiner.on((String)",").skipNulls();
    static final Joiner POSITION_ID_ERROR_MSG_JOINER = Joiner.on((String)", ").skipNulls();
    static final Splitter CLOSING_INVOICE_IDS_SPLITTER = Splitter.on((char)',').trimResults();
    static final Splitter INVOICE_ATTACHMENT_IDS_SPLITTER = Splitter.on((char)',').trimResults();
    private static final Set<EInvoiceState> DMS_PUSH__INVOICE_STATES = ImmutableSet.of((Object)EInvoiceState.ACCOUNTED, (Object)EInvoiceState.CANCELLED);
    private static final Set<EInvoiceState> STORE_PUSH__INVOICE_STATES = ImmutableSet.of((Object)EInvoiceState.ACCOUNTED, (Object)EInvoiceState.CANCELLED);
    static final Set<EInvoiceType> CUMULATIVE_INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.PARTIAL_INVOICE, (Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceType.FINAL_INVOICE);
    static final Set<EInvoiceType> ALLOWED_CLOSING_INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceType.FINAL_INVOICE);
    static final Set<EInvoiceState> INVOICE_DELETABLE_STATES = ImmutableSet.of((Object)EInvoiceState.IN_ACCOUNTING);
    static final Set<EInvoiceType> INVOICE_CANCELLATION__VOUCHER_CREATE_INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.PARTIAL_INVOICE, (Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceType.FINAL_INVOICE, (Object)EInvoiceType.INVOICE);
    static final Set<EInvoiceType> END_OF_DAY_EXTERNAL__INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.INTERNAL_VOUCHER, (Object)EInvoiceType.PARTIAL_INVOICE, (Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceType.FINAL_INVOICE, (Object)EInvoiceType.INVOICE);
    static final Set<EInvoiceType> END_OF_DAY_INTERNAL__INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.INTERNAL_INVOICE);
    static final Set<EInvoiceType> DMS_PUSH__INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.CREDIT_VOUCHER, (Object)EInvoiceType.INTERNAL_INVOICE, (Object)EInvoiceType.INTERNAL_VOUCHER, (Object)EInvoiceType.PARTIAL_INVOICE, (Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceType.FINAL_INVOICE, (Object[])new EInvoiceType[]{EInvoiceType.INVOICE});
    static final Set<EInvoiceType> STORE_PUSH__INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.CREDIT_VOUCHER, (Object)EInvoiceType.CUSTOMER_VOUCHER, (Object)EInvoiceType.INTERNAL_VOUCHER, (Object)EInvoiceType.PARTIAL_INVOICE, (Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceType.FINAL_INVOICE, (Object[])new EInvoiceType[]{EInvoiceType.PARTIAL_CUMULATIVE_INVOICE, EInvoiceType.FINAL_CUMULATIVE_INVOICE, EInvoiceType.CUMULATIVE_INVOICE, EInvoiceType.INVOICE, EInvoiceType.INTERNAL_INVOICE});
    static final Consumer<Invoice> NO_OP = x -> {};
    private final EnaioConfig enaioConfig;
    private final FileStoreConfig fileStoreConfig;
    private final StageHelperService stageHelperService;
    private final InvoiceAttachmentHandler invoiceAttachmentHandler;
    private final InvoiceSupplementHandler invoiceSupplementHandler;
    private ApplicationEventPublisher applicationEventPublisher;
    private final ApplicationConfig applicationConfig;
    private final ConfigService configService;
    private final DateTimeHelperService dateTimeHelperService;
    private final EntityFactory entityFactory;
    private final MessageService messageService;
    private final FileStoreHandler fileStoreHandler;
    private final FileStoreMapper fileStoreMapper;
    private final InvoiceMapper mapper;
    private final InvoiceHandler handler;
    private final ConfigurationCompanyHandler configurationCompanyHandler;
    private final MeasurementMapper measurementMapper;
    private final TaxKeyHandler taxKeyHandler;
    private final InvoiceService service;
    private final InvoiceCalculators invoiceCalculators;
    private final InvoicePrintService invoicePrintService;
    private final InvoicePrintMapper invoicePrintMapper;
    private final MeasurementCumulativePrintMapper measurementCumulativePrintMapper;
    private final MeasurementCumulativePrintService measurementCumulativePrintService;
    private final MeasurementCalculators measurementCalculators;
    private final MeasurementService measurementService;
    private final StageHandler stageHandler;
    private final UserService userService;
    private final DMSService dmsService;
    private final FileStoreService fileStoreService;
    private final EndOfDayXlsExportService endOfDayXlsService;
    private final ZugferdService zugferdService;
    private final Validators validators;
    private final AddressHandler addressHandler;
    private final MeasurementHandler measurementHandler;
    private final UserHandler userHandler;
    private final PdfExtractor pdfExtractor;
    private final ER2Route er2Route;
    private final PDFHelperService pdfHelperService;
    private final HistoryItemRoute historyItemRoute;
    private final ImageToPdfConverter imageToPdfConverter;
    private static final Iterable<EInvoiceType> CREDIT_VOUCHER_INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.CREDIT_VOUCHER);

    @Nonnull
    @Transactional(readOnly=true)
    public InvoiceCommon byId(long invoiceId) {
        this.validateReadAccess();
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(invoiceId));
        Function closedInvoiceFN = this.closedInvoiceFN(invoice);
        return this.mapper.map(invoice, closedInvoiceFN);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public InvoicePageCommon page(int page, int size, @NonNull String filterText, @Nullable LocalDate invoiceDateFrom, @Nullable LocalDate invoiceDateTo, @Nullable LocalDate postingDateFrom, @Nullable LocalDate postingDateTo, @Nullable LocalDate updatedOnDateFrom, @Nullable LocalDate updatedOnDateTo, @Nullable Boolean filterER2Downloaded, boolean optionEndOfDay, @NonNull String endOfDayTypeCand, @Nullable LocalDate endOfDayDate, @NonNull String filterInvoiceStateCandidate, @Nullable Long filterStageId, @Nullable Long filterPrimaryResponsibleUserId, @NonNull String sortOptionCandidate) {
        LocalDate postingDateToFinal;
        LocalDate postingDateFromFinal;
        LocalDate cancellationDatePeriodToFinal;
        LocalDate cancellationDatePeriodFromFinal;
        LocalDate invoiceStateChangeSinceTo;
        LocalDate invoiceStateChangeSinceFrom;
        Set invoiceTypes;
        Object invoiceStates;
        boolean anyManualFilterSet;
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (endOfDayTypeCand == null) {
            throw new NullPointerException("endOfDayTypeCand is marked non-null but is null");
        }
        if (filterInvoiceStateCandidate == null) {
            throw new NullPointerException("filterInvoiceStateCandidate is marked non-null but is null");
        }
        if (sortOptionCandidate == null) {
            throw new NullPointerException("sortOptionCandidate is marked non-null but is null");
        }
        this.validateReadAccess();
        EEndOfDayType endOfDayType = EEndOfDayType.lookup((String)endOfDayTypeCand, (EEndOfDayType)EEndOfDayType.NONE);
        boolean bl = anyManualFilterSet = StringUtils.isNotBlank((CharSequence)filterText) || null != invoiceDateFrom || null != invoiceDateTo;
        if (optionEndOfDay && EEndOfDayType.DAY == endOfDayType) {
            invoiceStates = ImmutableSet.of((Object)EInvoiceState.ACCOUNTED, (Object)EInvoiceState.CANCELLED);
            invoiceTypes = END_OF_DAY_EXTERNAL__INVOICE_TYPES;
            invoiceStateChangeSinceFrom = (LocalDate)MoreObjects.firstNonNull((Object)endOfDayDate, (Object)DateTimeHelper.today());
            invoiceStateChangeSinceTo = (LocalDate)MoreObjects.firstNonNull((Object)endOfDayDate, (Object)DateTimeHelper.today());
            cancellationDatePeriodFromFinal = null;
            cancellationDatePeriodToFinal = null;
            postingDateFromFinal = postingDateFrom;
            postingDateToFinal = postingDateTo;
        } else if (optionEndOfDay && EEndOfDayType.MONTH == endOfDayType) {
            invoiceStates = ImmutableSet.of((Object)EInvoiceState.ACCOUNTED, (Object)EInvoiceState.CANCELLED);
            invoiceTypes = END_OF_DAY_INTERNAL__INVOICE_TYPES;
            LocalDate referenceDate = (LocalDate)MoreObjects.firstNonNull((Object)endOfDayDate, (Object)DateTimeHelper.today());
            YearMonth referenceMonth = YearMonth.from(referenceDate);
            invoiceStateChangeSinceFrom = null;
            invoiceStateChangeSinceTo = null;
            cancellationDatePeriodFromFinal = referenceMonth.atDay(1);
            cancellationDatePeriodToFinal = referenceMonth.atEndOfMonth();
            postingDateFromFinal = referenceMonth.atDay(1);
            postingDateToFinal = referenceMonth.atEndOfMonth();
        } else if (anyManualFilterSet) {
            invoiceStates = StringUtils.isNotBlank((CharSequence)filterInvoiceStateCandidate) ? (Iterable)EInvoiceState.lookup((String)filterInvoiceStateCandidate).map(ImmutableSet::of).orElse(ImmutableSet.of()) : EInvoiceState.INVOICE_STATES_FOR_MANUAL_FILTER;
            invoiceTypes = ImmutableSet.of();
            invoiceStateChangeSinceFrom = null;
            invoiceStateChangeSinceTo = null;
            cancellationDatePeriodFromFinal = null;
            cancellationDatePeriodToFinal = null;
            postingDateFromFinal = postingDateFrom;
            postingDateToFinal = postingDateTo;
        } else {
            invoiceStates = (Iterable)EInvoiceState.lookup((String)filterInvoiceStateCandidate).map(ImmutableSet::of).orElse(ImmutableSet.of());
            invoiceTypes = ImmutableSet.of();
            invoiceStateChangeSinceFrom = null;
            invoiceStateChangeSinceTo = null;
            cancellationDatePeriodFromFinal = null;
            cancellationDatePeriodToFinal = null;
            postingDateFromFinal = postingDateFrom;
            postingDateToFinal = postingDateTo;
        }
        ImmutableList stages = null != filterStageId ? this.stageHandler.allByIds((Iterable)ImmutableSet.of((Object)filterStageId)) : ImmutableList.of();
        ImmutableList primaryResponsibleUsers = null != filterPrimaryResponsibleUserId ? this.userHandler.allByIds((Iterable)ImmutableSet.of((Object)filterPrimaryResponsibleUserId)) : ImmutableList.of();
        EInvoiceSortOption invoiceSortOption = EInvoiceSortOption.lookup((String)sortOptionCandidate, (EInvoiceSortOption)EInvoiceSortOption.ID_DESC);
        Page invoices = this.handler.page(page, size, StringUtils.trimToEmpty((String)filterText), invoiceDateFrom, invoiceDateTo, postingDateFromFinal, postingDateToFinal, cancellationDatePeriodFromFinal, cancellationDatePeriodToFinal, updatedOnDateFrom, updatedOnDateTo, invoiceStateChangeSinceFrom, invoiceStateChangeSinceTo, filterER2Downloaded, Boolean.valueOf(optionEndOfDay), endOfDayType, (Iterable)stages, (Iterable)primaryResponsibleUsers, (Iterable)invoiceStates, (Iterable)invoiceTypes, invoiceSortOption);
        return this.mapper.map(invoices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Transactional
    public InvoiceCommon update(@NonNull InvoiceUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Class<InvoiceRouteImpl> clazz = InvoiceRouteImpl.class;
        synchronized (InvoiceRouteImpl.class) {
            this.validateWriteAccess();
            Invoice invoice = this.entityFactory.invoice();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.updateInvoice(invoice, updateRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Transactional
    public InvoiceCommon update(long id, @NonNull InvoiceUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Class<InvoiceRouteImpl> clazz = InvoiceRouteImpl.class;
        synchronized (InvoiceRouteImpl.class) {
            this.validateWriteAccess();
            Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this.updateInvoice(invoice, updateRequest);
        }
    }

    @Nonnull
    private InvoiceCommon updateInvoice(@NonNull Invoice invoice, @NonNull InvoiceUpdateRequest updateRequest) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(updateRequest.getQuotationId());
        this.validateAccountability(invoice, stage, updateRequest);
        Map updateItemMeasurementPositionMap = this.createMissingMeasurementPositions(invoice, stage, updateRequest);
        InvoiceUpdateBucket updateBucket = this.updateBucket(invoice, stage, updateRequest);
        if (invoice.getId() == null && EInvoiceType.CUSTOMER_VOUCHER == updateBucket.getInvoiceType()) {
            throw new BusinessRuleValidationException("Keine manuelle Erstellung von Kundengutschriften m\u00f6glich", (List)ImmutableList.of());
        }
        List invoicePositions = (List)MoreObjects.firstNonNull((Object)updateRequest.getInvoicePositions(), (Object)ImmutableList.of());
        InvoicePositionsUpdateBucket invoicePositionsUpdateBucket = this.positionUpdateBuckets(updateBucket, updateItemMeasurementPositionMap, invoicePositions);
        Invoice invoiceMerged = this.mapper.merge(updateBucket, invoicePositionsUpdateBucket);
        invoiceMerged.setDmsExportState(EInvoiceExportState.NOT_EXPORTED);
        invoiceMerged.setDmsCompanyGroupExportState(EInvoiceExportState.NOT_EXPORTED);
        invoiceMerged.setFileStoreExportState(EInvoiceExportState.NOT_EXPORTED);
        Invoice invoiceUpdated1 = (Invoice)this.handler.update((EntityBase)invoiceMerged);
        Iterable cumulativeInvoices = this.cumulativeInvoices(invoiceUpdated1);
        this.invoiceCalculators.standard().calculateAndApply(invoiceUpdated1, cumulativeInvoices, false);
        EInvoiceState currentInvoiceState = invoice.getInvoiceState();
        if (null == currentInvoiceState || Objects.equals(EInvoiceState.UNKNOWN, currentInvoiceState)) {
            invoice.setInvoiceState(EInvoiceState.IN_ACCOUNTING);
            invoice.setInvoiceStateSince(DateTimeHelper.now());
        }
        Invoice invoiceUpdated2 = this.updateAndEmitMessage(invoiceUpdated1);
        Iterable measurementsWithNewState = this.applyMeasurementState(invoiceUpdated2, updateBucket.getMeasurementsToRemove());
        measurementsWithNewState.forEach(arg_0 -> ((MeasurementHandler)this.measurementHandler).update(arg_0));
        Function closedInvoiceFN = this.closedInvoiceFN(invoiceUpdated2);
        return this.mapper.map(invoiceUpdated2, closedInvoiceFN);
    }

    private void validateAccountability(@NonNull Invoice invoice, @NonNull Quotation stage, @NonNull InvoiceUpdateRequest updateRequest) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        EQStageState stageState = stage.getStageState();
        boolean isCommissionableType = Iterables.contains((Iterable)EQStageType.INVOICE_ACCOUNTABLE_STAGE_TYPES, (Object)stageType);
        if (!isCommissionableType) {
            String notValidStageTypeName = this.messageService.get((Translatable)stageType, new Object[0]);
            ImmutableList requiredStateTypes = (ImmutableList)Streams.stream((Iterable)EQStageType.INVOICE_ACCOUNTABLE_STAGE_TYPES).map(x$0 -> this.messageService.get(x$0, new Object[0])).collect(ImmutableList.toImmutableList());
            String requiredNames = COMMA_JOINER.join((Iterable)requiredStateTypes);
            String message = this.messageService.get((Translatable)EMessageKey.RULE_INVOICE__NO_VALID_STAGE_TYPE, new Object[]{notValidStageTypeName, requiredNames});
            throw new BusinessRuleValidationException(message, (List)ImmutableList.of());
        }
        boolean isCommissionableStageAndType = Iterables.contains((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (Object)stageState);
        if (!isCommissionableStageAndType) {
            String notValidStageStateName = this.messageService.get((Translatable)stageState, new Object[0]);
            ImmutableList requiredStateStates = (ImmutableList)Streams.stream((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES).map(x$0 -> this.messageService.get(x$0, new Object[0])).collect(ImmutableList.toImmutableList());
            String requiredStateNames = COMMA_JOINER.join((Iterable)requiredStateStates);
            String message = this.messageService.get((Translatable)EMessageKey.RULE_INVOICE__NO_VALID_STAGE_STATE, new Object[]{notValidStageStateName, requiredStateNames});
            throw new BusinessRuleValidationException(message, (List)ImmutableList.of());
        }
        boolean flagB2B = Objects.equals(stage.getFlagB2B(), Boolean.TRUE);
        Set invoiceMeasurements = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Set measurementIdsInInvoice = (Set)invoiceMeasurements.stream().map(InvoiceMeasurement::getMeasurement).filter(Objects::nonNull).map(Measurement::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        ImmutableSet measurementIdsInRequest = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)updateRequest.getMeasurementIds(), (Object)ImmutableList.of())));
        Sets.SetView measurementIdsNew = Sets.difference((Set)measurementIdsInRequest, (Set)measurementIdsInInvoice);
        Iterable measurements = this.measurementHandler.allByIds((Iterable)measurementIdsNew);
        ImmutableList.Builder measurementNumbersNotAvailableBuilder = ImmutableList.builder();
        for (Measurement measurement : measurements) {
            EMeasurementState eMeasurementState;
            Set allowedMeasurementStates;
            MeasurementState measurementState = measurement.getMeasurementState();
            if (null == measurementState || Iterables.contains((Iterable)(allowedMeasurementStates = flagB2B ? EMeasurementState.AVAILABLE_FOR_INVOICE_B2B : EMeasurementState.AVAILABLE_FOR_INVOICE_NON_B2B), (Object)(eMeasurementState = measurementState.getMeasurementState()))) continue;
            measurementNumbersNotAvailableBuilder.add((Object)Pair.of((Object)measurement.getMeasurementNumber(), (Object)eMeasurementState));
        }
        ImmutableList measurementNumbersNotAvailable = measurementNumbersNotAvailableBuilder.build();
        if (!Iterables.isEmpty((Iterable)measurementNumbersNotAvailable)) {
            LinkedHashSet detailMessages = Sets.newLinkedHashSet();
            for (Pair pair : measurementNumbersNotAvailable) {
                String measurementNumber = (String)pair.getLeft();
                EMeasurementState measurementState = (EMeasurementState)pair.getRight();
                String translatedMeasurementState = this.messageService.get((Translatable)measurementState, new Object[0]);
                detailMessages.add(String.format("%s: %s", measurementNumber, translatedMeasurementState));
            }
            String detailMessage = COMMA_JOINER.join((Iterable)detailMessages);
            String message = this.messageService.get((Translatable)EMessageKey.RULE_INVOICE__MEASUREMENTS_NOT_ACCOUNTABLE, new Object[]{detailMessage});
            throw new BusinessRuleValidationException(message, (List)ImmutableList.of());
        }
    }

    @Nonnull
    private Map<InvoicePositionUpdateItem, MeasurementPosition> createMissingMeasurementPositions(@NonNull Invoice invoice, @NonNull Quotation quotation, @NonNull InvoiceUpdateRequest updateRequest) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        List quotationPositions = this.stageHandler.allQuotationPositionsByQuotationNumberFailing(quotation, true);
        InvoiceUpdateBucket updateBucket = this.updateBucket(invoice, quotation, updateRequest);
        List invoicePositions = (List)MoreObjects.firstNonNull((Object)updateRequest.getInvoicePositions(), (Object)ImmutableList.of());
        InvoicePositionsUpdateBucket invoicePositionsUpdateBucket = this.positionUpdateBuckets(updateBucket, (Map)ImmutableMap.of(), invoicePositions);
        Multimap measurementInvoicePositionUpdateBuckets = invoicePositionsUpdateBucket.getMeasurementInvoicePositionUpdateBuckets();
        ImmutableMap.Builder allMeasurementPosBuilder = ImmutableMap.builder();
        for (Map.Entry entry : measurementInvoicePositionUpdateBuckets.asMap().entrySet()) {
            Measurement measurement = (Measurement)entry.getKey();
            Collection invoicePositionUpdateBuckets = (Collection)entry.getValue();
            ImmutableList.Builder measurementPositionUpdateBucketsBuilder = ImmutableList.builder();
            int maxSequenceNumberStandard = invoicePositionUpdateBuckets.stream().map(InvoicePositionUpdateBucket::getMeasurementPosition).filter(Objects::nonNull).map(MeasurementPosition::getSequenceNumberMeasurementStandard).filter(Objects::nonNull).max(Integer::compare).orElse(0);
            int maxSequenceNumberTransposed = invoicePositionUpdateBuckets.stream().map(InvoicePositionUpdateBucket::getMeasurementPosition).filter(Objects::nonNull).map(MeasurementPosition::getSequenceNumberMeasurementTransposed).filter(Objects::nonNull).max(Integer::compare).orElse(0);
            int maxColumnIndexTransposed = invoicePositionUpdateBuckets.stream().map(InvoicePositionUpdateBucket::getMeasurementPosition).filter(Objects::nonNull).map(MeasurementPosition::getColumnIndexTransposed).filter(Objects::nonNull).max(Integer::compare).orElse(0);
            ImmutableMap.Builder localMeasurementPosBuilder = ImmutableMap.builder();
            for (InvoicePositionUpdateBucket invoicePositionUpdateBucket : invoicePositionUpdateBuckets) {
                InvoicePositionUpdateItem updateItem = invoicePositionUpdateBucket.getUpdateItem();
                MeasurementPosition measurementPosition = invoicePositionUpdateBucket.getMeasurementPosition();
                MeasurementPositionUpdateBucket measurementPositionUpdateBucket = MeasurementPositionUpdateBucket.of((Long)measurementPosition.getId(), (MeasurementPosition)measurementPosition, (User)measurement.getAssignedUser(), (Long)updateItem.getPositionId(), (String)updateItem.getSurrogatePositionNumber(), (BigDecimal)updateItem.getAmount(), (BigDecimal)updateItem.getFactor1(), (BigDecimal)updateItem.getFactor2(), (BigDecimal)updateItem.getFactor3(), (String)StringUtils.trimToEmpty((String)updateItem.getRemarks()), (LocalDate)measurementPosition.getAccountingMonth(), (Integer)((Integer)MoreObjects.firstNonNull((Object)measurementPosition.getSequenceNumberMeasurementStandard(), (Object)maxSequenceNumberStandard++)), (Integer)((Integer)MoreObjects.firstNonNull((Object)measurementPosition.getSequenceNumberMeasurementTransposed(), (Object)maxSequenceNumberTransposed++)), (Integer)((Integer)MoreObjects.firstNonNull((Object)measurementPosition.getColumnIndexTransposed(), (Object)maxColumnIndexTransposed++)));
                measurementPositionUpdateBucketsBuilder.add((Object)measurementPositionUpdateBucket);
                localMeasurementPosBuilder.put((Object)updateItem, (Object)measurementPosition);
            }
            ImmutableMap localMeasurementPositions = localMeasurementPosBuilder.build();
            ImmutableList measurementPositionUpdateBuckets = measurementPositionUpdateBucketsBuilder.build();
            MeasurementPositionsUpdateBucket measurementPositionsUpdateBucket = new MeasurementPositionsUpdateBucket();
            measurementPositionsUpdateBucket.setMeasurement(measurement);
            measurementPositionsUpdateBucket.setQuotationPositions((Iterable)quotationPositions);
            measurementPositionsUpdateBucket.setAssignedUser(measurement.getAssignedUser());
            measurementPositionsUpdateBucket.setMeasurementPositionUpdateBuckets((Iterable)measurementPositionUpdateBuckets);
            List measurementPositionsMerged = this.measurementMapper.mergeMeasurementPositions(measurementPositionsUpdateBucket);
            this.measurementCalculators.standard().calculateAndApply(measurement);
            Measurement measurementUpdated = (Measurement)this.measurementHandler.update((EntityBase)measurement);
            List measurementPositionsUpdated = (List)MoreObjects.firstNonNull((Object)measurementUpdated.getMeasurementPositions(), (Object)ImmutableList.of());
            ImmutableMap measurementPositionsByReferenceId = Maps.uniqueIndex((Iterable)measurementPositionsUpdated, MeasurementPosition::getReferenceId);
            localMeasurementPositions.forEach((arg_0, arg_1) -> InvoiceRouteImpl.lambda$createMissingMeasurementPositions$3((Map)measurementPositionsByReferenceId, allMeasurementPosBuilder, arg_0, arg_1));
        }
        return allMeasurementPosBuilder.build();
    }

    @Transactional
    @Nonnull
    public InvoiceAttachmentListCommon createAttachments(long id, @NonNull MultipartFile[] multiPartFiles) throws IOException {
        if (multiPartFiles == null) {
            throw new NullPointerException("multiPartFiles is marked non-null but is null");
        }
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
        ImmutableList.Builder invoiceAttachmentBuilder = ImmutableList.builder();
        for (MultipartFile multiPartFile : multiPartFiles) {
            InvoiceAttachment invoiceAttachment;
            String contentType = multiPartFile.getContentType();
            if (StringUtils.equalsIgnoreCase((CharSequence)"application/pdf", (CharSequence)contentType)) {
                invoiceAttachment = this.createInvoiceAttachmentsFromAttachmentUpload(multiPartFile);
                invoiceAttachmentBuilder.add((Object)invoiceAttachment);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"image/jpeg", (CharSequence)contentType)) continue;
            invoiceAttachment = this.createInvoiceAttachmentsFromAttachmentUpload(multiPartFile);
            byte[] imageAsPDF = this.imageToPdfConverter.convertToPdf(multiPartFile);
            this.patchInvoiceAttachment(invoiceAttachment, imageAsPDF);
            invoiceAttachmentBuilder.add((Object)invoiceAttachment);
        }
        ImmutableList invoiceAttachmentsToBeAdded = invoiceAttachmentBuilder.build();
        Iterable invoiceAttachmentsUpdated = this.invoiceAttachmentHandler.update((Iterable)invoiceAttachmentsToBeAdded);
        Set invoiceAttachments = invoice.getInvoiceAttachments();
        if (null == invoiceAttachments) {
            invoice.setInvoiceAttachments((Set)Sets.newHashSet());
        }
        invoiceAttachmentsUpdated.forEach(item -> {
            invoice.getInvoiceAttachments().add(item);
            item.setInvoice(invoice);
        });
        return this.mapper.mapInvoiceAttachments((Iterable)invoice.getInvoiceAttachments());
    }

    @Transactional
    @Nonnull
    public InvoiceAttachmentListCommon deleteAttachment(long invoiceId, long attachmentId) {
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(invoiceId));
        InvoiceAttachment invoiceAttachment = (InvoiceAttachment)this.invoiceAttachmentHandler.byIdFailing(Long.valueOf(attachmentId));
        Set invoiceAttachments = invoice.getInvoiceAttachments();
        if (null == invoiceAttachments) {
            invoice.setInvoiceAttachments((Set)Sets.newHashSet());
        }
        invoice.getInvoiceAttachments().remove(invoiceAttachment);
        invoiceAttachment.setInvoice(null);
        invoiceAttachment.setTtl(DateTimeHelper.now());
        this.invoiceAttachmentHandler.update((EntityBase)invoiceAttachment);
        Invoice invoiceUpdated = (Invoice)this.handler.update((EntityBase)invoice);
        return this.mapper.mapInvoiceAttachments((Iterable)invoiceUpdated.getInvoiceAttachments());
    }

    @Transactional(readOnly=true)
    @Nonnull
    public InvoiceAttachmentListCommon listAttachments(long invoiceId) {
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(invoiceId));
        Set invoiceAttachments = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceAttachments(), (Object)ImmutableSet.of());
        return this.mapper.mapInvoiceAttachments((Iterable)invoiceAttachments);
    }

    @Transactional
    @Nonnull
    public CreditVoucherImportResultListCommon fromFile(@NonNull MultipartFile[] multiPartFiles) {
        if (multiPartFiles == null) {
            throw new NullPointerException("multiPartFiles is marked non-null but is null");
        }
        ImmutableList.Builder creditVoucherImportResultBuilder = ImmutableList.builder();
        for (MultipartFile multipartFile : multiPartFiles) {
            CreditVoucherImportResult creditVoucherImportResult = this.handleMultiPart(multipartFile);
            creditVoucherImportResultBuilder.add((Object)creditVoucherImportResult);
        }
        ImmutableList creditVoucherImportResults = creditVoucherImportResultBuilder.build();
        return this.mapper.mapVoucherImportResults((Iterable)creditVoucherImportResults);
    }

    @Nonnull
    private CreditVoucherImportResult handleMultiPart(@NonNull MultipartFile multiPartFile) {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        EInvoiceType supposedInvoiceType = EInvoiceType.INTERNAL_VOUCHER;
        try {
            String originalFilename = StringUtils.trimToEmpty((String)multiPartFile.getOriginalFilename());
            byte[] fileContent = multiPartFile.getBytes();
            InvoicePdfExtraction invoicePdfExtraction = this.pdfExtractor.extract(fileContent);
            if (EImportResultType.INFO == invoicePdfExtraction.getImportResultType()) {
                EPdfExtractType pdfExtractType = invoicePdfExtraction.getPdfExtractType();
                List measurementNumbers = invoicePdfExtraction.getMeasurementNumbers();
                Iterable measurements = this.measurementHandler.allRelevant(pdfExtractType, (Iterable)measurementNumbers);
                UploadValidationResult uploadValidationResult = this.validate(measurements, invoicePdfExtraction);
                Iterable uploadMeasurementValidationResults = uploadValidationResult.getUploadMeasurementValidationResults();
                Iterable measurementsAvailable = (Iterable)Streams.stream((Iterable)uploadMeasurementValidationResults).filter(UploadMeasurementValidationResult::isAvailable).map(UploadMeasurementValidationResult::getMeasurement).collect(ImmutableList.toImmutableList());
                Iterable globalValidationErrors = uploadValidationResult.getMessages();
                Iterable measurementValidationErrors = (Iterable)Streams.stream((Iterable)uploadMeasurementValidationResults).flatMap(item -> Streams.stream((Iterable)item.getMessages())).collect(ImmutableList.toImmutableList());
                Iterable validationErrors = Iterables.concat((Iterable)globalValidationErrors, (Iterable)measurementValidationErrors);
                Invoice invoice = this.entityFactory.invoice();
                if (!Iterables.isEmpty((Iterable)measurementsAvailable)) {
                    Quotation stage = ((Measurement)measurementsAvailable.iterator().next()).getQuotation();
                    BigDecimal vat = invoicePdfExtraction.getVatPercent();
                    Customer customer = stage.getCustomer();
                    Boolean flagSubContractorAsExternalServiceAccounting = (Boolean)MoreObjects.firstNonNull((Object)customer.getFlagSubContractorAsExternalServiceAccounting(), (Object)false);
                    Boolean flagCompanyGroup = (Boolean)MoreObjects.firstNonNull((Object)customer.getFlagCompanyGroup(), (Object)false);
                    Optional taxKey = this.taxKeyHandler.byInvoiceTypeAndVAT(supposedInvoiceType, vat, flagSubContractorAsExternalServiceAccounting.booleanValue(), flagCompanyGroup.booleanValue());
                    ImmutableList.Builder invoicePositionsBuilder = ImmutableList.builder();
                    measurementsAvailable.forEach(item -> invoicePositionsBuilder.addAll(this.invoicePositions(item)));
                    ImmutableList invoicePositions = invoicePositionsBuilder.build();
                    ImmutableList.Builder invoiceAttachmentBuilder = ImmutableList.builder();
                    invoiceAttachmentBuilder.add((Object)this.createInvoiceAttachmentsFromVoucherUpload(multiPartFile));
                    ImmutableList invoiceAttachments = invoiceAttachmentBuilder.build();
                    Invoice invoiceMerged = this.mapper.merge(originalFilename, invoicePdfExtraction, taxKey, measurementsAvailable, invoice, (Iterable)invoicePositions, validationErrors, supposedInvoiceType, (Iterable)invoiceAttachments);
                    invoiceMerged.setDmsExportState(EInvoiceExportState.NOT_EXPORTED);
                    invoiceMerged.setDmsCompanyGroupExportState(EInvoiceExportState.NOT_EXPORTED);
                    invoiceMerged.setFileStoreExportState(EInvoiceExportState.NOT_EXPORTED);
                    Iterable cumulativeInvoices = this.cumulativeInvoices(invoice);
                    this.invoiceCalculators.standard().calculateAndApply(invoiceMerged, cumulativeInvoices, false);
                    Invoice invoiceUpdated = this.updateAndEmitMessage(invoiceMerged);
                    Iterable measurementsWithNewState = this.applyMeasurementState(invoiceUpdated, (Iterable)ImmutableList.of());
                    measurementsWithNewState.forEach(arg_0 -> ((MeasurementHandler)this.measurementHandler).update(arg_0));
                    return CreditVoucherImportResult.success((MultipartFile)multiPartFile, (Invoice)invoiceUpdated, (Iterable)validationErrors, (EPdfExtractType)invoicePdfExtraction.getPdfExtractType());
                }
                return CreditVoucherImportResult.error((MultipartFile)multiPartFile, (Iterable)validationErrors, (EPdfExtractType)invoicePdfExtraction.getPdfExtractType());
            }
            return CreditVoucherImportResult.error((MultipartFile)multiPartFile, (Iterable)ImmutableList.of((Object)invoicePdfExtraction.getErrorMessage()), (EPdfExtractType)invoicePdfExtraction.getPdfExtractType());
        }
        catch (IOException e) {
            log.error("Error Handling PDF: {}", (Object)e.getMessage(), (Object)e);
            return CreditVoucherImportResult.error((MultipartFile)multiPartFile, (Iterable)ImmutableList.of((Object)e.getMessage()), (EPdfExtractType)EPdfExtractType.NONE);
        }
    }

    @Nonnull
    private Iterable<Invoice> cumulativeInvoices(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation stage = invoice.getQuotation();
        List allRelatedStages = this.stageHandler.allQuotationsByQuotationNumberFailing(stage);
        return this.handler.cumulativeInvoices(invoice, (Iterable)allRelatedStages);
    }

    @Nonnull
    private InvoiceAttachment createInvoiceAttachmentsFromAttachmentUpload(@NonNull MultipartFile multiPartFile) throws IOException {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        return this.createInvoiceAttachmentsFromUpload(multiPartFile, EInvoiceAttachmentType.ATTACHMENT, (long)this.applicationConfig.getInvoiceAttachmentCleanupTTLHours());
    }

    @Nonnull
    private InvoiceAttachment createInvoiceAttachmentsFromVoucherUpload(@NonNull MultipartFile multiPartFile) throws IOException {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        return this.createInvoiceAttachmentsFromUpload(multiPartFile, EInvoiceAttachmentType.PDF_VOUCHER_UPLOAD, (long)this.applicationConfig.getInvoiceAttachmentCleanupTTLHours());
    }

    @Nonnull
    private InvoiceAttachment createInvoiceAttachmentsFromUpload(@NonNull MultipartFile multiPartFile, @NonNull EInvoiceAttachmentType invoiceAttachmentType, long ttlHours) throws IOException {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        if (invoiceAttachmentType == null) {
            throw new NullPointerException("invoiceAttachmentType is marked non-null but is null");
        }
        FileStore fileStore = this.fileStoreMapper.merge(this.entityFactory.fileStore(), multiPartFile);
        FileStore fileStoreUpdated = (FileStore)this.fileStoreHandler.update((EntityBase)fileStore);
        String originalFilename = multiPartFile.getOriginalFilename();
        InvoiceAttachment invoiceAttachment = this.entityFactory.invoiceAttachment();
        invoiceAttachment.setFileStore(fileStore);
        invoiceAttachment.setTtl(DateTimeHelper.now().plusHours(ttlHours));
        invoiceAttachment.setInvoiceAttachmentType(invoiceAttachmentType);
        invoiceAttachment.setOptionPrint(Boolean.valueOf(true));
        invoiceAttachment.setName(originalFilename);
        return invoiceAttachment;
    }

    @Nonnull
    private InvoiceAttachment patchInvoiceAttachment(@NonNull InvoiceAttachment invoiceAttachment, byte[] buffer) throws IOException {
        if (invoiceAttachment == null) {
            throw new NullPointerException("invoiceAttachment is marked non-null but is null");
        }
        FileStore rootFileStore = invoiceAttachment.getFileStore();
        String originalName = StringUtils.replace((String)rootFileStore.getUploadOriginalFilename(), (String)".", (String)"_");
        String fileName = String.format("%s.pdf", originalName);
        FileStore fileStore = this.fileStoreMapper.merge(this.entityFactory.fileStore(), fileName, originalName, "application/pdf", buffer);
        FileStore fileStoreUpdated = (FileStore)this.fileStoreHandler.update((EntityBase)fileStore);
        invoiceAttachment.setFileStorePDF(fileStore);
        return invoiceAttachment;
    }

    @Nonnull
    private Iterable<InvoicePosition> invoicePositions(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        ImmutableList.Builder invoicePositionMeasurementBuilder = ImmutableList.builder();
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (MeasurementPosition measurementPosition : measurementPositions) {
            InvoicePosition invoicePositionMeasurement = this.entityFactory.invoicePosition();
            invoicePositionMeasurement.setInvoicePositionType(EInvoicePositionType.MEASUREMENT_POSITION);
            invoicePositionMeasurement.setSequenceNumber(Integer.valueOf(atomicInteger.getAndIncrement()));
            invoicePositionMeasurement.setMeasurementPosition(measurementPosition);
            invoicePositionMeasurementBuilder.add((Object)invoicePositionMeasurement);
        }
        return invoicePositionMeasurementBuilder.build();
    }

    @Nonnull
    private UploadValidationResult validate(@NonNull Iterable<Measurement> measurements, @NonNull InvoicePdfExtraction invoicePdfExtraction) {
        Set measurementNumbersExisting;
        ImmutableSet measurementNumbersInVoucher;
        Sets.SetView measurementNumberDifference;
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        if (invoicePdfExtraction == null) {
            throw new NullPointerException("invoicePdfExtraction is marked non-null but is null");
        }
        ImmutableList.Builder errorsBuilder = ImmutableList.builder();
        ImmutableList.Builder uploadMeasurementValidationResultBuilder = ImmutableList.builder();
        BigDecimal valueNetInMeasurements = BigDecimal.ZERO;
        for (Measurement measurement : measurements) {
            valueNetInMeasurements = valueNetInMeasurements.add(measurement.getValueOverall());
        }
        BigDecimal valueNetInVoucher = invoicePdfExtraction.getValueOverallNet();
        BigDecimal valueNetDifference = valueNetInVoucher.subtract(valueNetInMeasurements);
        if (valueNetDifference.compareTo(BigDecimal.ZERO) != 0) {
            errorsBuilder.add((Object)String.format("Preis stimmt nicht: Preis in Gutschrift: %s, Aufma\u00dfe: %s, Differenz: %s", BigDecimalHelper.asString((BigDecimal)valueNetInVoucher, (int)2), BigDecimalHelper.asString((BigDecimal)valueNetInMeasurements, (int)2), BigDecimalHelper.asString((BigDecimal)valueNetDifference, (int)2)));
        }
        if (!Iterables.isEmpty(measurements)) {
            Measurement firstMeasurement = measurements.iterator().next();
            Quotation quotation = firstMeasurement.getQuotation();
            BigDecimal vatInQuotation = (BigDecimal)MoreObjects.firstNonNull((Object)quotation.getVatPercent(), (Object)BigDecimal.ZERO);
            BigDecimal vatInVoucher = (BigDecimal)MoreObjects.firstNonNull((Object)invoicePdfExtraction.getVatPercent(), (Object)BigDecimal.ZERO);
            BigDecimal vatDifference = vatInVoucher.subtract(vatInQuotation);
            if (vatDifference.compareTo(BigDecimal.ZERO) != 0) {
                errorsBuilder.add((Object)String.format("Steuersatz stimmt nicht; Gutschrift: %s, Angebot: %s, Differenz: %s", BigDecimalHelper.asString((BigDecimal)vatInVoucher, (int)2), BigDecimalHelper.asString((BigDecimal)vatInQuotation, (int)2), BigDecimalHelper.asString((BigDecimal)vatDifference, (int)2)));
            }
            String costCenterInPDF = StringUtils.trimToEmpty((String)invoicePdfExtraction.getCostCenter());
            LocalDate projectExecutionStartDate = firstMeasurement.getProjectExecutionStartDate();
            User assignedUser = firstMeasurement.getAssignedUser();
            String costCenterOfUser = StringUtils.trimToEmpty((String)EmployeeHelper.currentCostCenterNotFailing((User)assignedUser, (LocalDate)projectExecutionStartDate).orElse("n/a"));
            String measurementNumber = firstMeasurement.getMeasurementNumber();
            if (StringUtils.isNotBlank((CharSequence)costCenterInPDF) && !StringUtils.equalsIgnoreCase((CharSequence)costCenterInPDF, (CharSequence)costCenterOfUser)) {
                errorsBuilder.add((Object)String.format("Kostenstelle stimmt nicht; Gutschrift: %s, Aufma\u00df (%s): %s", costCenterInPDF, measurementNumber, costCenterOfUser));
            }
            for (Measurement measurement : measurements) {
                MeasurementState measurementState = measurement.getMeasurementState();
                EMeasurementState eMeasurementState = measurementState.getMeasurementState();
                String measurementStateDE = this.messageService.getDE((Translatable)eMeasurementState, new Object[0]);
                if (!EMeasurementState.AVAILABLE_FOR_INVOICE_NON_B2B.contains(eMeasurementState)) {
                    String message = String.format("Aufma\u00df: %s nicht zur Fakturierung verf\u00fcgbar, Status: %s", measurement.getMeasurementNumber(), measurementStateDE);
                    uploadMeasurementValidationResultBuilder.add((Object)UploadMeasurementValidationResult.of((boolean)false, (Measurement)measurement, (Iterable)ImmutableList.of((Object)message)));
                    continue;
                }
                uploadMeasurementValidationResultBuilder.add((Object)UploadMeasurementValidationResult.of((boolean)true, (Measurement)measurement, (Iterable)ImmutableList.of()));
            }
        }
        if (!(measurementNumberDifference = Sets.difference((Set)(measurementNumbersInVoucher = ImmutableSet.copyOf((Collection)invoicePdfExtraction.getMeasurementNumbers())), measurementNumbersExisting = Streams.stream(measurements).map(Measurement::getMeasurementNumber).collect(Collectors.toSet()))).isEmpty()) {
            ImmutableSet measurementNumbersNotFound = measurementNumberDifference.immutableCopy();
            String measurementNumbersNotFoundText = Joiner.on((String)", ").skipNulls().join((Iterable)measurementNumbersNotFound);
            errorsBuilder.add((Object)String.format("Aufma\u00dfe nicht gefunden: %s", measurementNumbersNotFoundText));
        }
        ImmutableList measurementValidationResults = uploadMeasurementValidationResultBuilder.build();
        Iterable measurementAvailable = (Iterable)measurementValidationResults.stream().filter(UploadMeasurementValidationResult::isAvailable).map(UploadMeasurementValidationResult::getMeasurement).collect(ImmutableList.toImmutableList());
        InvoiceValidationBucket invoiceValidationBucket = InvoiceValidationBucket.of(null, (EInvoiceState)EInvoiceState.IN_ACCOUNTING, (EInvoiceState)EInvoiceState.IN_ACCOUNTING, (EInvoiceType)EInvoiceType.INTERNAL_VOUCHER, (EInvoiceType)EInvoiceType.INTERNAL_VOUCHER, (Iterable)measurementAvailable, (Iterable)ImmutableList.of());
        Iterable validationErrors = this.validators.invoiceValidation(invoiceValidationBucket).validatePDF().validate();
        Streams.stream((Iterable)validationErrors).map(ValidationResult::getMessages).flatMap(Streams::stream).map(arg_0 -> ((MessageService)this.messageService).get(arg_0)).forEach(arg_0 -> ((ImmutableList.Builder)errorsBuilder).add(arg_0));
        ImmutableList globalErrors = errorsBuilder.build();
        return UploadValidationResult.of((Iterable)globalErrors, (Iterable)measurementValidationResults);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public InvoiceMeasurementAutoCompleteResponse availableMeasurements(@Nullable Long stageId, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Quotation stage = null != stageId ? (Quotation)this.stageHandler.byIdFailing(stageId) : null;
        ImmutableSet stages = null != stage ? ImmutableSet.of((Object)stage) : ImmutableSet.of();
        Page availableMeasurements = this.measurementHandler.availableInvoiceMeasurements((Iterable)stages, filterText);
        return this.mapper.mapAutoComplete(availableMeasurements);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public NewInvoiceAutoCompleteResponse newInvoiceAutoComplete(@NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Page quotations = this.stageHandler.newInvoiceAutoCompleteByText(filterText);
        Iterable measurements = this.measurementHandler.newInvoiceAutoCompleteByText(filterText);
        return this.mapper.mapNewInvoiceAutoComplete((Iterable)quotations, measurements);
    }

    @Transactional
    @Nonnull
    public InvoiceCommon delete(long id) {
        this.validateWriteAccess();
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
        EInvoiceState invoiceState = invoice.getInvoiceState();
        if (!INVOICE_DELETABLE_STATES.contains(invoiceState)) {
            throw new BusinessRuleValidationException("Rechnungen k\u00f6nnen nur im Status 'In Faktura' gel\u00f6scht werden", (List)ImmutableList.of());
        }
        Iterable closingInvoices = (Iterable)MoreObjects.firstNonNull((Object)invoice.getClosedInvoices(), (Object)Sets.newHashSet());
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)Sets.newHashSet());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        invoiceMeasurements.forEach(item -> item.setMeasurement(null));
        invoice.getInvoiceMeasurements().clear();
        closingInvoices.forEach(item -> {
            item.setClosedOn(null);
            item.setClosedByUser(null);
            item.setFlagClosed(Boolean.valueOf(false));
            item.setClosedByInvoice(null);
        });
        invoice.getClosedInvoices().clear();
        invoice.setInvoiceState(EInvoiceState.DELETED);
        Invoice invoiceUpdated = (Invoice)this.handler.update((EntityBase)invoice);
        measurements.forEach(item -> {
            item.setInvoice(null);
            this.switchMeasurementState(null, item, EMeasurementState.TEMPORARY);
        });
        this.measurementHandler.update(measurements);
        Invoice invoiceDeleted = (Invoice)this.handler.delete((EntityBase)invoiceUpdated);
        return this.mapper.map(invoiceDeleted, x -> false);
    }

    @Transactional
    @Nonnull
    public InvoiceCommon reset(long id) {
        this.validateWriteAccess();
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableList.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        invoice.setInvoiceStateSince(DateTimeHelper.now());
        invoice.setInvoiceState(EInvoiceState.IN_ACCOUNTING);
        invoice.setImportErrors("");
        invoiceMeasurements.forEach(item -> {
            item.setInvoice(null);
            item.setMeasurement(null);
        });
        invoice.setInvoiceMeasurements((Set)Sets.newHashSet());
        measurements.forEach(item -> {
            item.setInvoice(null);
            item.setInvoiceMeasurements((Set)Sets.newHashSet());
        });
        this.measurementHandler.update(measurements);
        Invoice invoiceUpdated = (Invoice)this.handler.update((EntityBase)invoice);
        Function closedInvoiceFN = this.closedInvoiceFN(invoiceUpdated);
        return this.mapper.map(invoiceUpdated, closedInvoiceFN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @Nonnull
    public InvoiceCommon accountById(long id, @NonNull InvoiceAccountRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Class<InvoiceRouteImpl> clazz = InvoiceRouteImpl.class;
        synchronized (InvoiceRouteImpl.class) {
            Invoice invoiceUpdated3rd = this.account(id, request);
            Function closedInvoiceFN = this.closedInvoiceFN(invoiceUpdated3rd);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this.mapper.map(invoiceUpdated3rd, closedInvoiceFN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @Nonnull
    public Pair<String, byte[]> accountAndPrintById(long id, @NonNull InvoiceAccountRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Class<InvoiceRouteImpl> clazz = InvoiceRouteImpl.class;
        synchronized (InvoiceRouteImpl.class) {
            Invoice invoice = this.account(id, request);
            boolean optionPrint13bParagraph = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionPrint13bParagraph(), (Object)false);
            boolean optionPrintSubcontractorParagraph = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionPrintSubcontractorParagraph(), (Object)false);
            boolean optionPrintStromnetzParagraph = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionPrintStromnetzParagraph(), (Object)false);
            boolean optionCumulativePrint = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionCumulativePrint(), (Object)false);
            boolean optionMeasurementPrint = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionMeasurementPrint(), (Object)false);
            boolean optionsPrintCumulativeMeasurements = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionMeasurementCumulativePrint(), (Object)false);
            boolean optionsPrintCumulativeMeasurementsConsiderRemarks = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionMeasurementCumulativePrintConsiderRemarks(), (Object)false);
            boolean optionIgnoreAddendum = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionIgnoreAddendum(), (Object)false);
            String attachments = StringUtils.trimToEmpty((String)invoice.getAttachments());
            String additionalAttachments = StringUtils.trimToEmpty((String)invoice.getAdditionalAttachments());
            String footerText = StringUtils.trimToEmpty((String)invoice.getFooterText());
            Iterable attachmentIds = (Iterable)MoreObjects.firstNonNull((Object)request.getOptionPrintInvoiceAttachmentIds(), (Object)ImmutableSet.of());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this.print(id, optionPrint13bParagraph, optionPrintSubcontractorParagraph, optionPrintStromnetzParagraph, optionCumulativePrint, optionMeasurementPrint, attachments, additionalAttachments, footerText, optionsPrintCumulativeMeasurements, optionsPrintCumulativeMeasurementsConsiderRemarks, optionIgnoreAddendum, attachmentIds);
        }
    }

    @Transactional
    @Nonnull
    public InvoiceCommon cancelById(long id, @NonNull InvoiceCancelRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        this.validateWriteAccess();
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
        EInvoiceType invoiceType = invoice.getInvoiceType();
        LocalDate postingDate = invoice.getPostingDate();
        Range allowedCancellationPeriod = Range.closed((Comparable)postingDate, (Comparable)DateTimeHelper.thisMonth());
        LocalDate cancellationPeriod = (LocalDate)MoreObjects.firstNonNull((Object)request.getCancellationPeriod(), (Object)DateTimeHelper.thisMonth());
        if (!allowedCancellationPeriod.contains((Comparable)cancellationPeriod)) {
            throw new BusinessRuleValidationException("Stornoperiode muss im Bereich [BuchungsDatum - Heute] liegen", (List)ImmutableList.of());
        }
        Invoice invoiceUpdated = this.applyCancelState(invoice, request);
        Invoice invoiceUpdated2nd = this.applyClosingInvoices(invoiceUpdated);
        boolean optionCreateCustomerVoucher = (Boolean)MoreObjects.firstNonNull((Object)request.getOptionCreateCustomerVoucher(), (Object)false);
        if (optionCreateCustomerVoucher && INVOICE_CANCELLATION__VOUCHER_CREATE_INVOICE_TYPES.contains(invoiceType)) {
            Invoice voucher = this.entityFactory.invoice();
            Invoice voucherMerged = this.mapper.mergeAsVoucher(invoiceUpdated2nd, voucher);
            invoiceUpdated2nd.setReferencedByInvoice(voucherMerged);
            voucherMerged.setReferencedByInvoice(invoiceUpdated2nd);
            Invoice voucherUpdated = (Invoice)this.handler.update((EntityBase)voucher);
            Invoice invoice2 = this.applyAccountingAndPersist(voucherUpdated, DateTimeHelper.today(), NO_OP);
        }
        Invoice invoiceUpdated3rd = (Invoice)this.handler.update((EntityBase)invoiceUpdated2nd);
        Iterable measurementsWithNewState = this.applyMeasurementState(invoiceUpdated3rd, (Iterable)ImmutableList.of());
        measurementsWithNewState.forEach(arg_0 -> ((MeasurementHandler)this.measurementHandler).update(arg_0));
        Function closedInvoiceFN = this.closedInvoiceFN(invoiceUpdated3rd);
        return this.mapper.map(invoiceUpdated3rd, closedInvoiceFN);
    }

    @Nonnull
    private Invoice pushToDMS(@NonNull Invoice invoice) {
        InvoiceDMSResult invoiceDMSResult;
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceType invoiceType = invoice.getInvoiceType();
        EInvoiceState invoiceState = invoice.getInvoiceState();
        Quotation stage = invoice.getQuotation();
        Customer customer = stage.getCustomer();
        Path folderPathNormal = this.folderPath(invoiceType, false);
        if (this.enaioConfig.isEnabled() && DMS_PUSH__INVOICE_STATES.contains(invoiceState) && DMS_PUSH__INVOICE_TYPES.contains(invoiceType) && (invoiceDMSResult = this.pushToDMS(invoice, folderPathNormal)).isStored()) {
            return this.handler.patchDMSStore(invoice, invoice.getAccountedByUser(), DateTimeHelper.now(), StringUtils.trimToEmpty((String)invoiceDMSResult.getFullPath()), invoice.getTotalValueNet(), EInvoiceExportState.EXPORTED);
        }
        return this.handler.patchDMSStore(invoice, EInvoiceExportState.NOT_EXPORTED);
    }

    @Nonnull
    private Invoice pushToDMSCompanyGroup(@NonNull Invoice invoice) {
        InvoiceDMSResult invoiceDMSResult;
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceType invoiceType = invoice.getInvoiceType();
        EInvoiceState invoiceState = invoice.getInvoiceState();
        Address address = invoice.getInvoiceAddress();
        Customer customer = address.getCustomer();
        boolean currentInvoiceCustomerIsCompanyGroup = (Boolean)MoreObjects.firstNonNull((Object)customer.getFlagCompanyGroup(), (Object)false);
        Path folderPathCompanyGroup = this.folderPath(invoiceType, true);
        if (this.enaioConfig.isCompanyGroupCopyEnabled() && currentInvoiceCustomerIsCompanyGroup && DMS_PUSH__INVOICE_STATES.contains(invoiceState) && DMS_PUSH__INVOICE_TYPES.contains(invoiceType) && (invoiceDMSResult = this.pushToDMS(invoice, folderPathCompanyGroup)).isStored()) {
            return this.handler.patchDMSCompanyGroupStore(invoice, invoice.getAccountedByUser(), DateTimeHelper.now(), StringUtils.trimToEmpty((String)invoiceDMSResult.getFullPath()), invoice.getTotalValueNet(), EInvoiceExportState.EXPORTED);
        }
        return this.handler.patchDMSCompanyGroupStore(invoice, EInvoiceExportState.NOT_EXPORTED);
    }

    @Nonnull
    private InvoiceDMSResult pushToDMS(@NonNull Invoice invoice, @NonNull Path folderPathCompanyGroup) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (folderPathCompanyGroup == null) {
            throw new NullPointerException("folderPathCompanyGroup is marked non-null but is null");
        }
        Pair invoicePDF = this.generateInvoiceWithStoredParams(invoice);
        InvoiceDMSBucket invoiceDMSBucket = this.invoiceDMSBucket(invoice, invoicePDF);
        return this.dmsService.pushSilent(invoiceDMSBucket, folderPathCompanyGroup);
    }

    @Nonnull
    private Path folderPath(@NonNull EInvoiceType invoiceType, boolean companyGroupLogic) {
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        log.info("folderPath for InvoiceType: {}, CompanyGroupLogic: {}", (Object)invoiceType, (Object)companyGroupLogic);
        if (companyGroupLogic) {
            return this.enaioConfig.getFolderPathCompanyGroupCopy();
        }
        if (Iterables.contains((Iterable)CREDIT_VOUCHER_INVOICE_TYPES, (Object)invoiceType)) {
            return this.enaioConfig.getFolderPathCreditVoucher();
        }
        return this.enaioConfig.getFolderPathStandard();
    }

    @Nonnull
    private Invoice pushToStore(@NonNull Invoice invoice) {
        Pair invoicePDF;
        InvoiceFileStoreBucket invoiceFileStoreBucket;
        InvoiceFileStoreResult invoiceFileStoreResult;
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceType invoiceType = invoice.getInvoiceType();
        EInvoiceState invoiceState = invoice.getInvoiceState();
        if (this.fileStoreConfig.isInvoiceFileStoreEnabled() && STORE_PUSH__INVOICE_STATES.contains(invoiceState) && STORE_PUSH__INVOICE_TYPES.contains(invoiceType) && (invoiceFileStoreResult = this.fileStoreService.pushSilent(invoiceFileStoreBucket = this.invoiceFileStoreBucket(invoice, invoicePDF = this.generateInvoiceWithStoredParams(invoice)))).isStored()) {
            return this.handler.patchFileStore(invoice, DateTimeHelper.now(), StringUtils.trimToEmpty((String)invoiceFileStoreResult.getFullPath()), EInvoiceExportState.EXPORTED);
        }
        return this.handler.patchFileStore(invoice, EInvoiceExportState.EXPORTED);
    }

    @Nonnull
    private InvoiceDMSBucket invoiceDMSBucket(@NonNull Invoice invoice, @NonNull Pair<String, byte[]> invoicePDF) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (invoicePDF == null) {
            throw new NullPointerException("invoicePDF is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        String originalFileName = (String)invoicePDF.getLeft();
        byte[] buffer = (byte[])invoicePDF.getRight();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        String invoiceName = StringUtils.trimToEmpty((String)invoice.getInvoiceName());
        String invoiceAddressSuffix = StringUtils.trimToEmpty((String)invoice.getInvoiceAddressSuffix());
        String debtorAccountNumber = StringUtils.trimToEmpty((String)invoice.getFinanceDebtorAccountNumber());
        String invoiceNumber = StringUtils.trimToEmpty((String)invoice.getInvoiceNumber());
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        LocalDate invoiceDate = invoice.getInvoiceDate();
        BigDecimal totalValueNet = invoice.getTotalValueNet();
        BigDecimal totalValueGross = invoice.getTotalValueGross();
        BigDecimal vatValue = invoice.getVatValue();
        String costCenter = StringUtils.trimToEmpty((String)invoice.getCostCenter());
        String costUnit = InvoiceHelper.costUnitEnaio((Invoice)invoice, (String)stageOrEntityNumberPrefix);
        String orderNumber = StringUtils.trimToEmpty((String)invoice.getOrderNumber());
        Set invoiceMeasurements = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurementNumbers = (Iterable)invoiceMeasurements.stream().map(InvoiceMeasurement::getMeasurement).filter(Objects::nonNull).map(Measurement::getMeasurementNumber).collect(ImmutableSet.toImmutableSet());
        String oderNumberMod = this.stageHelperService.costUnit(orderNumber);
        String orderDescriptionMod = this.stageHelperService.costUnit(StringUtils.trimToEmpty((String)invoice.getOrderDescription()));
        return InvoiceDMSBucket.of((EInvoiceType)invoiceType, (String)originalFileName, (byte[])buffer, (String)invoiceName, (String)invoiceAddressSuffix, (String)debtorAccountNumber, (String)invoiceNumber, (EInvoiceState)invoiceState, (LocalDate)invoiceDate, (BigDecimal)totalValueNet, (BigDecimal)vatValue, (BigDecimal)totalValueGross, (String)costCenter, (String)costUnit, (String)oderNumberMod, (Iterable)measurementNumbers, (String)oderNumberMod, (String)orderDescriptionMod);
    }

    @Nonnull
    private InvoiceFileStoreBucket invoiceFileStoreBucket(@NonNull Invoice invoice, @NonNull Pair<String, byte[]> invoicePDF) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (invoicePDF == null) {
            throw new NullPointerException("invoicePDF is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        String originalFileName = (String)invoicePDF.getLeft();
        byte[] buffer = (byte[])invoicePDF.getRight();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        String invoiceName = StringUtils.trimToEmpty((String)invoice.getInvoiceName());
        String invoiceAddressSuffix = StringUtils.trimToEmpty((String)invoice.getInvoiceAddressSuffix());
        String debtorAccountNumber = StringUtils.trimToEmpty((String)invoice.getFinanceDebtorAccountNumber());
        String invoiceNumber = StringUtils.trimToEmpty((String)invoice.getInvoiceNumber());
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        LocalDate invoiceDate = invoice.getInvoiceDate();
        BigDecimal totalValueNet = invoice.getTotalValueNet();
        BigDecimal totalValueGross = invoice.getTotalValueGross();
        BigDecimal vatValue = invoice.getVatValue();
        String costCenter = StringUtils.trimToEmpty((String)invoice.getCostCenter());
        String costUnit = InvoiceHelper.costUnitEnaio((Invoice)invoice, (String)stageOrEntityNumberPrefix);
        String orderNumber = StringUtils.trimToEmpty((String)invoice.getOrderNumber());
        Set invoiceMeasurements = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurementNumbers = (Iterable)invoiceMeasurements.stream().map(InvoiceMeasurement::getMeasurement).filter(Objects::nonNull).map(Measurement::getMeasurementNumber).collect(ImmutableSet.toImmutableSet());
        return InvoiceFileStoreBucket.of((EInvoiceType)invoiceType, (String)originalFileName, (byte[])buffer, (String)invoiceName, (String)invoiceAddressSuffix, (String)debtorAccountNumber, (String)invoiceNumber, (EInvoiceState)invoiceState, (LocalDate)invoiceDate, (BigDecimal)totalValueNet, (BigDecimal)vatValue, (BigDecimal)totalValueGross, (String)costCenter, (String)costUnit, (String)orderNumber, (Iterable)measurementNumbers, (String)orderNumber);
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> print(long id, boolean optionPrint13bParagraph, boolean optionPrintSubcontractorParagraph, boolean optionPrintStromnetzParagraph, boolean optionCumulativePrint, boolean optionMeasurementPrint, @NonNull String attachments, @NonNull String additionalAttachments, @NonNull String footerText, boolean optionsPrintCumulativeMeasurements, boolean optionMeasurementCumulativePrintConsiderRemarks, boolean optionAddendumPositionWording, @NonNull String optionPrintInvoiceAttachmentIds) {
        if (attachments == null) {
            throw new NullPointerException("attachments is marked non-null but is null");
        }
        if (additionalAttachments == null) {
            throw new NullPointerException("additionalAttachments is marked non-null but is null");
        }
        if (footerText == null) {
            throw new NullPointerException("footerText is marked non-null but is null");
        }
        if (optionPrintInvoiceAttachmentIds == null) {
            throw new NullPointerException("optionPrintInvoiceAttachmentIds is marked non-null but is null");
        }
        Iterable attachmentIDs = InvoiceRouteImpl.extractIds((String)optionPrintInvoiceAttachmentIds, (Splitter)INVOICE_ATTACHMENT_IDS_SPLITTER);
        return this.print(id, optionPrint13bParagraph, optionPrintSubcontractorParagraph, optionPrintStromnetzParagraph, optionCumulativePrint, optionMeasurementPrint, attachments, additionalAttachments, footerText, optionsPrintCumulativeMeasurements, optionMeasurementCumulativePrintConsiderRemarks, optionAddendumPositionWording, attachmentIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Pair<String, byte[]> print(long id, boolean optionPrint13bParagraph, boolean optionPrintSubcontractorParagraph, boolean optionPrintStromnetzParagraph, boolean optionCumulativePrint, boolean optionMeasurementPrint, @NonNull String attachments, @NonNull String additionalAttachments, @NonNull String footerText, boolean optionsPrintCumulativeMeasurements, boolean optionMeasurementCumulativePrintConsiderRemarks, boolean optionAddendumPositionWording, @NonNull Iterable<Long> optionPrintInvoiceAttachmentIds) {
        if (attachments == null) {
            throw new NullPointerException("attachments is marked non-null but is null");
        }
        if (additionalAttachments == null) {
            throw new NullPointerException("additionalAttachments is marked non-null but is null");
        }
        if (footerText == null) {
            throw new NullPointerException("footerText is marked non-null but is null");
        }
        if (optionPrintInvoiceAttachmentIds == null) {
            throw new NullPointerException("optionPrintInvoiceAttachmentIds is marked non-null but is null");
        }
        Class<InvoiceRouteImpl> clazz = InvoiceRouteImpl.class;
        synchronized (InvoiceRouteImpl.class) {
            this.validateReadAccess();
            User authenticatedUser = this.userService.authenticatedUser();
            Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
            invoice.setPrintedByUser(authenticatedUser);
            invoice.setPrintedOn(DateTimeHelper.now());
            Invoice invoiceUpdated = this.updateAndEmitMessage(invoice);
            // ** MonitorExit[var15_14] (shouldn't be in output)
            return this.generateInvoice(invoice, optionPrint13bParagraph, optionPrintSubcontractorParagraph, optionPrintStromnetzParagraph, optionCumulativePrint, optionMeasurementPrint, attachments, additionalAttachments, footerText, optionsPrintCumulativeMeasurements, optionMeasurementCumulativePrintConsiderRemarks, optionAddendumPositionWording, optionPrintInvoiceAttachmentIds);
        }
    }

    @Nonnull
    public Pair<String, byte[]> printAsZip(long id, boolean optionPrint13bParagraph, boolean optionPrintSubcontractorParagraph, boolean optionPrintStromnetzParagraph, boolean optionCumulativePrint, boolean optionMeasurementPrint, @NonNull String attachments, @NonNull String additionalAttachments, @NonNull String footerText, boolean optionsPrintCumulativeMeasurements, boolean optionMeasurementCumulativePrintConsiderRemarks, boolean optionAddendumPositionWording, @NonNull String optionPrintInvoiceAttachmentIds) throws IOException, SQLException {
        if (attachments == null) {
            throw new NullPointerException("attachments is marked non-null but is null");
        }
        if (additionalAttachments == null) {
            throw new NullPointerException("additionalAttachments is marked non-null but is null");
        }
        if (footerText == null) {
            throw new NullPointerException("footerText is marked non-null but is null");
        }
        if (optionPrintInvoiceAttachmentIds == null) {
            throw new NullPointerException("optionPrintInvoiceAttachmentIds is marked non-null but is null");
        }
        Class<InvoiceRouteImpl> clazz = InvoiceRouteImpl.class;
        synchronized (InvoiceRouteImpl.class) {
            Pair pair;
            this.validateReadAccess();
            User authenticatedUser = this.userService.authenticatedUser();
            Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
            invoice.setPrintedByUser(authenticatedUser);
            invoice.setPrintedOn(DateTimeHelper.now());
            Invoice invoiceUpdated = this.updateAndEmitMessage(invoice);
            ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
            Iterable attachmentIds = InvoiceRouteImpl.extractIds((String)optionPrintInvoiceAttachmentIds, (Splitter)INVOICE_ATTACHMENT_IDS_SPLITTER);
            Pair invoiceAsPDF = this.generateInvoice(invoice, optionPrint13bParagraph, optionPrintSubcontractorParagraph, optionPrintStromnetzParagraph, optionCumulativePrint, optionMeasurementPrint, attachments, additionalAttachments, footerText, optionsPrintCumulativeMeasurements, optionMeasurementCumulativePrintConsiderRemarks, optionAddendumPositionWording, attachmentIds);
            byte[] invoiceAsXML = this.zugferdService.xml(configurationCompany, invoice);
            Long invoiceId = invoice.getId();
            String invoiceNumber = StringUtils.trimToEmpty((String)invoiceUpdated.getInvoiceNumber());
            String dateForFile = this.dateTimeHelperService.dateForFile();
            String pdfFileName = this.messageService.get((Translatable)EExportFileName.INVOICE_AS_PDF, new Object[]{dateForFile, invoiceNumber, invoiceId});
            String xmlFileName = this.messageService.get((Translatable)EExportFileName.INVOICE_AS_XML, new Object[]{dateForFile, invoiceNumber, invoiceId});
            String zipFileName = this.messageService.get((Translatable)EExportFileName.INVOICE_AS_ZIP, new Object[]{dateForFile, invoiceNumber, invoiceId});
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                try (ZipOutputStream zipOut = new ZipOutputStream(bos);){
                    String invoiceName = (String)invoiceAsPDF.getLeft();
                    byte[] pdfAsByte = (byte[])invoiceAsPDF.getRight();
                    ZipEntry pdfZipEntry = new ZipEntry(pdfFileName);
                    zipOut.putNextEntry(pdfZipEntry);
                    zipOut.write(pdfAsByte);
                    ZipEntry xmlZipEntry = new ZipEntry(xmlFileName);
                    zipOut.putNextEntry(xmlZipEntry);
                    zipOut.write(invoiceAsXML);
                }
                byte[] zipBuffer = bos.toByteArray();
                pair = Pair.of((Object)zipFileName, (Object)zipBuffer);
            }
            // ** MonitorExit[var15_14] (shouldn't be in output)
            return pair;
        }
    }

    @Nonnull
    @Transactional
    public Pair<String, byte[]> printAsZIP(@NonNull Iterable<Long> ids) throws IOException {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        this.validateReadAccess();
        Iterable invoices = this.handler.byIdsFailing(ids);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (ZipOutputStream zipOut = new ZipOutputStream(bos);){
                for (Invoice invoice2 : invoices) {
                    Pair printResult = this.generateInvoiceWithStoredParams(invoice2);
                    String fileName = (String)printResult.getLeft();
                    byte[] bytes = (byte[])printResult.getRight();
                    ZipEntry zipEntry = new ZipEntry(fileName);
                    zipOut.putNextEntry(zipEntry);
                    zipOut.write(bytes);
                }
            }
            byte[] zipBuffer = bos.toByteArray();
            User authenticatedUser = this.userService.authenticatedUser();
            invoices.forEach(invoice -> {
                invoice.setPrintedByUser(authenticatedUser);
                invoice.setPrintedOn(DateTimeHelper.now());
            });
            this.handler.update(invoices, false);
            String dateForFile = this.dateTimeHelperService.dateForFile();
            String fileNameZIP = this.messageService.get((Translatable)EExportFileName.INVOICES_AS_ZIP, new Object[]{dateForFile});
            Pair pair = Pair.of((Object)fileNameZIP, (Object)zipBuffer);
            return pair;
        }
    }

    @Nonnull
    @Transactional
    public Pair<String, byte[]> printAllMeasurements(long id, boolean optionCumulativePrint, boolean optionCumulativePrintConsiderRemarks) {
        User authenticatedUser = this.userService.authenticatedUser();
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
        invoice.setPrintedByUser(authenticatedUser);
        invoice.setPrintedOn(DateTimeHelper.now());
        Invoice invoiceUpdated = this.updateAndEmitMessage(invoice);
        return this.printAllMeasurements(invoiceUpdated, optionCumulativePrint, optionCumulativePrintConsiderRemarks);
    }

    private Pair<String, byte[]> printAllMeasurements(@NonNull Invoice invoice, boolean optionCumulativePrint, boolean optionCumulativePrintConsiderRemarks) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation stage = invoice.getQuotation();
        ImmutableList allQuotationsInInvoice = optionCumulativePrint ? this.stageHandler.allQuotationsByQuotationNumberFailing(stage) : ImmutableList.of();
        CumulativePrintBucket cumulativePrintBucket = this.secondaryInvoices(invoice, (Iterable)allQuotationsInInvoice, optionCumulativePrint, optionCumulativePrintConsiderRemarks);
        ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
        MeasurementCumulativePrintInfo printInfo = this.measurementCumulativePrintMapper.printInfo(configurationCompany, invoice, cumulativePrintBucket);
        MeasurementCumulativePrintConfiguration printConfiguration = MeasurementCumulativePrintConfiguration.of((Color)Color.BLACK, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        byte[] bytes = this.measurementCumulativePrintService.generatePDF(printInfo, printConfiguration, EPrintFontSize.DEFAULT, configurationCompany);
        String invoiceNumber = invoice.getInvoiceNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.INVOICE_MEASUREMENT, new Object[]{dateForFile, invoiceNumber});
        return Pair.of((Object)fileName, (Object)bytes);
    }

    @Nonnull
    @Transactional
    public InvoiceCommon fixDifference(long id) {
        this.validateWriteAccess();
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
        BigDecimal totalValueNet = invoice.getTotalValueNet();
        BigDecimal expectedTotalValueNet = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getExpectedPDFValueOverallNet(), (Object)totalValueNet);
        BigDecimal difference = expectedTotalValueNet.subtract(totalValueNet);
        if (difference.abs().compareTo(DEFAULT_MAX_VALUE_DIFF) > 0) {
            throw new BusinessRuleValidationException(String.format("Differenz > %s EUR, keine Position eingef\u00fcgt", BigDecimalHelper.asString((BigDecimal)DEFAULT_MAX_VALUE_DIFF)), (List)ImmutableList.of());
        }
        if (difference.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal amountNeeded = difference.divide(DEFAULT_FIX_POSITION_VALUE);
            InvoicePosition unitInvoicePosition = this.entityFactory.invoicePosition();
            unitInvoicePosition.setInvoicePositionType(EInvoicePositionType.CUSTOM);
            unitInvoicePosition.setAmount(amountNeeded);
            unitInvoicePosition.setProduct(BigDecimal.ONE);
            unitInvoicePosition.setPositionNumber("KORREKTUR.POS");
            unitInvoicePosition.setShortText("Korrekturposition");
            unitInvoicePosition.setRemarks("");
            unitInvoicePosition.setUnit("Stck");
            unitInvoicePosition.setMaterialSellingPricePerUnit(DEFAULT_FIX_POSITION_VALUE);
            unitInvoicePosition.setMaterialFactor(BigDecimal.ONE);
            unitInvoicePosition.setPricePerUnit(DEFAULT_FIX_POSITION_VALUE);
            if (null == invoice.getInvoicePositions()) {
                invoice.setInvoicePositions((Set)Sets.newHashSet());
            }
            Set invoicePositions = invoice.getInvoicePositions();
            unitInvoicePosition.setInvoice(invoice);
            invoicePositions.add(unitInvoicePosition);
        }
        Iterable cumulativeInvoices = this.cumulativeInvoices(invoice);
        this.invoiceCalculators.standard().calculateAndApply(invoice, cumulativeInvoices, false);
        Invoice invoiceUpdated = (Invoice)this.handler.update((EntityBase)invoice);
        Function closedInvoiceFN = this.closedInvoiceFN(invoiceUpdated);
        return this.mapper.map(invoiceUpdated, closedInvoiceFN);
    }

    @Nonnull
    @Transactional
    public Pair<String, byte[]> exportToER2AsZIP(@NonNull Set<Long> invoiceIdsRequested) throws IOException {
        if (invoiceIdsRequested == null) {
            throw new NullPointerException("invoiceIdsRequested is marked non-null but is null");
        }
        this.validateReadAccess();
        User authenticatedUser = this.userService.authenticatedUser();
        Iterable invoices = this.handler.allByIds(invoiceIdsRequested);
        ImmutableSet invoiceIdsExisting = (ImmutableSet)Streams.stream((Iterable)invoices).map(Invoice::getId).collect(ImmutableSet.toImmutableSet());
        Sets.SetView invoiceIdsMissing = Sets.difference((Set)invoiceIdsExisting, (Set)ImmutableSet.copyOf(invoiceIdsRequested));
        if (!invoiceIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)invoiceIdsMissing);
            throw ResourceNotFoundException.of((String)Invoice.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        Iterable invoiceOutputBuckets = this.er2Route.generate(invoices);
        invoices.forEach(invoice -> {
            invoice.setEr2ExportedBy(authenticatedUser);
            invoice.setEr2ExportedOn(DateTimeHelper.now());
        });
        Iterable updatedInvoices = this.handler.update(invoices);
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileNameER2Normal = this.messageService.get((Translatable)EExportFileName.INVOICES_AS_ER2_NORMAL, new Object[]{dateForFile});
        String fileNameER2CompanyGroup = this.messageService.get((Translatable)EExportFileName.INVOICES_AS_ER2_COMPANY_GROUP, new Object[]{dateForFile});
        String fileNameER2AsZip = this.messageService.get((Translatable)EExportFileName.INVOICES_AS_ZIP_ER2, new Object[]{dateForFile});
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (ZipOutputStream zipOut = new ZipOutputStream(bos);){
                for (ER2InvoiceOutputBucket invoiceOutputBucket : invoiceOutputBuckets) {
                    EER2OutputType outputType = invoiceOutputBucket.getOutputType();
                    byte[] buffer = invoiceOutputBucket.getBuffer();
                    String fileName = outputType == EER2OutputType.NORMAL ? fileNameER2Normal : fileNameER2CompanyGroup;
                    ZipEntry zipEntry = new ZipEntry(fileName);
                    zipOut.putNextEntry(zipEntry);
                    zipOut.write(buffer);
                }
            }
            byte[] zipBuffer = bos.toByteArray();
            Pair pair = Pair.of((Object)fileNameER2AsZip, (Object)zipBuffer);
            return pair;
        }
    }

    @Nonnull
    @Transactional
    public Pair<String, byte[]> exportToXLS(@NonNull Set<Long> invoiceIds) throws IOException {
        if (invoiceIds == null) {
            throw new NullPointerException("invoiceIds is marked non-null but is null");
        }
        this.validateReadAccess();
        Iterable invoices = this.handler.allByIds(invoiceIds);
        ImmutableList.Builder invoicePairBuilder = ImmutableList.builder();
        for (Invoice invoice : invoices) {
            Iterable closingInvoices = (Iterable)MoreObjects.firstNonNull((Object)invoice.getClosedInvoices(), (Object)ImmutableSet.of());
            if (!Iterables.isEmpty((Iterable)closingInvoices)) {
                BigDecimal totalValueNetClosingInvoices = Streams.stream((Iterable)closingInvoices).map(Invoice::getTotalValueNet).reduce(BigDecimal.ZERO, BigDecimal::add);
                invoicePairBuilder.add((Object)Pair.of((Object)invoice, (Object)totalValueNetClosingInvoices));
                continue;
            }
            invoicePairBuilder.add((Object)Pair.of((Object)invoice, (Object)BigDecimal.ZERO));
        }
        ImmutableList invoicePairs = invoicePairBuilder.build();
        Iterable dailySaleOutInvoices = this.mapper.mapXLS((Iterable)invoicePairs);
        try (SXSSFWorkbook workbook = this.endOfDayXlsService.detailXLS(dailySaleOutInvoices, "Tagesabschluss");){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String dateForFile = this.dateTimeHelperService.dateForFile();
            String fileName = this.messageService.get((Translatable)EExportFileName.INVOICES_AS_XLSX, new Object[]{dateForFile});
            Pair pair = Pair.of((Object)fileName, (Object)bytes);
            return pair;
        }
    }

    @Nonnull
    @Transactional(readOnly=true)
    public ClosingInvoiceListCommon closingList(@NonNull Long filterStageId, @NonNull String currentInvoiceTypeCandidate, @NonNull String currentClosingInvoicesIdsCandidate) {
        if (filterStageId == null) {
            throw new NullPointerException("filterStageId is marked non-null but is null");
        }
        if (currentInvoiceTypeCandidate == null) {
            throw new NullPointerException("currentInvoiceTypeCandidate is marked non-null but is null");
        }
        if (currentClosingInvoicesIdsCandidate == null) {
            throw new NullPointerException("currentClosingInvoicesIdsCandidate is marked non-null but is null");
        }
        this.validateReadAccess();
        EInvoiceType invoiceType = EInvoiceType.lookupFailing((String)currentInvoiceTypeCandidate);
        if (ALLOWED_CLOSING_INVOICE_TYPES.contains(invoiceType)) {
            Iterable selectedIds = InvoiceRouteImpl.extractIds((String)currentClosingInvoicesIdsCandidate, (Splitter)CLOSING_INVOICE_IDS_SPLITTER);
            Iterable quotations = this.stageHandler.allByIds((Iterable)ImmutableSet.of((Object)filterStageId));
            Function closedInvoiceFN = this.closedInvoiceFN(selectedIds);
            Iterable availableClosingInvoices = this.handler.closingInvoices(quotations);
            ImmutableList currentSelectedClosingInvoices = !Iterables.isEmpty((Iterable)selectedIds) ? this.handler.byIdsFailing(selectedIds) : ImmutableList.of();
            Iterable allClosingInvoices = Iterables.concat((Iterable)availableClosingInvoices, (Iterable)currentSelectedClosingInvoices);
            return this.mapper.mapClosingInvoice(allClosingInvoices, closedInvoiceFN);
        }
        return ClosingInvoiceListCommon.empty();
    }

    @Transactional
    public boolean pushToDMS() {
        boolean companyGroupCopyEnabled;
        boolean enaioEnabled = this.enaioConfig.isEnabled();
        if (enaioEnabled) {
            Iterable invoicesNotPushed = this.handler.notExportedToDMS(DMS_PUSH__INVOICE_STATES, DMS_PUSH__INVOICE_TYPES, 3);
            for (Invoice invoice : invoicesNotPushed) {
                this.pushToDMS(invoice);
            }
        }
        if (companyGroupCopyEnabled = this.enaioConfig.isCompanyGroupCopyEnabled()) {
            Iterable invoicesNotPushed = this.handler.notExportedToDMSCompanyGroup(DMS_PUSH__INVOICE_STATES, DMS_PUSH__INVOICE_TYPES, 3);
            for (Invoice invoice : invoicesNotPushed) {
                this.pushToDMSCompanyGroup(invoice);
            }
        }
        return true;
    }

    @Transactional
    public boolean pushToStore() {
        Iterable invoicesNotPushed = this.handler.notExportedToStore(STORE_PUSH__INVOICE_STATES, STORE_PUSH__INVOICE_TYPES, 3);
        for (Invoice invoice : invoicesNotPushed) {
            this.pushToStore(invoice);
        }
        return true;
    }

    @Nonnull
    private InvoiceUpdateBucket updateBucket(@NonNull Invoice invoice, @NonNull Quotation stage, @NonNull InvoiceUpdateRequest updateRequest) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        String invoiceTypeCandidate = StringUtils.trimToEmpty((String)updateRequest.getInvoiceType());
        EInvoiceType invoiceType = EInvoiceType.lookupFailing((String)invoiceTypeCandidate);
        Long primaryResponsibleUserId = updateRequest.getPrimaryResponsibleUserId();
        User primaryResponsibleUser = null != primaryResponsibleUserId ? (User)this.userHandler.byIdFailing(primaryResponsibleUserId) : null;
        Long assignedSquadId = updateRequest.getAssignedSquadId();
        User assignedSquad = null != assignedSquadId ? (User)this.userHandler.byIdFailing(assignedSquadId) : null;
        Long invoiceAddressId = updateRequest.getInvoiceAddressId();
        Long invoiceRefAddressId = updateRequest.getInvoiceRefAddressId();
        Address invoiceAddress = null != invoiceAddressId ? (Address)this.addressHandler.byIdFailing(invoiceAddressId) : null;
        Address invoiceRefAddress = null != invoiceRefAddressId ? (Address)this.addressHandler.byIdFailing(invoiceRefAddressId) : null;
        Long financeTaxKeyId = updateRequest.getFinanceTaxKeyId();
        TaxKey taxKey = null != financeTaxKeyId ? (TaxKey)this.taxKeyHandler.byIdFailing(financeTaxKeyId) : null;
        List measurementIds = updateRequest.getMeasurementIds();
        ImmutableList measurements = ImmutableList.copyOf((Iterable)this.measurementHandler.byIdsFailing((Iterable)measurementIds));
        Iterable closingInvoiceIds = (Iterable)MoreObjects.firstNonNull((Object)updateRequest.getClosingInvoiceIds(), (Object)ImmutableList.of());
        ImmutableList closingInvoices = ImmutableList.copyOf((Iterable)this.handler.byIdsFailing(closingInvoiceIds));
        Iterable invoiceAttachments = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceAttachments(), (Object)Sets.newHashSet());
        Iterable invoiceMeasurementsExisting = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableList.of());
        ImmutableSet measurementsNeeded = ImmutableSet.copyOf((Iterable)measurements);
        ImmutableSet measurementsKnown = ImmutableSet.copyOf((Iterable)InvoiceHelper.measurements((Iterable)invoiceMeasurementsExisting));
        ImmutableMap invoiceMeasurementKnownByMeasurement = Maps.uniqueIndex((Iterable)invoiceMeasurementsExisting, InvoiceMeasurement::getMeasurement);
        Sets.SetView measurementsToAdd = Sets.difference((Set)measurementsNeeded, (Set)measurementsKnown);
        Sets.SetView measurementsToRemove = Sets.difference((Set)measurementsKnown, (Set)measurementsNeeded);
        ImmutableSet.Builder invoiceMeasurementBuilder = ImmutableSet.builder();
        measurementsKnown.stream().filter(item -> !measurementsToRemove.contains(item)).forEach(arg_0 -> InvoiceRouteImpl.lambda$updateBucket$16((Map)invoiceMeasurementKnownByMeasurement, invoiceMeasurementBuilder, arg_0));
        measurementsToAdd.forEach(item -> {
            InvoiceMeasurement invoiceMeasurement = this.entityFactory.invoiceMeasurement();
            invoiceMeasurement.setMeasurement(item);
            invoiceMeasurement.setInvoice(invoice);
            invoiceMeasurementBuilder.add((Object)invoiceMeasurement);
        });
        ImmutableSet invoiceMeasurements = invoiceMeasurementBuilder.build();
        Iterable addendumDiscounts = this.stageHandler.allStageDiscounts(stage);
        Iterable invoiceSupplements = this.invoiceSupplementBuckets(updateRequest);
        return InvoiceUpdateBucket.of((InvoiceModificationRequest)updateRequest, (Invoice)invoice, (Invoice)invoice, (Quotation)stage, (User)primaryResponsibleUser, (User)assignedSquad, (EInvoiceType)invoiceType, (Address)invoiceAddress, (Address)invoiceRefAddress, (TaxKey)taxKey, (Iterable)measurements, (Iterable)measurementsToAdd, (Iterable)measurementsToRemove, (Iterable)invoiceMeasurements, (Iterable)closingInvoices, (Iterable)invoiceAttachments, (Iterable)addendumDiscounts, (Iterable)invoiceSupplements);
    }

    @Nonnull
    private Iterable<InvoiceSupplementUpdateBucket> invoiceSupplementBuckets(@NonNull InvoiceUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        List invoiceSupplements = (List)MoreObjects.firstNonNull((Object)updateRequest.getInvoiceSupplements(), (Object)ImmutableList.of());
        return (Iterable)invoiceSupplements.stream().map(item -> InvoiceSupplementUpdateBucket.of((Long)item.getId(), (InvoiceSupplementUpdateItem)item)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private InvoicePositionsUpdateBucket positionUpdateBuckets(@NonNull InvoiceUpdateBucket updateBucket, @NonNull Map<InvoicePositionUpdateItem, MeasurementPosition> updateItemMeasurementPositionMap, @NonNull List<InvoicePositionUpdateItem> updateItems) {
        Set measurementPositionIdsExisting;
        Set invoicePositionIdsExisting;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        if (updateItemMeasurementPositionMap == null) {
            throw new NullPointerException("updateItemMeasurementPositionMap is marked non-null but is null");
        }
        if (updateItems == null) {
            throw new NullPointerException("updateItems is marked non-null but is null");
        }
        Invoice invoice = (Invoice)updateBucket.getEntity();
        Iterable invoicePositionsCustom = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoicePositions(), (Object)ImmutableSet.of());
        ImmutableMap invoicePositionsCustomById = Maps.uniqueIndex((Iterable)invoicePositionsCustom, InvoicePosition::getId);
        Iterable addendumDiscounts = updateBucket.getAddendumDiscounts();
        Map addendumDiscountsByAddendumNumber = MapsHelper.mapKeyAndValue((Iterable)addendumDiscounts, AddendumDiscount::getAddendumNumber, QuotationHelper::discount);
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)updateBucket.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        ImmutableMap measurementsById = Maps.uniqueIndex((Iterable)measurements, Measurement::getId);
        List measurementPositions = Streams.stream((Iterable)measurements).filter(item -> null != item.getMeasurementPositions()).flatMap(item -> item.getMeasurementPositions().stream()).collect(Collectors.toList());
        ImmutableMap measurementPositionsById = Maps.uniqueIndex(measurementPositions, MeasurementPosition::getId);
        ImmutableSet invoicePositionIdsRequired = ImmutableSet.copyOf(updateItems.stream().map(InvoicePositionUpdateItem::getId).filter(Objects::nonNull).iterator());
        Sets.SetView invoicePositionCustomIdsNotPresent = Sets.difference((Set)invoicePositionIdsRequired, invoicePositionIdsExisting = invoicePositionsCustomById.keySet());
        if (!invoicePositionCustomIdsNotPresent.isEmpty()) {
            String positionIds = POSITION_ID_ERROR_MSG_JOINER.join((Iterable)invoicePositionCustomIdsNotPresent);
            throw ResourceNotFoundException.of((String)InvoicePosition.class.getSimpleName(), (FieldName)FieldNamesFactory.cascadedFieldName((FieldName[])new FieldName[]{FieldNamesFactory.simpleFieldName((EField)EField.INVOICE__INVOICE_POSITION), FieldNamesFactory.simpleFieldName((EField)EField.ID)}), (String)positionIds);
        }
        ImmutableSet measurementPositionIdsRequired = ImmutableSet.copyOf(updateItems.stream().filter(item -> item instanceof InvoicePositionMeasurementUpdateItem).map(item -> (InvoicePositionMeasurementUpdateItem)item).map(InvoicePositionMeasurementUpdateItem::getMeasurementPositionId).filter(Objects::nonNull).iterator());
        Sets.SetView measurementPositionIdsNotPresent = Sets.difference((Set)measurementPositionIdsRequired, measurementPositionIdsExisting = measurementPositionsById.keySet());
        if (!measurementPositionIdsNotPresent.isEmpty()) {
            String positionIds = POSITION_ID_ERROR_MSG_JOINER.join((Iterable)measurementPositionIdsNotPresent);
            throw ResourceNotFoundException.of((String)MeasurementPosition.class.getSimpleName(), (FieldName)FieldNamesFactory.cascadedFieldName((FieldName[])new FieldName[]{FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_POSITIONS), FieldNamesFactory.simpleFieldName((EField)EField.ID)}), (String)positionIds);
        }
        ImmutableMultimap.Builder measurementUpdateBucketsBuilder = ImmutableMultimap.builder();
        ImmutableList.Builder invoicePositionMeasurementUpdateBucketBuilder = ImmutableList.builder();
        for (InvoicePositionUpdateItem updateItem : updateItems) {
            Long id = updateItem.getId();
            if (updateItem instanceof InvoicePositionMeasurementUpdateItem) {
                MeasurementPosition measurementPosition;
                boolean createMeasurementPosition;
                InvoicePositionMeasurementUpdateItem invoicePositionMeasurementUpdateItem = (InvoicePositionMeasurementUpdateItem)updateItem;
                Long measurementId = invoicePositionMeasurementUpdateItem.getMeasurementId();
                Measurement measurement = (Measurement)measurementsById.get(measurementId);
                if (null == measurement) continue;
                Long measurementPositionId = invoicePositionMeasurementUpdateItem.getMeasurementPositionId();
                boolean bl = createMeasurementPosition = null == measurementPositionId;
                if (createMeasurementPosition) {
                    measurementPosition = updateItemMeasurementPositionMap.containsKey(updateItem) ? updateItemMeasurementPositionMap.get(updateItem) : this.entityFactory.measurementPosition();
                    measurementPosition.setAddendumNumber(Long.valueOf(0L));
                } else {
                    measurementPosition = (MeasurementPosition)measurementPositionsById.get(measurementPositionId);
                }
                Long addendumNumber = MeasurementHelper.addendumNumber((MeasurementPosition)measurementPosition, (boolean)false);
                BigDecimal discount = addendumDiscountsByAddendumNumber.getOrDefault(addendumNumber, BigDecimal.ZERO);
                InvoicePositionUpdateBucket invoicePositionUpdateBucket = InvoicePositionUpdateBucket.of((Long)id, (EInvoicePositionType)EInvoicePositionType.MEASUREMENT_POSITION, (MeasurementPosition)measurementPosition, (InvoicePositionUpdateItem)invoicePositionMeasurementUpdateItem, (boolean)createMeasurementPosition, (Long)addendumNumber, (BigDecimal)discount);
                measurementUpdateBucketsBuilder.put((Object)measurement, (Object)invoicePositionUpdateBucket);
                continue;
            }
            if (!(updateItem instanceof InvoicePositionCustomUpdateItem)) continue;
            InvoicePositionCustomUpdateItem invoicePositionCustomUpdateItem = (InvoicePositionCustomUpdateItem)updateItem;
            InvoicePositionUpdateBucket invoicePositionUpdateBucket = InvoicePositionUpdateBucket.of((Long)id, (EInvoicePositionType)EInvoicePositionType.CUSTOM, null, (InvoicePositionUpdateItem)invoicePositionCustomUpdateItem, (boolean)false, null, (BigDecimal)BigDecimal.ZERO);
            invoicePositionMeasurementUpdateBucketBuilder.add((Object)invoicePositionUpdateBucket);
        }
        ImmutableList customPositionUpdateBuckets = invoicePositionMeasurementUpdateBucketBuilder.build();
        ImmutableMultimap measurementUpdateBuckets = measurementUpdateBucketsBuilder.build();
        return InvoicePositionsUpdateBucket.of((Invoice)invoice, (List)customPositionUpdateBuckets, (Multimap)measurementUpdateBuckets);
    }

    @Nonnull
    private Invoice updateAndEmitMessage(@NonNull Invoice entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        Invoice itemUpdated = (Invoice)this.handler.update((EntityBase)entity);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)InvoiceChangeMessage.of((Object)this, (Invoice)itemUpdated));
        return itemUpdated;
    }

    @Nonnull
    private Pair<String, byte[]> generateInvoiceWithStoredParams(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Boolean optionPrint13bParagraph = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionPrint13bParagraph(), (Object)false);
        Boolean optionPrintSubcontractorParagraph = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionPrintSubcontractorParagraph(), (Object)false);
        Boolean optionPrintStromnetzParagraph = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionPrintStromnetzParagraph(), (Object)false);
        Boolean optionCumulativePrint = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionCumulativePrint(), (Object)false);
        Boolean optionMeasurementPrint = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionMeasurementPrint(), (Object)false);
        Boolean optionMeasurementCumulativePrint = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionMeasurementCumulativePrint(), (Object)false);
        Boolean optionMeasurementCumulativePrintConsiderRemarks = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionMeasurementCumulativePrintConsiderRemarks(), (Object)false);
        Boolean optionIgnoreAddendum = (Boolean)MoreObjects.firstNonNull((Object)invoice.getOptionIgnoreAddendum(), (Object)false);
        String attachments = StringUtils.trimToEmpty((String)invoice.getAttachments());
        String additionalAttachments = StringUtils.trimToEmpty((String)invoice.getAdditionalAttachments());
        String footerText = StringUtils.trimToEmpty((String)invoice.getFooterText());
        Set invoiceAttachments = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceAttachments(), (Object)ImmutableSet.of());
        ImmutableSet attachmentIds = (ImmutableSet)invoiceAttachments.stream().filter(item -> Boolean.TRUE == item.getOptionPrint()).map(InvoiceAttachment::getId).collect(ImmutableSet.toImmutableSet());
        return this.generateInvoice(invoice, optionPrint13bParagraph.booleanValue(), optionPrintSubcontractorParagraph.booleanValue(), optionPrintStromnetzParagraph.booleanValue(), optionCumulativePrint.booleanValue(), optionMeasurementPrint.booleanValue(), attachments, additionalAttachments, footerText, optionMeasurementCumulativePrint.booleanValue(), optionMeasurementCumulativePrintConsiderRemarks.booleanValue(), optionIgnoreAddendum.booleanValue(), (Iterable)attachmentIds);
    }

    @Nonnull
    private Pair<String, byte[]> generateInvoice(@NonNull Invoice invoice, boolean optionPrint13bParagraph, boolean optionPrintSubcontractorParagraph, boolean optionPrintStromnetzParagraph, boolean optionCumulativePrint, boolean optionMeasurementPrint, @NonNull String optionAttachments, @NonNull String optionAdditionalAttachments, @NonNull String footerText, boolean optionsPrintCumulativeMeasurements, boolean optionsPrintCumulativeMeasurementsConsiderRemarks, boolean optionIgnoreAddendum, @NonNull Iterable<Long> attachmentIds) {
        byte[] measurementPDF;
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (optionAttachments == null) {
            throw new NullPointerException("optionAttachments is marked non-null but is null");
        }
        if (optionAdditionalAttachments == null) {
            throw new NullPointerException("optionAdditionalAttachments is marked non-null but is null");
        }
        if (footerText == null) {
            throw new NullPointerException("footerText is marked non-null but is null");
        }
        if (attachmentIds == null) {
            throw new NullPointerException("attachmentIds is marked non-null but is null");
        }
        long invoiceId = invoice.getId();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        boolean safeOptionCumulativePrint = optionCumulativePrint && Iterables.contains((Iterable)CUMULATIVE_INVOICE_TYPES, (Object)invoiceType);
        Quotation stage = invoice.getQuotation();
        ImmutableList allQuotationsInInvoice = safeOptionCumulativePrint ? this.stageHandler.allQuotationsByQuotationNumberFailing(stage) : ImmutableList.of();
        CumulativePrintBucket cumulativePrintBucket = safeOptionCumulativePrint ? this.secondaryInvoices(invoice, (Iterable)allQuotationsInInvoice, optionCumulativePrint, optionsPrintCumulativeMeasurementsConsiderRemarks) : CumulativePrintBucket.empty();
        ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
        InvoicePrintInfo printInfo = this.invoicePrintMapper.invoicePrintInfo(configurationCompany, invoice, cumulativePrintBucket, optionPrint13bParagraph, optionPrintSubcontractorParagraph, optionPrintStromnetzParagraph, optionMeasurementPrint, optionAttachments, optionAdditionalAttachments, footerText, optionsPrintCumulativeMeasurements, optionIgnoreAddendum);
        InvoicePrintConfiguration printConfiguration = InvoicePrintConfiguration.of((Color)Color.BLACK, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        byte[] invoicePDF = this.invoicePrintService.generatePDF(printInfo, printConfiguration, EPrintFontSize.DEFAULT, configurationCompany);
        ArrayList measurementDocuments = Lists.newArrayList();
        if (optionMeasurementPrint) {
            measurementPDF = (byte[])this.printAllMeasurements(invoice, false, false).getRight();
            measurementDocuments.add(measurementPDF);
        }
        if (optionsPrintCumulativeMeasurements) {
            measurementPDF = (byte[])this.printAllMeasurements(invoice, true, optionsPrintCumulativeMeasurementsConsiderRemarks).getRight();
            measurementDocuments.add(measurementPDF);
        }
        List otherAttachmentDocuments = InvoiceRouteImpl.determineAttachments((Invoice)invoice, attachmentIds);
        String invoiceNumber = invoice.getInvoiceNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.INVOICE_AS_PDF, new Object[]{dateForFile, invoiceNumber, invoiceId});
        try {
            ArrayList documentsToMerge = Lists.newArrayList();
            documentsToMerge.add(invoicePDF);
            documentsToMerge.addAll(measurementDocuments);
            documentsToMerge.addAll(otherAttachmentDocuments);
            User user = invoice.getAccountedByUser();
            String fullName = null != user ? StringUtils.trimToEmpty((String)user.getFullName()) : "";
            byte[] mergedBuffer = this.pdfHelperService.merge(fileName, fileName, fullName, (Iterable)ImmutableSet.copyOf((Collection)documentsToMerge));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mergedBuffer);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            boolean injectOk = this.zugferdService.inject((InputStream)byteArrayInputStream, (OutputStream)byteArrayOutputStream, configurationCompany, invoice);
            byte[] zugferdBuffer = byteArrayOutputStream.toByteArray();
            return Pair.of((Object)fileName, (Object)zugferdBuffer);
        }
        catch (IOException | SQLException e) {
            throw new PDFGenerationException(String.format("Could not merge Invoice and Measurements: %s", e.getMessage()));
        }
    }

    @Nonnull
    private CumulativePrintBucket secondaryInvoices(@NonNull Invoice primaryInvoice, @NonNull Iterable<Quotation> allQuotationsInInvoice, boolean optionCumulativePrint, boolean optionCumulativePrintConsiderRemarks) {
        if (primaryInvoice == null) {
            throw new NullPointerException("primaryInvoice is marked non-null but is null");
        }
        if (allQuotationsInInvoice == null) {
            throw new NullPointerException("allQuotationsInInvoice is marked non-null but is null");
        }
        ImmutableList secondaryInvoicesWithoutPrimary = optionCumulativePrint ? this.handler.cumulativeInvoices(primaryInvoice, allQuotationsInInvoice) : ImmutableList.of();
        return CumulativePrintBucket.of((boolean)optionCumulativePrint, (boolean)optionCumulativePrintConsiderRemarks, (Iterable)secondaryInvoicesWithoutPrimary, allQuotationsInInvoice);
    }

    @Nonnull
    private Invoice applyAccountingState(long id, @NonNull InvoiceAccountRequest request) {
        Iterable finalInvoices;
        Iterable invoiceMeasurements;
        Iterable measurements;
        EInvoiceType invoiceTypeNew;
        EInvoiceType invoiceTypeOld;
        EInvoiceState invoiceStateOld;
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Invoice invoice = (Invoice)this.handler.byIdFailing(Long.valueOf(id));
        InvoiceValidationBucket invoiceValidationBucket = InvoiceValidationBucket.of((Invoice)invoice, (EInvoiceState)(invoiceStateOld = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN)), (EInvoiceState)EInvoiceState.ACCOUNTED, (EInvoiceType)(invoiceTypeOld = (EInvoiceType)MoreObjects.firstNonNull((Object)invoice.getInvoiceType(), (Object)EInvoiceType.UNKNOWN)), (EInvoiceType)(invoiceTypeNew = (EInvoiceType)MoreObjects.firstNonNull((Object)invoice.getInvoiceType(), (Object)EInvoiceType.UNKNOWN)), (Iterable)(measurements = InvoiceHelper.measurements((Iterable)(invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of())))), (Iterable)(finalInvoices = this.handler.finalInvoices((Iterable)ImmutableList.of((Object)invoice.getQuotation()), this.applicationConfig.getValidationDoubleFinalInvoiceValidationMinDate())));
        Iterable validationErrors = this.validators.invoiceValidation(invoiceValidationBucket).validateUpdate().validateStateChange().validate();
        if (!Iterables.isEmpty((Iterable)validationErrors)) {
            Iterable allErrors = (Iterable)Streams.stream((Iterable)validationErrors).map(ValidationResult::getMessages).flatMap(Streams::stream).map(arg_0 -> ((MessageService)this.messageService).get(arg_0)).collect(ImmutableList.toImmutableList());
            String messages = COMMA_JOINER.join(allErrors);
            throw new BusinessRuleValidationException(messages, (List)ImmutableList.of());
        }
        LocalDate invoiceDate = DateTimeHelper.today();
        LocalDate postingDate = (LocalDate)MoreObjects.firstNonNull((Object)request.getPostingDate(), (Object)invoiceDate);
        Set invoiceAttachmentIds = (Set)MoreObjects.firstNonNull((Object)request.getOptionPrintInvoiceAttachmentIds(), (Object)ImmutableSet.of());
        return this.applyAccountingAndPersist(invoice, postingDate, invoiceCB -> {
            invoiceCB.setOptionPrint13bParagraph((Boolean)MoreObjects.firstNonNull((Object)request.getOptionPrint13bParagraph(), (Object)false));
            invoiceCB.setOptionPrintSubcontractorParagraph((Boolean)MoreObjects.firstNonNull((Object)request.getOptionPrintSubcontractorParagraph(), (Object)false));
            invoiceCB.setOptionPrintStromnetzParagraph((Boolean)MoreObjects.firstNonNull((Object)request.getOptionPrintStromnetzParagraph(), (Object)false));
            invoiceCB.setOptionCumulativePrint((Boolean)MoreObjects.firstNonNull((Object)request.getOptionCumulativePrint(), (Object)false));
            invoiceCB.setOptionMeasurementPrint((Boolean)MoreObjects.firstNonNull((Object)request.getOptionMeasurementPrint(), (Object)false));
            invoiceCB.setOptionMeasurementCumulativePrint((Boolean)MoreObjects.firstNonNull((Object)request.getOptionCumulativeMeasurementPrint(), (Object)false));
            invoiceCB.setOptionIgnoreAddendum((Boolean)MoreObjects.firstNonNull((Object)request.getOptionAddendumPositionWording(), (Object)false));
            invoiceCB.setAttachments(StringUtils.trimToEmpty((String)request.getAttachments()));
            invoiceCB.setAdditionalAttachments(StringUtils.trimToEmpty((String)request.getAdditionalAttachments()));
            invoiceCB.setFooterText(StringUtils.trimToEmpty((String)request.getFooterText()));
            Set invoiceAttachments = (Set)MoreObjects.firstNonNull((Object)invoiceCB.getInvoiceAttachments(), (Object)ImmutableSet.of());
            invoiceAttachments.forEach(ia -> ia.setOptionPrint(Boolean.valueOf(Iterables.contains((Iterable)invoiceAttachmentIds, (Object)ia.getId()))));
        });
    }

    @Nonnull
    private Invoice applyAccountingAndPersist(@NonNull Invoice invoice, @NonNull LocalDate postingDate, @NonNull Consumer<Invoice> callback) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (postingDate == null) {
            throw new NullPointerException("postingDate is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        EInvoiceState invoiceStateOld = invoice.getInvoiceState();
        if (EInvoiceState.ACCOUNTED != invoiceStateOld && StringUtils.isBlank((CharSequence)invoice.getInvoiceNumber())) {
            User authenticatedUser = this.userService.authenticatedUser();
            Quotation stage = invoice.getQuotation();
            EInvoiceType invoiceType = invoice.getInvoiceType();
            invoice.setInvoiceStateSince(DateTimeHelper.now());
            invoice.setInvoiceState(EInvoiceState.ACCOUNTED);
            invoice.setDmsExportState(EInvoiceExportState.NOT_EXPORTED);
            invoice.setDmsCompanyGroupExportState(EInvoiceExportState.NOT_EXPORTED);
            invoice.setFileStoreExportState(EInvoiceExportState.NOT_EXPORTED);
            LocalDate invoiceDate = DateTimeHelper.today();
            invoice.setInvoiceDate(invoiceDate);
            YearMonth postingMonth = YearMonth.from(postingDate);
            invoice.setPostingDate(postingMonth.atDay(1));
            Optional openInvoiceNumber = this.service.findHoles(invoiceType, invoiceDate);
            if (openInvoiceNumber.isPresent()) {
                invoiceNumber = (String)openInvoiceNumber.get();
                invoice.setInvoiceNumber(invoiceNumber);
            } else {
                invoiceNumber = this.service.determineNextInvoiceNumber(invoiceType, invoiceDate);
                invoice.setInvoiceNumber(invoiceNumber);
            }
            invoice.setAccountedByUser(authenticatedUser);
            if (invoiceType == EInvoiceType.PARTIAL_INVOICE) {
                Integer currentPartialNumber = this.handler.currentPartialNumber(invoice);
                int nextPartialNumber = null == currentPartialNumber ? 1 : 1 + currentPartialNumber;
                invoice.setInternalPartialNumber(Integer.valueOf(nextPartialNumber));
                String invoiceTypeComment = String.format("%s. TR", nextPartialNumber);
                invoice.setInvoiceTypeComment(invoiceTypeComment);
            } else if (invoiceType == EInvoiceType.PARTIAL_FINAL_INVOICE) {
                Integer currentPartialFinalNumber = this.handler.currentPartialFinalNumber(invoice);
                int nextPartialFinalNumber = null == currentPartialFinalNumber ? 1 : 1 + currentPartialFinalNumber;
                invoice.setInternalPartialFinalNumber(Integer.valueOf(nextPartialFinalNumber));
                String invoiceTypeComment = String.format("%s. TSR", nextPartialFinalNumber);
                invoice.setInvoiceTypeComment(invoiceTypeComment);
            }
            Integer currentSequentialNumber = this.handler.currentSequentialNumber(invoice);
            int nextSequentialNumber = null == currentSequentialNumber ? 1 : 1 + currentSequentialNumber;
            invoice.setSequentialNumber(Integer.valueOf(nextSequentialNumber));
            callback.accept(invoice);
            this.stageHandler.applyLastInvoice(stage, invoice);
            if (invoiceType == EInvoiceType.FINAL_INVOICE) {
                this.stageHandler.applyFinalInvoice(stage, invoice);
            }
            return this.updateAndEmitMessage(invoice);
        }
        return invoice;
    }

    @Nonnull
    private Invoice applyCancelState(@NonNull Invoice invoice, @NonNull InvoiceCancelRequest request) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        EInvoiceState invoiceStateOld = invoice.getInvoiceState();
        invoice.setInvoiceStateSince(DateTimeHelper.now());
        invoice.setInvoiceState(EInvoiceState.CANCELLED);
        invoice.setEr2ExportedOn(null);
        invoice.setEr2ExportedBy(null);
        if (EInvoiceState.CANCELLED != invoiceStateOld) {
            invoice.setCancellationRemarks(request.getCancellationRemarks());
            invoice.setCancellationDebitNote(request.getCancellationDebitNote());
            LocalDate cancellationDate = DateTimeHelper.today();
            invoice.setCancellationDate(cancellationDate);
            LocalDate cancellationPeriod = (LocalDate)MoreObjects.firstNonNull((Object)request.getCancellationPeriod(), (Object)DateTimeHelper.thisMonth());
            invoice.setCancellationPeriod(cancellationPeriod);
        }
        invoice.setDmsExportState(EInvoiceExportState.NOT_EXPORTED);
        invoice.setDmsCompanyGroupExportState(EInvoiceExportState.NOT_EXPORTED);
        invoice.setFileStoreExportState(EInvoiceExportState.NOT_EXPORTED);
        return this.updateAndEmitMessage(invoice);
    }

    @Nonnull
    private Invoice applyClosingInvoices(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        User authenticatedUser = this.userService.authenticatedUser();
        EInvoiceState invoiceState = invoice.getInvoiceState();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        if (invoiceState == EInvoiceState.ACCOUNTED) {
            if (EInvoiceType.FINAL_INVOICE == invoiceType) {
                Quotation quotation = invoice.getQuotation();
                ImmutableSet invoicesToBeClosed = ImmutableSet.copyOf((Iterable)this.handler.closingInvoices((Iterable)ImmutableSet.of((Object)quotation)));
                if (null == invoice.getClosedInvoices()) {
                    invoice.setClosedInvoices((Set)Sets.newHashSet());
                }
                Set closedInvoices = invoice.getClosedInvoices();
                invoicesToBeClosed.forEach(item -> {
                    item.setFlagClosed(Boolean.TRUE);
                    item.setClosedOn(DateTimeHelper.now());
                    item.setClosedByUser(authenticatedUser);
                    item.setClosedByInvoice(invoice);
                });
                closedInvoices.addAll(invoicesToBeClosed);
                invoicesToBeClosed.forEach(arg_0 -> ((InvoiceHandler)this.handler).update(arg_0));
            }
            return this.updateAndEmitMessage(invoice);
        }
        if (invoiceState == EInvoiceState.CANCELLED) {
            if (Iterables.contains((Iterable)EInvoiceType.INVOICE_TYPES__UNCLOSE_ON_CANCELLATION, (Object)invoiceType)) {
                if (null == invoice.getClosedInvoices()) {
                    invoice.setClosedInvoices((Set)Sets.newHashSet());
                }
                Set closedInvoices = invoice.getClosedInvoices();
                closedInvoices.forEach(item -> {
                    item.setFlagClosed(Boolean.FALSE);
                    item.setClosedOn(null);
                    item.setClosedByUser(null);
                    item.setClosedByInvoice(null);
                });
                invoice.getClosedInvoices().clear();
                closedInvoices.forEach(arg_0 -> ((InvoiceHandler)this.handler).update(arg_0));
            }
            return this.updateAndEmitMessage(invoice);
        }
        return invoice;
    }

    @Nonnull
    private Iterable<Measurement> applyMeasurementState(@NonNull Invoice invoice, @NonNull Iterable<Measurement> measurementsToReset) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (measurementsToReset == null) {
            throw new NullPointerException("measurementsToReset is marked non-null but is null");
        }
        EInvoiceState invoiceState = invoice.getInvoiceState();
        EMeasurementState measurementStateNew = invoiceState == EInvoiceState.ACCOUNTED ? EMeasurementState.ACCOUNTED : (invoiceState == EInvoiceState.IN_ACCOUNTING ? EMeasurementState.IN_ACCOUNTING : (invoiceState == EInvoiceState.CANCELLED ? EMeasurementState.TEMPORARY : EMeasurementState.TEMPORARY));
        Set invoiceMeasurements = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        for (Measurement measurementToAccount : measurements) {
            this.switchMeasurementState(invoice, measurementToAccount, measurementStateNew);
        }
        for (Measurement measurementToReset : measurementsToReset) {
            this.switchMeasurementState(null, measurementToReset, EMeasurementState.TEMPORARY);
        }
        return Iterables.concat((Iterable)measurements, measurementsToReset);
    }

    private void switchMeasurementState(@Nullable Invoice invoice, @NonNull Measurement measurement, @NonNull EMeasurementState measurementStateNew) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (measurementStateNew == null) {
            throw new NullPointerException("measurementStateNew is marked non-null but is null");
        }
        MeasurementHistorySnapShot snapShot = this.historyItemRoute.snapShot(measurement);
        this.measurementService.switchMeasurementState(measurement, measurementStateNew, EMeasurementStateReason.ACCOUNTING);
        measurement.setInvoice(invoice);
        this.historyItemRoute.persistChanges(snapShot, measurement);
    }

    @Nonnull
    private Function<Invoice, Boolean> closedInvoiceFN(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Set closedInvoices = (Set)MoreObjects.firstNonNull((Object)invoice.getClosedInvoices(), (Object)ImmutableSet.of());
        Set closedInvoicesIds = (Set)closedInvoices.stream().map(Invoice::getId).collect(ImmutableSet.toImmutableSet());
        return this.closedInvoiceFN((Iterable)closedInvoicesIds);
    }

    @Nonnull
    private Function<Invoice, Boolean> closedInvoiceFN(@NonNull Iterable<Long> invoiceIds) {
        if (invoiceIds == null) {
            throw new NullPointerException("invoiceIds is marked non-null but is null");
        }
        return item -> Iterables.contains((Iterable)invoiceIds, (Object)item.getId());
    }

    private void validateReadAccess() {
        User user = this.userService.authenticatedUser();
        boolean readInvoice = this.userService.hasPrivilege(EPrivilege.INVOICE__READ);
        if (readInvoice) {
            return;
        }
        String privDE = this.messageService.getDE(EPrivilege.INVOICE__READ);
        throw new MissingPrivilegeException(String.format("Missing Privilege: %s to read Invoice for User: %s", EPrivilege.INVOICE__READ, user), Message.of((EMessageKey)EMessageKey.SECURITY__INVOICE_READ__NOT_ALLOWED, (String)privDE), EPrivilege.INVOICE__READ);
    }

    private void validateWriteAccess() {
        User user = this.userService.authenticatedUser();
        boolean writeInvoice = this.userService.hasPrivilege(EPrivilege.INVOICE__WRITE);
        if (writeInvoice) {
            return;
        }
        String privDE = this.messageService.getDE(EPrivilege.INVOICE__WRITE);
        throw new MissingPrivilegeException(String.format("Missing Privilege: %s to write Invoice for User: %s", EPrivilege.INVOICE__WRITE, user), Message.of((EMessageKey)EMessageKey.SECURITY__INVOICE_WRITE__NOT_ALLOWED, (String)privDE), EPrivilege.INVOICE__WRITE);
    }

    @Nonnull
    private Invoice account(long id, @NonNull InvoiceAccountRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        this.validateWriteAccess();
        Invoice invoiceUpdated = this.applyAccountingState(id, request);
        Invoice invoiceUpdated2nd = this.applyClosingInvoices(invoiceUpdated);
        Iterable measurementsWithNewState = this.applyMeasurementState(invoiceUpdated2nd, (Iterable)ImmutableList.of());
        measurementsWithNewState.forEach(arg_0 -> ((MeasurementHandler)this.measurementHandler).update(arg_0));
        return invoiceUpdated2nd;
    }

    @Nonnull
    private static List<byte[]> determineAttachments(@NonNull Invoice invoice, @NonNull Iterable<Long> attachmentIds) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (attachmentIds == null) {
            throw new NullPointerException("attachmentIds is marked non-null but is null");
        }
        Set invoiceAttachments = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceAttachments(), (Object)ImmutableSet.of());
        ArrayList otherAttachmentDocuments = Lists.newArrayList();
        for (InvoiceAttachment invoiceAttachment : invoiceAttachments) {
            Long invoiceAttachmentId = invoiceAttachment.getId();
            boolean optionPrint = Iterables.contains(attachmentIds, (Object)invoiceAttachmentId);
            if (!optionPrint) continue;
            FileStore fileStore = invoiceAttachment.getFileStore();
            FileStore fileStorePDF = invoiceAttachment.getFileStorePDF();
            if (null != fileStorePDF) {
                FileStoreHelper.fetchBytes((FileStore)fileStorePDF).ifPresent(otherAttachmentDocuments::add);
                continue;
            }
            if (null == fileStore) continue;
            FileStoreHelper.fetchBytes((FileStore)fileStore).ifPresent(otherAttachmentDocuments::add);
        }
        return otherAttachmentDocuments;
    }

    @Nonnull
    private static Iterable<Long> extractIds(@NonNull String currentClosingInvoicesIdsCandidate, @NonNull Splitter splitter) {
        if (currentClosingInvoicesIdsCandidate == null) {
            throw new NullPointerException("currentClosingInvoicesIdsCandidate is marked non-null but is null");
        }
        if (splitter == null) {
            throw new NullPointerException("splitter is marked non-null but is null");
        }
        Stream stringStream = splitter.splitToStream((CharSequence)currentClosingInvoicesIdsCandidate);
        return (Iterable)stringStream.map(arg_0 -> ((CharMatcher)DIGIT_MATCHER).retainFrom(arg_0)).map(Longs::tryParse).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    public InvoiceRouteImpl(EnaioConfig enaioConfig, FileStoreConfig fileStoreConfig, StageHelperService stageHelperService, InvoiceAttachmentHandler invoiceAttachmentHandler, InvoiceSupplementHandler invoiceSupplementHandler, ApplicationEventPublisher applicationEventPublisher, ApplicationConfig applicationConfig, ConfigService configService, DateTimeHelperService dateTimeHelperService, EntityFactory entityFactory, MessageService messageService, FileStoreHandler fileStoreHandler, FileStoreMapper fileStoreMapper, InvoiceMapper mapper, InvoiceHandler handler, ConfigurationCompanyHandler configurationCompanyHandler, MeasurementMapper measurementMapper, TaxKeyHandler taxKeyHandler, InvoiceService service, InvoiceCalculators invoiceCalculators, InvoicePrintService invoicePrintService, InvoicePrintMapper invoicePrintMapper, MeasurementCumulativePrintMapper measurementCumulativePrintMapper, MeasurementCumulativePrintService measurementCumulativePrintService, MeasurementCalculators measurementCalculators, MeasurementService measurementService, StageHandler stageHandler, UserService userService, DMSService dmsService, FileStoreService fileStoreService, EndOfDayXlsExportService endOfDayXlsService, ZugferdService zugferdService, Validators validators, AddressHandler addressHandler, MeasurementHandler measurementHandler, UserHandler userHandler, PdfExtractor pdfExtractor, ER2Route er2Route, PDFHelperService pdfHelperService, HistoryItemRoute historyItemRoute, ImageToPdfConverter imageToPdfConverter) {
        this.enaioConfig = enaioConfig;
        this.fileStoreConfig = fileStoreConfig;
        this.stageHelperService = stageHelperService;
        this.invoiceAttachmentHandler = invoiceAttachmentHandler;
        this.invoiceSupplementHandler = invoiceSupplementHandler;
        this.applicationEventPublisher = applicationEventPublisher;
        this.applicationConfig = applicationConfig;
        this.configService = configService;
        this.dateTimeHelperService = dateTimeHelperService;
        this.entityFactory = entityFactory;
        this.messageService = messageService;
        this.fileStoreHandler = fileStoreHandler;
        this.fileStoreMapper = fileStoreMapper;
        this.mapper = mapper;
        this.handler = handler;
        this.configurationCompanyHandler = configurationCompanyHandler;
        this.measurementMapper = measurementMapper;
        this.taxKeyHandler = taxKeyHandler;
        this.service = service;
        this.invoiceCalculators = invoiceCalculators;
        this.invoicePrintService = invoicePrintService;
        this.invoicePrintMapper = invoicePrintMapper;
        this.measurementCumulativePrintMapper = measurementCumulativePrintMapper;
        this.measurementCumulativePrintService = measurementCumulativePrintService;
        this.measurementCalculators = measurementCalculators;
        this.measurementService = measurementService;
        this.stageHandler = stageHandler;
        this.userService = userService;
        this.dmsService = dmsService;
        this.fileStoreService = fileStoreService;
        this.endOfDayXlsService = endOfDayXlsService;
        this.zugferdService = zugferdService;
        this.validators = validators;
        this.addressHandler = addressHandler;
        this.measurementHandler = measurementHandler;
        this.userHandler = userHandler;
        this.pdfExtractor = pdfExtractor;
        this.er2Route = er2Route;
        this.pdfHelperService = pdfHelperService;
        this.historyItemRoute = historyItemRoute;
        this.imageToPdfConverter = imageToPdfConverter;
    }

    private static /* synthetic */ void lambda$updateBucket$16(Map invoiceMeasurementKnownByMeasurement, ImmutableSet.Builder invoiceMeasurementBuilder, Measurement item) {
        InvoiceMeasurement element = (InvoiceMeasurement)invoiceMeasurementKnownByMeasurement.get(item);
        if (null != element) {
            invoiceMeasurementBuilder.add((Object)element);
        }
    }

    private static /* synthetic */ void lambda$createMissingMeasurementPositions$3(Map measurementPositionsByReferenceId, ImmutableMap.Builder allMeasurementPosBuilder, InvoicePositionUpdateItem updateItem, MeasurementPosition measurementPosition) {
        String referenceId = measurementPosition.getReferenceId();
        if (measurementPositionsByReferenceId.containsKey(referenceId)) {
            MeasurementPosition measurementPositionUpdated = (MeasurementPosition)measurementPositionsByReferenceId.get(referenceId);
            allMeasurementPosBuilder.put((Object)updateItem, (Object)measurementPositionUpdated);
        }
    }
}

