/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.response.history.v1.HistoryItemCommon;
import de.qfm.erp.common.response.history.v1.HistoryItemPageCommon;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.history.MeasurementHistorySnapShot;
import de.qfm.erp.service.model.internal.history.StageHistorySnapShot;
import de.qfm.erp.service.model.jpa.history.HistoryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.handler.HistoryItemHandler;
import de.qfm.erp.service.service.history.MeasurementHistoryPreparer;
import de.qfm.erp.service.service.history.StageHistoryPreparer;
import de.qfm.erp.service.service.mapper.HistoryItemMapper;
import de.qfm.erp.service.service.route.HistoryItemRoute;
import de.qfm.erp.service.service.validator.Validator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HistoryItemRouteImpl
implements HistoryItemRoute {
    private final HistoryItemMapper mapper;
    private final HistoryItemHandler handler;
    private final MeasurementHistoryPreparer measurementHistoryPreparer;
    private final StageHistoryPreparer stageHistoryPreparer;

    @Nonnull
    @Transactional(readOnly=true)
    public HistoryItemCommon byId(long userId) {
        return this.mapper.map((HistoryItem)this.handler.byIdFailing(Long.valueOf(userId)));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public HistoryItemPageCommon page(int page, int size) {
        PageRequest pageRequest = PageRequest.of((int)page, (int)size);
        return this.mapper.map(this.handler.page((Pageable)pageRequest));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public HistoryItemPageCommon pageForEntity(@NonNull String entityClazzCandidate, long entityId, int page, int size) {
        if (entityClazzCandidate == null) {
            throw new NullPointerException("entityClazzCandidate is marked non-null but is null");
        }
        Optional eEntityClass = EEntityClass.lookup((String)entityClazzCandidate);
        if (eEntityClass.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ENTITY_CLASS), (String)entityClazzCandidate, EEntityClass.class, EEntityClass::allowedKeys);
        }
        return this.mapper.map(this.handler.pageForEntity(eEntityClass.orElse(EEntityClass.NONE), entityId, page, size));
    }

    @Nonnull
    public Iterable<HistoryItem> persist(@NonNull Iterable<HistoryItem> historyItems) {
        if (historyItems == null) {
            throw new NullPointerException("historyItems is marked non-null but is null");
        }
        return this.handler.save(historyItems);
    }

    @Nonnull
    public MeasurementHistorySnapShot snapShot(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return this.measurementHistoryPreparer.snapShot(measurement);
    }

    @Nonnull
    public Iterable<HistoryItem> persistChanges(@NonNull MeasurementHistorySnapShot measurementHistorySnapShot, @NonNull Measurement measurement) {
        if (measurementHistorySnapShot == null) {
            throw new NullPointerException("measurementHistorySnapShot is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        List difference = this.measurementHistoryPreparer.difference(measurementHistorySnapShot, measurement);
        return this.persist((Iterable)difference);
    }

    @Nonnull
    public StageHistorySnapShot snapShot(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.stageHistoryPreparer.snapShot(stage);
    }

    @Nonnull
    public Iterable<HistoryItem> persistChanges(@NonNull StageHistorySnapShot stageHistorySnapShot, @NonNull Quotation stage) {
        if (stageHistorySnapShot == null) {
            throw new NullPointerException("stageHistorySnapShot is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        List difference = this.stageHistoryPreparer.difference(stageHistorySnapShot, stage);
        return this.persist((Iterable)difference);
    }

    public HistoryItemRouteImpl(HistoryItemMapper mapper, HistoryItemHandler handler, MeasurementHistoryPreparer measurementHistoryPreparer, StageHistoryPreparer stageHistoryPreparer) {
        this.mapper = mapper;
        this.handler = handler;
        this.measurementHistoryPreparer = measurementHistoryPreparer;
        this.stageHistoryPreparer = stageHistoryPreparer;
    }
}

